/*
 * Decompiled with CFR 0.152.
 */
package com.exlibris.core.infra.common.util;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.zip.CRC32;
import org.apache.commons.codec.binary.Hex;

public final class Checksummer {
    private static final int ONE_MB_IN_BYTE = 0x100000;
    InputStream fis = null;
    OutputStream fos = null;
    ByteBuffer bBuf = null;
    MessageDigest md5 = null;
    MessageDigest sha1 = null;
    MessageDigest sha256 = null;
    MessageDigest other = null;
    CRC32 crc32;
    String otherChecksum = null;
    boolean calcMD5 = true;
    boolean calcSHA1 = true;
    boolean calcCRC32 = true;
    boolean calcSHA256 = true;

    public Checksummer(File file) throws FileNotFoundException, IOException {
        this.updateDigesters();
        if (file != null) {
            this.createChecksum(file);
        }
    }

    public Checksummer(File file, boolean calcMD5, boolean calcSHA1, boolean calcCRC32, boolean calcSHA256) throws IOException {
        this.calcMD5 = calcMD5;
        this.calcSHA1 = calcSHA1;
        this.calcSHA256 = calcSHA256;
        this.calcCRC32 = calcCRC32;
        this.updateDigesters();
        if (file != null) {
            this.createChecksum(file);
        }
    }

    public Checksummer(File file, String mdImpl) throws FileNotFoundException, IOException {
        this.otherChecksum = mdImpl;
        this.updateDigesters();
        if (file != null) {
            this.createChecksum(file);
        }
    }

    public Checksummer(byte[] byteBuffer) throws FileNotFoundException, IOException {
        this.bBuf = ByteBuffer.wrap(byteBuffer);
        this.updateDigesters();
        this.createChecksum();
    }

    public Checksummer(byte[] byteBuffer, boolean calcMD5, boolean calcSHA1, boolean calcCRC32, boolean calcSHA256) throws FileNotFoundException, IOException {
        this.calcMD5 = calcMD5;
        this.calcSHA1 = calcSHA1;
        this.calcCRC32 = calcCRC32;
        this.calcSHA256 = calcSHA256;
        this.bBuf = ByteBuffer.wrap(byteBuffer);
        this.updateDigesters();
        this.createChecksum();
    }

    public Checksummer(String str, boolean calcMD5, boolean calcSHA1, boolean calcCRC32, boolean calcSHA256) throws FileNotFoundException, IOException {
        this.calcMD5 = calcMD5;
        this.calcSHA1 = calcSHA1;
        this.calcCRC32 = calcCRC32;
        this.calcSHA256 = calcSHA256;
        this.bBuf = ByteBuffer.wrap(str.getBytes("UTF-8"));
        this.updateDigesters();
        this.createChecksum();
    }

    public Checksummer(String str) throws FileNotFoundException, IOException {
        this.bBuf = ByteBuffer.wrap(str.getBytes("UTF-8"));
        this.updateDigesters();
        this.createChecksum();
    }

    public Checksummer(String str, String mdImpl) throws FileNotFoundException, IOException {
        this.otherChecksum = mdImpl;
        this.bBuf = ByteBuffer.wrap(str.getBytes("UTF-8"));
        this.updateDigesters();
        this.createChecksum();
    }

    public Checksummer(InputStream is) throws IOException {
        this.updateDigesters();
        if (is != null) {
            this.createChecksum(is);
        }
    }

    public Checksummer(InputStream is, boolean calcMD5, boolean calcSHA1, boolean calcCRC32, boolean calcSHA256) throws IOException {
        this.calcMD5 = calcMD5;
        this.calcSHA1 = calcSHA1;
        this.calcCRC32 = calcCRC32;
        this.calcSHA256 = calcSHA256;
        this.updateDigesters();
        if (is != null) {
            this.createChecksum(is);
        }
    }

    public Checksummer(InputStream is, OutputStream output, boolean calcMD5, boolean calcSHA1, boolean calcCRC32, boolean calcSHA256) throws IOException {
        this.calcMD5 = calcMD5;
        this.calcSHA1 = calcSHA1;
        this.calcCRC32 = calcCRC32;
        this.calcSHA256 = calcSHA256;
        this.fis = is;
        this.fos = output;
        this.updateDigesters();
    }

    public void setInputStream(InputStream is) {
        this.fis = is;
    }

    public void createChecksumAndCopyFile() throws IOException {
        int numRead;
        byte[] buffer = new byte[0x500000];
        do {
            if ((numRead = this.fis.read(buffer)) <= 0) continue;
            this.fos.write(buffer, 0, numRead);
            this.updateChecksum(buffer, numRead);
        } while (numRead != -1);
    }

    private void updateChecksum(byte[] buffer, int numRead) {
        if (this.md5 != null) {
            this.md5.update(buffer, 0, numRead);
        }
        if (this.sha1 != null) {
            this.sha1.update(buffer, 0, numRead);
        }
        if (this.sha256 != null) {
            this.sha256.update(buffer, 0, numRead);
        }
        if (this.other != null) {
            this.other.update(buffer, 0, numRead);
        }
        if (this.crc32 != null) {
            this.crc32.update(buffer, 0, numRead);
        }
    }

    private void createChecksum() {
        for (int i = 0; i < this.bBuf.limit(); ++i) {
            byte b = this.bBuf.get(i);
            if (this.md5 != null) {
                this.md5.update(b);
            }
            if (this.sha1 != null) {
                this.sha1.update(b);
            }
            if (this.sha256 != null) {
                this.sha256.update(b);
            }
            if (this.other != null) {
                this.other.update(b);
            }
            if (this.crc32 == null) continue;
            this.crc32.update(b);
        }
    }

    private void createChecksum(InputStream is) throws IOException {
        int numRead;
        this.fis = is;
        byte[] buffer = new byte[0x500000];
        do {
            if ((numRead = this.fis.read(buffer)) <= 0) continue;
            this.updateChecksum(buffer, numRead);
        } while (numRead != -1);
        this.fis.close();
    }

    private void createChecksum(File file) throws IOException {
        this.createChecksum(new FileInputStream(file));
    }

    private void updateDigesters() {
        if (this.otherChecksum != null) {
            try {
                this.other = MessageDigest.getInstance("otherChecksum");
            }
            catch (NoSuchAlgorithmException ex) {
                this.other = null;
            }
        }
        if (this.calcSHA1) {
            try {
                this.sha1 = MessageDigest.getInstance("SHA1");
            }
            catch (NoSuchAlgorithmException ex) {
                this.sha1 = null;
            }
        }
        if (this.calcSHA256) {
            try {
                this.sha256 = MessageDigest.getInstance("SHA-256");
            }
            catch (NoSuchAlgorithmException ex) {
                this.sha256 = null;
            }
        }
        if (this.calcMD5) {
            try {
                this.md5 = MessageDigest.getInstance("MD5");
            }
            catch (NoSuchAlgorithmException ex) {
                this.md5 = null;
            }
        }
        if (this.calcCRC32) {
            this.crc32 = new CRC32();
        }
    }

    public String getMD5() {
        if (this.md5 == null) {
            return null;
        }
        byte[] hash = this.md5.digest();
        return new String(Hex.encodeHex((byte[])hash));
    }

    public String getSHA1() {
        if (this.sha1 == null) {
            return null;
        }
        byte[] hash = this.sha1.digest();
        return new String(Hex.encodeHex((byte[])hash));
    }

    public String getSHA256() {
        if (this.sha256 == null) {
            return null;
        }
        byte[] hash = this.sha256.digest();
        return new String(Hex.encodeHex((byte[])hash));
    }

    public String getCRC32() {
        if (this.crc32 == null) {
            return null;
        }
        long hash = this.crc32.getValue();
        String crc32Str = Long.toHexString(hash);
        if (crc32Str != null) {
            while (crc32Str.length() < 8) {
                crc32Str = "0" + crc32Str;
            }
        }
        return crc32Str;
    }

    public String getOther() {
        if (this.other == null) {
            return null;
        }
        byte[] hash = this.other.digest();
        return new String(Hex.encodeHex((byte[])hash));
    }

    public String getChecksum(String mdImpl) throws NoSuchAlgorithmException {
        if ("CRC32".equals(mdImpl)) {
            return this.getCRC32();
        }
        if ("MD5".equals(mdImpl)) {
            return this.getMD5();
        }
        if ("SHA1".equals(mdImpl)) {
            return this.getSHA1();
        }
        if ("SHA256".equals(mdImpl)) {
            return this.getSHA256();
        }
        if (this.otherChecksum != null && this.otherChecksum.equals(mdImpl)) {
            return this.getOther();
        }
        return null;
    }

    public static long hex2decimal(String s) {
        String digits = "0123456789ABCDEF";
        s = s.toUpperCase();
        long val = 0L;
        for (int i = 0; i < s.length(); ++i) {
            char c = s.charAt(i);
            int d = digits.indexOf(c);
            val = 16L * val + (long)d;
        }
        return val;
    }

    public static String decimal2hex(int d) {
        String digits = "0123456789ABCDEF";
        if (d == 0) {
            return "0";
        }
        String hex = "";
        while (d > 0) {
            int digit = d % 16;
            hex = digits.charAt(digit) + hex;
            d /= 16;
        }
        return hex;
    }

    public Checksummer(InputStream is, boolean calcMD5, boolean calcSHA1, boolean calcCRC32) throws IOException {
        this.calcMD5 = calcMD5;
        this.calcSHA1 = calcSHA1;
        this.calcCRC32 = calcCRC32;
        this.updateDigesters();
        if (is != null) {
            this.createChecksum(is);
        }
    }

    public Checksummer(String str, boolean calcMD5, boolean calcSHA1, boolean calcCRC32) throws FileNotFoundException, IOException {
        this.calcMD5 = calcMD5;
        this.calcSHA1 = calcSHA1;
        this.calcCRC32 = calcCRC32;
        this.bBuf = ByteBuffer.wrap(str.getBytes("UTF-8"));
        this.updateDigesters();
        this.createChecksum();
    }

    public Checksummer(byte[] byteBuffer, boolean calcMD5, boolean calcSHA1, boolean calcCRC32) throws FileNotFoundException, IOException {
        this.calcMD5 = calcMD5;
        this.calcSHA1 = calcSHA1;
        this.calcCRC32 = calcCRC32;
        this.bBuf = ByteBuffer.wrap(byteBuffer);
        this.updateDigesters();
        this.createChecksum();
    }

    public Checksummer(File file, boolean calcMD5, boolean calcSHA1, boolean calcCRC32) throws IOException {
        this.calcMD5 = calcMD5;
        this.calcSHA1 = calcSHA1;
        this.calcCRC32 = calcCRC32;
        this.updateDigesters();
        if (file != null) {
            this.createChecksum(file);
        }
    }

    public static void main(String[] args) {
        try {
            Checksummer mcs = new Checksummer("sdfasdsdasdasdasdfasdf<hkgk>");
            String v = mcs.getChecksum("SHA-512");
            System.out.println(v);
            System.out.println(mcs.getChecksum("SHA-256"));
            System.out.println(mcs.getChecksum("SHA-384"));
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public Checksummer(InputStream is, OutputStream output, boolean calcMD5, boolean calcSHA1, boolean calcCRC32) throws IOException {
        this.calcMD5 = calcMD5;
        this.calcSHA1 = calcSHA1;
        this.calcCRC32 = calcCRC32;
        this.fis = is;
        this.fos = output;
        this.updateDigesters();
    }

    public static boolean isBundledFixityAlgorithm(String fixityAlgorithm) {
        try {
            return FixityAlgorithm.valueOf(fixityAlgorithm) != null;
        }
        catch (Exception e) {
            return false;
        }
    }

    public static enum FixityAlgorithm {
        MD5,
        SHA1,
        SHA256,
        CRC32;

    }
}

