/*
 * Decompiled with CFR 0.152.
 */
package com.exlibris.core.infra.common.util;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.UnsupportedEncodingException;
import java.text.NumberFormat;
import java.text.ParsePosition;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.Vector;

public class StringUtils {
    static final char SINGLE_QUOTATION_MARK = '\'';
    static final String UTF8 = "UTF-8";
    static Map<String, String> escapingCharacters = new HashMap<String, String>();

    public static String getLimitedUTF8LengthString(String str, int length) {
        if (null == str) {
            return str;
        }
        int newLength = length;
        String newString = str;
        try {
            int l = str.getBytes(UTF8).length;
            if (l <= length) {
                return str;
            }
            while (l > length) {
                newString = StringUtils.getLimitedLengthString(newString, --newLength);
                l = newString.getBytes(UTF8).length;
            }
        }
        catch (UnsupportedEncodingException e) {
            e.printStackTrace();
            return str;
        }
        return newString;
    }

    public static String getLimitedLengthString(String str, int length) {
        if (StringUtils.getNullSafeLength(str) > length) {
            return str.substring(0, length);
        }
        return str;
    }

    public static int getNullSafeLength(String str) {
        if (null != str) {
            return str.length();
        }
        return -1;
    }

    public static String textToHtml(String text) {
        String result = text;
        result = result.replaceAll("\\\\r\\\\n", "\n");
        result = result.replaceAll("\r", "\n");
        result = result.replaceAll("\n+", "<br>");
        return result;
    }

    public static String replaceTags(String str, String repl) {
        String regex = "<[^>]*>";
        return str.replaceAll(regex, repl);
    }

    public static String removeLetters(String str) {
        StringBuffer buf = new StringBuffer(str.length());
        for (int i = 0; i < str.length(); ++i) {
            char c = str.charAt(i);
            if (Character.isLetter(c)) continue;
            buf.append(c);
        }
        return buf.toString();
    }

    public static String remove_blanks(String str) {
        StringBuffer buf = new StringBuffer(str.length());
        for (int i = 0; i < str.length(); ++i) {
            if (str.charAt(i) == ' ') continue;
            buf.append(str.charAt(i));
        }
        return buf.toString();
    }

    public static String pack_blanks(String str) {
        StringBuffer buf = new StringBuffer(str.length());
        for (int i = 0; i < str.length() - 1; ++i) {
            if (str.charAt(i) == ' ' && str.charAt(i + 1) == ' ') continue;
            buf.append(str.charAt(i));
        }
        buf.append(str.charAt(str.length() - 1));
        return buf.toString().trim();
    }

    public static String suffix(String str, char c) {
        int i = str.lastIndexOf(c);
        if (i < 0) {
            return "";
        }
        return str.substring(i);
    }

    public static String base(String str, char c) {
        int i = str.lastIndexOf(c);
        if (i < 0) {
            return str;
        }
        return str.substring(0, i);
    }

    @Deprecated
    public static boolean isEmptyString(String Value) {
        if (Value == null) {
            return true;
        }
        char[] chars = Value.toCharArray();
        for (int i = 0; i < chars.length; ++i) {
            if (chars[i] <= '\u0000' || Character.isSpaceChar(chars[i])) continue;
            return false;
        }
        return true;
    }

    public static boolean isEqual(String value1, String value2) {
        if (value1 == null) {
            return value2 == null;
        }
        if (value2 == null) {
            return false;
        }
        return value1.equals(value2);
    }

    public static String replaceSubString(String original, String oldString, String newString) {
        StringBuffer sb = new StringBuffer();
        int end = original.indexOf(oldString);
        int start = 0;
        int stringSize = oldString.length();
        while (end != -1) {
            sb.append(original.substring(start, end));
            sb.append(newString);
            start = end + stringSize;
            end = original.indexOf(oldString, start);
        }
        end = original.length();
        sb.append(original.substring(start, end));
        return sb.toString();
    }

    public static boolean isDigitsString(String s) {
        if (s == null || s.length() == 0) {
            return false;
        }
        for (int i = 0; i < s.length(); ++i) {
            if (Character.isDigit(s.charAt(i))) continue;
            return false;
        }
        return true;
    }

    public static boolean startsWithDigit(String s) {
        if (s == null || s.length() == 0) {
            return false;
        }
        return Character.isDigit(s.charAt(0));
    }

    public static boolean isNumeric(String str) {
        NumberFormat formatter = NumberFormat.getInstance();
        ParsePosition pos = new ParsePosition(0);
        formatter.parse(str, pos);
        return str.length() == pos.getIndex();
    }

    public static String toAlphaNumeric(String str) {
        StringBuffer buf = new StringBuffer();
        for (int i = 0; i < str.length(); ++i) {
            char c = str.charAt(i);
            if (Character.isLetterOrDigit(c)) {
                buf.append(c);
                continue;
            }
            buf.append('_');
        }
        return buf.toString();
    }

    public static void extractParameter(String str, String[] result) {
        int pos = str.indexOf("=");
        if (pos == -1) {
            return;
        }
        result[0] = str.substring(0, pos);
        result[1] = str.substring(pos + 1);
    }

    public static Vector extractValues(String str, String delim) {
        Vector<String> valuesVector = new Vector<String>();
        if (str == null) {
            return valuesVector;
        }
        StringTokenizer tokenizer = new StringTokenizer(str, delim);
        String value = null;
        while (tokenizer.hasMoreTokens()) {
            value = tokenizer.nextToken();
            valuesVector.add(value);
        }
        return valuesVector;
    }

    public static Vector extractValues(String str, String delim, boolean splitStringSurroundedByQuotationMarks) throws IllegalArgumentException {
        if (splitStringSurroundedByQuotationMarks) {
            return StringUtils.extractValues(str, delim);
        }
        Vector splitStringBySingleQuotMarks = StringUtils.splitStringBySingleQuotationMarks(str);
        Vector<String> toReturn = new Vector<String>();
        for (String currSplitStr : splitStringBySingleQuotMarks) {
            if (currSplitStr.charAt(0) == '\'' && currSplitStr.charAt(currSplitStr.length() - 1) == '\'') {
                toReturn.add(currSplitStr.substring(1, currSplitStr.length() - 1));
                continue;
            }
            Vector innerSplitStrings = StringUtils.extractValues(currSplitStr, delim);
            Iterator innerSplitStringsIter = innerSplitStrings.iterator();
            while (innerSplitStringsIter.hasNext()) {
                toReturn.add((String)innerSplitStringsIter.next());
            }
        }
        return toReturn;
    }

    private static Vector splitStringBySingleQuotationMarks(String str) throws IllegalArgumentException {
        int nextSingleQuotMarkPos;
        int prevSingleQuotMarkPos = -1;
        int currSingleQuotMarkPos = str.indexOf(39);
        int lastSingleQuotMarkPos = nextSingleQuotMarkPos = str.indexOf(39, currSingleQuotMarkPos + 1);
        Vector<String> splitStrings = new Vector<String>();
        if (currSingleQuotMarkPos < 0) {
            splitStrings.add(str);
            return splitStrings;
        }
        do {
            if (currSingleQuotMarkPos < 0 || nextSingleQuotMarkPos < 0) {
                throw new IllegalArgumentException("Given string does not contain even number of quotation marks");
            }
            if (prevSingleQuotMarkPos + 1 < currSingleQuotMarkPos) {
                splitStrings.add(str.substring(prevSingleQuotMarkPos + 1, currSingleQuotMarkPos));
            }
            splitStrings.add(str.substring(currSingleQuotMarkPos, nextSingleQuotMarkPos + 1));
            prevSingleQuotMarkPos = nextSingleQuotMarkPos;
            currSingleQuotMarkPos = str.indexOf(39, nextSingleQuotMarkPos + 1);
            if (currSingleQuotMarkPos < 0 || (nextSingleQuotMarkPos = str.indexOf(39, currSingleQuotMarkPos + 1)) < 0) continue;
            lastSingleQuotMarkPos = nextSingleQuotMarkPos;
        } while (currSingleQuotMarkPos >= 0 && nextSingleQuotMarkPos >= 0);
        if (lastSingleQuotMarkPos < str.length() - 1) {
            splitStrings.add(str.substring(nextSingleQuotMarkPos + 1));
        }
        return splitStrings;
    }

    public static String makePathParameter(String paramater) {
        return "\"" + paramater + "\"";
    }

    public static String getParamsAsString(String[] params) {
        return StringUtils.getParamsAsString(params, " ");
    }

    public static String getParamsAsString(String[] params, String delim) {
        StringBuffer buf = new StringBuffer(100);
        for (int i = 0; i < params.length; ++i) {
            if (i > 0) {
                buf.append(delim);
            }
            buf.append(params[i]);
        }
        return buf.toString();
    }

    public static String getParamsAsString(Set params, String delim) {
        StringBuffer buf = new StringBuffer(100);
        Iterator itr = params.iterator();
        int i = 0;
        while (itr.hasNext()) {
            if (i > 0) {
                buf.append(delim);
            }
            buf.append(itr.next());
            ++i;
        }
        return buf.toString();
    }

    public static String getParamsAsString(Vector params, String delim) {
        if (params == null) {
            return null;
        }
        String[] result = new String[params.size()];
        result = params.toArray(result);
        return StringUtils.getParamsAsString(result, delim);
    }

    public static String getClassName(Class cls) {
        String className = cls.getName();
        int pos = className.lastIndexOf(46);
        if (pos == -1) {
            return className;
        }
        return className.substring(pos + 1);
    }

    public static String fillString(String str2Fill, String fillWithWhat, int howManyTimes, boolean shouldFillFromLeft) {
        for (int i = 0; i < howManyTimes; ++i) {
            str2Fill = shouldFillFromLeft ? fillWithWhat + str2Fill : str2Fill + fillWithWhat;
        }
        return str2Fill;
    }

    public static String readToString(InputStream in) {
        StringBuffer sb = new StringBuffer();
        try {
            String line;
            BufferedReader inbr = new BufferedReader(new InputStreamReader(in));
            while ((line = inbr.readLine()) != null) {
                sb.append(line);
            }
            return sb.toString();
        }
        catch (IOException e) {
            return null;
        }
    }

    public static String convertDBStr2GUIStr(String str2Convert, WordSeparator separateByWhat) {
        String toReturn;
        block5: {
            block4: {
                if (str2Convert == null) {
                    return null;
                }
                if (separateByWhat == null) {
                    return str2Convert;
                }
                toReturn = null;
                if (separateByWhat != WordSeparator.BY_SPACE_OR_UNDERSCORE) break block4;
                toReturn = str2Convert.replace('_', ' ');
                toReturn = toReturn.toUpperCase().charAt(0) + toReturn.substring(1, toReturn.length());
                for (int i = 0; i < toReturn.length(); ++i) {
                    if (toReturn.charAt(i) != ' ' || i >= toReturn.length() - 2) continue;
                    toReturn = toReturn.substring(0, i + 1) + toReturn.toUpperCase().charAt(i + 1) + toReturn.substring(i + 2, toReturn.length());
                }
                break block5;
            }
            if (separateByWhat != WordSeparator.BY_CAPITAL_LETTER) break block5;
            toReturn = str2Convert;
            for (int i = 1; i < toReturn.length(); ++i) {
                if (toReturn.charAt(i) < 'A' || toReturn.charAt(i) > 'Z') continue;
                toReturn = toReturn.substring(0, i) + ' ' + toReturn.substring(i);
                ++i;
            }
        }
        return toReturn;
    }

    public static String removeAllCharOccurrences(char char2Remove, String str2RemoveFrom) {
        if (str2RemoveFrom == null) {
            return null;
        }
        String toReturn = "";
        for (int i = 0; i < str2RemoveFrom.length(); ++i) {
            if (str2RemoveFrom.charAt(i) == char2Remove) continue;
            toReturn = toReturn + str2RemoveFrom.charAt(i);
        }
        return toReturn;
    }

    public static String[] splitValueDelimited(String valueToSplit, String delimiter) {
        String pattern = delimiter + "(?=(?:[^\"]*\"[^\"]*\")*(?![^\"]*\"))";
        String[] res = valueToSplit.split(pattern);
        return res;
    }

    public static String[] removeElement(String[] arr, int index) {
        String[] ret = new String[arr.length - 1];
        System.arraycopy(arr, 0, ret, 0, index);
        System.arraycopy(arr, index + 1, ret, index, arr.length - index - 1);
        return ret;
    }

    public static String zeroPadding(int number, int size) {
        StringBuffer str = new StringBuffer();
        String numberStr = Integer.toString(number);
        for (int i = 0; i < size - numberStr.length(); ++i) {
            str.append("0");
        }
        str.append(numberStr);
        return str.toString();
    }

    public static String spacePadding(String str, int size) {
        if (str == null) {
            str = "";
        }
        while (str.length() < size) {
            str = str + " ";
        }
        if (str.length() > size) {
            str = str.substring(0, size);
        }
        return str;
    }

    public static List splitCSV(String line) {
        ArrayList<String> lst = new ArrayList<String>();
        if (line == null || line.trim().length() == 0) {
            return lst;
        }
        String[] res = StringUtils.splitValueDelimited(line, ",");
        for (int i = 0; i < res.length; ++i) {
            String frmtd = res[i].trim();
            if (frmtd.startsWith("\"") && (frmtd = frmtd.replaceFirst("\"", "")).endsWith("\"")) {
                frmtd = frmtd.substring(0, frmtd.length() - 1);
            }
            frmtd = frmtd.replaceAll("\"\"", "\"");
            lst.add(frmtd.trim());
        }
        return lst;
    }

    public static void appendWithSeparator(StringBuffer buf, String str, String sep) {
        if (null == buf) {
            throw new IllegalArgumentException("buf may not be null");
        }
        if (null == str || str.length() == 0) {
            return;
        }
        if (buf.length() > 0 && null != sep) {
            buf.append(sep);
        }
        buf.append(str);
    }

    public static String encodingProblematicChars(String source) {
        if (source == null) {
            return null;
        }
        String toReturn = "";
        for (int i = 0; i < source.length(); ++i) {
            String s = String.valueOf(source.charAt(i));
            toReturn = escapingCharacters.containsKey(s) ? toReturn + escapingCharacters.get(s) : toReturn + source.charAt(i);
        }
        return toReturn;
    }

    public static String concat(Object ... array) {
        if (array == null) {
            return null;
        }
        int bufSize = array.length;
        if (array.length <= 0) {
            return "";
        }
        StringBuilder stringBuilder = new StringBuilder(bufSize *= array[0] == null ? 16 : array[0].toString().length());
        for (Object object : array) {
            if (object == null) continue;
            stringBuilder.append(object);
        }
        return stringBuilder.toString();
    }

    public static String splitCamelCase(String s) {
        return s.replaceAll(String.format("%s|%s|%s", "(?<=[A-Z])(?=[A-Z][a-z])", "(?<=[^A-Z])(?=[A-Z])", "(?<=[A-Za-z])(?=[^A-Za-z])"), " ");
    }

    public static boolean checkRTLOfString(String str) {
        if (str == null) {
            return false;
        }
        long length = str.length();
        int i = 0;
        while ((long)i < length) {
            char charCode = str.charAt(i);
            if (charCode > '\u0590' && charCode < '\u05ff') {
                return true;
            }
            ++i;
        }
        return false;
    }

    static {
        escapingCharacters.put("<", "&lt;");
        escapingCharacters.put(">", "&gt;");
        escapingCharacters.put("\"", "&quot;");
    }

    public static class WordSeparator {
        public static WordSeparator BY_SPACE_OR_UNDERSCORE = new WordSeparator("Space or underscore");
        public static WordSeparator BY_CAPITAL_LETTER = new WordSeparator("Capital letter");
        private String description;

        private WordSeparator(String description) {
            this.description = description;
        }

        public String getDescription() {
            return this.description;
        }
    }
}

