/*
 * Decompiled with CFR 0.152.
 */
package com.exlibris.core.infra.console;

import com.exlibris.core.infra.console.ConsolePage;
import com.exlibris.core.infra.svc.api.sharedsession.SessionHelper;
import java.lang.ref.WeakReference;
import java.util.Date;
import java.util.Enumeration;
import java.util.Map;
import javax.servlet.http.HttpSession;

public class SessionsList
extends ConsolePage {
    String printSessionList() throws Exception {
        StringBuilder sb = new StringBuilder();
        Map<String, WeakReference<SessionHelper.SharedSession>> sessions = SessionHelper.getSharedSessions();
        this.addHeader(sb);
        sb.append("<table border='1'>");
        sb.append("<tr>");
        this.addColumn(sb, "session id");
        this.addColumn(sb, "creation date");
        this.addColumn(sb, "last use");
        this.addColumn(sb, "used time");
        this.addColumn(sb, "number of shared attributes");
        this.addColumn(sb, "number attributes");
        this.addColumn(sb, "contexts");
        sb.append("</tr>");
        for (String sessionId : sessions.keySet()) {
            if (sessions.get(sessionId) == null) continue;
            sb.append("<tr>");
            SessionHelper.SharedSession sharedSession = (SessionHelper.SharedSession)sessions.get(sessionId).get();
            int nbAttributes = sharedSession.attributes.size();
            for (String context : sharedSession.sessionContexts) {
                HttpSession session = sharedSession.sessions.get(context);
                Enumeration names = session.getAttributeNames();
                while (names.hasMoreElements()) {
                    names.nextElement();
                    ++nbAttributes;
                }
            }
            this.addColumn(sb, "<a href='session?sessionId=" + sessionId + "'>" + sessionId + "</a>");
            this.addColumn(sb, new Date(sharedSession.create));
            this.addColumn(sb, new Date(sharedSession.lastUse));
            this.addColumn(sb, (sharedSession.lastUse - sharedSession.create) / 1000L + "s");
            this.addColumn(sb, sharedSession.attributes.size());
            this.addColumn(sb, nbAttributes);
            this.addColumn(sb, sharedSession.sessionContexts.toString());
            sb.append("</tr>");
        }
        sb.append("</table>");
        this.addFooter(sb);
        return sb.toString();
    }
}

