/*
 * Decompiled with CFR 0.152.
 */
package com.exlibris.core.infra.model.authentication;

import com.exlibris.core.infra.model.HStandardEntity;
import com.exlibris.core.infra.model.authentication.AuthenticationProfileParameter;
import java.util.List;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.EnumType;
import javax.persistence.Enumerated;
import javax.persistence.FetchType;
import javax.persistence.OneToMany;
import javax.persistence.Table;
import javax.persistence.UniqueConstraint;
import org.hibernate.annotations.Cascade;
import org.hibernate.annotations.CascadeType;

@Entity
@Table(uniqueConstraints={@UniqueConstraint(columnNames={"name"})})
public class AuthenticationProfile
extends HStandardEntity {
    private static final long serialVersionUID = 1187393568092357989L;
    private String name;
    private String description;
    private AuthenticationProfileType profileType;
    private List<AuthenticationProfileParameter> authenticationProfileParamters;

    @Column(nullable=false)
    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    @Column
    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    @Column
    @Enumerated(value=EnumType.STRING)
    public AuthenticationProfileType getProfileType() {
        return this.profileType;
    }

    public void setProfileType(AuthenticationProfileType profileType) {
        this.profileType = profileType;
    }

    @OneToMany(targetEntity=AuthenticationProfileParameter.class, mappedBy="authenticationProfile", fetch=FetchType.EAGER)
    @Cascade(value={CascadeType.ALL, CascadeType.DELETE_ORPHAN})
    public List<AuthenticationProfileParameter> getAuthenticationProfileParamters() {
        return this.authenticationProfileParamters;
    }

    public void setAuthenticationProfileParamters(List<AuthenticationProfileParameter> authenticationProfileParamters) {
        this.authenticationProfileParamters = authenticationProfileParamters;
    }

    public static enum AuthenticationProfileType {
        SAML;

    }
}

