/*
 * Decompiled with CFR 0.152.
 */
package com.exlibris.core.infra.svc.api.queue;

import com.exlibris.core.infra.common.exceptions.logging.ExLogger;
import com.exlibris.core.infra.svc.api.queue.ExecutableJob;
import com.exlibris.core.infra.svc.api.queue.QueueConstants;
import com.exlibris.core.infra.svc.api.queue.WorkQueue;
import com.exlibris.core.infra.svc.api.queue.WorkQueueApplicationException;
import java.util.LinkedList;
import java.util.List;

public abstract class AbstractWorkQueue<T>
implements WorkQueue<T> {
    List<ExecutableJob<T>> listeners = new LinkedList<ExecutableJob<T>>();
    String name = null;
    private static final ExLogger log = ExLogger.getExLogger(AbstractWorkQueue.class);

    @Override
    public abstract void enqueue(T var1, String var2, String var3, int var4, QueueConstants.messageType var5) throws WorkQueueApplicationException;

    @Override
    public void addListener(ExecutableJob<T> j) {
        this.listeners.add(j);
    }

    @Override
    public void removeListener(ExecutableJob<T> j) {
        this.listeners.remove(j);
    }

    @Override
    public void notifyListeners(T o) throws Exception {
        if (this.listeners.size() == 0) {
            log.error("The listeners list for queue " + this.name + " is empty", new String[0]);
            throw new RuntimeException("The listeners list for queue " + this.name + " is empty");
        }
        if (o != null) {
            for (ExecutableJob<T> j : this.listeners) {
                j.execute(o);
            }
        }
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public void setName(String name) {
        this.name = name;
    }
}

