/*
 * Decompiled with CFR 0.152.
 */
package com.exlibris.core.infra.svc.api.security;

import com.exlibris.core.infra.Common;
import com.exlibris.core.infra.common.exceptions.logging.ExLogger;
import com.exlibris.core.infra.common.security.UserPrincipalRetriever;
import com.exlibris.core.infra.svc.api.AuthenticationManager;
import com.exlibris.core.infra.svc.api.locator.ServiceLocator;
import com.exlibris.core.infra.svc.api.utils.AuthenticationUtil;
import java.util.HashMap;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang.StringUtils;
import org.springframework.security.authentication.UsernamePasswordAuthenticationToken;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.AuthenticationException;
import org.springframework.security.web.authentication.UsernamePasswordAuthenticationFilter;

public class PdsInstitutionAuthenticationFilter
extends UsernamePasswordAuthenticationFilter {
    private static final ExLogger logger = ExLogger.getExLogger(PdsInstitutionAuthenticationFilter.class);

    public Authentication attemptAuthentication(HttpServletRequest request, HttpServletResponse response) throws AuthenticationException {
        this.setPostOnly(false);
        return super.attemptAuthentication(request, response);
    }

    protected String obtainPassword(HttpServletRequest request) {
        String password = null;
        switch (this.getAuthenticationMode(request)) {
            case PDS: {
                password = request.getParameter("inst") == null ? "null" : request.getParameter("inst");
                break;
            }
            case LOCAL: {
                password = (String)request.getSession().getAttribute("password");
                request.getSession().setAttribute("password", null);
                break;
            }
            case SAML: {
                password = request.getParameter("SAMLResponse");
            }
        }
        return password;
    }

    protected String obtainUsername(HttpServletRequest request) {
        String username = null;
        switch (this.getAuthenticationMode(request)) {
            case PDS: {
                username = request.getParameter("pds_handle");
                break;
            }
            case LOCAL: {
                username = (String)request.getSession().getAttribute("username");
                break;
            }
            case SAML: {
                username = this.handleSaml(request);
            }
        }
        return username;
    }

    private String handleSaml(HttpServletRequest request) {
        String username = null;
        if (StringUtils.isBlank((String)request.getParameter("SAMLResponse")) && UserPrincipalRetriever.getUserPrincipal() != null) {
            username = (String)request.getSession().getAttribute("username");
        } else {
            String samlProfile = AuthenticationUtil.getAuthenticationProfileName(request);
            HashMap<String, String> authenticationParameters = new HashMap<String, String>();
            authenticationParameters.put("authenticationProfile", samlProfile);
            authenticationParameters.put("serverUrl", AuthenticationUtil.getServerUrl(request));
            request.getSession().setAttribute("authenticationParameters", authenticationParameters);
            String module = (String)request.getSession().getAttribute("curModule");
            String institution = "adm".equals(module) ? "CRS00" : (String)request.getSession().getAttribute("institution");
            username = request.getSession().getAttribute("SAML_Session_ID") + "-institutionCode-" + institution;
        }
        return username;
    }

    protected void setDetails(HttpServletRequest request, UsernamePasswordAuthenticationToken authRequest) {
        HashMap<String, Object> parameters = new HashMap<String, Object>();
        parameters.put("authentication_mode", (Object)this.getAuthenticationMode(request));
        parameters.put("authenticationParameters", AuthenticationUtil.getAuthenticationParameters(request));
        authRequest.setDetails(parameters);
    }

    private Common.AuthenticationMode getAuthenticationMode(HttpServletRequest request) {
        AuthenticationManager authenticationManager = (AuthenticationManager)ServiceLocator.getInstance().lookUp(AuthenticationManager.class);
        return authenticationManager.getAuthenticationMode(request);
    }
}

