/*
 * Decompiled with CFR 0.152.
 */
package com.exlibris.core.infra.svc.api.wizard;

import com.exlibris.core.infra.common.exceptions.logging.ExLogger;
import com.exlibris.core.infra.common.util.ResourceBundleUtil;
import com.exlibris.core.infra.model.codetables.HMappingTables;
import com.exlibris.core.infra.svc.api.CodeTablesManager;
import com.exlibris.core.infra.svc.api.CodeTablesResourceBundle;
import com.exlibris.core.infra.svc.api.WizardCustomButton;
import com.exlibris.core.infra.svc.api.flatobjects.Tab;
import com.exlibris.core.infra.svc.api.locator.ServiceLocator;
import com.exlibris.core.infra.svc.api.utils.FormBuilderUtilitiesApi;
import com.exlibris.core.infra.svc.api.wizard.WizardApi;
import com.exlibris.core.web.page.xmlbeans.XButton;
import com.exlibris.core.web.wizard.xmlbeans.CustomActions;
import com.exlibris.core.web.wizard.xmlbeans.Steps;
import com.exlibris.core.web.wizard.xmlbeans.WizardDocument;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.ResourceBundle;

public class SimpleWizard
implements WizardApi {
    private static final ExLogger log = ExLogger.getExLogger(WizardDocument.Wizard.class);
    public static final String SKIP_MAPPING_TABLE = "WizardStepConfig";
    private static long id = 1L;
    private WizardDocument.Wizard wizard;
    private Map<String, String> stepNameToUrl = new HashMap<String, String>();
    private Map<String, String> stepKeyNameToUrl = new HashMap<String, String>();
    private Map<String, Map<String, String>> stepParametersMap = new HashMap<String, Map<String, String>>();
    private List<String> stepsNames = new ArrayList<String>();
    private List<String> stepsUrl = new ArrayList<String>();
    private Map<String, Boolean> stepIsBackable = new HashMap<String, Boolean>();
    private Map<String, Boolean> stepIsCancelable = new HashMap<String, Boolean>();
    private Map<String, Tab> tabsRealNameToTab = new HashMap<String, Tab>();
    private Map<String, Tab> tabsCodeNameToTab = new HashMap<String, Tab>();
    private Map<String, List<WizardCustomButton>> stepCodeToCustomButtons = new HashMap<String, List<WizardCustomButton>>();
    private Map<String, Map<String, String>> stepToCustomActionsKeysAndValues = new HashMap<String, Map<String, String>>();
    private List<Tab> tabs = new ArrayList<Tab>();
    private boolean confirmCancalation = false;
    private int wizardViewType;
    private int stepIndex = 0;
    private String wizardId;
    private List<String> skipStepList;
    private Locale locale;
    private String wizardName;
    private Tab lastTab;
    private Tab currentTab;
    private String currentStepName;

    @Override
    public String getWizardId() {
        return this.wizardId;
    }

    public SimpleWizard(String wizardName, WizardDocument.Wizard wizard, Locale locale) {
        this.wizard = wizard;
        this.locale = locale;
        this.wizardName = wizardName;
    }

    @Override
    public String getCurrentStep() {
        return this.stepsUrl.get(this.stepIndex);
    }

    @Override
    public String getNextStep() {
        ++this.stepIndex;
        this.currentStepName = this.stepsNames.get(this.stepIndex);
        return this.stepsUrl.get(this.stepIndex);
    }

    @Override
    public String getPrevStep() {
        --this.stepIndex;
        this.currentStepName = this.stepsNames.get(this.stepIndex);
        return this.stepsUrl.get(this.stepIndex);
    }

    @Override
    public String getStepByName(String stepName) {
        String stepUrl = this.stepNameToUrl.get(stepName);
        if (stepUrl == null) {
            stepUrl = this.stepKeyNameToUrl.get(stepName);
        }
        return stepUrl;
    }

    @Override
    public List<String> getStepsNames() {
        return this.stepsNames;
    }

    @Override
    public String getCurrentStepName() {
        return this.currentStepName;
    }

    @Override
    public boolean isStepBackable(String stepName) {
        return this.stepIsBackable.get(stepName);
    }

    @Override
    public int getWizardSize() {
        return this.stepsNames.size();
    }

    @Override
    public void saveStepParameters(String stepName, Map<String, String> parameters) {
        this.stepParametersMap.put(stepName, parameters);
    }

    @Override
    public Map<String, String> getStepParameters(String stepName) {
        return this.stepParametersMap.get(stepName);
    }

    @Override
    public int getWizardViewType() {
        return this.wizardViewType;
    }

    @Override
    public void initWizard() {
        this.initWizardId();
        try {
            Steps wizardSteps = this.wizard.getSteps();
            this.wizardViewType = this.wizard.getWizardUiType().intValue();
            Steps.Step[] steps = wizardSteps.getStepArray();
            this.confirmCancalation = this.wizard.getConfirmationMessagebox();
            ResourceBundle resourceBundle = CodeTablesResourceBundle.getDefaultBundle(this.locale);
            for (Steps.Step step : steps) {
                if (step.isSetSkippable() && this.skipStep(step.getLabel())) continue;
                this.stepsNames.add(step.getLabel());
                String urlTemplate = step.getUrlTemplate().trim();
                this.stepsUrl.add(urlTemplate);
                String stepTitle = this.getTitle(step.getLabel());
                this.stepNameToUrl.put(stepTitle, urlTemplate);
                this.stepKeyNameToUrl.put(step.getLabel(), urlTemplate);
                if (step.isSetBackable()) {
                    this.stepIsBackable.put(step.getLabel(), step.getBackable());
                } else {
                    this.stepIsBackable.put(step.getLabel(), true);
                }
                if (step.isSetCancelable()) {
                    this.stepIsCancelable.put(step.getLabel(), step.getCancelable());
                } else {
                    this.stepIsCancelable.put(step.getLabel(), true);
                }
                this.initTabWizard(step, stepTitle);
                CustomActions actions = step.getCustomActions();
                if (actions == null) continue;
                XButton[] customActions = actions.getCustomActionArray();
                ArrayList<WizardCustomButton> buttons = new ArrayList<WizardCustomButton>();
                HashMap<String, String> customActionsKeyByValue = new HashMap<String, String>();
                for (XButton customAction : customActions) {
                    WizardCustomButton button = new WizardCustomButton();
                    button.setPosition(customAction.getButtonPosition().intValue());
                    button.setLabel(customAction.getLabel());
                    String customUrlTemplate = customAction.getUrlTemplate();
                    if (customUrlTemplate != null) {
                        customUrlTemplate = new StringBuffer().append(customUrlTemplate.trim()).append("&stepName=").append(stepTitle).toString();
                    }
                    button.setUrlTemplate(customUrlTemplate);
                    if (!customAction.isSetPositiveAction()) {
                        button.setPositiveAction(true);
                    } else {
                        button.setPositiveAction(customAction.getPositiveAction());
                    }
                    button.setModes(FormBuilderUtilitiesApi.getFieldModes(customAction.getXFieldModes()));
                    if (customAction.getVisible() != null) {
                        button.setVisibleFieldName(customAction.getVisible().getXFieldName());
                        button.setVisibleDefaultValue(customAction.getVisible().getDefaultValue());
                    }
                    buttons.add(button);
                    customActionsKeyByValue.put(ResourceBundleUtil.getString(resourceBundle, customAction.getLabel()), customAction.getLabel());
                }
                this.stepCodeToCustomButtons.put(step.getLabel(), buttons);
                if (customActionsKeyByValue.size() <= 0) continue;
                this.stepToCustomActionsKeysAndValues.put(step.getLabel(), customActionsKeyByValue);
            }
            this.setDefaultSelectedTab(steps[0]);
        }
        catch (Exception e) {
            log.error("problem during the initialize of the wizard", e, new String[0]);
        }
    }

    private void initTabWizard(Steps.Step step, String stepTitle) {
        Tab wizardTab = new Tab();
        wizardTab.setLabel(step.getLabel());
        String urlTemplate = new StringBuffer().append(step.getUrlTemplate().trim()).append("&stepName=").append(step.getLabel()).toString();
        wizardTab.setUrlTemplate(urlTemplate);
        wizardTab.setModified(false);
        if (step.getVisible() != null) {
            wizardTab.setVisibleFieldName(step.getVisible().getXFieldName());
            wizardTab.setVisibleDefaultValue(step.getVisible().getDefaultValue());
        }
        this.tabsRealNameToTab.put(stepTitle, wizardTab);
        this.tabsCodeNameToTab.put(step.getLabel(), wizardTab);
        this.tabs.add(wizardTab);
    }

    private void setDefaultSelectedTab(Steps.Step step) {
        String stepName = step.getLabel();
        Tab tab = this.tabsCodeNameToTab.get(stepName);
        tab.setIsSelected(Boolean.TRUE.toString());
        this.lastTab = tab;
        this.currentTab = tab;
        this.setCurrentStepName(stepName);
    }

    private boolean skipStep(String title) {
        if (this.skipStepList == null) {
            this.skipStepList = new ArrayList<String>();
            CodeTablesManager codeTableManager = (CodeTablesManager)ServiceLocator.getInstance().lookUp(CodeTablesManager.class);
            if (codeTableManager != null) {
                List<HMappingTables> dateMapppingTable = codeTableManager.findMappingTableByName(SKIP_MAPPING_TABLE);
                for (HMappingTables mappingTables : dateMapppingTable) {
                    if (mappingTables.getTargetCode() == null || !mappingTables.getTargetCode().equals(this.wizardName)) continue;
                    this.skipStepList.add(mappingTables.getSourceCode1());
                }
            }
        }
        return this.skipStepList.contains(title);
    }

    private void initWizardId() {
        this.wizardId = new Long(++id).toString();
    }

    @Override
    public int getStepCurrentIndex() {
        return this.stepIndex;
    }

    @Override
    public boolean isConfirmCancalation() {
        return this.confirmCancalation;
    }

    @Override
    public boolean isStepCancelable(String stepName) {
        return this.stepIsCancelable.get(stepName);
    }

    @Override
    public List<Tab> getWizardTabs() {
        return this.tabs;
    }

    @Override
    public Tab getTabByStepName(String name) {
        Tab tab;
        if (name.contains("*")) {
            name = name.substring(2, name.length());
        }
        if ((tab = this.tabsRealNameToTab.get(name)) == null) {
            tab = this.tabsCodeNameToTab.get(name);
        }
        if (tab != null) {
            this.currentStepName = tab.getLabel();
        }
        return tab;
    }

    private String getTitle(String titlePath) {
        ResourceBundle resourceBundle;
        String title = null;
        if (this.locale != null && (resourceBundle = CodeTablesResourceBundle.getDefaultBundle(this.locale)) != null) {
            try {
                title = ResourceBundleUtil.getString(resourceBundle, titlePath);
            }
            catch (Exception E) {
                title = "";
            }
        }
        return title;
    }

    @Override
    public Tab getCurrentTab() {
        return this.currentTab;
    }

    @Override
    public Tab getLastTab() {
        return this.lastTab;
    }

    @Override
    public void setLastTab(Tab tab) {
        this.lastTab = tab;
    }

    @Override
    public void setCurrentTab(Tab tab) {
        this.currentTab = tab;
    }

    @Override
    public List<WizardCustomButton> getCustomButtons(String stepName) {
        return this.stepCodeToCustomButtons.get(stepName);
    }

    @Override
    public void setCurrentStepName(String stepName) {
        this.currentStepName = stepName;
    }

    @Override
    public String getCustomButtonKey(String stepName, String operation) {
        if (this.stepToCustomActionsKeysAndValues.get(stepName) != null) {
            return this.stepToCustomActionsKeysAndValues.get(stepName).get(operation);
        }
        return null;
    }

    @Override
    public void skipStep() {
        if (this.stepIndex + 1 < this.stepsNames.size() - 1) {
            ++this.stepIndex;
        }
    }

    @Override
    public void backToPrevStep() {
        if (this.stepIndex > 1) {
            --this.stepIndex;
        }
    }
}

