/*
 * Decompiled with CFR 0.152.
 */
package com.exlibris.core.sdk.formatting;

import com.exlibris.core.infra.common.exceptions.logging.ExLogger;
import com.exlibris.core.infra.svc.api.utils.DublinCoreDefinition;
import com.exlibris.core.sdk.formatting.DublinCoreFactory;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.StringTokenizer;
import org.apache.commons.lang.StringUtils;
import org.dom4j.Attribute;
import org.dom4j.Document;
import org.dom4j.DocumentException;
import org.dom4j.DocumentFactory;
import org.dom4j.Element;
import org.dom4j.Namespace;
import org.dom4j.Node;
import org.dom4j.QName;
import org.dom4j.io.SAXReader;

public class DublinCore {
    private static ExLogger log = ExLogger.getExLogger(DublinCore.class);
    public static final int DC_NAMESPACE = 10;
    public static final int DCTERMS_NAMESPACE = 20;
    public static final int MODS_NAMESPACE = 30;
    public static final int MARCREL_NAMESPACE = 40;
    public static final int ROSETTA_NAMESPACE = 50;
    public static final String DC_PREFIX = "dc";
    public static final String DCTERMS_PERFIX = "dcterms";
    public static final String MODS_PREFIX = "mods";
    public static final String MARCREL_PREFIX = "marcrel";
    public static final String XSI_TYPE = "xsi:type";
    private Document m_document = null;
    private Element m_record = null;
    private String mid = null;
    public static final Namespace dcNamespace = new Namespace("dc", "http://purl.org/dc/elements/1.1/");
    public static final Namespace dctermsNamespace = new Namespace("dcterms", "http://purl.org/dc/terms/");
    public static final Namespace modsNamespace = new Namespace("mods", "http://www.loc.gov/mods/v3");
    public static final Namespace marcrelNamespace = new Namespace("marcrel", "http://www.loc.gov/marc/relators/");
    public static final Namespace rosettaNamespace = new Namespace("rosetta", "http://www.exlibrisgroup.com/dps");
    public static final Namespace xsiNamespace = new Namespace("xsi", "http://www.w3.org/2001/XMLSchema-instance");
    public static final Namespace xmlNamespace = new Namespace("xml", "http://www.w3.org/XML/1998/namespace");
    public static final QName XsiQName = new QName("type", xsiNamespace);
    public static final QName XmlQName = new QName("lang", xmlNamespace);
    public static final QName RECORD_NODE_NAME = new QName("record", dcNamespace);

    public static void main(String[] args) throws IOException {
        System.out.println(DublinCoreFactory.getInstance().createDocument().toXml());
        DublinCore DC = DublinCoreFactory.getInstance().createDocument();
        System.out.println(DC.toXml());
    }

    protected DublinCore() {
        this.createNew();
    }

    protected DublinCore(String xml) throws DocumentException {
        this.createFromXml(xml);
    }

    public String getTitle() {
        String label = "";
        label = this.getDcValue("title");
        if (label == null) {
            label = this.getDctermsValue("alternative");
        }
        return label;
    }

    public DublinCore copyDC() throws Exception {
        return new DublinCore(this.toXml());
    }

    private void createFromXml(String xml) throws DocumentException {
        SAXReader reader = new SAXReader();
        this.m_document = reader.read((Reader)new StringReader(xml));
        this.m_record = this.m_document.getRootElement();
    }

    private void createNew() {
        this.m_document = DocumentFactory.getInstance().createDocument();
        this.m_record = this.m_document.addElement(RECORD_NODE_NAME);
        this.m_record.add(dcNamespace);
        this.m_record.add(dctermsNamespace);
        this.m_record.add(xsiNamespace);
    }

    public void addNamespace(Namespace namespace) {
        if (namespace == null) {
            return;
        }
        String prefix = namespace.getPrefix();
        if (this.getNamespace(prefix) == null) {
            this.m_record.add(namespace);
        }
    }

    public Namespace getNamespace(String prefix) {
        return this.m_record.getNamespaceForPrefix(prefix);
    }

    public List<Namespace> getNamespaces() {
        LinkedList<Namespace> namespaces = new LinkedList<Namespace>();
        namespaces.add(dcNamespace);
        namespaces.add(dctermsNamespace);
        namespaces.add(xsiNamespace);
        Collection<Namespace> collection = DublinCoreDefinition.getNameSpaceMap().values();
        if (collection != null) {
            namespaces.addAll(collection);
        }
        return namespaces;
    }

    @Deprecated
    public void addElement(int namespace, String key, String value) {
        this.addElement(namespace, key, null, value);
    }

    @Deprecated
    public void addElement(int namespace, String key, String xsiType, String value) {
        if (value == null) {
            return;
        }
        QName qname = null;
        if (namespace == 10) {
            qname = new QName(key, dcNamespace);
        } else if (namespace == 20) {
            qname = new QName(key, dctermsNamespace);
        } else if (namespace == 30) {
            qname = new QName(key, modsNamespace);
        } else if (namespace == 40) {
            qname = new QName(key, marcrelNamespace);
        } else if (namespace == 50) {
            qname = new QName(key, rosettaNamespace);
        } else {
            return;
        }
        Element elem = this.m_record.addElement(qname);
        elem.setText(value);
        if (xsiType != null) {
            elem.addAttribute(XsiQName, xsiType);
        }
    }

    @Deprecated
    public void addElement(int namespace, String key, Element xsiType, String value, boolean flag) {
        QName qname = null;
        if (namespace == 10) {
            qname = new QName(key, dcNamespace);
        } else if (namespace == 20) {
            qname = new QName(key, dctermsNamespace);
        } else if (namespace == 30) {
            qname = new QName(key, modsNamespace);
        } else if (namespace == 40) {
            qname = new QName(key, marcrelNamespace);
        } else if (namespace == 50) {
            qname = new QName(key, rosettaNamespace);
        } else {
            return;
        }
        Element elem = this.m_record.addElement(qname);
        elem.setText(value);
        for (int i = 0; i < xsiType.attributes().size(); ++i) {
            elem.addAttribute(xsiType.attribute(i).getQualifiedName(), xsiType.attribute(i).getValue());
        }
    }

    private QName getQNameFromString(String str) {
        if (com.exlibris.core.infra.common.util.StringUtils.isEmptyString(str)) {
            return null;
        }
        String[] array = str.split(":");
        if (array == null || array.length != 2) {
            return null;
        }
        Namespace namespace = this.getNamespace(array[0]);
        if (namespace == null) {
            return null;
        }
        return new QName(array[1], namespace);
    }

    public void addElement(String xPathKey, String value) {
        this.addElement(xPathKey, value, null);
    }

    public void addElement(String xPathKey, String value, QName qName) {
        if (qName == null) {
            qName = XsiQName;
        }
        if (com.exlibris.core.infra.common.util.StringUtils.isEmptyString(xPathKey)) {
            return;
        }
        String[] array = xPathKey.split("@");
        if (array == null || array.length < 1) {
            return;
        }
        QName qname = this.getQNameFromString(array[0]);
        if (qname == null) {
            return;
        }
        Element elem = this.m_record.addElement(qname);
        elem.setText(value);
        if (array.length >= 2 && !StringUtils.isBlank((String)array[1])) {
            elem.addAttribute(XsiQName, array[1]);
        }
        if (array.length == 3) {
            elem.addAttribute(XmlQName, array[2]);
        }
    }

    public String getDcValue(String key) {
        return this.getValue(10, key, null);
    }

    public String getDctermsValue(String key) {
        return this.getValue(20, key, null);
    }

    public String getMarcrelValue(String key) {
        return this.getValue(40, key, null);
    }

    public String getModsValue(String key) {
        return this.getValue(30, key, null);
    }

    public String getValue(String namespace, String key) {
        return this.getValue(namespace, key, null);
    }

    public String getValue(String xPathKey) {
        DCElement dcElem = this.parseKey(xPathKey);
        if (dcElem == null) {
            return null;
        }
        return this.getValue(dcElem.namespace, dcElem.key, dcElem.xsiType);
    }

    public List getValues(String xPathKey) {
        DCElement dcElem = this.parseKey(xPathKey);
        if (dcElem == null) {
            return null;
        }
        return this.getValues(dcElem.namespace, dcElem.key, dcElem.xsiType, dcElem.xmlLang);
    }

    private String getValue(int namespace, String key, String xsiType) {
        StringBuffer xpath = new StringBuffer("//");
        if (namespace == 10) {
            xpath.append(DC_PREFIX);
        } else if (namespace == 20) {
            xpath.append(DCTERMS_PERFIX);
        } else if (namespace == 30) {
            xpath.append(MODS_PREFIX);
        } else if (namespace == 40) {
            xpath.append(MARCREL_PREFIX);
        } else {
            return null;
        }
        if (key == null || key.length() == 0) {
            return null;
        }
        StringTokenizer st = new StringTokenizer(key, "/");
        String index = null;
        if (st.hasMoreElements()) {
            key = (String)st.nextElement();
        }
        if (st.hasMoreElements()) {
            index = (String)st.nextElement();
        }
        xpath.append(":").append(key);
        if (xsiType == null || xsiType.length() == 0) {
            xpath.append("[not(@*)]");
        } else {
            xpath.append("[@xsi:type='").append(xsiType).append("']");
        }
        if (index == null || index.length() == 0) {
            return this.getXPathValue(xpath.toString());
        }
        List list = this.getXPathValues(xpath.toString());
        int i = Integer.parseInt(index) - 1;
        return (String)list.get(i);
    }

    public String getValue(String namespace, String key, String xsiType) {
        StringBuffer xpath = new StringBuffer("//");
        if (namespace == null) {
            return null;
        }
        xpath.append(namespace);
        if (key == null || key.length() == 0) {
            return null;
        }
        StringTokenizer st = new StringTokenizer(key, "/");
        String index = null;
        if (st.hasMoreElements()) {
            key = (String)st.nextElement();
        }
        if (st.hasMoreElements()) {
            index = (String)st.nextElement();
        }
        xpath.append(":").append(key);
        if (xsiType == null || xsiType.length() == 0) {
            xpath.append("[not(@*)]");
        } else {
            xpath.append("[@xsi:type='").append(xsiType).append("']");
        }
        if (index == null || index.length() == 0) {
            return this.getXPathValue(xpath.toString());
        }
        List list = this.getXPathValues(xpath.toString());
        int i = Integer.parseInt(index) - 1;
        return (String)list.get(i);
    }

    public List getValues(String namespace, String key, String xsiType) {
        return this.getValues(namespace, key, xsiType, null);
    }

    public List getValues(String namespace, String key, String xsiType, String xmlLang) {
        StringBuffer xpath = new StringBuffer("//");
        if (namespace == null) {
            return null;
        }
        xpath.append(namespace);
        if (key == null || key.length() == 0) {
            return null;
        }
        StringTokenizer st = new StringTokenizer(key, "/");
        String index = null;
        if (st.hasMoreElements()) {
            key = (String)st.nextElement();
        }
        if (st.hasMoreElements()) {
            index = (String)st.nextElement();
        }
        xpath.append(":").append(key);
        if (StringUtils.isBlank((String)xsiType) && StringUtils.isBlank((String)xmlLang)) {
            xpath.append("[not(@*)]");
        }
        if (StringUtils.isNotBlank((String)xsiType)) {
            xpath.append("[@xsi:type='").append(xsiType).append("']");
        }
        if (StringUtils.isNotBlank((String)xmlLang)) {
            xpath.append("[@xml:lang='").append(xmlLang).append("']");
        }
        return this.getXPathValues(xpath.toString());
    }

    public void save(String fileName) throws IOException {
        FileWriter out = new FileWriter(fileName);
        this.m_document.write((Writer)out);
        out.flush();
        out.close();
    }

    public String toXml() throws IOException {
        StringWriter sw = new StringWriter();
        this.m_document.write((Writer)sw);
        sw.flush();
        sw.close();
        return sw.getBuffer().toString();
    }

    public Document getDocument() {
        return this.m_document;
    }

    public String getXMLPathValue(String path) {
        List values = this.getXMLPathValues(path);
        if (values == null || values.size() == 0) {
            return null;
        }
        return (String)values.get(0);
    }

    public List getXMLPathValues(String path) {
        if (path == null || path.length() == 0) {
            return null;
        }
        String[] fieldParts = path.split(" ");
        if (fieldParts.length <= 1) {
            return this.getValues(path);
        }
        StringBuffer xPath = new StringBuffer("//");
        xPath.append(fieldParts[0]);
        String[] attributeParts = fieldParts[1].split("=");
        xPath.append(" [@").append(attributeParts[0]).append("=").append(attributeParts[1].replaceAll("\"", "'")).append("]");
        return this.getXPathValues(xPath.toString());
    }

    private String getXPathValue(String xPath) {
        Node node = this.m_document.selectSingleNode(xPath);
        if (node != null) {
            return node.getText();
        }
        return null;
    }

    private List getXPathValues(String xPath) {
        try {
            List nodes = this.m_document.selectNodes(xPath);
            if (nodes != null) {
                ArrayList<String> l = new ArrayList<String>();
                Iterator i = nodes.iterator();
                while (i.hasNext()) {
                    l.add(((Node)i.next()).getText());
                }
                return l;
            }
            return null;
        }
        catch (Exception e) {
            log.warn((Object)e.getMessage(), this.m_document.asXML());
            return null;
        }
    }

    private String getXPath(String namespace, String key, String xsiType) {
        StringBuffer xpath = new StringBuffer("//");
        if (namespace == null) {
            return null;
        }
        xpath.append(namespace);
        if (key == null || key.length() == 0) {
            return null;
        }
        xpath.append(":").append(key);
        if (xsiType == null || xsiType.length() == 0) {
            xpath.append("[not(@*)]");
        } else {
            xpath.append("[@xsi:type='").append(xsiType).append("']");
        }
        return xpath.toString();
    }

    private String getXPath(String namespace, String key, String xsiType, String value) {
        StringBuffer xpath = new StringBuffer("//");
        if (namespace == null) {
            return null;
        }
        xpath.append(namespace);
        if (key == null || key.length() == 0) {
            return null;
        }
        xpath.append(":").append(key);
        if (StringUtils.isBlank((String)xsiType)) {
            xpath.append("[not(@*)");
        } else {
            xpath.append("[@xsi:type='").append(xsiType).append("'");
        }
        if (StringUtils.isNotBlank((String)value)) {
            if (value.contains("'")) {
                xpath.append(" and text() = \"").append(value).append("\"");
            } else {
                xpath.append(" and text() = '").append(value).append("'");
            }
        }
        xpath.append("]");
        return xpath.toString();
    }

    public void removeElemet(String namespace, String key) {
        this.removeElemet(namespace, key, null);
    }

    public void removeElemet(String xPathKey) {
        DCElement dcElem = this.parseKey(xPathKey);
        if (dcElem == null) {
            return;
        }
        this.removeElemet(dcElem.namespace, dcElem.key, dcElem.xsiType);
    }

    public void removeElement(String xPathKey, String value) {
        DCElement dcElem = this.parseKey(xPathKey);
        if (dcElem == null) {
            return;
        }
        String xPath = this.getXPath(dcElem.namespace, dcElem.key, dcElem.xsiType, value);
        for (Object object : this.m_document.selectNodes(xPath)) {
            Node node = (Node)object;
            node.detach();
        }
    }

    public void removeElemet(String namespace, String key, String xsiType) {
        String path = this.getXPath(namespace, key, xsiType);
        this.removeNodeByXPath(path);
    }

    private void removeNodeByXPath(String xPath) {
        Node node = this.m_document.selectSingleNode(xPath);
        if (node != null) {
            node.detach();
        }
    }

    private DCElement parseKey(String key) {
        if (key == null || key.length() == 0) {
            return null;
        }
        DCElement dcElem = new DCElement();
        int pos = key.indexOf("@");
        if (pos == -1) {
            if (key.length() > 0) {
                String[] fieldParts = key.split(":");
                if (fieldParts.length != 2) {
                    log.warn((Object)("Failed to parse xpath: " + key), new String[0]);
                    return null;
                }
                dcElem.key = fieldParts[1];
                dcElem.namespace = fieldParts[0];
            }
        } else {
            String[] fieldParts = key.substring(0, pos).split(":");
            if (fieldParts.length != 2) {
                log.warn((Object)("Failed to parse xpath: " + key), new String[0]);
                return null;
            }
            dcElem.key = fieldParts[1];
            dcElem.namespace = fieldParts[0];
            if (key.split("@").length > 2) {
                dcElem.xmlLang = key.substring(pos + 1, key.lastIndexOf("@"));
            } else {
                dcElem.xsiType = key.substring(pos + 1);
            }
        }
        return dcElem;
    }

    public String getMid() {
        return this.mid;
    }

    public void setMid(String mid) {
        this.mid = mid;
    }

    public List<String> getElementsXpaths() {
        ArrayList<String> xpaths = new ArrayList<String>();
        Element root = this.m_document.getRootElement();
        Iterator i = root.elementIterator();
        while (i.hasNext()) {
            String tag = null;
            String xsi = null;
            String xpath = null;
            Element element = (Element)i.next();
            tag = element.getNamespacePrefix() + ":" + element.getName();
            Iterator j = element.attributeIterator();
            while (j.hasNext()) {
                Attribute attribute = (Attribute)j.next();
                if (!attribute.getPath().contains(XSI_TYPE)) continue;
                xsi = attribute.getValue();
                break;
            }
            xpath = xsi != null ? tag + "@" + xsi : tag;
            xpaths.add(xpath);
        }
        return xpaths;
    }

    private class DCElement {
        public String namespace;
        public String xsiType;
        public String key;
        public String val;
        public String xmlLang;

        private DCElement() {
        }

        public String toString() {
            return "namespace=" + this.namespace + ";key=" + this.key + ";xsiType=" + this.xsiType + ";val=" + this.val;
        }
    }
}

