/*
 * Decompiled with CFR 0.152.
 */
package com.exlibris.core.sdk.utils;

import com.exlibris.core.infra.common.exceptions.logging.ExLogger;
import com.exlibris.core.infra.common.util.IOUtil;
import com.exlibris.core.infra.svc.api.GeneralParameterManager;
import com.exlibris.core.infra.svc.api.locator.ServiceLocator;
import com.exlibris.core.sdk.exceptions.ExceptionErrorHandler;
import com.exlibris.core.sdk.utils.FileUtil;
import gov.loc.mets.MetsDocument;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.io.Reader;
import java.io.StringReader;
import java.util.HashMap;
import java.util.Map;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.transform.stream.StreamSource;
import javax.xml.validation.Schema;
import javax.xml.validation.SchemaFactory;
import org.dom4j.DocumentException;
import org.dom4j.io.SAXReader;
import org.w3c.dom.NamedNodeMap;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public class ContentStructureValidator {
    public static final String RECORDS_NODE = "/records";
    public static final String RECORD_NODE = "/record";
    public static final String ROSETTA_METS_SCHEMA = "http://www.exlibrisgroup.com/xsd/dps/rosettaMets";
    public static final String METS_SCHEMA = "http://www.loc.gov/METS/";
    public static final String XML_SCHEMA = "http://www.w3.org/2001/XMLSchema-instance";
    public static final String XML_SCHEMA_REPLACEMENT = "http://www.exlibrisgroup.com/XMLSchema-instance";
    public static final String METS_XSD = "mets.xsd";
    public static final String ROSETTA_METS_XSD = "mets_rosetta.xsd";
    private static Map<String, Schema> schemas = new HashMap<String, Schema>();
    private static ExLogger log = ExLogger.getExLogger(ContentStructureValidator.class);

    public static final boolean validateDcsXML(File file) {
        String DCSString = null;
        try {
            FileInputStream fin = new FileInputStream(file);
            DCSString = IOUtil.toString(fin);
            SAXReader reader = new SAXReader();
            try {
                reader.read((Reader)new StringReader(DCSString));
            }
            catch (DocumentException e) {
                throw e;
            }
            finally {
                if (fin != null) {
                    fin.close();
                }
            }
            DCSString = DCSString.toLowerCase();
            if (!DCSString.startsWith("<records>") || !DCSString.trim().endsWith("</records>")) {
                return false;
            }
        }
        catch (Exception e) {
            return false;
        }
        return true;
    }

    public static final boolean validateMetsXML(File file) throws Exception {
        String xmlMetsContent = FileUtil.getContents(file, "UTF-8");
        return ContentStructureValidator.validateMetsXML(xmlMetsContent, file.getAbsolutePath(), file.getName());
    }

    public static boolean validateMetsXML(String xmlMetsContent, String fileAbsolutePath, String fileName) throws Exception {
        xmlMetsContent = xmlMetsContent.replaceAll(XML_SCHEMA, XML_SCHEMA_REPLACEMENT);
        String xmlRosettaMetsContent = null;
        if (xmlMetsContent.contains(ROSETTA_METS_SCHEMA)) {
            xmlRosettaMetsContent = xmlMetsContent;
            xmlMetsContent = xmlMetsContent.replaceAll(ROSETTA_METS_SCHEMA, METS_SCHEMA);
        } else {
            xmlRosettaMetsContent = xmlMetsContent.replaceAll(METS_SCHEMA, ROSETTA_METS_SCHEMA);
        }
        GeneralParameterManager genParamMng = (GeneralParameterManager)ServiceLocator.getInstance().lookUp(GeneralParameterManager.class);
        boolean validateRosettaMets = Boolean.valueOf(genParamMng.getParameter("deposit", "validate_with_rosetta_mets"));
        boolean validateMets = Boolean.valueOf(genParamMng.getParameter("deposit", "validate_with_mets"));
        try {
            MetsDocument mets = MetsDocument.Factory.parse(xmlMetsContent);
            NamedNodeMap attributes = mets.getDomNode().getFirstChild().getAttributes();
            if (attributes.getNamedItem("xsi:schemaLocation") != null) {
                attributes.removeNamedItem("xsi:schemaLocation");
                xmlMetsContent = mets.xmlText();
                xmlRosettaMetsContent = xmlMetsContent.replaceAll(METS_SCHEMA, ROSETTA_METS_SCHEMA);
            }
        }
        catch (Exception e) {
            throw new Exception("XML '" + fileAbsolutePath + "' doesn't pass basic parsing with following Error: " + e.getMessage());
        }
        try {
            ContentStructureValidator.validateXML(fileAbsolutePath, xmlRosettaMetsContent, ROSETTA_METS_XSD);
            return true;
        }
        catch (Exception e) {
            if (validateRosettaMets) {
                log.error("XML:'" + fileName + "' wasn't acquired into Rosetta", new String[0]);
                throw new Exception(e);
            }
            log.warn((Object)("XML '" + fileName + "' doesn't pass validation by :" + ROSETTA_METS_XSD + " with the following validation error: " + e.getMessage()), new String[0]);
            try {
                ContentStructureValidator.validateXML(fileAbsolutePath, xmlMetsContent, METS_XSD);
                return true;
            }
            catch (Exception e2) {
                if (validateMets) {
                    log.error("XML:'" + fileName + "' wasn't acquired into Rosetta", new String[0]);
                    throw new Exception(e2);
                }
                log.warn((Object)("XML '" + fileName + "' doesn't pass validation by :" + METS_XSD + " with the following validation error: " + e2.getMessage()), new String[0]);
                return true;
            }
        }
    }

    private static void validateXML(String fileFullName, String xml, String xsdName) throws Exception {
        try {
            DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
            factory.setNamespaceAware(true);
            factory.setSchema(ContentStructureValidator.getSchema(xsdName));
            DocumentBuilder builder = factory.newDocumentBuilder();
            builder.setErrorHandler(new ExceptionErrorHandler());
            builder.parse(new InputSource(new StringReader(xml)));
        }
        catch (Exception e) {
            throw new Exception("XML '" + fileFullName + "' doesn't pass validation by :" + xsdName + " with the following validation error: " + e.getMessage());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Schema getSchema(String xsdName) throws SAXException {
        if (schemas.get(xsdName) == null) {
            InputStream inputStream = null;
            try {
                inputStream = Thread.currentThread().getContextClassLoader().getResourceAsStream(xsdName);
                StreamSource xsdFile = new StreamSource(inputStream);
                SchemaFactory schemaFactory = SchemaFactory.newInstance("http://www.w3.org/XML/XMLSchema/v1.1");
                schemas.put(xsdName, schemaFactory.newSchema(xsdFile));
            }
            catch (Exception e) {
                try {
                    log.error("Failed to create Schema", e, new String[0]);
                }
                catch (Throwable throwable) {
                    IOUtil.closeQuietly(inputStream);
                    throw throwable;
                }
                IOUtil.closeQuietly(inputStream);
            }
            IOUtil.closeQuietly(inputStream);
        }
        return schemas.get(xsdName);
    }
}

