/*
 * Decompiled with CFR 0.152.
 */
package com.exlibris.digitool.common.dnx;

import com.exlibris.digitool.common.dnx.DnxDocument;
import com.exlibris.digitool.common.dnx.DnxRecordKey;
import com.exlibris.digitool.common.dnx.DnxSection;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.dom4j.Element;

public class DnxSectionRecord {
    private final Element element;
    private final DnxSection parent;
    private final List<DnxRecordKey> keyList = new ArrayList<DnxRecordKey>();

    public void deleteAttributeByName(String name) {
    }

    public void deleteAttributeByName(String name, int occurence) {
    }

    DnxSectionRecord(DnxSection dnxSection, Element element) {
        this.element = element;
        this.parent = dnxSection;
    }

    public DnxRecordKey createKey(String id, String q1, String q2, String value, boolean emptyValue) {
        if (StringUtils.isBlank((String)value) && !emptyValue) {
            return null;
        }
        if (id == null) {
            System.err.println("dnx \"id\" cannot be null...");
            id = "null";
        }
        Element key = this.element.addElement(DnxDocument.KEY);
        key.addAttribute(DnxDocument.ID, id);
        if (q1 != null) {
            key.addAttribute(DnxDocument.Q1, q1);
        }
        if (q2 != null) {
            key.addAttribute(DnxDocument.Q2, q2);
        }
        if (value != null) {
            key.addText(value);
        }
        DnxRecordKey dnxRecordKey = new DnxRecordKey(this, key);
        this.keyList.add(dnxRecordKey);
        return dnxRecordKey;
    }

    public DnxRecordKey getKeyById(String id) {
        for (DnxRecordKey key : this.keyList) {
            if (!key.getId().equals(id)) continue;
            return key;
        }
        return null;
    }

    public void updateKey(String keyId, String value) {
        DnxRecordKey key = this.getKeyById(keyId);
        if (StringUtils.isNotBlank((String)value)) {
            if (key == null) {
                this.createKey(keyId, null, null, value, false);
            } else {
                key.updateValue(value);
            }
        } else {
            if (key != null) {
                this.element.remove(key.getKey());
            }
            this.keyList.remove(key);
        }
    }

    public List<DnxRecordKey> getKeylist() {
        return this.keyList;
    }

    public String getSectionKeyValue(String sectionKeyId) {
        DnxRecordKey key = this.getKeyById(sectionKeyId);
        if (key == null) {
            return null;
        }
        return key.getValue();
    }

    public Element getElement() {
        return this.element;
    }
}

