/*
 * Decompiled with CFR 0.152.
 */
package org.jwat.arc;

import java.io.BufferedOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.jwat.arc.ArcRecordBase;
import org.jwat.arc.ArcWriter;
import org.jwat.gzip.GzipEntry;
import org.jwat.gzip.GzipWriter;

public class ArcWriterCompressed
extends ArcWriter {
    protected GzipWriter writer;
    protected GzipEntry entry;

    ArcWriterCompressed(OutputStream out) {
        if (out == null) {
            throw new IllegalArgumentException("The 'out' parameter is null!");
        }
        this.writer = new GzipWriter(out);
        this.init();
    }

    ArcWriterCompressed(OutputStream out, int buffer_size) {
        if (out == null) {
            throw new IllegalArgumentException("The 'out' parameter is null!");
        }
        if (buffer_size <= 0) {
            throw new IllegalArgumentException("The 'buffer_size' parameter is less than or equal to zero!");
        }
        this.writer = new GzipWriter((OutputStream)new BufferedOutputStream(out, buffer_size));
        this.init();
    }

    @Override
    public boolean isCompressed() {
        return true;
    }

    @Override
    public void close() throws IOException {
        if (this.entry != null) {
            this.closeRecord();
        }
        if (this.out != null) {
            this.out.flush();
            this.out.close();
            this.out = null;
        }
    }

    @Override
    public void closeRecord() throws IOException {
        if (this.state == 0) {
            throw new IllegalStateException("Write a record before closing it!");
        }
        if (this.entry != null) {
            this.closeRecord_impl();
            this.state = 3;
            this.entry.close();
            this.entry = null;
        }
    }

    @Override
    public void writeRawHeader(byte[] header_bytes, Long contentLength) throws IOException {
        if (header_bytes == null) {
            throw new IllegalArgumentException("The 'header_bytes' parameter is null!");
        }
        if (contentLength != null && contentLength < 0L) {
            throw new IllegalArgumentException("The 'contentLength' parameter is negative!");
        }
        if (this.state == 1) {
            throw new IllegalStateException("Headers written back to back!");
        }
        if (this.state == 2) {
            this.closeRecord();
        }
        this.entry = new GzipEntry();
        this.entry.magic = 35615;
        this.entry.cm = (short)8;
        this.entry.flg = 0;
        this.entry.mtime = System.currentTimeMillis() / 1000L;
        this.entry.xfl = 0;
        this.entry.os = (short)255;
        this.writer.writeEntryHeader(this.entry);
        this.out = this.entry.getOutputStream();
        this.out.write(header_bytes);
        this.state = 1;
        this.header = null;
        this.headerContentLength = contentLength;
        this.payloadWrittenTotal = 0L;
    }

    @Override
    public byte[] writeHeader(ArcRecordBase record) throws IOException {
        if (record == null) {
            throw new IllegalArgumentException("The 'record' parameter is null!");
        }
        if (this.state == 1) {
            throw new IllegalStateException("Headers written back to back!");
        }
        if (this.state == 2) {
            this.closeRecord();
        }
        this.entry = new GzipEntry();
        this.entry.magic = 35615;
        this.entry.cm = (short)8;
        this.entry.flg = 0;
        this.entry.mtime = System.currentTimeMillis() / 1000L;
        this.entry.xfl = 0;
        this.entry.os = (short)255;
        this.writer.writeEntryHeader(this.entry);
        this.out = this.entry.getOutputStream();
        return this.writeHeader_impl(record);
    }

    @Override
    public long streamPayload(InputStream in) throws IOException {
        if (this.entry == null) {
            throw new IllegalStateException();
        }
        return super.streamPayload(in);
    }

    @Override
    public long writePayload(byte[] b) throws IOException {
        if (this.entry == null) {
            throw new IllegalStateException();
        }
        return super.writePayload(b);
    }

    @Override
    public long writePayload(byte[] b, int offset, int len) throws IOException {
        if (this.entry == null) {
            throw new IllegalStateException();
        }
        return super.writePayload(b, offset, len);
    }
}

