/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jimi.core.util;

import com.sun.jimi.core.JimiException;
import com.sun.jimi.core.JimiImage;
import com.sun.jimi.core.JimiImageFactory;
import com.sun.jimi.core.JimiImageHandle;
import com.sun.jimi.core.JimiLicenseInformation;
import com.sun.jimi.core.MemoryJimiImageFactory;
import com.sun.jimi.core.raster.JimiRasterImage;
import com.sun.jimi.core.util.ErrorImageProducer;
import com.sun.jimi.core.util.JimiImageFactoryProxy;
import java.awt.Image;
import java.awt.Toolkit;
import java.awt.image.ColorModel;
import java.awt.image.DirectColorModel;
import java.awt.image.ImageProducer;
import java.awt.image.IndexColorModel;
import java.util.Enumeration;
import java.util.Vector;

public class JimiUtil {
    private static final String nonFileName = "X#jimi#X";
    public static final boolean TRUE = true;
    static byte[] expansionTable = new byte[2048];
    static int[] intExpansionTable = new int[2048];

    static {
        int n = 0;
        int n2 = 0;
        while (n2 < 256) {
            JimiUtil.expansionTable[n++] = (n2 & 0x80) == 0 ? (byte)0 : 1;
            JimiUtil.expansionTable[n++] = (n2 & 0x40) == 0 ? (byte)0 : 1;
            JimiUtil.expansionTable[n++] = (n2 & 0x20) == 0 ? (byte)0 : 1;
            JimiUtil.expansionTable[n++] = (n2 & 0x10) == 0 ? (byte)0 : 1;
            JimiUtil.expansionTable[n++] = (n2 & 8) == 0 ? (byte)0 : 1;
            JimiUtil.expansionTable[n++] = (n2 & 4) == 0 ? (byte)0 : 1;
            JimiUtil.expansionTable[n++] = (n2 & 2) == 0 ? (byte)0 : 1;
            JimiUtil.expansionTable[n++] = (n2 & 1) == 0 ? (byte)0 : 1;
            ++n2;
        }
        n = 0;
        n2 = 0;
        while (n2 < 256) {
            JimiUtil.intExpansionTable[n++] = (n2 & 0x80) == 0 ? -16777216 : -1;
            JimiUtil.intExpansionTable[n++] = (n2 & 0x40) == 0 ? -16777216 : -1;
            JimiUtil.intExpansionTable[n++] = (n2 & 0x20) == 0 ? -16777216 : -1;
            JimiUtil.intExpansionTable[n++] = (n2 & 0x10) == 0 ? -16777216 : -1;
            JimiUtil.intExpansionTable[n++] = (n2 & 8) == 0 ? -16777216 : -1;
            JimiUtil.intExpansionTable[n++] = (n2 & 4) == 0 ? -16777216 : -1;
            JimiUtil.intExpansionTable[n++] = (n2 & 2) == 0 ? -16777216 : -1;
            JimiUtil.intExpansionTable[n++] = (n2 & 1) == 0 ? -16777216 : -1;
            ++n2;
        }
    }

    public static JimiRasterImage asJimiRasterImage(JimiImage jimiImage) {
        if (jimiImage instanceof JimiRasterImage) {
            return (JimiRasterImage)jimiImage;
        }
        if (jimiImage instanceof JimiImageHandle) {
            try {
                return JimiUtil.asJimiRasterImage(((JimiImageHandle)jimiImage).getWrappedJimiImage());
            }
            catch (JimiException jimiException) {
                return null;
            }
        }
        return null;
    }

    public static byte countBitsSet(int n) {
        byte by = 0;
        int n2 = 1;
        int n3 = 0;
        while (n3 < 32) {
            if ((n & n2) != 0) {
                by = (byte)(by + 1);
            }
            n2 <<= 1;
            ++n3;
        }
        return by;
    }

    public static void expandOneBitPixels(byte[] byArray, byte[] byArray2, int n) {
        int n2 = n % 8;
        int n3 = n / 8;
        int n4 = 0;
        while (n4 < n3) {
            int n5 = (byArray[n4] & 0xFF) * 8;
            System.arraycopy(expansionTable, n5, byArray2, n4 * 8, 8);
            ++n4;
        }
        if (n2 != 0) {
            System.arraycopy(expansionTable, (byArray[n3] & 0xFF) * 8, byArray2, n3 * 8, n2);
        }
    }

    public static void expandOneBitPixels(byte[] byArray, byte[] byArray2, int n, int n2, int n3) {
        int n4 = n2 % 8;
        n2 /= 8;
        if (n4 != 0) {
            n4 = 8 - n4;
            System.arraycopy(expansionTable, ((byArray[n2++] & 0xFF) << 3) + 8 - n4, byArray2, n3, n4);
            n3 += n4;
        }
        int n5 = n % 8;
        int n6 = n2 + n / 8;
        int n7 = n2;
        while (n7 < n6) {
            System.arraycopy(expansionTable, (byArray[n7] & 0xFF) << 3, byArray2, n3, 8);
            n3 += 8;
            ++n7;
        }
        if (n5 != 0) {
            System.arraycopy(expansionTable, (byArray[n6 - 1] & 0xFF) << 3, byArray2, n3, n5);
        }
    }

    public static void expandOneBitPixelsToBW(byte[] byArray, int[] nArray, int n, int n2, int n3) {
        int n4 = n2 % 8;
        n2 /= 8;
        if (n4 != 0) {
            n4 = 8 - n4;
            System.arraycopy(intExpansionTable, (byArray[n2++] << 3) + 8 - n4, nArray, n3, n4);
            n3 += n4;
        }
        int n5 = n % 8;
        int n6 = n2 + n / 8;
        int n7 = n2;
        while (n7 < n6) {
            System.arraycopy(intExpansionTable, (byArray[n7] & 0xFF) << 3, nArray, n3, 8);
            n3 += 8;
            ++n7;
        }
        if (n5 != 0) {
            System.arraycopy(intExpansionTable, (byArray[n6] & 0xFF) << 3, nArray, n3, n5);
        }
    }

    public static void expandPixels(int n, byte[] byArray, byte[] byArray2, int n2) {
        if (n == 1) {
            JimiUtil.expandOneBitPixels(byArray, byArray2, n2);
            return;
        }
        int n3 = 0;
        int n4 = 1;
        int n5 = 0;
        int n6 = 0;
        int n7 = 0;
        int n8 = 0;
        switch (n) {
            case 1: {
                n8 = 128;
                n4 = 1;
                n3 = 8;
                n5 = 7;
                n7 = 1;
                break;
            }
            case 2: {
                n8 = 192;
                n4 = 2;
                n3 = 4;
                n5 = 6;
                n7 = 2;
                break;
            }
            case 4: {
                n8 = 240;
                n4 = 4;
                n3 = 2;
                n5 = 4;
                n7 = 4;
                break;
            }
            default: {
                throw new RuntimeException("support only expand for 1, 2, 4");
            }
        }
        int n9 = 0;
        int n10 = 0;
        while (n10 < byArray2.length) {
            int n11 = n8;
            n6 = n5;
            byte by = byArray[n9];
            int n12 = 0;
            while (n12 < n3 && n10 < byArray2.length) {
                byArray2[n10] = (byte)((by & n11) >>> n6 & 0xFF);
                n11 = (byte)((n11 & 0xFF) >>> n4);
                n6 -= n7;
                ++n12;
                ++n10;
            }
            ++n9;
        }
    }

    public static boolean flagSet(int n, int n2) {
        return (n & n2) != 0;
    }

    public static boolean flagsSet(int n, int n2) {
        return (n & n2) == n2;
    }

    public static byte[] getChannelWidths(ColorModel colorModel) {
        byte[] byArray = new byte[8];
        if (colorModel instanceof DirectColorModel) {
            DirectColorModel directColorModel = (DirectColorModel)colorModel;
            byArray[0] = JimiUtil.countBitsSet(directColorModel.getAlphaMask());
            byArray[1] = JimiUtil.countBitsSet(directColorModel.getRedMask());
            byArray[2] = JimiUtil.countBitsSet(directColorModel.getGreenMask());
            byArray[3] = JimiUtil.countBitsSet(directColorModel.getBlueMask());
        } else if (colorModel instanceof IndexColorModel) {
            byArray[0] = 8;
            byArray[1] = 8;
            byArray[2] = 8;
            byArray[3] = 8;
        }
        return byArray;
    }

    public static Image getErrorImage() {
        return Toolkit.getDefaultToolkit().createImage(JimiUtil.getErrorImageProducer());
    }

    public static ImageProducer getErrorImageProducer() {
        return new ErrorImageProducer();
    }

    public static boolean isCompatibleWithJavaVersion(int n, int n2) {
        try {
            String string = System.getProperty("java.version");
            int n3 = Integer.parseInt(string.substring(0, string.indexOf(46)));
            String string2 = string.substring(string.indexOf(".") + 1);
            if (string2.indexOf(46) != -1) {
                string2 = string2.substring(0, string2.indexOf(46));
            }
            int n4 = Integer.parseInt(string2);
            boolean bl = n3 > n || n3 == n && n4 >= n2;
            return bl;
        }
        catch (Exception exception) {
            return false;
        }
    }

    public static boolean isRGBDefault(ColorModel colorModel) {
        if (colorModel instanceof DirectColorModel) {
            DirectColorModel directColorModel = (DirectColorModel)colorModel;
            DirectColorModel directColorModel2 = (DirectColorModel)ColorModel.getRGBdefault();
            int n = directColorModel2.getAlphaMask();
            int n2 = directColorModel2.getRedMask();
            int n3 = directColorModel2.getGreenMask();
            int n4 = directColorModel2.getBlueMask();
            int n5 = directColorModel.getAlphaMask();
            int n6 = directColorModel.getRedMask();
            int n7 = directColorModel.getGreenMask();
            int n8 = directColorModel.getBlueMask();
            return n == n5 && n2 == n6 && n3 == n7 && n4 == n8;
        }
        return false;
    }

    public static void packOneBitPixels(byte[] byArray, int n, byte[] byArray2, int n2, int n3, int n4) {
        int n5;
        int n6;
        int n7;
        int n8 = n;
        n2 += n3 / 8;
        int n9 = (n3 %= 8) == 0 ? n4 / 8 : (n4 - (8 - n3)) / 8;
        int n10 = 0;
        int n11 = n3 == 0 ? 0 : 1;
        int n12 = n2 + (n3 == 0 ? 0 : 1);
        int n13 = n7 = n4 < 8 - n3 ? n4 : 8 - n3;
        if (n3 != 0) {
            n6 = 7 - n3;
            n5 = 0;
            while (n5 < n7) {
                if (byArray[n8++] == 0) {
                    int n14 = n2;
                    byArray2[n14] = (byte)(byArray2[n14] & ~(1 << n6 - n5));
                } else {
                    int n15 = n2;
                    byArray2[n15] = (byte)(byArray2[n15] | 1 << n6 - n5);
                }
                ++n5;
            }
        }
        n6 = n11;
        while (n6 < n9) {
            n10 = 0;
            if (byArray[n8++] != 0) {
                n10 += 128;
            }
            if (byArray[n8++] != 0) {
                n10 += 64;
            }
            if (byArray[n8++] != 0) {
                n10 += 32;
            }
            if (byArray[n8++] != 0) {
                n10 += 16;
            }
            if (byArray[n8++] != 0) {
                n10 += 8;
            }
            if (byArray[n8++] != 0) {
                n10 += 4;
            }
            if (byArray[n8++] != 0) {
                n10 += 2;
            }
            if (byArray[n8++] != 0) {
                ++n10;
            }
            byArray2[n12 + n6] = (byte)n10;
            ++n6;
        }
        n5 = n3 == 0 ? n4 % 8 : n4 - (8 - n3) % 8;
        int n16 = n2 + n9;
        if ((n5 %= 8) > 0) {
            int n17 = 0;
            while (n17 < n5) {
                if (byArray[n8++] == 0) {
                    int n18 = n16;
                    byArray2[n18] = (byte)(byArray2[n18] & ~(1 << 7 - n17));
                } else {
                    int n19 = n16;
                    byArray2[n19] = (byte)(byArray2[n19] | 1 << 7 - n17);
                }
                ++n17;
            }
        }
    }

    public static int packPixels(int n, byte[] byArray, byte[] byArray2) {
        int n2 = (1 << n) - 1;
        int n3 = byArray.length;
        switch (n) {
            case 1: {
                int n4 = n3 % 8;
                int n5 = n3 / 8;
                int n6 = n5 + 1;
                int n7 = n3;
                int n8 = 0;
                switch (n4) {
                    case 7: {
                        n8 |= (byArray[--n7] & n2) << 1;
                    }
                    case 6: {
                        n8 |= (byArray[--n7] & n2) << 2;
                    }
                    case 5: {
                        n8 |= (byArray[--n7] & n2) << 3;
                    }
                    case 4: {
                        n8 |= (byArray[--n7] & n2) << 4;
                    }
                    case 3: {
                        n8 |= (byArray[--n7] & n2) << 5;
                    }
                    case 2: {
                        n8 |= (byArray[--n7] & n2) << 6;
                    }
                    case 1: {
                        byArray2[n5] = (byte)(n8 |= (byArray[--n7] & n2) << 7);
                        break;
                    }
                    case 0: {
                        --n6;
                        break;
                    }
                }
                n7 = n3 - n4;
                int n9 = n5;
                while (--n9 >= 0) {
                    byArray2[n9] = (byte)(byArray[--n7] & n2 | (byArray[--n7] & n2) << 1 | (byArray[--n7] & n2) << 2 | (byArray[--n7] & n2) << 3 | (byArray[--n7] & n2) << 4 | (byArray[--n7] & n2) << 5 | (byArray[--n7] & n2) << 6 | (byArray[--n7] & n2) << 7);
                }
                return n6;
            }
            case 2: {
                int n10 = n3 % 4;
                int n11 = n3 / 4;
                int n12 = n11 + 1;
                int n13 = n3;
                int n14 = 0;
                switch (n10) {
                    case 3: {
                        n14 |= (byArray[--n13] & n2) << 2;
                    }
                    case 2: {
                        n14 |= (byArray[--n13] & n2) << 4;
                    }
                    case 1: {
                        byArray2[n11] = (byte)(n14 |= (byArray[--n13] & n2) << 6);
                        break;
                    }
                    case 0: {
                        --n12;
                        break;
                    }
                }
                n13 = n3 - n10;
                int n15 = n11;
                while (--n15 >= 0) {
                    byArray2[n15] = (byte)(byArray[--n13] & n2 | (byArray[--n13] & n2) << 2 | (byArray[--n13] & n2) << 4 | (byArray[--n13] & n2) << 6);
                }
                return n12;
            }
            case 4: {
                int n16 = n3 % 2;
                int n17 = n3 / 2;
                int n18 = n17 + 1;
                int n19 = n3;
                int n20 = 0;
                switch (n16) {
                    case 1: {
                        byArray2[n17] = (byte)(n20 |= (byArray[--n19] & n2) << 4);
                        break;
                    }
                    case 0: {
                        --n18;
                        break;
                    }
                }
                n19 = n3 - n16;
                int n21 = n17;
                while (--n21 >= 0) {
                    byArray2[n21] = (byte)(byArray[--n19] & n2 | (byArray[--n19] & n2) << 4);
                }
                return n18;
            }
            case 8: {
                System.arraycopy(byArray, 0, byArray2, 0, n3);
                return n3;
            }
        }
        throw new IllegalArgumentException("depth must be 1 2 4 or 8, not " + n);
    }

    public static void packPixels(int[] nArray, int n, byte[] byArray, int n2, int n3) {
        int n4;
        int n5 = n;
        int n6 = n3 / 8;
        int n7 = 0;
        while (n7 < n6) {
            n4 = 0;
            if (nArray[n5++] == -1) {
                n4 |= 0x80;
            }
            if (nArray[n5++] == -1) {
                n4 |= 0x40;
            }
            if (nArray[n5++] == -1) {
                n4 |= 0x20;
            }
            if (nArray[n5++] == -1) {
                n4 |= 0x10;
            }
            if (nArray[n5++] == -1) {
                n4 |= 8;
            }
            if (nArray[n5++] == -1) {
                n4 |= 4;
            }
            if (nArray[n5++] == -1) {
                n4 |= 2;
            }
            if (nArray[n5++] == -1) {
                n4 |= 1;
            }
            byArray[n2 + n7] = (byte)n4;
            ++n7;
        }
        n4 = n3 % 8;
        int n8 = 7;
        int n9 = 255;
        while (n4-- > 0) {
            if (nArray[n5++] == -1) continue;
            n9 &= ~(1 << n8--);
        }
        byArray[n2 + n6] = (byte)n9;
    }

    public static void pixelDepthChange(int n, byte[] byArray, int n2) {
        if (n2 <= n) {
            throw new IllegalArgumentException("pixelDepth Must < newPixelSize");
        }
        int n3 = n2 - n;
        int n4 = (1 << n2) - 1;
        int n5 = (1 << n) - 1;
        int n6 = byArray.length;
        while (--n6 >= 0) {
            byArray[n6] = (byte)(byArray[n6] * n4 / n5);
        }
    }

    public static void runCommands(Vector vector) {
        Enumeration enumeration = vector.elements();
        while (enumeration.hasMoreElements()) {
            ((Runnable)enumeration.nextElement()).run();
        }
    }

    public static JimiImageFactory stripStamping(JimiImageFactory jimiImageFactory) {
        if (JimiLicenseInformation.isCrippled()) {
            return jimiImageFactory;
        }
        JimiImageFactory jimiImageFactory2 = jimiImageFactory;
        while (jimiImageFactory2 instanceof JimiImageFactoryProxy) {
            jimiImageFactory2 = ((JimiImageFactoryProxy)jimiImageFactory2).getProxiedFactory();
        }
        if (jimiImageFactory2 instanceof MemoryJimiImageFactory || jimiImageFactory2.getClass().getName().equals("com.sun.jimi.core.VMemStampedJimiImageFactory")) {
            jimiImageFactory = jimiImageFactory2;
        }
        return jimiImageFactory;
    }
}

