/*
 * Decompiled with CFR 0.152.
 */
package net.byteseek.matcher.automata;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import net.byteseek.automata.Automata;
import net.byteseek.automata.State;
import net.byteseek.io.reader.WindowReader;
import net.byteseek.io.reader.windows.Window;
import net.byteseek.matcher.MatchResult;
import net.byteseek.matcher.automata.AutomataMatcher;

public class DfaMatcher<T>
implements AutomataMatcher<T> {
    private final Automata<T> automata;

    public DfaMatcher(Automata<T> automata) {
        this.automata = automata;
    }

    @Override
    public boolean matches(WindowReader reader, long matchPosition) throws IOException {
        long currentPosition = matchPosition;
        Window window = reader.getWindow(currentPosition);
        State<T> state = this.automata.getInitialState();
        while (window != null) {
            int windowStart;
            byte[] bytes = window.getArray();
            int windowLength = window.length();
            int windowPos = windowStart = reader.getWindowOffset(currentPosition);
            while (state != null && windowPos < windowLength) {
                if (state.isFinal()) {
                    return true;
                }
                byte currentByte = bytes[windowPos++];
                state = state.getNextState(currentByte);
            }
            window = reader.getWindow(currentPosition += (long)(windowLength - windowStart));
        }
        return false;
    }

    @Override
    public boolean matches(byte[] bytes, int matchPosition) {
        int length = bytes.length;
        if (matchPosition >= 0 && matchPosition < length) {
            byte currentByte;
            int currentPosition = matchPosition;
            for (State<T> currentState = this.automata.getInitialState(); currentState != null && currentPosition < length; currentState = currentState.getNextState(currentByte)) {
                if (currentState.isFinal()) {
                    return true;
                }
                currentByte = bytes[currentPosition++];
            }
        }
        return false;
    }

    @Override
    public MatchResult<T> firstMatch(WindowReader reader, long matchPosition) throws IOException {
        long currentPosition = matchPosition;
        Window window = reader.getWindow(currentPosition);
        State<T> state = this.automata.getInitialState();
        while (window != null) {
            int windowStart;
            byte[] bytes = window.getArray();
            int windowLength = window.length();
            int windowPos = windowStart = reader.getWindowOffset(currentPosition);
            while (state != null && windowPos < windowLength) {
                if (state.isFinal()) {
                    long matchLength = currentPosition - matchPosition + (long)windowPos - (long)windowStart;
                    return new DfaMatchResult<T>(matchPosition, matchLength, state);
                }
                byte currentByte = bytes[windowPos++];
                state = state.getNextState(currentByte);
            }
            window = reader.getWindow(currentPosition += (long)(windowLength - windowStart));
        }
        return null;
    }

    @Override
    public MatchResult<T> nextMatch(WindowReader reader, MatchResult<T> lastMatch) throws IOException {
        if (lastMatch instanceof DfaMatchResult) {
            long startPosition;
            long matchPosition = lastMatch.getMatchPosition();
            long currentPosition = startPosition = matchPosition + lastMatch.getMatchLength();
            Window window = reader.getWindow(currentPosition);
            State state = ((DfaMatchResult)lastMatch).getMatchingState();
            while (window != null) {
                int windowStart;
                byte[] bytes = window.getArray();
                int windowLength = window.length();
                int windowPos = windowStart = reader.getWindowOffset(currentPosition);
                while (state != null && windowPos < windowLength) {
                    byte currentByte;
                    if ((state = state.getNextState(currentByte = bytes[windowPos++])) == null || !state.isFinal()) continue;
                    long matchLength = currentPosition - matchPosition + (long)windowPos - (long)windowStart;
                    return new DfaMatchResult(matchPosition, matchLength, state);
                }
                window = reader.getWindow(currentPosition += (long)(windowLength - windowStart));
            }
        }
        return null;
    }

    @Override
    public Collection<MatchResult<T>> allMatches(WindowReader reader, long matchPosition) throws IOException {
        long currentPosition = matchPosition;
        Window window = reader.getWindow(currentPosition);
        State<T> state = this.automata.getInitialState();
        List<MatchResult<T>> results = Collections.emptyList();
        while (window != null) {
            int windowStart;
            byte[] bytes = window.getArray();
            int windowLength = window.length();
            int windowPos = windowStart = reader.getWindowOffset(currentPosition);
            while (state != null && windowPos < windowLength) {
                if (state.isFinal()) {
                    if (results.isEmpty()) {
                        results = new ArrayList<MatchResult<T>>();
                    }
                    long matchLength = currentPosition - matchPosition + (long)windowPos - (long)windowStart;
                    results.add(new DfaMatchResult<T>(matchPosition, matchLength, state));
                }
                byte currentByte = bytes[windowPos++];
                state = state.getNextState(currentByte);
            }
            window = reader.getWindow(currentPosition += (long)(windowLength - windowStart));
        }
        return results;
    }

    @Override
    public MatchResult<T> firstMatch(byte[] bytes, int matchPosition) {
        int length = bytes.length;
        if (matchPosition >= 0 && matchPosition < length) {
            byte currentByte;
            int currentPosition = matchPosition;
            for (State<T> currentState = this.automata.getInitialState(); currentState != null && currentPosition < length; currentState = currentState.getNextState(currentByte)) {
                if (currentState.isFinal()) {
                    long matchLength = currentPosition - matchPosition;
                    return new DfaMatchResult<T>(matchPosition, matchLength, currentState);
                }
                currentByte = bytes[currentPosition++];
            }
        }
        return null;
    }

    @Override
    public MatchResult<T> nextMatch(byte[] bytes, MatchResult<T> lastMatch) {
        if (lastMatch instanceof DfaMatchResult) {
            int length = bytes.length;
            int matchPosition = (int)lastMatch.getMatchPosition();
            int startPosition = (int)((long)matchPosition + lastMatch.getMatchLength());
            if (startPosition >= 0 && startPosition < length) {
                int currentPosition = startPosition;
                State currentState = ((DfaMatchResult)lastMatch).getMatchingState();
                while (currentState != null && currentPosition < length) {
                    byte currentByte;
                    if ((currentState = currentState.getNextState(currentByte = bytes[currentPosition++])) == null || !currentState.isFinal()) continue;
                    long matchLength = currentPosition - matchPosition;
                    return new DfaMatchResult(matchPosition, matchLength, currentState);
                }
            }
        }
        return null;
    }

    @Override
    public Collection<MatchResult<T>> allMatches(byte[] bytes, int matchPosition) {
        int length = bytes.length;
        List<MatchResult<T>> results = Collections.emptyList();
        if (matchPosition >= 0 && matchPosition < length) {
            byte currentByte;
            int currentPosition = matchPosition;
            for (State<T> currentState = this.automata.getInitialState(); currentState != null && currentPosition < length; currentState = currentState.getNextState(currentByte)) {
                if (currentState.isFinal()) {
                    if (results.isEmpty()) {
                        results = new ArrayList<MatchResult<T>>();
                    }
                    long matchLength = currentPosition - matchPosition;
                    results.add(new DfaMatchResult<T>(matchPosition, matchLength, currentState));
                }
                currentByte = bytes[currentPosition++];
            }
        }
        return results;
    }

    public String toString() {
        return this.getClass().getSimpleName() + "[automata:" + this.automata + ']';
    }

    private static final class DfaMatchResult<T>
    implements MatchResult<T> {
        private final long matchPosition;
        private final long matchLength;
        private State<T> matchingState;

        public DfaMatchResult(long matchPosition, long matchLength, State<T> matchingState) {
            this.matchPosition = matchPosition;
            this.matchLength = matchLength;
            this.matchingState = matchingState;
        }

        @Override
        public Collection<T> getMatchingObjects() {
            return this.matchingState.getAssociations();
        }

        @Override
        public long getMatchPosition() {
            return this.matchPosition;
        }

        @Override
        public long getMatchLength() {
            return this.matchLength;
        }

        private State<T> getMatchingState() {
            return this.matchingState;
        }
    }
}

