/*
 * Decompiled with CFR 0.152.
 */
package net.byteseek.searcher.multisequence.wu_manber;

import java.io.IOException;
import java.util.Collection;
import java.util.List;
import net.byteseek.io.reader.WindowReader;
import net.byteseek.io.reader.windows.Window;
import net.byteseek.matcher.multisequence.MultiSequenceMatcher;
import net.byteseek.matcher.sequence.SequenceMatcher;
import net.byteseek.searcher.SearchResult;
import net.byteseek.searcher.SearchUtils;
import net.byteseek.searcher.multisequence.wu_manber.AbstractWuManberSearcher;

public class WuManberOneByteSearcher
extends AbstractWuManberSearcher {
    public WuManberOneByteSearcher(MultiSequenceMatcher matcher) {
        super(matcher, 1);
    }

    @Override
    public List<SearchResult<SequenceMatcher>> searchForwards(byte[] bytes, int fromPosition, int toPosition) {
        int searchPosition;
        AbstractWuManberSearcher.SearchInfo info = (AbstractWuManberSearcher.SearchInfo)this.forwardInfo.get();
        int[] safeShifts = info.shifts;
        MultiSequenceMatcher backMatcher = info.matcher;
        int lastPossiblePosition = bytes.length - 1;
        int lastToPosition = toPosition + this.sequences.getMaximumLength() - 1;
        int lastPosition = lastToPosition < lastPossiblePosition ? lastToPosition : lastPossiblePosition;
        int minimumPosition = this.sequences.getMinimumLength() - 1;
        int n = searchPosition = fromPosition > 0 ? fromPosition + minimumPosition : minimumPosition;
        while (searchPosition <= lastPosition) {
            int safeShift = safeShifts[bytes[searchPosition] & 0xFF];
            if (safeShift == 0) {
                List<SearchResult<SequenceMatcher>> results;
                Collection<SequenceMatcher> matches = backMatcher.allMatchesBackwards(bytes, searchPosition);
                if (!matches.isEmpty() && !(results = SearchUtils.resultsBackFromPosition(searchPosition, matches, fromPosition, toPosition)).isEmpty()) {
                    return results;
                }
                ++searchPosition;
                continue;
            }
            searchPosition += safeShift;
        }
        return SearchUtils.noResults();
    }

    @Override
    protected List<SearchResult<SequenceMatcher>> doSearchForwards(WindowReader reader, long fromPosition, long toPosition) throws IOException {
        Window window;
        int arrayStartPosition;
        int arraySearchPosition;
        AbstractWuManberSearcher.SearchInfo info = (AbstractWuManberSearcher.SearchInfo)this.forwardInfo.get();
        int[] safeShifts = info.shifts;
        MultiSequenceMatcher backMatcher = info.matcher;
        long finalPosition = toPosition + (long)this.sequences.getMaximumLength() - 1L;
        for (long searchPosition = fromPosition + (long)this.sequences.getMinimumLength() - 1L; searchPosition <= finalPosition && (window = reader.getWindow(searchPosition)) != null; searchPosition += (long)(arraySearchPosition - arrayStartPosition)) {
            byte[] array = window.getArray();
            arrayStartPosition = reader.getWindowOffset(searchPosition);
            int arrayEndPosition = window.length() - 1;
            long distanceToEnd = finalPosition - window.getWindowPosition();
            int lastSearchPosition = distanceToEnd < (long)arrayEndPosition ? (int)distanceToEnd : arrayEndPosition;
            arraySearchPosition = arrayStartPosition;
            while (arraySearchPosition <= lastSearchPosition) {
                int safeShift = safeShifts[array[arraySearchPosition] & 0xFF];
                if (safeShift == 0) {
                    List<SearchResult<SequenceMatcher>> results;
                    long matchEndPosition = searchPosition + (long)arraySearchPosition - (long)arrayStartPosition;
                    Collection<SequenceMatcher> matches = backMatcher.allMatchesBackwards(reader, matchEndPosition);
                    if (!matches.isEmpty() && !(results = SearchUtils.resultsBackFromPosition(matchEndPosition, matches, fromPosition, toPosition)).isEmpty()) {
                        return results;
                    }
                    ++arraySearchPosition;
                    continue;
                }
                arraySearchPosition += safeShift;
            }
        }
        return SearchUtils.noResults();
    }

    @Override
    public List<SearchResult<SequenceMatcher>> searchBackwards(byte[] bytes, int fromPosition, int toPosition) {
        int searchPosition;
        AbstractWuManberSearcher.SearchInfo info = (AbstractWuManberSearcher.SearchInfo)this.backwardInfo.get();
        int[] safeShifts = info.shifts;
        MultiSequenceMatcher verifier = info.matcher;
        int lastPosition = toPosition > 0 ? toPosition : 0;
        int firstPossiblePosition = bytes.length - 1;
        int n = searchPosition = fromPosition < firstPossiblePosition ? fromPosition : firstPossiblePosition;
        while (searchPosition >= lastPosition) {
            int safeShift = safeShifts[bytes[searchPosition] & 0xFF];
            if (safeShift == 0) {
                Collection<SequenceMatcher> matches = verifier.allMatches(bytes, searchPosition);
                if (!matches.isEmpty()) {
                    return SearchUtils.resultsAtPosition(searchPosition, matches);
                }
                --searchPosition;
                continue;
            }
            searchPosition -= safeShift;
        }
        return SearchUtils.noResults();
    }

    @Override
    protected List<SearchResult<SequenceMatcher>> doSearchBackwards(WindowReader reader, long fromPosition, long toPosition) throws IOException {
        Window window;
        int arraySearchPosition;
        int arrayStartPosition;
        AbstractWuManberSearcher.SearchInfo info = (AbstractWuManberSearcher.SearchInfo)this.backwardInfo.get();
        int[] safeShifts = info.shifts;
        MultiSequenceMatcher verifier = info.matcher;
        for (long searchPosition = fromPosition; searchPosition >= toPosition && (window = reader.getWindow(searchPosition)) != null; searchPosition -= (long)(arrayStartPosition - arraySearchPosition)) {
            byte[] array = window.getArray();
            arrayStartPosition = reader.getWindowOffset(searchPosition);
            long distanceToEnd = toPosition - window.getWindowPosition();
            int lastSearchPosition = distanceToEnd > 0L ? (int)distanceToEnd : 0;
            arraySearchPosition = arrayStartPosition;
            while (arraySearchPosition >= lastSearchPosition) {
                int safeShift = safeShifts[array[arraySearchPosition] & 0xFF];
                if (safeShift == 0) {
                    long startMatchPosition = searchPosition + (long)arraySearchPosition - (long)arrayStartPosition;
                    Collection<SequenceMatcher> matches = verifier.allMatches(reader, startMatchPosition);
                    if (!matches.isEmpty()) {
                        return SearchUtils.resultsAtPosition(startMatchPosition, matches);
                    }
                    --arraySearchPosition;
                    continue;
                }
                arraySearchPosition -= safeShift;
            }
        }
        return SearchUtils.noResults();
    }

    @Override
    public String toString() {
        return this.getClass().getSimpleName() + "[block size: " + this.blockSize + " sequences:" + this.sequences + ']';
    }
}

