/*
 * Decompiled with CFR 0.152.
 */
package net.byteseek.searcher.sequence.sunday;

import java.io.IOException;
import java.util.Arrays;
import java.util.List;
import net.byteseek.io.reader.WindowReader;
import net.byteseek.io.reader.windows.Window;
import net.byteseek.matcher.bytes.ByteMatcher;
import net.byteseek.matcher.sequence.SequenceMatcher;
import net.byteseek.searcher.SearchResult;
import net.byteseek.searcher.SearchUtils;
import net.byteseek.searcher.sequence.AbstractSequenceSearcher;
import net.byteseek.utils.factory.ObjectFactory;
import net.byteseek.utils.lazy.DoubleCheckImmutableLazyObject;
import net.byteseek.utils.lazy.LazyObject;

public final class SundayQuickSearcher
extends AbstractSequenceSearcher {
    private final LazyObject<int[]> forwardInfo = new DoubleCheckImmutableLazyObject<int[]>(new ForwardInfoFactory());
    private final LazyObject<int[]> backwardInfo = new DoubleCheckImmutableLazyObject<int[]>(new BackwardInfoFactory());

    public SundayQuickSearcher(SequenceMatcher sequence) {
        super(sequence);
    }

    @Override
    public List<SearchResult<SequenceMatcher>> searchForwards(byte[] bytes, int fromPosition, int toPosition) {
        int searchPosition;
        int[] safeShifts = this.forwardInfo.get();
        SequenceMatcher sequence = this.getMatcher();
        int length = sequence.length();
        int finalPosition = bytes.length - length;
        int lastLoopPosition = finalPosition - 1;
        int lastPosition = toPosition < lastLoopPosition ? toPosition : lastLoopPosition;
        int n = searchPosition = fromPosition > 0 ? fromPosition : 0;
        while (searchPosition <= lastPosition) {
            if (sequence.matchesNoBoundsCheck(bytes, searchPosition)) {
                return SearchUtils.singleResult(searchPosition, sequence);
            }
            searchPosition += safeShifts[bytes[searchPosition + length] & 0xFF];
        }
        if (searchPosition == finalPosition && toPosition >= finalPosition && sequence.matches(bytes, finalPosition)) {
            return SearchUtils.singleResult(finalPosition, sequence);
        }
        return SearchUtils.noResults();
    }

    @Override
    public List<SearchResult<SequenceMatcher>> doSearchForwards(WindowReader reader, long fromPosition, long toPosition) throws IOException {
        Window window;
        int[] safeShifts = this.forwardInfo.get();
        SequenceMatcher sequence = this.getMatcher();
        int length = sequence.length();
        long searchPosition = fromPosition;
        while (searchPosition <= toPosition && (window = reader.getWindow(searchPosition + (long)length)) != null) {
            int arraySearchPosition;
            int shift;
            byte[] array = window.getArray();
            int arrayStartPosition = reader.getWindowOffset(searchPosition + (long)length);
            int arrayEndPosition = window.length() - 1;
            long distanceToEnd = toPosition - window.getWindowPosition() + (long)length;
            int finalPosition = distanceToEnd < (long)arrayEndPosition ? (int)distanceToEnd : arrayEndPosition;
            for (arraySearchPosition = arrayStartPosition; arraySearchPosition < finalPosition; arraySearchPosition += shift) {
                if (sequence.matches(reader, searchPosition)) {
                    return SearchUtils.singleResult(searchPosition, sequence);
                }
                shift = safeShifts[array[arraySearchPosition] & 0xFF];
                searchPosition += (long)shift;
            }
            if (arraySearchPosition != finalPosition && searchPosition != toPosition) continue;
            if (sequence.matches(reader, searchPosition)) {
                return SearchUtils.singleResult(searchPosition, sequence);
            }
            searchPosition += (long)safeShifts[array[arraySearchPosition] & 0xFF];
        }
        return SearchUtils.noResults();
    }

    @Override
    public List<SearchResult<SequenceMatcher>> searchBackwards(byte[] bytes, int fromPosition, int toPosition) {
        int searchPosition;
        int[] safeShifts = this.backwardInfo.get();
        SequenceMatcher sequence = this.getMatcher();
        int lastLoopPosition = toPosition > 1 ? toPosition : 1;
        int firstPossiblePosition = bytes.length - sequence.length();
        int n = searchPosition = fromPosition < firstPossiblePosition ? fromPosition : firstPossiblePosition;
        while (searchPosition >= lastLoopPosition) {
            if (sequence.matchesNoBoundsCheck(bytes, searchPosition)) {
                return SearchUtils.singleResult(searchPosition, sequence);
            }
            searchPosition -= safeShifts[bytes[searchPosition - 1] & 0xFF];
        }
        if (searchPosition == 0 && toPosition < 1 && sequence.matches(bytes, 0)) {
            return SearchUtils.singleResult(0L, sequence);
        }
        return SearchUtils.noResults();
    }

    @Override
    public List<SearchResult<SequenceMatcher>> doSearchBackwards(WindowReader reader, long fromPosition, long toPosition) throws IOException {
        Window window;
        int[] safeShifts = this.forwardInfo.get();
        SequenceMatcher sequence = this.getMatcher();
        long searchPosition = fromPosition;
        while (searchPosition >= toPosition && (window = reader.getWindow(searchPosition - 1L)) != null) {
            int arraySearchPosition;
            int shift;
            byte[] array = window.getArray();
            int arrayStartPosition = reader.getWindowOffset(searchPosition - 1L);
            long endRelativeToWindow = toPosition - window.getWindowPosition();
            int arrayEndSearchPosition = endRelativeToWindow > 0L ? (int)endRelativeToWindow : 0;
            for (arraySearchPosition = arrayStartPosition; arraySearchPosition > arrayEndSearchPosition; arraySearchPosition -= shift) {
                if (sequence.matches(reader, searchPosition)) {
                    return SearchUtils.singleResult(searchPosition, sequence);
                }
                shift = safeShifts[array[arraySearchPosition] & 0xFF];
                searchPosition -= (long)shift;
            }
            if (arraySearchPosition != arrayEndSearchPosition && searchPosition != toPosition) continue;
            if (sequence.matches(reader, searchPosition)) {
                return SearchUtils.singleResult(searchPosition, sequence);
            }
            searchPosition -= (long)safeShifts[array[arraySearchPosition] & 0xFF];
        }
        return SearchUtils.noResults();
    }

    @Override
    public void prepareForwards() {
        this.forwardInfo.get();
    }

    @Override
    public void prepareBackwards() {
        this.backwardInfo.get();
    }

    @Override
    public String toString() {
        return this.getClass().getSimpleName() + "[sequence:" + this.matcher + ']';
    }

    private final class BackwardInfoFactory
    implements ObjectFactory<int[]> {
        private BackwardInfoFactory() {
        }

        @Override
        public int[] create() {
            int[] shifts = new int[256];
            SequenceMatcher sequence = SundayQuickSearcher.this.getMatcher();
            int numBytes = sequence.length();
            Arrays.fill(shifts, numBytes + 1);
            for (int sequenceByteIndex = numBytes - 1; sequenceByteIndex >= 0; --sequenceByteIndex) {
                ByteMatcher aMatcher = sequence.getMatcherForPosition(sequenceByteIndex);
                byte[] matchingBytes = aMatcher.getMatchingBytes();
                int distanceFromStart = sequenceByteIndex + 1;
                for (byte b : matchingBytes) {
                    shifts[b & 0xFF] = distanceFromStart;
                }
            }
            return shifts;
        }
    }

    private final class ForwardInfoFactory
    implements ObjectFactory<int[]> {
        private ForwardInfoFactory() {
        }

        @Override
        public int[] create() {
            int[] shifts = new int[256];
            SequenceMatcher sequence = SundayQuickSearcher.this.getMatcher();
            int numBytes = sequence.length();
            Arrays.fill(shifts, numBytes + 1);
            for (int sequenceByteIndex = 0; sequenceByteIndex < numBytes; ++sequenceByteIndex) {
                ByteMatcher aMatcher = sequence.getMatcherForPosition(sequenceByteIndex);
                byte[] matchingBytes = aMatcher.getMatchingBytes();
                int distanceFromEnd = numBytes - sequenceByteIndex;
                for (byte b : matchingBytes) {
                    shifts[b & 0xFF] = distanceFromEnd;
                }
            }
            return shifts;
        }
    }
}

