/*
 * Decompiled with CFR 0.152.
 */
package org.icepdf.core.pobjects.acroform;

import java.util.HashMap;
import java.util.List;
import org.icepdf.core.pobjects.Dictionary;
import org.icepdf.core.pobjects.Name;
import org.icepdf.core.pobjects.Names;
import org.icepdf.core.pobjects.StringObject;
import org.icepdf.core.pobjects.acroform.CertSeedValueDictionary;
import org.icepdf.core.util.Library;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SeedValueDictionary
extends Dictionary {
    public static final Name LOCK_TYPE_VALUE = new Name("SV");
    public static final Name Ff_KEY = new Name("Ff");
    private static final int Ff_FILTER_BIT = 1;
    private static final int Ff_SUB_FILTER_BIT = 2;
    private static final int Ff_V_BIT = 4;
    private static final int Ff_REASONS_BIT = 8;
    private static final int Ff_LEGAL_ATTESTATION_BIT = 16;
    private static final int Ff_ADD_REV_INFO_BIT = 32;
    private static final int Ff_DIGEST_METHOD_BIT = 64;
    public static final Name FILTER_KEY = new Name("Filter");
    public static final Name SUB_FILTER_KEY = new Name("SubFilter");
    public static final Name DIGEST_METHOD_KEY = new Name("DigestMethod");
    public static final Name V_KEY = new Name("V");
    public static final Name CERT_KEY = new Name("Cert");
    public static final Name REASONS_KEY = new Name("Reasons");
    public static final Name MDP_KEY = new Name("MDP");
    public static final Name TIME_STAMP_KEY = new Name("TimeStamp");
    public static final Name LEGAL_ATTESTATION_KEY = new Name("LegalAttestation");
    public static final Name ADD_REV_INFO_KEY = new Name("AddRevInfo");
    private int flags;

    public SeedValueDictionary(Library library, HashMap entries) {
        super(library, entries);
        this.flags = library.getInt(entries, Ff_KEY);
    }

    public Name getFilterKey() {
        Object tmp = this.library.getObject(this.entries, FILTER_KEY);
        if (tmp instanceof Name) {
            return (Name)tmp;
        }
        return null;
    }

    public List<Names> getSubFilter() {
        List tmp = this.library.getArray(this.entries, FILTER_KEY);
        if (tmp != null) {
            return tmp;
        }
        return null;
    }

    public List<Names> getDigestMethod() {
        List tmp = this.library.getArray(this.entries, FILTER_KEY);
        if (tmp != null) {
            return tmp;
        }
        return null;
    }

    public double getV() {
        return this.library.getFloat(this.entries, V_KEY);
    }

    public CertSeedValueDictionary getCert() {
        Object tmp = this.library.getObject(this.entries, CERT_KEY);
        if (tmp instanceof HashMap) {
            return new CertSeedValueDictionary(this.library, (HashMap)tmp);
        }
        return null;
    }

    public List<StringObject> getReasons() {
        List tmp = this.library.getArray(this.entries, REASONS_KEY);
        if (tmp != null) {
            return tmp;
        }
        return null;
    }

    public HashMap getMDP() {
        Object tmp = this.library.getObject(this.entries, MDP_KEY);
        if (tmp instanceof HashMap) {
            return (HashMap)tmp;
        }
        return null;
    }

    public HashMap getTimeStamp() {
        Object tmp = this.library.getObject(this.entries, TIME_STAMP_KEY);
        if (tmp instanceof HashMap) {
            return (HashMap)tmp;
        }
        return null;
    }

    public List<StringObject> getLegalAttestation() {
        List tmp = this.library.getArray(this.entries, LEGAL_ATTESTATION_KEY);
        if (tmp != null) {
            return tmp;
        }
        return null;
    }

    public boolean getAddRevInfo() {
        return this.library.getBoolean(this.entries, ADD_REV_INFO_KEY);
    }

    public boolean isFilter() {
        return (this.flags & 1) == 1;
    }

    public boolean isSubFilter() {
        return (this.flags & 2) == 2;
    }

    public boolean isV() {
        return (this.flags & 4) == 4;
    }

    public boolean isReasons() {
        return (this.flags & 8) == 8;
    }

    public boolean isLegalAttenstation() {
        return (this.flags & 0x10) == 16;
    }

    public boolean isAddRevInfo() {
        return (this.flags & 0x20) == 32;
    }

    public boolean isDigestMethod() {
        return (this.flags & 0x40) == 64;
    }
}

