/*
 * Decompiled with CFR 0.152.
 */
package com.kerb4j.client;

import com.kerb4j.client.SpnegoClient;
import com.kerb4j.common.util.base64.Base64Codec;
import java.io.Closeable;
import java.io.IOException;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import javax.security.auth.Subject;
import org.ietf.jgss.GSSContext;
import org.ietf.jgss.GSSException;
import org.ietf.jgss.GSSName;

public class SpnegoContext
implements Closeable {
    private static final byte[] EMPTY_BYTE = new byte[0];
    private final SpnegoClient spnegoClient;
    private final GSSContext gssContext;

    public SpnegoContext(SpnegoClient spnegoClient, GSSContext gssContext) {
        this.spnegoClient = spnegoClient;
        this.gssContext = gssContext;
    }

    public void requestCredentialsDelegation() throws GSSException {
        this.gssContext.requestCredDeleg(true);
    }

    public byte[] createToken() throws PrivilegedActionException {
        return Subject.doAs(this.spnegoClient.getSubject(), new PrivilegedExceptionAction<byte[]>(){

            @Override
            public byte[] run() throws Exception {
                return SpnegoContext.this.gssContext.initSecContext(EMPTY_BYTE, 0, 0);
            }
        });
    }

    public String createTokenAsAuthroizationHeader() throws PrivilegedActionException {
        return "Negotiate " + Base64Codec.encode((byte[])this.createToken());
    }

    public byte[] processMutualAuthorization(final byte[] data, final int offset, final int length) throws PrivilegedActionException {
        return Subject.doAs(this.spnegoClient.getSubject(), new PrivilegedExceptionAction<byte[]>(){

            @Override
            public byte[] run() throws Exception {
                return SpnegoContext.this.gssContext.initSecContext(data, offset, length);
            }
        });
    }

    public byte[] acceptToken(byte[] token) throws GSSException {
        return this.gssContext.acceptSecContext(token, 0, token.length);
    }

    public GSSName getSrcName() throws GSSException {
        return this.gssContext.getSrcName();
    }

    public GSSContext getGSSContext() {
        return this.gssContext;
    }

    public boolean isEstablished() {
        return this.gssContext.isEstablished();
    }

    @Override
    public void close() throws IOException {
        try {
            this.gssContext.dispose();
        }
        catch (GSSException e) {
            throw new IOException(e);
        }
    }
}

