/*
 * Decompiled with CFR 0.152.
 */
package com.kerb4j.common.util;

import com.kerb4j.common.util.SpnegoAuthScheme;
import java.io.IOException;
import java.net.URL;
import javax.security.auth.callback.Callback;
import javax.security.auth.callback.CallbackHandler;
import javax.security.auth.callback.NameCallback;
import javax.security.auth.callback.PasswordCallback;
import javax.security.auth.callback.UnsupportedCallbackException;
import org.ietf.jgss.GSSException;
import org.ietf.jgss.GSSManager;
import org.ietf.jgss.GSSName;
import org.ietf.jgss.Oid;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class SpnegoProvider {
    public static final GSSManager GSS_MANAGER = GSSManager.getInstance();
    public static final String SPNEGO_MECHANISM = "1.3.6.1.5.5.2";
    public static final String KERBEROS_MECHANISM = "1.2.840.113554.1.2.2";
    public static final String LEGACY_KERBEROS_MECHANISM = "1.2.840.48018.1.2.2";
    public static final Oid SPNEGO_OID = SpnegoProvider.getSpnegoOid();
    public static final Oid KERBEROS_V5_OID = SpnegoProvider.getKerberosV5Oid();
    public static final Oid[] SUPPORTED_OIDS = new Oid[]{SPNEGO_OID, KERBEROS_V5_OID};
    private static final Logger LOGGER = LoggerFactory.getLogger(SpnegoProvider.class);

    private SpnegoProvider() {
    }

    public static SpnegoAuthScheme getAuthScheme(String header) {
        if (null == header || header.isEmpty()) {
            LOGGER.trace("authorization header was missing/null");
            return null;
        }
        if (header.startsWith("Negotiate")) {
            String token = header.substring("Negotiate".length() + 1);
            return new SpnegoAuthScheme("Negotiate", token);
        }
        if (header.startsWith("Basic")) {
            String token = header.substring("Basic".length() + 1);
            return new SpnegoAuthScheme("Basic", token);
        }
        throw new UnsupportedOperationException("Negotiate or Basic Only:" + header);
    }

    private static Oid getSpnegoOid() {
        Oid oid = null;
        try {
            oid = new Oid(SPNEGO_MECHANISM);
        }
        catch (GSSException gsse) {
            LOGGER.error("Unable to create OID 1.3.6.1.5.5.2 !", (Throwable)gsse);
        }
        return oid;
    }

    private static Oid getKerberosV5Oid() {
        Oid oid = null;
        try {
            oid = new Oid(KERBEROS_MECHANISM);
        }
        catch (GSSException gsse) {
            LOGGER.error("Unable to create OID 1.2.840.113554.1.2.2 !", (Throwable)gsse);
        }
        return oid;
    }

    public static GSSName createGSSNameForSPN(String spn) throws GSSException {
        return GSS_MANAGER.createName(spn.replaceAll("/", "@"), GSSName.NT_HOSTBASED_SERVICE, SPNEGO_OID);
    }

    public static GSSName getServerName(URL url) throws GSSException {
        return GSS_MANAGER.createName("HTTP@" + url.getHost(), GSSName.NT_HOSTBASED_SERVICE, SPNEGO_OID);
    }

    public static CallbackHandler getUsernameAndPasswordHandler(final String username, final String password) {
        LOGGER.trace("username=" + username + "; password=" + password.hashCode());
        return new CallbackHandler(){

            @Override
            public void handle(Callback[] callbacks) throws IOException, UnsupportedCallbackException {
                for (Callback callback : callbacks) {
                    if (callback instanceof NameCallback) {
                        NameCallback nameCallback = (NameCallback)callback;
                        nameCallback.setName(username);
                        continue;
                    }
                    if (callback instanceof PasswordCallback) {
                        PasswordCallback passCallback = (PasswordCallback)callback;
                        passCallback.setPassword(password.toCharArray());
                        continue;
                    }
                    LOGGER.warn("Unsupported Callback class=" + callback.getClass().getName());
                }
            }
        };
    }
}

