/*
 * Decompiled with CFR 0.152.
 */
package com.exlibris.core.infra.base.security;

import com.exlibris.core.infra.base.security.ContextCallableStatement;
import com.exlibris.core.infra.base.security.ContextPreparedStatement;
import com.exlibris.core.infra.base.security.ContextStatement;
import com.exlibris.core.infra.base.security.CrossNetworkWorkflow;
import com.exlibris.core.infra.base.security.CustomerInstitutionRetriever;
import java.sql.Array;
import java.sql.Blob;
import java.sql.CallableStatement;
import java.sql.Clob;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.NClob;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLClientInfoException;
import java.sql.SQLException;
import java.sql.SQLWarning;
import java.sql.SQLXML;
import java.sql.Savepoint;
import java.sql.Statement;
import java.sql.Struct;
import java.sql.Wrapper;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.Executor;
import oracle.jdbc.driver.OracleConnection;
import org.apache.log4j.Logger;

public class ContextConnection
implements Connection,
Wrapper {
    private static final String N_A = "N/A";
    private static final Logger logger = Logger.getLogger(ContextConnection.class);
    private static Map<Long, List<String>> sids = new ConcurrentHashMap<Long, List<String>>();
    protected String custumerId;
    protected String institutionId;
    protected String sid;
    private OracleConnection connectionDelegate;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ContextConnection(OracleConnection delegate) throws SQLException {
        this.connectionDelegate = delegate;
        this.connectionDelegate.setSessionTimeZone("GMT");
        this.setAppContext(N_A, N_A, "ContextConnection creation");
        Statement spStatement = null;
        ResultSet rsSP = null;
        try {
            spStatement = this.connectionDelegate.createStatement();
            rsSP = spStatement.executeQuery("select sys_context('USERENV','SID') sid from dual");
            while (rsSP.next()) {
                this.sid = rsSP.getString("sid");
            }
        }
        finally {
            try {
                rsSP.close();
            }
            catch (Exception exception) {}
            try {
                spStatement.close();
            }
            catch (Exception exception) {}
        }
    }

    public String getSid() {
        return this.sid;
    }

    public static String getSid(Thread thread) {
        List<String> lSids = sids.get(thread.getId());
        if (lSids == null || lSids.isEmpty()) {
            return null;
        }
        StringBuilder sb = new StringBuilder();
        boolean first = true;
        for (String sid : lSids) {
            if (first) {
                first = false;
            } else {
                sb.append(',');
            }
            sb.append(sid);
        }
        return sb.toString();
    }

    public static void addSidToCurrentThread(String sid) {
        long tId = Thread.currentThread().getId();
        List<String> lSids = sids.get(tId);
        if (lSids == null) {
            lSids = new ArrayList<String>();
            sids.put(tId, lSids);
        }
        lSids.add(sid);
    }

    public static void removeSidToCurrentThread() {
        long tId = Thread.currentThread().getId();
        List<String> lSids = sids.get(tId);
        if (lSids != null && lSids.size() > 0) {
            lSids.remove(lSids.size() - 1);
        }
        if (lSids != null && lSids.isEmpty()) {
            sids.remove(tId);
        }
    }

    public void setContext() throws SQLException {
        Long instId;
        String newCustumerId = N_A;
        String newInstitutionId = N_A;
        Long custId = CustomerInstitutionRetriever.getCustomerId();
        if (custId != null) {
            newCustumerId = " " + custId + " ";
        }
        if ((instId = CustomerInstitutionRetriever.getInstitutionId()) != null) {
            newInstitutionId = " " + instId + " ";
        }
        if (!newCustumerId.equals(this.custumerId) || !newInstitutionId.equals(this.institutionId)) {
            this.setAppContext(newCustumerId, newInstitutionId, "setContext");
        }
        if (CustomerInstitutionRetriever.getCrossNetworkContext() != null) {
            this.openForNetwork(CustomerInstitutionRetriever.getCrossNetworkContext());
        }
    }

    public void setAppContext(String newCustumerId, String newInstitutionId, String fromFct) throws SQLException {
        if (logger.isDebugEnabled()) {
            logger.debug((Object)(this.connectionDelegate.toString() + " (" + fromFct + "): VPD change from (" + this.custumerId + "," + this.institutionId + ") to (" + newCustumerId + "," + newInstitutionId + ")."));
        }
        this.custumerId = newCustumerId;
        this.institutionId = newInstitutionId;
        if (!N_A.equals(newCustumerId)) {
            this.connectionDelegate.setApplicationContext("CLIENTCONTEXT", "CUST_ID", newCustumerId);
            this.connectionDelegate.setApplicationContext("CLIENTCONTEXT", "INST_ID", newInstitutionId);
        } else {
            this.connectionDelegate.setApplicationContext("CLIENTCONTEXT", "CUST_ID", "");
            this.connectionDelegate.setApplicationContext("CLIENTCONTEXT", "INST_ID", "");
        }
    }

    private void openForNetwork(CrossNetworkWorkflow crossNetworkWorkflow) throws SQLException {
        if (logger.isDebugEnabled()) {
            logger.debug((Object)(this.connectionDelegate.toString() + " openForNetwork, CrossNetworkWorkflow is [" + (Object)((Object)crossNetworkWorkflow) + "]"));
        }
        this.connectionDelegate.setApplicationContext("CLIENTCONTEXT", crossNetworkWorkflow.toString().toUpperCase(), "true");
    }

    public void logContext(String fromFct) throws SQLException {
        if (logger.isDebugEnabled()) {
            logger.debug((Object)(this.connectionDelegate.toString() + "(" + fromFct + "): (" + this.custumerId + "," + this.institutionId + ")."));
        }
    }

    @Override
    public void clearWarnings() throws SQLException {
        CrossNetworkWorkflow crossNetworkContext;
        if (!N_A.equals(this.custumerId) || !N_A.equals(this.institutionId)) {
            this.setAppContext(N_A, N_A, "clearWarnings");
        }
        if ((crossNetworkContext = CustomerInstitutionRetriever.getCrossNetworkContext()) != null) {
            this.connectionDelegate.setApplicationContext("CLIENTCONTEXT", crossNetworkContext.toString().toUpperCase(), "");
        }
        this.connectionDelegate.clearWarnings();
    }

    @Override
    public void close() throws SQLException {
        this.setAppContext(N_A, N_A, "close");
        this.connectionDelegate.close();
    }

    @Override
    public void commit() throws SQLException {
        this.setContext();
        this.connectionDelegate.commit();
    }

    @Override
    public Statement createStatement() throws SQLException {
        this.setContext();
        return new ContextStatement(this.connectionDelegate.createStatement(), this);
    }

    @Override
    public Statement createStatement(int resultSetType, int resultSetConcurrency) throws SQLException {
        this.setContext();
        return new ContextStatement(this.connectionDelegate.createStatement(resultSetType, resultSetConcurrency), this);
    }

    @Override
    public Statement createStatement(int resultSetType, int resultSetConcurrency, int resultSetHoldability) throws SQLException {
        this.setContext();
        return new ContextStatement(this.connectionDelegate.createStatement(resultSetType, resultSetConcurrency, resultSetHoldability), this);
    }

    @Override
    public boolean getAutoCommit() throws SQLException {
        return this.connectionDelegate.getAutoCommit();
    }

    @Override
    public String getCatalog() throws SQLException {
        this.setContext();
        return this.connectionDelegate.getCatalog();
    }

    @Override
    public int getHoldability() throws SQLException {
        this.setContext();
        return this.connectionDelegate.getHoldability();
    }

    @Override
    public DatabaseMetaData getMetaData() throws SQLException {
        this.setContext();
        return this.connectionDelegate.getMetaData();
    }

    @Override
    public int getTransactionIsolation() throws SQLException {
        this.setContext();
        return this.connectionDelegate.getTransactionIsolation();
    }

    @Override
    public Map<String, Class<?>> getTypeMap() throws SQLException {
        this.setContext();
        return this.connectionDelegate.getTypeMap();
    }

    @Override
    public SQLWarning getWarnings() throws SQLException {
        this.setContext();
        return this.connectionDelegate.getWarnings();
    }

    @Override
    public boolean isClosed() throws SQLException {
        this.setContext();
        return this.connectionDelegate.isClosed();
    }

    @Override
    public boolean isReadOnly() throws SQLException {
        this.setContext();
        return this.connectionDelegate.isReadOnly();
    }

    @Override
    public String nativeSQL(String sql) throws SQLException {
        this.setContext();
        return this.connectionDelegate.nativeSQL(sql);
    }

    @Override
    public CallableStatement prepareCall(String sql) throws SQLException {
        this.setContext();
        return new ContextCallableStatement(this.connectionDelegate.prepareCall(sql), this);
    }

    @Override
    public CallableStatement prepareCall(String sql, int resultSetType, int resultSetConcurrency) throws SQLException {
        this.setContext();
        return new ContextCallableStatement(this.connectionDelegate.prepareCall(sql, resultSetType, resultSetConcurrency), this);
    }

    @Override
    public CallableStatement prepareCall(String sql, int resultSetType, int resultSetConcurrency, int resultSetHoldability) throws SQLException {
        this.setContext();
        return new ContextCallableStatement(this.connectionDelegate.prepareCall(sql, resultSetType, resultSetConcurrency, resultSetHoldability), this);
    }

    @Override
    public PreparedStatement prepareStatement(String sql) throws SQLException {
        this.setContext();
        return new ContextPreparedStatement(this.connectionDelegate.prepareStatement(sql), this);
    }

    @Override
    public PreparedStatement prepareStatement(String sql, int autoGeneratedKeys) throws SQLException {
        this.setContext();
        return new ContextPreparedStatement(this.connectionDelegate.prepareStatement(sql, autoGeneratedKeys), this);
    }

    @Override
    public PreparedStatement prepareStatement(String sql, int[] columnIndexes) throws SQLException {
        this.setContext();
        return new ContextPreparedStatement(this.connectionDelegate.prepareStatement(sql, columnIndexes), this);
    }

    @Override
    public PreparedStatement prepareStatement(String sql, String[] columnNames) throws SQLException {
        this.setContext();
        return new ContextPreparedStatement(this.connectionDelegate.prepareStatement(sql, columnNames), this);
    }

    @Override
    public PreparedStatement prepareStatement(String sql, int resultSetType, int resultSetConcurrency) throws SQLException {
        this.setContext();
        return new ContextPreparedStatement(this.connectionDelegate.prepareStatement(sql, resultSetType, resultSetConcurrency), this);
    }

    @Override
    public PreparedStatement prepareStatement(String sql, int resultSetType, int resultSetConcurrency, int resultSetHoldability) throws SQLException {
        return new ContextPreparedStatement(this.connectionDelegate.prepareStatement(sql, resultSetType, resultSetConcurrency, resultSetHoldability), this);
    }

    @Override
    public void releaseSavepoint(Savepoint savepoint) throws SQLException {
        this.connectionDelegate.releaseSavepoint(savepoint);
    }

    @Override
    public void rollback() throws SQLException {
        this.connectionDelegate.rollback();
    }

    @Override
    public void rollback(Savepoint savepoint) throws SQLException {
        this.connectionDelegate.rollback(savepoint);
    }

    @Override
    public void setAutoCommit(boolean autoCommit) throws SQLException {
        this.connectionDelegate.setAutoCommit(autoCommit);
    }

    @Override
    public void setCatalog(String catalog) throws SQLException {
        this.connectionDelegate.setCatalog(catalog);
    }

    @Override
    public void setHoldability(int holdability) throws SQLException {
        this.connectionDelegate.setHoldability(holdability);
    }

    @Override
    public void setReadOnly(boolean readOnly) throws SQLException {
        this.connectionDelegate.setReadOnly(readOnly);
    }

    @Override
    public Savepoint setSavepoint() throws SQLException {
        return this.connectionDelegate.setSavepoint();
    }

    @Override
    public Savepoint setSavepoint(String name) throws SQLException {
        return this.connectionDelegate.setSavepoint(name);
    }

    @Override
    public void setTransactionIsolation(int level) throws SQLException {
        this.connectionDelegate.setTransactionIsolation(level);
    }

    @Override
    public void setTypeMap(Map<String, Class<?>> map) throws SQLException {
        this.connectionDelegate.setTypeMap(map);
    }

    @Override
    public Array createArrayOf(String typeName, Object[] elements) throws SQLException {
        return this.connectionDelegate.createArrayOf(typeName, elements);
    }

    @Override
    public Blob createBlob() throws SQLException {
        return this.connectionDelegate.createBlob();
    }

    @Override
    public Clob createClob() throws SQLException {
        return this.connectionDelegate.createClob();
    }

    @Override
    public NClob createNClob() throws SQLException {
        return this.connectionDelegate.createNClob();
    }

    @Override
    public SQLXML createSQLXML() throws SQLException {
        return this.connectionDelegate.createSQLXML();
    }

    @Override
    public Struct createStruct(String typeName, Object[] attributes) throws SQLException {
        return this.connectionDelegate.createStruct(typeName, attributes);
    }

    @Override
    public Properties getClientInfo() throws SQLException {
        return this.connectionDelegate.getClientInfo();
    }

    @Override
    public String getClientInfo(String name) throws SQLException {
        return this.connectionDelegate.getClientInfo(name);
    }

    @Override
    public boolean isValid(int timeout) throws SQLException {
        return this.connectionDelegate.isValid(timeout);
    }

    @Override
    public void setClientInfo(Properties properties) throws SQLClientInfoException {
        this.connectionDelegate.setClientInfo(properties);
    }

    @Override
    public void setClientInfo(String name, String value) throws SQLClientInfoException {
        this.connectionDelegate.setClientInfo(name, value);
    }

    @Override
    public boolean isWrapperFor(Class<?> iface) throws SQLException {
        if (iface.isAssignableFrom(this.connectionDelegate.getClass())) {
            return true;
        }
        return this.connectionDelegate.isWrapperFor(iface);
    }

    @Override
    public <T> T unwrap(Class<T> iface) throws SQLException {
        if (iface.isAssignableFrom(this.connectionDelegate.getClass())) {
            return iface.cast(this.connectionDelegate);
        }
        return (T)this.connectionDelegate.unwrap(iface);
    }

    public Integer pingDatabase() throws SQLException {
        return this.connectionDelegate.pingDatabase();
    }

    @Override
    public void setSchema(String schema) throws SQLException {
    }

    @Override
    public String getSchema() throws SQLException {
        return null;
    }

    @Override
    public void abort(Executor executor) throws SQLException {
    }

    @Override
    public void setNetworkTimeout(Executor executor, int milliseconds) throws SQLException {
    }

    @Override
    public int getNetworkTimeout() throws SQLException {
        return 0;
    }
}

