/*
 * Decompiled with CFR 0.152.
 */
package com.exlibris.core.infra.model.quartz;

import com.exlibris.core.infra.Common;
import com.exlibris.core.infra.model.HOwneredEntity;
import java.util.Date;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.EnumType;
import javax.persistence.Enumerated;
import javax.persistence.Lob;
import javax.persistence.Table;
import javax.persistence.Transient;
import javax.persistence.UniqueConstraint;

@Entity
@Table(uniqueConstraints={@UniqueConstraint(columnNames={"OWNER", "JOB_NAME", "JOB_GROUP"})})
public class QuartzJobConfig
extends HOwneredEntity
implements Cloneable {
    private static final long serialVersionUID = -5559914602088306512L;
    private String jobName = null;
    private String jobClass = null;
    private String jobGroup = null;
    private Integer numOfWorkers = null;
    private JobType jobType = null;
    private Common.QuartzRole jobRole = null;
    private SchedulerType schedulerType = null;
    private String operationalJobName;
    private String paramsXml = null;
    private String cronExpr = null;
    private Date startDate = null;
    private Date endDate = null;
    private Common.SchedulingMode schedulingMode;
    private String schedulingDescription = null;
    private Date lastRunDate = null;
    private String emailAddress = null;
    private EmailLevel emailLevel = EmailLevel.NEVER;
    private boolean toReschedule = true;

    public QuartzJobConfig() {
        this.schedulingMode = Common.SchedulingMode.ADVANCE;
        this.emailLevel = EmailLevel.NEVER;
    }

    @Column(name="JOB_NAME")
    public String getJobName() {
        return this.jobName;
    }

    public void setJobName(String jobName) {
        this.jobName = jobName;
    }

    @Column(name="JOB_CLASS")
    public String getJobClass() {
        return this.jobClass;
    }

    public void setJobClass(String jobClass) {
        this.jobClass = jobClass;
    }

    @Column(name="JOB_GROUP")
    public String getJobGroup() {
        return this.jobGroup;
    }

    public void setJobGroup(String jobGroup) {
        this.jobGroup = jobGroup;
    }

    @Column(name="CRON_EXPR")
    public String getCronExpr() {
        return this.cronExpr;
    }

    public void setCronExpr(String cronExpr) {
        this.cronExpr = cronExpr;
    }

    @Column(name="NUM_OF_WORKERS")
    public Integer getNumOfWorkers() {
        return this.numOfWorkers;
    }

    public void setNumOfWorkers(Integer numOfWorkers) {
        this.numOfWorkers = numOfWorkers;
    }

    @Transient
    public boolean isNumOfWorkersJob() {
        boolean isNumOfWorkersJob = this.schedulerType == SchedulerType.IN_MEMORY && this.numOfWorkers != null && this.numOfWorkers > 0;
        return isNumOfWorkersJob;
    }

    @Column(name="JOB_TYPE")
    @Enumerated(value=EnumType.STRING)
    public JobType getJobType() {
        return this.jobType;
    }

    public void setJobType(JobType jobType) {
        this.jobType = jobType;
    }

    @Column(name="JOB_ROLE")
    @Enumerated(value=EnumType.STRING)
    public Common.QuartzRole getJobRole() {
        return this.jobRole;
    }

    public void setJobRole(Common.QuartzRole jobRole) {
        this.jobRole = jobRole;
    }

    @Column(name="SCHEDULER_TYPE")
    @Enumerated(value=EnumType.STRING)
    public SchedulerType getSchedulerType() {
        return this.schedulerType;
    }

    public void setSchedulerType(SchedulerType schedulerType) {
        this.schedulerType = schedulerType;
    }

    @Column(name="OPERATIONAL_JOB_NAME")
    public String getOperationalJobName() {
        return this.operationalJobName;
    }

    public void setOperationalJobName(String operationalJobName) {
        this.operationalJobName = operationalJobName;
    }

    @Column(name="PARAMS_XML")
    @Lob
    public String getParamsXml() {
        return this.paramsXml;
    }

    public void setParamsXml(String paramsXml) {
        this.paramsXml = paramsXml;
    }

    @Column(name="START_DATE")
    public Date getStartDate() {
        return this.startDate;
    }

    public void setStartDate(Date startDate) {
        this.startDate = startDate;
    }

    @Column(name="END_DATE")
    public Date getEndDate() {
        return this.endDate;
    }

    public void setEndDate(Date endDate) {
        this.endDate = endDate;
    }

    @Column(name="SCHEDULING_MODE")
    @Enumerated(value=EnumType.STRING)
    public Common.SchedulingMode getSchedulingMode() {
        return this.schedulingMode;
    }

    public void setSchedulingMode(Common.SchedulingMode schedulingMode) {
        this.schedulingMode = schedulingMode;
    }

    @Column(name="SCHEDULING_DESCRIPTION")
    public String getSchedulingDescription() {
        return this.schedulingDescription;
    }

    public void setSchedulingDescription(String schedulingDescription) {
        this.schedulingDescription = schedulingDescription;
    }

    @Column(name="LAST_RUN_DATE")
    public Date getLastRunDate() {
        return this.lastRunDate;
    }

    public void setLastRunDate(Date lastRunDate) {
        this.lastRunDate = lastRunDate;
    }

    @Column(name="TO_RESCHEDULE")
    public boolean getToReschedule() {
        return this.toReschedule;
    }

    public void setToReschedule(boolean toReschedule) {
        this.toReschedule = toReschedule;
    }

    @Transient
    public String getTriggerName() {
        return this.getJobName();
    }

    @Transient
    public String getTriggerGroup() {
        return this.getJobGroup();
    }

    @Column
    public String getEmailAddress() {
        return this.emailAddress;
    }

    public void setEmailAddress(String emailAddress) {
        this.emailAddress = emailAddress;
    }

    @Enumerated(value=EnumType.STRING)
    @Column
    public EmailLevel getEmailLevel() {
        return this.emailLevel;
    }

    public void setEmailLevel(EmailLevel emailLevel) {
        this.emailLevel = emailLevel;
    }

    @Transient
    public String getEmailLevelStr() {
        return this.emailLevel.toString();
    }

    public void setEmailLevelStr(String emailLevelStr) {
        this.emailLevel = EmailLevel.valueOf(emailLevelStr);
    }

    public QuartzJobConfig clone() throws CloneNotSupportedException {
        QuartzJobConfig clone = (QuartzJobConfig)super.clone();
        clone.setJobName(this.jobName);
        clone.setJobClass(this.jobClass);
        clone.setJobGroup(this.jobGroup);
        clone.setNumOfWorkers(this.numOfWorkers);
        clone.setJobType(this.jobType);
        clone.setJobRole(this.jobRole);
        clone.setSchedulerType(this.schedulerType);
        clone.setParamsXml(this.paramsXml);
        clone.setCronExpr(this.cronExpr);
        clone.setStartDate(this.startDate);
        clone.setEndDate(this.endDate);
        clone.setSchedulingMode(this.schedulingMode);
        clone.setSchedulingDescription(this.schedulingDescription);
        clone.setToReschedule(this.toReschedule);
        clone.setEmailAddress(this.emailAddress);
        clone.setEmailLevel(this.emailLevel);
        return clone;
    }

    public static enum EmailLevel {
        ALWAYS,
        ON_FAILED,
        NEVER;

    }

    public static enum SchedulerType {
        CLUSTERED,
        IN_MEMORY;

    }

    public static enum JobType {
        SYSTEM,
        BACKGROUND,
        OPERATIONAL;

    }
}

