/*
 * Decompiled with CFR 0.152.
 */
package com.exlibris.core.infra.model.storage;

import com.exlibris.core.infra.model.HOwneredVersionedEntity;
import com.exlibris.core.infra.model.storage.StorageGroup;
import com.exlibris.core.infra.model.storage.StorageParameter;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.persistence.CascadeType;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.NamedQueries;
import javax.persistence.NamedQuery;
import javax.persistence.OneToMany;
import javax.persistence.Table;
import javax.persistence.Transient;
import org.hibernate.annotations.Cascade;
import org.hibernate.annotations.Index;
import org.hibernate.collection.PersistentBag;

@Entity
@NamedQueries(value={@NamedQuery(name="findStoragesByGroupId", query="from Storage where group.id = :groupId")})
@Table(name="STORAGE")
public class Storage
extends HOwneredVersionedEntity {
    private static final long serialVersionUID = 1L;
    private StorageGroup group;
    private String pluginInstanceName;
    private List<StorageParameter> storageParameters;
    private String storageName;
    private String storageDescription;
    private Long storageOrder;

    @ManyToOne
    @JoinColumn(name="GROUP_ID")
    @Index(name="GROUP_ID_IDX")
    public StorageGroup getGroup() {
        return this.group;
    }

    @OneToMany(mappedBy="storage", targetEntity=StorageParameter.class, cascade={CascadeType.ALL}, fetch=FetchType.EAGER)
    @Cascade(value={org.hibernate.annotations.CascadeType.ALL, org.hibernate.annotations.CascadeType.DELETE_ORPHAN})
    public List<StorageParameter> getStorageParameters() {
        return this.storageParameters;
    }

    @Column(name="STORAGE_NAME", length=50)
    public String getStorageName() {
        return this.storageName;
    }

    @Column(name="STORAGE_DESCRIPTION")
    public String getStorageDescription() {
        return this.storageDescription;
    }

    @Column(name="STORAGE_ORDER", length=5)
    public Long getStorageOrder() {
        return this.storageOrder;
    }

    @Column(name="PLUGIN_NAME")
    public String getPluginInstanceName() {
        return this.pluginInstanceName;
    }

    @Transient
    public Map<String, String> getStorageParamAsMap() {
        HashMap<String, String> retMap = new HashMap<String, String>();
        for (StorageParameter param : this.getStorageParameters()) {
            retMap.put(param.getKey(), param.getValue());
        }
        return retMap;
    }

    public void setPluginInstanceName(String pluginInstanceName) {
        this.pluginInstanceName = pluginInstanceName;
    }

    public void setGroup(StorageGroup group) {
        this.group = group;
    }

    public void setStorageName(String name) {
        this.storageName = name;
    }

    public void setStorageParameters(List<StorageParameter> storageParameters) {
        this.storageParameters = storageParameters;
        if (storageParameters != null && !storageParameters.getClass().equals(PersistentBag.class)) {
            for (StorageParameter param : storageParameters) {
                param.setStorage(this);
            }
        }
    }

    public void setStorageDescription(String description) {
        this.storageDescription = description;
    }

    public void setStorageOrder(Long order) {
        this.storageOrder = order;
    }

    public void addStorageParameters(StorageParameter param) {
        if (this.storageParameters == null) {
            this.storageParameters = new ArrayList<StorageParameter>();
        }
        this.storageParameters.add(param);
        param.setStorage(this);
    }

    @Override
    public int hashCode() {
        int prime = 31;
        int result = super.hashCode();
        result = 31 * result + (this.group == null ? 0 : this.group.hashCode());
        result = 31 * result + (this.storageDescription == null ? 0 : this.storageDescription.hashCode());
        result = 31 * result + (this.storageName == null ? 0 : this.storageName.hashCode());
        result = 31 * result + (this.storageOrder == null ? 0 : this.storageOrder.hashCode());
        result = 31 * result + (this.storageParameters == null ? 0 : this.storageParameters.hashCode());
        result = 31 * result + (this.pluginInstanceName == null ? 0 : this.pluginInstanceName.hashCode());
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!super.equals(obj)) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        Storage other = (Storage)obj;
        if (this.group == null ? other.group != null : !this.group.equals(other.group)) {
            return false;
        }
        if (this.storageDescription == null ? other.storageDescription != null : !this.storageDescription.equals(other.storageDescription)) {
            return false;
        }
        if (this.storageName == null ? other.storageName != null : !this.storageName.equals(other.storageName)) {
            return false;
        }
        if (this.storageOrder == null ? other.storageOrder != null : !this.storageOrder.equals(other.storageOrder)) {
            return false;
        }
        if (this.storageParameters == null ? other.storageParameters != null : !this.storageParameters.equals(other.storageParameters)) {
            return false;
        }
        return !(this.pluginInstanceName == null ? other.pluginInstanceName != null : !this.pluginInstanceName.equals(other.pluginInstanceName));
    }

    public static enum PermanentStorageType {
        SIP,
        METADATA,
        IE,
        FILE;

    }
}

