/*
 * Decompiled with CFR 0.152.
 */
package com.exlibris.core.infra.svc.api;

import com.exlibris.core.infra.common.cache.SessionUtils;
import com.exlibris.core.infra.common.exceptions.logging.ExLogger;
import com.exlibris.core.infra.svc.api.CodeTablesManager;
import com.exlibris.core.infra.svc.api.locator.ServiceLocator;
import java.util.Collections;
import java.util.Enumeration;
import java.util.Locale;
import java.util.ResourceBundle;
import java.util.Set;
import org.apache.commons.lang.StringEscapeUtils;
import org.apache.commons.lang.StringUtils;

public class CodeTablesResourceBundle
extends ResourceBundle {
    private static final ExLogger log = ExLogger.getExLogger(CodeTablesResourceBundle.class);
    private static String defaultBundle;
    private CodeTablesManager ctManager;
    public static final String UI_LABLES = "UILabels";
    public static final String UI_MESSAGES = "UIMessages";
    public static final String CRS_OWNER = "CRS00";

    public static ResourceBundle getDefaultBundle(Locale locale) {
        if (locale == null) {
            return ResourceBundle.getBundle(CodeTablesResourceBundle.getDefaultBundle());
        }
        return ResourceBundle.getBundle(CodeTablesResourceBundle.getDefaultBundle(), locale);
    }

    public static String getDefaultBundle() {
        if (defaultBundle == null) {
            defaultBundle = CodeTablesResourceBundle.class.getName();
        }
        return defaultBundle;
    }

    @Override
    public Enumeration<String> getKeys() {
        Set keySet = null;
        try {
            keySet = this.getCodeTablesManager().getCodeTableFromTreeCache(UI_LABLES, "en", CRS_OWNER).keySet();
            keySet.addAll(this.getCodeTablesManager().getCodeTableFromTreeCache(UI_MESSAGES, "en", CRS_OWNER).keySet());
        }
        catch (Exception e) {
            log.warn((Object)"Failed to ", e, new String[0]);
        }
        return Collections.enumeration(keySet);
    }

    @Override
    protected Object handleGetObject(String code) {
        String res;
        if (code == null) {
            code = "";
        }
        res = (res = this.getValue(code)) == null ? code : res.trim();
        res = StringEscapeUtils.unescapeHtml((String)res);
        return res;
    }

    private final String getValue(String code) {
        String value = null;
        try {
            String codeTableName = com.exlibris.core.infra.common.util.StringUtils.startsWithDigit(code) ? UI_MESSAGES : UI_LABLES;
            String language = SessionUtils.getSessionLanguage();
            value = this.getCodeTablesManager().getCodeTableValueFromTreeCache(codeTableName, language, CRS_OWNER, code);
            if (StringUtils.isBlank((String)value) && !"en".equals(language)) {
                value = this.getCodeTablesManager().getCodeTableValueFromTreeCache(codeTableName, "en", CRS_OWNER, code);
            }
        }
        catch (Exception e) {
            log.warn((Object)("Failed to get value of code :'" + code + "'"), e, new String[0]);
        }
        return value;
    }

    private CodeTablesManager getCodeTablesManager() {
        if (this.ctManager == null) {
            this.ctManager = (CodeTablesManager)ServiceLocator.getInstance().lookUp(CodeTablesManager.class);
        }
        return this.ctManager;
    }
}

