/*
 * Decompiled with CFR 0.152.
 */
package com.exlibris.core.infra.svc.api.plugins;

import com.exlibris.core.infra.common.exceptions.InfraException;
import com.exlibris.core.infra.common.javaclass.JavaClassUtils;
import com.exlibris.core.infra.common.javaclass.PluginClassLoader;
import com.exlibris.core.infra.model.plugins.HFrPluginInstance;
import com.exlibris.core.infra.model.plugins.HFrPluginType;
import com.exlibris.core.infra.svc.api.plugins.ListenerResult;
import com.exlibris.core.infra.svc.api.plugins.PluginListener;
import java.io.File;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.Calendar;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.io.FileUtils;
import org.apache.log4j.Logger;

public class PluginsInitializatorUtils {
    private static final Logger log = Logger.getLogger(PluginsInitializatorUtils.class);
    public static Map<String, PluginClassLoader> pluginClassLoaders = new HashMap<String, PluginClassLoader>();

    public static void log(String pluginName, String jarName, double version, DeploymentResult operation) {
        StringBuilder logMsg = new StringBuilder();
        logMsg.append("|");
        PluginsInitializatorUtils.logColumn(logMsg, pluginName, 35);
        logMsg.append(" | ");
        PluginsInitializatorUtils.logColumn(logMsg, jarName, 30);
        logMsg.append(" | ");
        PluginsInitializatorUtils.logColumn(logMsg, version + "", 5);
        logMsg.append(" | ");
        PluginsInitializatorUtils.logColumn(logMsg, operation.name(), 35);
        logMsg.append("|");
        log.info((Object)logMsg.toString());
    }

    private static void logColumn(StringBuilder logMsg, String columnValue, int columnWidth) {
        if (columnWidth - columnValue.length() > 0) {
            logMsg.append(columnValue);
        } else {
            logMsg.append(columnValue.substring(0, columnWidth - 3)).append("...");
        }
        for (int i = 0; i < columnWidth - columnValue.length(); ++i) {
            logMsg.append(" ");
        }
    }

    public static void runListener(HFrPluginInstance instance, HFrPluginType type) throws InfraException {
        if (type.getPluginListener() != null) {
            PluginsInitializatorUtils.runPluginListener(instance);
        }
    }

    public static void loadJarToClassPath(String jarFilePath, String jarFileName) {
        File jar = new File(jarFilePath + jarFileName);
        try {
            JavaClassUtils.addURLToClassLoader(jar.toURI().toURL());
        }
        catch (Exception e) {
            log.error((Object)("failed to load jar/jar class into loader class path " + jarFileName), (Throwable)e);
        }
    }

    public static URLClassLoader getPluginClassLoader(String jarFilePath, String jarFileName, double version) {
        PluginClassLoader classLoader = null;
        File pluginJar = new File(jarFilePath + jarFileName);
        File jarInTemp = null;
        ClassLoader sysloader = Thread.currentThread().getContextClassLoader();
        classLoader = pluginClassLoaders.get(PluginsInitializatorUtils.generateClassLoaderMapKey(jarFilePath, jarFileName, version));
        if (classLoader == null) {
            try {
                long timeStamp = Calendar.getInstance().getTimeInMillis();
                String tempJarName = jarFileName + "_" + version + "_" + timeStamp;
                File tempDirectory = new File(System.getProperty("java.io.tmpdir"), tempJarName);
                tempDirectory.mkdir();
                jarInTemp = new File(tempDirectory, tempJarName);
                FileUtils.copyFile((File)pluginJar, (File)jarInTemp);
                classLoader = new PluginClassLoader(new URL[]{jarInTemp.toURI().toURL()}, sysloader);
                classLoader.addJar(jarInTemp, version, tempDirectory);
                pluginClassLoaders.put(PluginsInitializatorUtils.generateClassLoaderMapKey(jarFilePath, jarFileName, version), classLoader);
            }
            catch (MalformedURLException e) {
                log.error((Object)("failed to load jar/jar class into loader class path " + jarFileName), (Throwable)e);
            }
            catch (IOException e) {
                log.error((Object)("Failed to copy Plugin Jar " + pluginJar.getPath() + "To " + jarInTemp.getPath()), (Throwable)e);
            }
        }
        return classLoader;
    }

    private static String generateClassLoaderMapKey(String jarFilePath, String jarFileName, double version) {
        return jarFilePath + jarFileName + "_" + version;
    }

    public static void runPluginListener(HFrPluginInstance pm) {
        PluginListener pl = null;
        try {
            pl = (PluginListener)Class.forName(pm.getPluginType().getPluginListener()).newInstance();
        }
        catch (Exception e) {
            log.warn((Object)("PluginListener not found for plugin type: " + pm.getPluginType().getPluginTypeName()));
        }
        try {
            ListenerResult lr;
            if (pl != null && !(lr = pl.postInsall(pm)).isSuccess()) {
                log.warn((Object)lr.getErrorMessage());
            }
        }
        catch (Exception e) {
            String errorMsg = "Post install for plugin type: " + pm.getPluginType().getPluginTypeName() + " throw an exception: " + e.getMessage();
            log.error((Object)errorMsg, (Throwable)e);
        }
    }

    public static void removeJarFromClassLoaderMap(String jarFilePath, String jarFileName, double version) {
        String classLoaderKey = PluginsInitializatorUtils.generateClassLoaderMapKey(jarFilePath, jarFileName, version);
        pluginClassLoaders.remove(classLoaderKey);
    }

    public static enum DeploymentResult {
        ALREADY_DEPLOYED,
        NEW_DEPLOY,
        MOVED_TO_DEPLOY,
        FAILED,
        UPDATED,
        UPDATED_VERSION_FOR_OLD_INSTANCES;

    }
}

