/*
 * Decompiled with CFR 0.152.
 */
package com.exlibris.core.infra.svc.api.properties;

import com.exlibris.core.infra.common.exceptions.logging.ExLogger;
import com.exlibris.core.infra.common.util.IOUtil;
import com.exlibris.core.infra.model.properties.PropertiesConfiguration;
import com.exlibris.core.infra.svc.api.GeneralParameterManager;
import com.exlibris.core.infra.svc.api.applicationVersion.ApplicationVersionService;
import com.exlibris.core.infra.svc.api.config.GlobalProperties;
import com.exlibris.core.infra.svc.api.locator.ServiceLocator;
import com.exlibris.core.infra.svc.api.properties.AuthHttpSolrClient;
import com.exlibris.core.infra.svc.api.properties.SolrIndexServices;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Properties;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.apache.commons.lang.StringUtils;
import org.apache.http.HttpException;
import org.apache.http.HttpHost;
import org.apache.http.HttpRequest;
import org.apache.http.HttpRequestInterceptor;
import org.apache.http.auth.AuthScheme;
import org.apache.http.auth.AuthScope;
import org.apache.http.auth.AuthState;
import org.apache.http.auth.Credentials;
import org.apache.http.auth.UsernamePasswordCredentials;
import org.apache.http.client.CredentialsProvider;
import org.apache.http.client.HttpClient;
import org.apache.http.impl.auth.BasicScheme;
import org.apache.http.impl.client.BasicCredentialsProvider;
import org.apache.http.impl.client.HttpClientBuilder;
import org.apache.http.protocol.HttpContext;
import org.apache.solr.client.solrj.SolrClient;
import org.apache.solr.client.solrj.impl.CloudSolrClient;
import org.apache.solr.common.SolrInputDocument;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

public class SolrUtils {
    private static final String SOLR_ADMIN_USERS_PROPERTIES = "solr/prop/solr-admin-users.properties";
    private static final String COLLECTION = "collection";
    private static final String SIP_COLLECTION = "sip_collection";
    private static final ExLogger log = ExLogger.getExLogger(SolrUtils.class, "RPS");
    private static Properties solrUsersFile = null;
    private static List<String> zkHost = null;
    private static CloudSolrClient collectionServer = null;
    private static CloudSolrClient sipCollectionServer = null;

    private static synchronized Properties getSolrUsersFile() throws URISyntaxException, IOException {
        if (solrUsersFile == null) {
            solrUsersFile = SolrUtils.loadProperties(SOLR_ADMIN_USERS_PROPERTIES);
        }
        return solrUsersFile;
    }

    public static String getSolrUrl(String idxProtocol, String idxServer, String idxProtocolPort, boolean includeProtocol, String coreInstance) {
        String protocolPrefix = idxProtocol + "://";
        String solrUrl = includeProtocol ? protocolPrefix + idxServer + ":" + idxProtocolPort + "/solr/" + (coreInstance != null ? coreInstance : COLLECTION) + "/" : idxServer + ":" + idxProtocolPort + "/solr/" + (coreInstance != null ? coreInstance : COLLECTION) + "/";
        return solrUrl;
    }

    public static String getLocalhostSolrUrl(boolean includeProtocol, String coreInstance) {
        String idxServer = GlobalProperties.getInstance().getProperty("idx.server");
        String idxProtocol = GlobalProperties.getInstance().getProperty("protocol.idx");
        String idxProtocolPort = SolrUtils.getSolrPort();
        return SolrUtils.getSolrUrl(idxProtocol, idxServer, idxProtocolPort, includeProtocol, coreInstance);
    }

    public static String getSolrUpdateUrl(String coreInstance) {
        String idxServer = GlobalProperties.getInstance().getProperty("idx.server");
        String idxProtocol = GlobalProperties.getInstance().getProperty("protocol.idx");
        String idxProtocolPort = SolrUtils.getSolrPort();
        String commitWithin = SolrUtils.getGeneralParameterManager().getParameter("search", "solr_commit_within");
        return SolrUtils.getSolrUrl(idxProtocol, idxServer, idxProtocolPort, true, coreInstance) + "update?commitWithin=" + commitWithin;
    }

    public static String getShortFieldName(String fieldName) {
        ArrayList<String> fieldKeyParts = new ArrayList<String>(Arrays.asList(fieldName.split("\\.")));
        fieldKeyParts.remove(fieldKeyParts.size() - 1);
        fieldKeyParts.remove(fieldKeyParts.size() - 1);
        return StringUtils.join(fieldKeyParts, (String)".");
    }

    public static String getFullFieldName(String fieldName, PropertiesConfiguration properties) {
        StringBuffer fullFieldName = new StringBuffer(fieldName);
        switch (properties.getType()) {
            case DATE: {
                fullFieldName.append(".date");
                break;
            }
            case TEXT: {
                fullFieldName.append(".text");
                break;
            }
            case STRING: {
                fullFieldName.append(".string");
                break;
            }
            case NUMBER: {
                fullFieldName.append(".number");
                break;
            }
            case BOOLEAN: {
                fullFieldName.append(".boolean");
                break;
            }
            case NORM_STRING: {
                fullFieldName.append(".norm_string");
            }
        }
        if (properties.isRepeatable()) {
            fullFieldName.append(".multiple");
        } else {
            fullFieldName.append(".single");
        }
        return fullFieldName.toString();
    }

    public static String getFullFieldNameForStartsWith(String fieldName, PropertiesConfiguration properties) {
        StringBuffer fullFieldName = new StringBuffer(fieldName);
        fullFieldName.append(".norm_string");
        if (properties.isRepeatable()) {
            fullFieldName.append(".multiple");
        } else {
            fullFieldName.append(".single");
        }
        return fullFieldName.toString();
    }

    public static String getFullFieldNameForEqual(String fieldName, PropertiesConfiguration properties) {
        if (PropertiesConfiguration.UIType.ID_TEXT.equals((Object)properties.getUiType())) {
            StringBuffer fullFieldName = new StringBuffer(fieldName);
            fullFieldName.append(".string");
            if (properties.isRepeatable()) {
                fullFieldName.append(".multiple");
            } else {
                fullFieldName.append(".single");
            }
            return fullFieldName.toString();
        }
        return SolrUtils.getFullFieldName(fieldName, properties);
    }

    public static String getFullFieldNameForSort(String fieldName, PropertiesConfiguration properties) {
        StringBuffer fullFieldName = new StringBuffer(fieldName);
        if (PropertiesConfiguration.MetadataType.DC.equals((Object)properties.getMetadataType()) || PropertiesConfiguration.MetadataType.SIPDC.equals((Object)properties.getMetadataType())) {
            fullFieldName.append(".norm_string.single");
            return fullFieldName.toString();
        }
        if ("IE.internalIdentifier.internalIdentifierType.PID".equals(fieldName) || "REP.internalIdentifier.internalIdentifierType.PID".equals(fieldName) || "FILE.internalIdentifier.internalIdentifierType.PID".equals(fieldName) || "SIP.pid".equals(fieldName)) {
            fullFieldName.append(".number");
            fullFieldName.append(".single");
            return fullFieldName.toString();
        }
        return SolrUtils.getFullFieldName(fieldName, properties);
    }

    public static String getFullFieldName(String fieldName) {
        SolrIndexServices solrIndexServices = (SolrIndexServices)ServiceLocator.getInstance().lookUp(SolrIndexServices.class);
        PropertiesConfiguration propertiesConfiguration = solrIndexServices.getPropertyPerKey(fieldName);
        return SolrUtils.getFullFieldName(fieldName, propertiesConfiguration);
    }

    public static String getFullFieldNameForSort(String fieldName) {
        SolrIndexServices solrIndexServices = (SolrIndexServices)ServiceLocator.getInstance().lookUp(SolrIndexServices.class);
        PropertiesConfiguration propertiesConfiguration = solrIndexServices.getPropertyPerKey(fieldName);
        return SolrUtils.getFullFieldNameForSort(fieldName, propertiesConfiguration);
    }

    public static CloudSolrClient getDefaultCloudSolrServer() throws URISyntaxException, IOException {
        return SolrUtils.getCollectionSolrCloudServer(COLLECTION);
    }

    public static SolrClient getSolrServer(String solrUrl, String solrCore) throws URISyntaxException, IOException {
        if (SolrUtils.isCloudMode().booleanValue()) {
            CloudSolrClient server = solrCore.equals(COLLECTION) ? SolrUtils.getCollectionSolrCloudServer(solrCore) : SolrUtils.getSipCollectionSolrCloudServer(solrCore);
            return server;
        }
        AuthHttpSolrClient server = new AuthHttpSolrClient(solrUrl, SolrUtils.getSolrUsername(), SolrUtils.getSolrPassword());
        return server;
    }

    private static CloudSolrClient getCollectionSolrCloudServer(String solrCore) throws URISyntaxException, IOException {
        if (collectionServer != null) {
            return collectionServer;
        }
        collectionServer = new CloudSolrClient.Builder().withZkHost(SolrUtils.getZKHost()).withHttpClient(SolrUtils.httpClient()).build();
        collectionServer.setDefaultCollection(COLLECTION);
        return collectionServer;
    }

    private static CloudSolrClient getSipCollectionSolrCloudServer(String solrCore) throws URISyntaxException, IOException {
        if (sipCollectionServer != null) {
            return sipCollectionServer;
        }
        sipCollectionServer = new CloudSolrClient.Builder().withZkHost(SolrUtils.getZKHost()).withHttpClient(SolrUtils.httpClient()).build();
        sipCollectionServer.setDefaultCollection(SIP_COLLECTION);
        return sipCollectionServer;
    }

    public static Boolean isCloudMode() {
        return Boolean.valueOf(SolrUtils.getGeneralParameterManager().getParameter("search", "solr_cloud_mode"));
    }

    public static String getSolrPassword() throws URISyntaxException, IOException {
        return SolrUtils.getSolrUsersFile().getProperty(SolrUtils.getSolrUsername()).split(",")[0];
    }

    public static String getSolrUsername() {
        return "slr";
    }

    public static Integer getMaxResults() {
        int maxResults = 100000;
        try {
            maxResults = Integer.valueOf(SolrUtils.getGeneralParameterManager().getParameter("search", "publishing_max_results"));
        }
        catch (Exception e) {
            log.error("Failed to get maxResults from 'publishing_max_results' General Parameter, use default maxResults " + maxResults, e, new String[0]);
        }
        return maxResults;
    }

    public static int getSearchResultLimit() {
        int maxResults = 10000;
        try {
            maxResults = Integer.valueOf(SolrUtils.getGeneralParameterManager().getParameter("search", "max_results"));
        }
        catch (Exception e) {
            log.error("Failed to retrieve 'max_results' general parameter value, use default : " + maxResults, e, new String[0]);
        }
        return maxResults;
    }

    public static String getSolrPort() {
        return SolrUtils.getGeneralParameterManager().getParameter("search", "solr_port");
    }

    private static List<String> getZKHost() {
        if (zkHost == null) {
            ApplicationVersionService applicationVersionService = (ApplicationVersionService)ServiceLocator.getInstance().lookUp(ApplicationVersionService.class);
            zkHost = applicationVersionService.getZKHost();
        }
        return zkHost;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Properties loadProperties(String propFileName) throws URISyntaxException, IOException {
        Properties properties = new Properties();
        InputStream in = SolrUtils.class.getClassLoader().getResourceAsStream(propFileName);
        if (in != null) {
            try {
                properties.load(in);
                log.info("loaded application properties: /" + propFileName);
            }
            catch (IOException e) {
                log.error("Error reading " + propFileName + " file - " + e.getMessage(), new String[0]);
            }
            finally {
                IOUtil.closeQuietly(in);
            }
        } else {
            log.error("Error reading " + propFileName + " file", new String[0]);
        }
        return properties;
    }

    private static GeneralParameterManager getGeneralParameterManager() {
        return (GeneralParameterManager)ServiceLocator.getInstance().lookUp(GeneralParameterManager.class);
    }

    public static HttpClient httpClient() throws URISyntaxException, IOException {
        BasicCredentialsProvider provider = new BasicCredentialsProvider();
        UsernamePasswordCredentials credentials = new UsernamePasswordCredentials(SolrUtils.getSolrUsername(), SolrUtils.getSolrPassword());
        provider.setCredentials(AuthScope.ANY, (Credentials)credentials);
        return HttpClientBuilder.create().setDefaultCredentialsProvider((CredentialsProvider)provider).build();
    }

    public static boolean isRollbackedFromCloudMode() {
        return Boolean.valueOf(SolrUtils.getGeneralParameterManager().getParameter("search", "rollback_from_solr_cloud_mode"));
    }

    public static List<SolrInputDocument> parseXmlToSolrInputDocument(String SolrXMLFile) throws Exception {
        ArrayList<SolrInputDocument> solrInputDocList = new ArrayList<SolrInputDocument>();
        try {
            DocumentBuilder documentBuilder = DocumentBuilderFactory.newInstance().newDocumentBuilder();
            Document document = documentBuilder.parse(new File(SolrXMLFile));
            NodeList docsList = document.getElementsByTagName("doc");
            for (int i = 0; i < docsList.getLength(); ++i) {
                SolrInputDocument solrInputDoc = new SolrInputDocument(new String[0]);
                Node currentNode = docsList.item(i);
                NodeList fieldsList = currentNode.getChildNodes();
                for (int j = 0; j < fieldsList.getLength(); ++j) {
                    Node fieldNode = fieldsList.item(j);
                    if (!fieldNode.getNodeName().equalsIgnoreCase("field")) continue;
                    String fieldName = fieldNode.getAttributes().item(0).getNodeValue();
                    String fieldValue = fieldNode.getTextContent();
                    solrInputDoc.addField(fieldName, (Object)fieldValue);
                }
                solrInputDocList.add(solrInputDoc);
            }
        }
        catch (ParserConfigurationException | SAXException e) {
            log.error("Failed parsing Solr xml content.", new String[0]);
            throw e;
        }
        return solrInputDocList;
    }

    static class PreemptiveAuthInterceptor
    implements HttpRequestInterceptor {
        PreemptiveAuthInterceptor() {
        }

        public void process(HttpRequest request, HttpContext context) throws HttpException, IOException {
            AuthState authState = (AuthState)context.getAttribute("http.auth.target-scope");
            if (authState.getAuthScheme() == null) {
                HttpHost targetHost;
                CredentialsProvider credsProvider = (CredentialsProvider)context.getAttribute("http.auth.credentials-provider");
                Credentials creds = credsProvider.getCredentials(new AuthScope((targetHost = (HttpHost)context.getAttribute("http.target_host")).getHostName(), targetHost.getPort()));
                if (creds == null) {
                    throw new HttpException("No credentials for preemptive authentication");
                }
                authState.setAuthScheme((AuthScheme)new BasicScheme());
                authState.setCredentials(creds);
            }
        }
    }
}

