/*
 * Decompiled with CFR 0.152.
 */
package com.exlibris.core.infra.svc.api.quartz;

import com.exlibris.core.infra.common.cache.SessionUtils;
import com.exlibris.core.infra.common.email.EMailUtil;
import com.exlibris.core.infra.common.exceptions.logging.ExLogger;
import com.exlibris.core.infra.common.fsutils.InfraFSUtil;
import com.exlibris.core.infra.common.util.ResourceBundleUtil;
import com.exlibris.core.infra.model.logs.LogTable;
import com.exlibris.core.infra.model.quartz.JobDetails;
import com.exlibris.core.infra.model.quartz.QuartzJobConfig;
import com.exlibris.core.infra.svc.api.CodeTablesResourceBundle;
import com.exlibris.core.infra.svc.api.ConsortiumManager;
import com.exlibris.core.infra.svc.api.FileTableManager;
import com.exlibris.core.infra.svc.api.GeneralParameterManager;
import com.exlibris.core.infra.svc.api.common.DBLogger;
import com.exlibris.core.infra.svc.api.common.DateHandler;
import com.exlibris.core.infra.svc.api.email.EmailData;
import com.exlibris.core.infra.svc.api.locator.ServiceLocator;
import com.exlibris.core.infra.svc.api.logs.LogTableService;
import com.exlibris.core.infra.svc.api.quartz.InfraQuartzJobsService;
import com.exlibris.core.infra.svc.api.xml.XmlUtil;
import com.exlibris.digitool.common.forms.xmlbeans.XFields;
import com.exlibris.digitool.common.forms.xmlbeans.XFormDocument;
import com.exlibris.digitool.common.forms.xmlbeans.XUiType;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.StandardCharsets;
import java.sql.SQLException;
import java.text.MessageFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.ResourceBundle;
import java.util.concurrent.TimeUnit;
import javax.activation.DataSource;
import javax.mail.util.ByteArrayDataSource;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.xmlbeans.XmlException;
import org.quartz.DisallowConcurrentExecution;
import org.quartz.Job;
import org.quartz.JobExecutionContext;
import org.quartz.JobExecutionException;
import org.quartz.PersistJobDataAfterExecution;
import org.quartz.Trigger;

@PersistJobDataAfterExecution
@DisallowConcurrentExecution
public abstract class InfraStatefulJob
implements Job {
    public static final String QUARTZ_DB_LOGGER_GROUP = "quartz_jobs_logs";
    private ExLogger exLogger = ExLogger.getExLogger(this.getClass(), "JB");
    private DBLogger dbLogger = null;
    private boolean useDbLogger = false;
    private Map<LogTable.LogStatus, Boolean> updateJobLastRunDate = new HashMap<LogTable.LogStatus, Boolean>();

    public abstract void executeInternal(JobExecutionContext var1) throws JobExecutionException, SQLException;

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public final void execute(JobExecutionContext context) throws JobExecutionException {
        LogTable.LogStatus logStatus;
        Calendar startTime = Calendar.getInstance();
        Long quartzJobConfigId = null;
        if (context != null) {
            quartzJobConfigId = (Long)context.getJobDetail().getJobDataMap().get((Object)"job_id");
        }
        if (quartzJobConfigId == null) {
            this.exLogger.info("Notice: This job is not scheduled from the " + InfraQuartzJobsService.class.getSimpleName() + ", and therefore not associated to " + QuartzJobConfig.class.getSimpleName() + " entity.");
        } else {
            this.dbLogger = new DBLogger(QUARTZ_DB_LOGGER_GROUP, String.valueOf(quartzJobConfigId), startTime);
        }
        try {
            this.initUpdateJobLastRunDate();
            this.executeInternal(context);
            if (quartzJobConfigId == null) return;
            logStatus = this.dbLogger.getStatusFlag();
        }
        catch (Exception e) {
            try {
                this.exLogger.error("Error occurred while execute job." + (StringUtils.isNotBlank((String)e.getMessage()) ? "\n  Error: " + e.getMessage() : ""), e, new String[0]);
                if (e instanceof JobExecutionException) throw (JobExecutionException)e;
                throw new JobExecutionException((Throwable)e);
            }
            catch (Throwable throwable) {
                if (quartzJobConfigId == null) throw throwable;
                LogTable.LogStatus logStatus2 = this.dbLogger.getStatusFlag();
                try {
                    if (this.updateJobLastRunDate.get((Object)logStatus2).booleanValue()) {
                        InfraQuartzJobsService infraQuartzJobsService = (InfraQuartzJobsService)ServiceLocator.getInstance().lookUp(InfraQuartzJobsService.class);
                        infraQuartzJobsService.updateJobLastRunDate(quartzJobConfigId, startTime.getTime());
                    }
                    if (!this.useDbLogger) throw throwable;
                    String msg = "Job completed " + (logStatus2 == LogTable.LogStatus.RUNNING ? "Successfully" : (logStatus2 == LogTable.LogStatus.WARN ? "with Warnings" : (logStatus2 == LogTable.LogStatus.ERROR ? "with Errors" : logStatus2.name())));
                    this.dbLogger.info(msg);
                    if (logStatus2 == LogTable.LogStatus.RUNNING) {
                        this.dbLogger.setLogStatus(LogTable.LogStatus.SUCCESS);
                    } else {
                        this.dbLogger.setLogStatus(this.dbLogger.getStatusFlag());
                    }
                    this.dbLogger.save();
                    try {
                        if (logStatus2 == LogTable.LogStatus.NO_WORK) throw throwable;
                        this.sendEmail(context);
                        throw throwable;
                    }
                    catch (Exception e2) {
                        this.exLogger.error("Failed to send email for Job " + quartzJobConfigId, e2, new String[0]);
                        throw throwable;
                    }
                }
                catch (Exception e3) {
                    this.exLogger.error("Failed to update log status for job " + quartzJobConfigId, e3, new String[0]);
                }
                throw throwable;
            }
        }
        try {
            if (this.updateJobLastRunDate.get((Object)logStatus).booleanValue()) {
                InfraQuartzJobsService infraQuartzJobsService = (InfraQuartzJobsService)ServiceLocator.getInstance().lookUp(InfraQuartzJobsService.class);
                infraQuartzJobsService.updateJobLastRunDate(quartzJobConfigId, startTime.getTime());
            }
            if (!this.useDbLogger) return;
            String msg = "Job completed " + (logStatus == LogTable.LogStatus.RUNNING ? "Successfully" : (logStatus == LogTable.LogStatus.WARN ? "with Warnings" : (logStatus == LogTable.LogStatus.ERROR ? "with Errors" : logStatus.name())));
            this.dbLogger.info(msg);
            if (logStatus == LogTable.LogStatus.RUNNING) {
                this.dbLogger.setLogStatus(LogTable.LogStatus.SUCCESS);
            } else {
                this.dbLogger.setLogStatus(this.dbLogger.getStatusFlag());
            }
            this.dbLogger.save();
            try {
                if (logStatus == LogTable.LogStatus.NO_WORK) return;
                this.sendEmail(context);
                return;
            }
            catch (Exception e) {
                this.exLogger.error("Failed to send email for Job " + quartzJobConfigId, e, new String[0]);
                return;
            }
        }
        catch (Exception e) {
            this.exLogger.error("Failed to update log status for job " + quartzJobConfigId, e, new String[0]);
            return;
        }
    }

    protected void setDbLoggerOn() {
        if (this.dbLogger == null) {
            this.exLogger.error("Try to set DbLoggerOn for job but dbLogger is null.", new String[0]);
        } else {
            this.useDbLogger = true;
        }
    }

    protected void setDbLoggerOff() {
        this.useDbLogger = false;
    }

    protected void writeLogInfo(String message) {
        this.exLogger.info(message);
        if (this.useDbLogger) {
            this.dbLogger.info(message);
        }
    }

    protected void writeLogWarning(String message) {
        this.exLogger.warn((Object)message, new String[0]);
        if (this.useDbLogger) {
            this.dbLogger.warn(message);
        }
    }

    protected void writeLogError(String message) {
        this.exLogger.error(message, new String[0]);
        if (this.useDbLogger) {
            this.dbLogger.error(message);
        }
    }

    protected void writeLogError(String message, Throwable e) {
        this.exLogger.error(message, e, new String[0]);
        if (this.useDbLogger) {
            this.dbLogger.error(message);
        }
    }

    protected void writeLogDebug(String message) {
        this.exLogger.debug((Object)message, new String[0]);
    }

    protected void writeLogNoWork() {
        if (this.useDbLogger) {
            this.dbLogger.noWork();
        }
    }

    protected void disableJobLastRunDate(LogTable.LogStatus ... logStatuses) {
        for (LogTable.LogStatus logStatus : logStatuses) {
            this.updateJobLastRunDate.put(logStatus, false);
        }
    }

    protected void writeToServerLogError(String messageLog, Exception e) {
        this.exLogger.error(messageLog, e, new String[0]);
    }

    private void initUpdateJobLastRunDate() {
        for (LogTable.LogStatus logStatus : LogTable.LogStatus.values()) {
            this.updateJobLastRunDate.put(logStatus, true);
        }
    }

    protected void markDirectory(File subDirectory, DirectoryStatus status) throws IOException {
        String directoryPath = subDirectory.getPath();
        File doneFile = new File(FilenameUtils.concat((String)directoryPath, (String)DirectoryStatus.DONE.name()));
        File errorFile = new File(FilenameUtils.concat((String)directoryPath, (String)DirectoryStatus.ERROR.name()));
        File lockFile = new File(FilenameUtils.concat((String)directoryPath, (String)DirectoryStatus.LOCKED.name()));
        errorFile.delete();
        lockFile.delete();
        doneFile.delete();
        switch (status) {
            case DONE: {
                doneFile.createNewFile();
                break;
            }
            case LOCKED: {
                lockFile.createNewFile();
                break;
            }
            case ERROR: {
                errorFile.createNewFile();
            }
        }
    }

    protected boolean isReady(File directory) {
        if (!directory.isDirectory()) {
            return false;
        }
        for (DirectoryStatus status : DirectoryStatus.values()) {
            File checkFile = new File(FilenameUtils.concat((String)directory.getPath(), (String)status.name()));
            if (!checkFile.exists()) continue;
            String message = "'" + directory.getName() + "' is marked as " + StringUtils.capitalize((String)status.name().toLowerCase());
            if (DirectoryStatus.ERROR.equals((Object)status)) {
                this.writeLogError(message);
            } else {
                this.writeLogInfo(message);
            }
            return false;
        }
        return true;
    }

    protected String getJobId() {
        return this.dbLogger.getSource();
    }

    protected void saveJobDetails(JobDetails jd) {
        this.dbLogger.saveJobDetails(jd);
    }

    private boolean sendEmail(JobExecutionContext context) throws Exception {
        Long quartzJobConfigId = null;
        if (context != null) {
            quartzJobConfigId = (Long)context.getJobDetail().getJobDataMap().get((Object)"job_id");
        }
        InfraQuartzJobsService infraQuartzJobsService = (InfraQuartzJobsService)ServiceLocator.getInstance().lookUp(InfraQuartzJobsService.class);
        final QuartzJobConfig job = infraQuartzJobsService.getJob(quartzJobConfigId);
        LogTable.LogStatus logStatus = this.dbLogger.getStatusFlag();
        QuartzJobConfig.EmailLevel emailLevel = job.getEmailLevel() != null ? job.getEmailLevel() : QuartzJobConfig.EmailLevel.NEVER;
        switch (emailLevel) {
            case NEVER: {
                return false;
            }
            case ON_FAILED: {
                if (!LogTable.LogStatus.ERROR.equals((Object)logStatus)) {
                    return false;
                }
            }
            case ALWAYS: {
                Trigger.TriggerState state;
                Locale locale = new Locale(SessionUtils.getSessionLanguage());
                final ResourceBundle resourceBundle = CodeTablesResourceBundle.getDefaultBundle(locale);
                HashMap<String, String> ParamsJobFields = null;
                if (job.getParamsXml() != null) {
                    Map<String, String> tmpParamsXmlMap = InfraStatefulJob.getParamsLabelAndValue(job.getParamsXml());
                    ParamsJobFields = new HashMap<String, String>();
                    for (Map.Entry<String, String> entry : tmpParamsXmlMap.entrySet()) {
                        ParamsJobFields.put(ResourceBundleUtil.getString(resourceBundle, entry.getKey()).replace(' ', '-').replace(":", ""), entry.getValue());
                    }
                }
                final String stateDesc = Trigger.TriggerState.NORMAL.equals((Object)(state = InfraStatefulJob.getJobsService().getJobTriggerState(job))) ? ResourceBundleUtil.getString(resourceBundle, "ui.quartz.jobs.state.normal") : (Trigger.TriggerState.PAUSED.equals((Object)state) ? ResourceBundleUtil.getString(resourceBundle, "ui.quartz.jobs.state.pause") : (Trigger.TriggerState.COMPLETE.equals((Object)state) ? ResourceBundleUtil.getString(resourceBundle, "ui.quartz.jobs.state.complete") : (Trigger.TriggerState.ERROR.equals((Object)state) ? ResourceBundleUtil.getString(resourceBundle, "ui.quartz.jobs.state.error") : (Trigger.TriggerState.BLOCKED.equals((Object)state) ? ResourceBundleUtil.getString(resourceBundle, "ui.quartz.jobs.state.blocked") : (Trigger.TriggerState.NONE.equals((Object)state) ? ResourceBundleUtil.getString(resourceBundle, "ui.quartz.jobs.state.notRunning") : String.valueOf(state))))));
                HashMap<String, String> emailGeneralInfo = new HashMap<String, String>(){
                    private static final long serialVersionUID = 1L;
                    {
                        this.put("language", SessionUtils.getSessionLanguage());
                        this.put("css", InfraFSUtil.getSystemDir() + "/thirdparty/tomcat/rosetta-webapps/dps-backoffice-web.war/" + "css/email.css");
                    }
                };
                LogTableService logTableService = (LogTableService)ServiceLocator.getInstance().lookUp(LogTableService.class);
                List<LogTable> logs = logTableService.findLog(QUARTZ_DB_LOGGER_GROUP, String.valueOf(job.getId()), null, 0, 0, "desc");
                final LogTable log = logs.isEmpty() ? null : logs.get(0);
                LinkedHashMap<String, String> logFields = null;
                if (log != null) {
                    LogTable.LogStatus status = log.getLogStatus();
                    final String statusDesc = status == LogTable.LogStatus.SUCCESS ? ResourceBundleUtil.getString(resourceBundle, "ui.quartz.jobs.status.success") : (status == LogTable.LogStatus.ABORTED ? ResourceBundleUtil.getString(resourceBundle, "ui.quartz.jobs.status.aborted") : (status == LogTable.LogStatus.RUNNING ? ResourceBundleUtil.getString(resourceBundle, "ui.quartz.jobs.status.running") : (status == LogTable.LogStatus.WARN ? ResourceBundleUtil.getString(resourceBundle, "ui.quartz.jobs.status.completeWithWarnings") : (status == LogTable.LogStatus.ERROR ? ResourceBundleUtil.getString(resourceBundle, "ui.quartz.jobs.status.error") : status.name()))));
                    Long duration = log.getDuration();
                    final String durationAsString = String.format("%d min, %d sec", TimeUnit.MILLISECONDS.toMinutes(duration), TimeUnit.MILLISECONDS.toSeconds(duration) - TimeUnit.MINUTES.toSeconds(TimeUnit.MILLISECONDS.toMinutes(duration)));
                    logFields = new LinkedHashMap<String, String>(){
                        private static final long serialVersionUID = 1L;
                        {
                            this.put(ResourceBundleUtil.getString(resourceBundle, "ui.quartz.jobs.status"), statusDesc);
                            this.put(ResourceBundleUtil.getString(resourceBundle, "ui.quartz.jobs.startTime").replace(' ', '-'), DateHandler.getStringFormatFromCalendar(log.getStartTime()));
                            this.put(ResourceBundleUtil.getString(resourceBundle, "ui.quartz.jobs.duration"), durationAsString);
                        }
                    };
                }
                LinkedHashMap<String, String> generalJobFields = new LinkedHashMap<String, String>(){
                    private static final long serialVersionUID = 1L;
                    {
                        this.put(ResourceBundleUtil.getString(resourceBundle, "ui.quartz.jobs.name"), job.getJobName());
                        this.put(ResourceBundleUtil.getString(resourceBundle, "ui.quartz.jobs.state"), stateDesc);
                        this.put(ResourceBundleUtil.getString(resourceBundle, "ui.quartz.jobs.cronExpression"), InfraStatefulJob.getJobsService().getJobTrigger(job).getDescription() != null ? InfraStatefulJob.getJobsService().getJobTrigger(job).getDescription() : "-");
                        this.put(ResourceBundleUtil.getString(resourceBundle, "ui.quartz.jobs.startDate").replace(' ', '-'), DateHandler.getStringFormatFromCalendar(log.getStartTime()));
                        this.put(ResourceBundleUtil.getString(resourceBundle, "ui.quartz.jobs.endDate").replace(' ', '-'), job.getEndDate() != null ? DateHandler.formatDateAndTime(job.getEndDate()) : "-");
                        this.put(ResourceBundleUtil.getString(resourceBundle, "ui.quartz.jobs.previousFireTime").replace(' ', '-'), DateHandler.formatTime(job.getLastRunDate()));
                        this.put(ResourceBundleUtil.getString(resourceBundle, "ui.quartz.jobs.nextFireTime").replace(' ', '-'), DateHandler.formatTime(InfraStatefulJob.getJobsService().getJobTrigger(job).getNextFireTime()));
                    }
                };
                EmailData emailData2 = new EmailData();
                String dataContent = emailData2.asXmlContent("General-Info", (Map<String, String>)emailGeneralInfo) + emailData2.asXmlContent("job-fields", (Map<String, String>)generalJobFields) + emailData2.asXmlContent("log-fields", logFields);
                if (ParamsJobFields != null) {
                    dataContent = dataContent + emailData2.asXmlContent("job-params", ParamsJobFields);
                }
                String xmlContent = "<?xml version=\"1.0\" encoding=\"UTF-8\"?>" + emailData2.asXml(dataContent);
                String xslFullFileName = null;
                String owner = "CRS00";
                String key = "com.exlibris.dps.repository.email.emailToUserJobComplete";
                FileTableManager fileTableManager = (FileTableManager)ServiceLocator.getInstance().lookUp(FileTableManager.class);
                xslFullFileName = fileTableManager.getFileByKeyAsString(key, owner);
                String content = XmlUtil.runXSL(xmlContent, xslFullFileName);
                if (content == null) {
                    content = xmlContent;
                }
                EMailUtil emailUtil = EMailUtil.getInstance();
                boolean emailSent = false;
                ConsortiumManager consortiumManager = (ConsortiumManager)ServiceLocator.getInstance().lookUp(ConsortiumManager.class);
                String customizationId = consortiumManager.getUiCustomizationId(owner);
                String imagePath = InfraFSUtil.getSystemDir() + "/thirdparty/tomcat/rosetta-webapps/dps-backoffice-web.war/" + "images/" + customizationId + "/logo-main.png";
                File imgFile = new File(imagePath);
                FileInputStream logoImgStream = new FileInputStream(imgFile);
                List<DataSource> extraAttachments = this.getExtraAttachments();
                DataSource[] attachments = new DataSource[extraAttachments.size() + 2];
                ByteArrayDataSource image = new ByteArrayDataSource((InputStream)logoImgStream, "image/png");
                image.setName("logo.jpg");
                attachments[0] = image;
                String logContent = log != null ? log.getContent() : "log was not created for this run";
                ByteArrayInputStream logStream = new ByteArrayInputStream(logContent.getBytes(StandardCharsets.UTF_8.name()));
                ByteArrayDataSource logFile = new ByteArrayDataSource((InputStream)logStream, "text/html");
                SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd HH-mm-ss");
                logFile.setName(job.getJobName() + " " + dateFormat.format(log.getStartTime().getTime()) + " - log.txt");
                attachments[1] = logFile;
                int count = 2;
                for (DataSource attachment : extraAttachments) {
                    attachments[count++] = attachment;
                }
                String subject = ResourceBundleUtil.getString(resourceBundle, "email.jobReport");
                subject = MessageFormat.format(subject, job.getJobName());
                emailSent = emailUtil.sendEmail(this.getAddressFrom("backoffice"), job.getEmailAddress(), subject, content, attachments);
                break;
            }
        }
        return true;
    }

    private String getAddressFrom(String module) {
        GeneralParameterManager gpm = (GeneralParameterManager)ServiceLocator.getInstance().lookUp(GeneralParameterManager.class);
        String addressFrom = "Management Department <do-not-reply@exlibris.co.il>";
        String name = "email_sender";
        try {
            addressFrom = gpm.getParameter(module, name);
        }
        catch (Exception e) {
            this.exLogger.warn((Object)(name + " general parameter not found in " + module + "module, using the default: " + addressFrom), new String[0]);
        }
        return addressFrom;
    }

    static InfraQuartzJobsService getJobsService() {
        return (InfraQuartzJobsService)ServiceLocator.getInstance().lookUp(InfraQuartzJobsService.class);
    }

    public static Map<String, String> getParamsLabelAndValue(String paramsXml) throws XmlException {
        XFormDocument xformDocument = null;
        xformDocument = XFormDocument.Factory.parse(paramsXml);
        XFields xFields = xformDocument.getXForm().getXFields();
        LinkedHashMap<String, String> map = new LinkedHashMap<String, String>();
        if (xformDocument.getXForm() != null && xFields != null && xFields.getXFieldArray() != null) {
            XFields.XField[] xfieldArr;
            for (XFields.XField xfield : xfieldArr = xFields.getXFieldArray()) {
                boolean fieldHasNoValue;
                if (xfield.getLabel() == null || ((Object)((Object)XUiType.HIDDEN)).equals((Object)xfield.getXUiType()) || ((Object)((Object)XUiType.PASSWORD)).equals((Object)xfield.getXUiType()) || ((Object)((Object)XUiType.INTERNAL_USE)).equals((Object)xfield.getXUiType()) || xfield.isSetVisible()) continue;
                boolean bl = fieldHasNoValue = xfield.getDefaultValue() == null || xfield.getDefaultValue().isEmpty();
                if (((Object)((Object)XUiType.CHECKBOX)).equals((Object)xfield.getXUiType()) && xfield.getDefaultValue() == null) {
                    map.put(StringUtils.isEmpty((String)xfield.getLabel()) ? xfield.getUiToolTip() : xfield.getLabel(), "false");
                    continue;
                }
                map.put(StringUtils.isEmpty((String)xfield.getLabel()) ? xfield.getUiToolTip() : xfield.getLabel(), fieldHasNoValue ? "-" : xfield.getDefaultValue());
            }
        }
        return map;
    }

    public static String getStateDescription(Trigger.TriggerState state) {
        String stateDescription = Trigger.TriggerState.NORMAL.equals((Object)state) ? "Normal" : (Trigger.TriggerState.PAUSED.equals((Object)state) ? "Pause" : (Trigger.TriggerState.COMPLETE.equals((Object)state) ? "Complete" : (Trigger.TriggerState.ERROR.equals((Object)state) ? "Error" : (Trigger.TriggerState.BLOCKED.equals((Object)state) ? "Blocked" : (Trigger.TriggerState.NONE.equals((Object)state) ? "Not Running" : String.valueOf(state))))));
        return stateDescription;
    }

    protected List<DataSource> getExtraAttachments() throws Exception {
        return new ArrayList<DataSource>();
    }

    public static enum DirectoryStatus {
        DONE,
        LOCKED,
        ERROR;

    }
}

