/*
 * Decompiled with CFR 0.152.
 */
package com.exlibris.core.infra.svc.api.services;

import com.exlibris.core.infra.common.exceptions.logging.ExLogger;
import java.util.concurrent.ConcurrentHashMap;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBException;

public class JAXBContextService {
    private static ExLogger logger = ExLogger.getExLogger(JAXBContextService.class);
    private static ConcurrentHashMap<Class, JAXBContext> contextMap = new ConcurrentHashMap(100, 0.75f, 100);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static JAXBContext getJAXBContext(Class classToBeBound) throws JAXBException {
        JAXBContext jaxbContext = contextMap.get(classToBeBound);
        if (jaxbContext == null) {
            Class clazz = classToBeBound;
            synchronized (clazz) {
                jaxbContext = contextMap.get(classToBeBound);
                if (jaxbContext == null) {
                    logger.info("Generating new JAXBContext instance for: " + classToBeBound.getName());
                    jaxbContext = JAXBContext.newInstance((Class[])new Class[]{classToBeBound});
                    contextMap.put(classToBeBound, jaxbContext);
                }
            }
        }
        return jaxbContext;
    }
}

