/*
 * Decompiled with CFR 0.152.
 */
package com.exlibris.core.sdk.formatting;

import com.exlibris.core.sdk.formatting.DublinCore;
import com.exlibris.core.sdk.formatting.DublinCoreFactory;
import org.dom4j.Document;
import org.dom4j.DocumentFactory;
import org.dom4j.Element;

public class FormattedDocument {
    private Document xmlDoc = null;
    private DublinCore dcDoc = null;
    private int docType = 1;
    public static final int DOCUMENT_TYPE_DC = 2;
    public static final int DOCUMENT_TYPE_XML = 1;
    public static final String MAIN_TAG = "record";
    public static final String MAIN_CLOSING_TAG_STR = "</record>";
    public static final String NEW_LINE = "\n";

    public boolean isEmpty() {
        if (this.docType == 1) {
            return this.xmlDoc == null || this.xmlDoc.getRootElement() == null || this.xmlDoc.getRootElement().nodeCount() == 0;
        }
        return this.dcDoc == null;
    }

    public FormattedDocument(String mainTag) {
        this.docType = 1;
        this.init(mainTag);
    }

    public FormattedDocument(int docType) {
        this.docType = docType == 2 || docType == 1 ? docType : 1;
        this.init(MAIN_TAG);
    }

    private void init(String mainTag) {
        this.xmlDoc = DocumentFactory.getInstance().createDocument();
        switch (this.docType) {
            case 2: {
                this.dcDoc = DublinCoreFactory.getInstance().createDocument();
                break;
            }
            case 1: {
                Element rootElement = DocumentFactory.getInstance().createElement(mainTag);
                this.xmlDoc.setRootElement(rootElement);
            }
        }
    }

    public void createElement(Element element) {
        switch (this.docType) {
            case 1: {
                if (this.xmlDoc == null) {
                    return;
                }
                this.xmlDoc.getRootElement().add(element);
                break;
            }
        }
    }

    public void createElement(String name, String value) {
        if (this.docType == 1 && (this.xmlDoc == null || this.xmlDoc.getRootElement() == null)) {
            return;
        }
        if (this.docType == 2 && this.dcDoc == null) {
            return;
        }
        if (name == null || name.equals("")) {
            return;
        }
        if (value == null || value.equals("")) {
            return;
        }
        if (this.docType == 1) {
            Element element = DocumentFactory.getInstance().createElement(name);
            element.setText(value);
            this.xmlDoc.getRootElement().add(element);
        } else {
            this.dcDoc.addElement(name, value);
        }
    }

    public Document getDocument() {
        switch (this.docType) {
            case 2: {
                if (this.dcDoc == null) {
                    return null;
                }
                return this.dcDoc.getDocument();
            }
        }
        return this.xmlDoc;
    }

    public String getFormattedDocument() {
        if (this.docType == 1) {
            if (this.xmlDoc == null || this.xmlDoc.getRootElement() == null) {
                return "";
            }
            return this.xmlDoc.getRootElement().asXML();
        }
        if (this.dcDoc == null || this.dcDoc.getDocument() == null || this.dcDoc.getDocument().getRootElement() == null) {
            return "";
        }
        return this.dcDoc.getDocument().getRootElement().asXML();
    }
}

