/*
 * Decompiled with CFR 0.152.
 */
package com.exlibris.core.sdk.storage.handler;

import com.exlibris.core.infra.svc.api.GeneralParameterManager;
import com.exlibris.core.infra.svc.api.locator.ServiceLocator;
import com.exlibris.core.infra.svc.api.queue.QueueConstants;
import com.exlibris.core.infra.svc.api.queue.WorkQueue;
import com.exlibris.core.infra.svc.api.queue.WorkQueueFactory;
import com.exlibris.core.sdk.utils.FileUtil;
import java.io.File;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.lang.StringUtils;

public class StorageUtil {
    public static final String DEST_PATH_FOLDER = "destPath";
    private static final String SEPERATOR = ";";
    private static final String TMP_FOLDER = "tmp";
    private static final String STORAGE_FOLDER = "storage";
    private static Map<String, Map<String, String>> filePathsLocationPerIePids = new ConcurrentHashMap<String, Map<String, String>>(16, 0.9f, 1);

    public static boolean saveDestPathToTmpFile(String iePid, String path, String filePid, String destPath) {
        Map<String, String> curMap = filePathsLocationPerIePids.get(iePid);
        if (curMap == null) {
            curMap = new HashMap<String, String>();
        }
        curMap.put(filePid, destPath);
        filePathsLocationPerIePids.put(iePid, curMap);
        return FileUtil.appendStringToFile(path + File.separator + iePid, filePid + SEPERATOR + destPath + "\n");
    }

    public static String readDestPathFromTmpFile(String iePid, String path, String filePid) {
        Map<String, String> curMap = filePathsLocationPerIePids.get(iePid);
        if (curMap == null) {
            curMap = FileUtil.getFileContentAsMap(path + File.separator + iePid, SEPERATOR);
        }
        if (curMap == null) {
            return null;
        }
        filePathsLocationPerIePids.put(iePid, curMap);
        return curMap.get(filePid);
    }

    public static void deleteTmpFile(String iePid, List<String> pids, String ... paths) throws Exception {
        if (paths == null) {
            return;
        }
        HashMap<String, String> pathsMap = new HashMap<String, String>();
        String KEY = "PATH";
        for (int i = 0; i < paths.length; ++i) {
            pathsMap.put("PATH" + i, paths[i]);
        }
        StorageUtil.deleteTmpFile(iePid, pids, pathsMap);
    }

    private static void deleteTmpFile(String iePid, List<String> pids, Map<String, String> paths) throws Exception {
        if (paths == null) {
            return;
        }
        WorkQueueFactory workQueueFactory = WorkQueueFactory.getWorkQueueFactory(LinkedHashMap.class);
        WorkQueue workQueue = workQueueFactory.getWorkQueue("GENERIC_REP_Q");
        LinkedHashMap<String, String> params = new LinkedHashMap<String, String>();
        params.put("SPECIFIC_OPERATION", QueueConstants.GenericRepositoryOperations.DELETE_FILE.toString());
        params.put("PATHS_KEYS", StringUtils.join(paths.keySet(), (String)SEPERATOR));
        for (String key : paths.keySet()) {
            if (paths.get(key).contains("/operational_export_directory/")) {
                for (String pid : pids) {
                    params.put(key + pid, FilenameUtils.concat((String)paths.get(key), (String)pid));
                    params.put("PATHS_KEYS", (String)params.get("PATHS_KEYS") + SEPERATOR + key + pid);
                }
                continue;
            }
            params.put(key, FilenameUtils.concat((String)paths.get(key), (String)iePid));
        }
        workQueue.enqueue(params, "IE_ID", iePid, QueueConstants.MessagePriority.HIGH.getDefaultValue(), QueueConstants.messageType.QUEUE);
        StorageUtil.removeEntryFromFilePathsMap(iePid);
    }

    public static void removeEntryFromFilePathsMap(String iePid) {
        filePathsLocationPerIePids.remove(iePid);
    }

    public static String getTempStorageDirectory() {
        GeneralParameterManager generalParameterManager = (GeneralParameterManager)ServiceLocator.getInstance().lookUp(GeneralParameterManager.class);
        String operationalShared = generalParameterManager.getParameter("general", "operational_shared");
        return operationalShared + File.separator + TMP_FOLDER + File.separator + STORAGE_FOLDER + File.separator;
    }
}

