/*
 * Decompiled with CFR 0.152.
 */
package com.exlibris.core.sdk.utils;

import com.exlibris.core.infra.common.exceptions.logging.DescriptorConstants;
import com.exlibris.core.infra.common.exceptions.logging.ExLogger;
import com.exlibris.core.infra.svc.api.config.InfraConfigurationManager;
import com.exlibris.core.sdk.utils.FSDepositAreaUtil;
import com.exlibris.core.sdk.utils.FileUtil;
import java.io.File;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.nio.channels.FileChannel;
import java.nio.channels.FileLock;
import java.nio.channels.OverlappingFileLockException;
import java.util.ArrayList;
import java.util.List;

public class FSDirUtil {
    public static final String SEPARATOR = File.separator;
    public static final String XML_EXT = ".xml";
    private static final String DIGITOOL_HOME = "digitool.home";
    public static final String SYSTEM = "system.dir";
    private static final String PROFILE = "../profile";
    private static final String WORK = "work/";
    private static final String COLLECTION = "collection/";
    private static final String CONF = "conf/";
    private static final String TEMPLATES = "templates/";
    private static final String METADATA = "metadata/";
    private static final String COPYRIGHTS = "copyrights/";
    private static final String DES_DESCRIPTORS_DIR = "services/des_descriptors";
    private static final String DES_PARAMS_DIR = "services/des_params";
    private static final String UNITS = "units/";
    private static final String STORAGE = "storage/";
    public static final int STORAGE_FOLDER_ID = 100;
    private static final String JMAGICK_WORK = "jmagick/";
    public static final int JMAGICK_FOLDER_ID = 200;
    private static final String XSLT_WORK = "xslt_viewer_tmp/";
    public static final int XSLT_WORK_FOLDER_ID = 300;
    private static final String METS_WORK_DIR = "mets_viewer_tmp/";
    private static final String METS_TEMP_DIR = "mets_viewer_tmp/temp/";
    private static final String DEPLOY_DIR = "/thirdparty/openserver/server/default/deploy/";
    private static final String REPORTS = "reports/";
    private static final String EXPORT = "export/";
    private static final String DE_SERVICE_TMP_DIR = "de_service_tmp/";
    private static final String SOURCE_CONTROL_DIR = "CVS";
    private static final String LICENSE_PATH = "/license";
    private static final String LICENSE_ROOT = "u3_";
    private static final String LICENSE_ROOT_ALT = "d3_";
    private static final String DIGITOOL_ANCHOR = "j3_";
    private static final String PRODUCT = "/product/bin/";
    private static final String REPLICATIONS = "replications/";
    private static final String REPLICATIONS_LOGS = "logs/";
    private static final String REPLICATIONS_TIMESTAMPS = "timestamps/";
    private static final String REPLICATIONS_RECOVERY = "recovery/";
    private static final String REPLICATIONS_CONF = "conf/";
    private static final String SYNCHRONISATION = "synchronisations/";
    private static final String SYNCHRONISATION_LOGS = "logs/";
    private static final String SYNCHRONISATION_TIMESTAMPS = "timestamps/";
    private static final String SYNCHRONISATION_CONF = "conf/";
    private static final String SYNCHRONISATION_FILES = "files/";
    private static final String SYNCHRONISATION_RUN = "run/";
    private static final String FILE_SEPARATOR = System.getProperty("file.separator");
    private static final String JHOVE_CONF_FILE = "/thirdparty/jhove/conf/jhove.conf";
    private static String m_digitoolHome = null;
    private static String m_workHome = null;
    private static String m_metsWorkDir = null;
    private static String m_deServiceWorkDir = null;
    private static String m_metsTempWorkDir = null;
    private static String m_systemHome = null;
    private static String m_profileHome = null;
    private static String m_profileExtention = null;
    private static String m_collectionHome = null;
    private static String m_copyrightsHome = null;
    private static String m_confHome = null;
    private static String reportsDir = null;
    private static String exportDir = null;
    private static String m_deployDir = null;
    private static String m_des_desc = null;
    private static String replicationsDir = null;
    private static String replicationsLogsDir = null;
    private static String replicationsTimestampsDir = null;
    private static String replicationsRecoveryDir = null;
    private static String replicationsConfDir = null;
    private static String synchronisationsDir = null;
    private static String synchronisationsLogsDir = null;
    private static String synchronisationsTimestampsDir = null;
    private static String synchronisationsConfDir = null;
    private static String synchronisationsFilesDir = null;
    private static String synchronisationsRunDir = null;
    private static String templatesDir = null;
    private static String metadataDir = null;
    private static String jhoveConfDir = null;
    private static String m_systemConfDir = null;
    private static ExLogger log = ExLogger.getExLogger(FSDirUtil.class);

    public static void main(String[] args) {
        System.out.println("Home dir=" + FSDirUtil.getDigitoolHome());
        System.out.println("Unit dir=" + FSDirUtil.getUnitsDir());
        System.out.println("Work dir=" + FSDirUtil.getWorkDir());
        System.out.println("Profile Dir=" + FSDirUtil.getProfileDir());
        System.out.println("System Dir=" + FSDirUtil.getSystemDir());
        System.out.println("Storage Dir=" + FSDirUtil.getDefaultStorageDir());
        System.out.println("JMagick Dir=" + FSDirUtil.getJMagickWorkDir());
        System.out.println("Reports Dir=" + FSDirUtil.getReportsWorkDir());
        System.out.println("Export Dir=" + FSDirUtil.getExportWorkDir());
        System.out.println("Collection Dir=" + FSDirUtil.getCollectionDir());
        System.out.println("Unit Count=" + FSDirUtil.getUnitsCount());
    }

    public static String getTemplatesDir() {
        if (templatesDir != null) {
            return templatesDir;
        }
        templatesDir = FSDirUtil.getConfDir() + TEMPLATES;
        return templatesDir;
    }

    public static String getMetadataDir() {
        if (metadataDir != null) {
            return metadataDir;
        }
        metadataDir = FSDirUtil.getTemplatesDir() + METADATA;
        return metadataDir;
    }

    public static String getReplicationsDir() {
        if (replicationsDir != null) {
            return replicationsDir;
        }
        replicationsDir = FSDirUtil.getProfileDir() + REPLICATIONS;
        return replicationsDir;
    }

    public static String getReplicationsLogsDir() {
        if (replicationsLogsDir != null) {
            return replicationsLogsDir;
        }
        replicationsLogsDir = FSDirUtil.getReplicationsDir() + "logs/";
        return replicationsLogsDir;
    }

    public static String getReplicationsTimestampsDir() {
        if (replicationsTimestampsDir != null) {
            return replicationsTimestampsDir;
        }
        replicationsTimestampsDir = FSDirUtil.getReplicationsDir() + "timestamps/";
        return replicationsTimestampsDir;
    }

    public static String getReplicationsRecoveryDir() {
        if (replicationsRecoveryDir != null) {
            return replicationsRecoveryDir;
        }
        replicationsRecoveryDir = FSDirUtil.getReplicationsDir() + REPLICATIONS_RECOVERY;
        return replicationsRecoveryDir;
    }

    public static String getReplicationsConfDir() {
        if (replicationsConfDir != null) {
            return replicationsConfDir;
        }
        replicationsConfDir = FSDirUtil.getReplicationsDir() + "conf/";
        return replicationsConfDir;
    }

    public static String getSynchronisationsDir() {
        if (synchronisationsDir != null) {
            return synchronisationsDir;
        }
        synchronisationsDir = FSDirUtil.getProfileDir() + SYNCHRONISATION;
        return synchronisationsDir;
    }

    public static String getSynchronisationsLogsDir() {
        if (synchronisationsLogsDir != null) {
            return synchronisationsLogsDir;
        }
        synchronisationsLogsDir = FSDirUtil.getSynchronisationsDir() + "logs/";
        return synchronisationsLogsDir;
    }

    public static String getSynchronisationsTimestampsDir() {
        if (synchronisationsTimestampsDir != null) {
            return synchronisationsTimestampsDir;
        }
        synchronisationsTimestampsDir = FSDirUtil.getSynchronisationsDir() + "timestamps/";
        return synchronisationsTimestampsDir;
    }

    public static String getSynchronisationsConfDir() {
        if (synchronisationsConfDir != null) {
            return synchronisationsConfDir;
        }
        synchronisationsConfDir = FSDirUtil.getSynchronisationsDir() + "conf/";
        return synchronisationsConfDir;
    }

    public static String getSynchronisationsFilesDir() {
        if (synchronisationsFilesDir != null) {
            return synchronisationsFilesDir;
        }
        synchronisationsFilesDir = FSDirUtil.getSynchronisationsDir() + SYNCHRONISATION_FILES;
        return synchronisationsFilesDir;
    }

    public static String getSynchronisationsRunDir() {
        if (synchronisationsRunDir != null) {
            return synchronisationsRunDir;
        }
        synchronisationsRunDir = FSDirUtil.getSynchronisationsDir() + SYNCHRONISATION_RUN;
        return synchronisationsRunDir;
    }

    public static File getLicenseFile() {
        File lf = null;
        String jpath = FSDirUtil.getSystemConfDir() + LICENSE_PATH;
        lf = new File(jpath);
        if (!lf.exists()) {
            lf = null;
        }
        return lf;
    }

    public static String getDigitoolHome() {
        if (m_digitoolHome != null) {
            return m_digitoolHome;
        }
        m_digitoolHome = FSDirUtil.getHome() + "../";
        File f = new File(m_digitoolHome);
        try {
            m_digitoolHome = f.getCanonicalPath() + SEPARATOR;
            return m_digitoolHome;
        }
        catch (IOException e) {
            e.printStackTrace();
            return null;
        }
    }

    public static String getXSLTWorkDir() {
        return FSDirUtil.getWorkDir() + XSLT_WORK;
    }

    public static String getDeployDir() {
        if (m_deployDir != null) {
            return m_deployDir;
        }
        m_deployDir = FSDirUtil.getSystemDir() + DEPLOY_DIR;
        return m_deployDir;
    }

    public static String getSystemDir() {
        if (m_systemHome != null) {
            return m_systemHome;
        }
        m_systemHome = FSDirUtil.getHome();
        return m_systemHome;
    }

    public static String getSystemConfDir() {
        if (m_systemConfDir != null) {
            return m_systemConfDir;
        }
        m_systemConfDir = FSDirUtil.getCanonicalPath(FSDirUtil.appendPath(FSDirUtil.getHome(), "conf/"));
        return m_systemConfDir;
    }

    public static String getDefaultStorageDir() {
        return FSDirUtil.getProfileDir() + STORAGE;
    }

    public static String getJMagickWorkDir() {
        return FSDirUtil.getWorkDir() + JMAGICK_WORK;
    }

    public static String getReportsWorkDir() {
        File reportsDirFile;
        if (reportsDir == null && !(reportsDirFile = new File(reportsDir = FSDirUtil.getProfileDir() + REPORTS)).exists()) {
            reportsDirFile.mkdir();
        }
        return reportsDir;
    }

    public static String getJobWorkDir(Long jobId) {
        return FSDirUtil.getReportsWorkDir() + FILE_SEPARATOR + jobId;
    }

    public static String getExportWorkDir() {
        File exportDirFile;
        if (exportDir == null && !(exportDirFile = new File(exportDir = FSDirUtil.getProfileDir() + EXPORT)).exists()) {
            exportDirFile.mkdir();
        }
        return exportDir;
    }

    public static String getProfileDir() {
        if (m_profileHome != null) {
            return m_profileHome;
        }
        m_profileHome = FSDirUtil.getHome() + PROFILE + m_profileExtention + SEPARATOR;
        File f = new File(m_profileHome);
        try {
            m_profileHome = f.getCanonicalPath() + SEPARATOR;
            return m_profileHome;
        }
        catch (IOException e) {
            e.printStackTrace();
            return null;
        }
    }

    public static String getWorkDir() {
        if (m_workHome != null) {
            return m_workHome;
        }
        m_workHome = FSDirUtil.getProfileDir() + WORK;
        return m_workHome;
    }

    public static String getMetsWorkDir() {
        if (m_metsWorkDir != null) {
            return m_metsWorkDir;
        }
        if (m_workHome == null) {
            m_metsWorkDir = FSDirUtil.getWorkDir() + METS_WORK_DIR;
            return m_metsWorkDir;
        }
        m_metsWorkDir = m_workHome + METS_WORK_DIR;
        return m_metsWorkDir;
    }

    public static String getMetsTempWorkDir() {
        if (m_metsTempWorkDir != null) {
            return m_metsTempWorkDir;
        }
        if (m_workHome == null) {
            m_metsTempWorkDir = FSDirUtil.getWorkDir() + METS_TEMP_DIR;
            return m_metsTempWorkDir;
        }
        m_metsTempWorkDir = m_workHome + METS_TEMP_DIR;
        return m_metsTempWorkDir;
    }

    public static String getDeServiceWorkDir() {
        if (m_deServiceWorkDir != null) {
            return m_deServiceWorkDir;
        }
        if (m_workHome == null) {
            m_deServiceWorkDir = FSDirUtil.getWorkDir() + DE_SERVICE_TMP_DIR;
            return m_deServiceWorkDir;
        }
        m_deServiceWorkDir = m_workHome + DE_SERVICE_TMP_DIR;
        return m_deServiceWorkDir;
    }

    public static String getCollectionDir() {
        if (m_collectionHome != null) {
            return m_collectionHome;
        }
        m_collectionHome = FSDirUtil.getProfileDir() + COLLECTION;
        return m_collectionHome;
    }

    public static String getCopyrightsDir() {
        if (m_copyrightsHome != null) {
            return m_copyrightsHome;
        }
        m_copyrightsHome = FSDirUtil.getConfDir() + COPYRIGHTS;
        return m_copyrightsHome;
    }

    public static String getConfDir() {
        if (m_confHome != null) {
            return m_confHome;
        }
        m_confHome = FSDirUtil.getProfileDir() + "conf/";
        return m_confHome;
    }

    public static String getServicesDescriptorsDir() {
        if (m_des_desc != null) {
            return m_des_desc;
        }
        StringBuffer desc_buffer = new StringBuffer(50);
        m_des_desc = desc_buffer.append(FSDirUtil.getConfDir()).append(DES_DESCRIPTORS_DIR + SEPARATOR).toString();
        return m_des_desc;
    }

    public static String getServicesParamsDir() {
        if (m_des_desc != null) {
            return m_des_desc;
        }
        StringBuffer desc_buffer = new StringBuffer(50);
        m_des_desc = desc_buffer.append(FSDirUtil.getConfDir()).append(DES_PARAMS_DIR + SEPARATOR).toString();
        return m_des_desc;
    }

    public static String getUnitsDir() {
        return FSDirUtil.getProfileDir() + UNITS;
    }

    private static synchronized String getHome() {
        if (m_systemHome != null) {
            return m_systemHome;
        }
        String m_systemHome = System.getProperty(DIGITOOL_HOME);
        if (!m_systemHome.endsWith(SEPARATOR)) {
            m_systemHome = m_systemHome + SEPARATOR;
        }
        if (m_systemHome == null) {
            return null;
        }
        String homeNoCase = m_systemHome.toLowerCase();
        int begin = homeNoCase.lastIndexOf(SYSTEM);
        if (begin != -1) {
            int end = m_systemHome.substring(begin += SYSTEM.length()).indexOf(SEPARATOR);
            m_profileExtention = m_systemHome.substring(begin, begin + end);
        }
        File f = new File(m_systemHome);
        try {
            m_systemHome = f.getCanonicalPath() + SEPARATOR;
            return m_systemHome;
        }
        catch (IOException e) {
            e.printStackTrace();
            return null;
        }
    }

    public static List getUnitList() {
        ArrayList<String> ret = new ArrayList<String>();
        StringBuffer path = new StringBuffer(32);
        path.append(FSDirUtil.getProfileDir());
        path.append(SEPARATOR + UNITS);
        File[] fList = new File(path.toString()).listFiles(new FileUtil.DirectoryFilter());
        for (int i = 0; i < fList.length; ++i) {
            if (fList[i].getName().toUpperCase().equals(SOURCE_CONTROL_DIR)) continue;
            ret.add(fList[i].getName());
        }
        return ret;
    }

    public static int getUnitsCount() {
        StringBuffer path = new StringBuffer(32);
        path.append(FSDirUtil.getProfileDir());
        path.append(SEPARATOR + UNITS);
        File[] fList = new File(path.toString()).listFiles(new FileUtil.DirectoryFilter());
        return fList.length;
    }

    public static FSDepositAreaUtil getDepositAreaUtil(String depName) throws Exception {
        FSDepositAreaUtil depositAreaUtil = new FSDepositAreaUtil(depName);
        if (depositAreaUtil.isExists()) {
            return depositAreaUtil;
        }
        throw new RuntimeException(DescriptorConstants.GN_FSUnitDoesNotExists + " Area " + depName);
    }

    public static FileLock lockFile(File pFile, FileChannel channel) throws IOException {
        channel = new RandomAccessFile(pFile, "rw").getChannel();
        FileLock lock = null;
        try {
            lock = channel.tryLock();
        }
        catch (OverlappingFileLockException e) {
            return null;
        }
        return lock;
    }

    public static boolean unlockFile(FileLock lock) throws IOException {
        if (lock == null) {
            return false;
        }
        lock.release();
        return true;
    }

    public static String getFilePath(String fileName, int folderID) {
        String urlstr = null;
        switch (folderID) {
            case 100: {
                urlstr = FSDirUtil.getDefaultStorageDir() + fileName;
                break;
            }
            case 200: {
                urlstr = FSDirUtil.getJMagickWorkDir() + fileName;
                break;
            }
            case 300: {
                urlstr = FSDirUtil.getXSLTWorkDir() + fileName;
                break;
            }
            default: {
                urlstr = fileName;
            }
        }
        return urlstr;
    }

    public static String getBatchExtention() {
        if (InfraConfigurationManager.getInstance().isDevelopmentMode()) {
            return ".bat";
        }
        return ".sh";
    }

    public static synchronized String getJHome() {
        String home = FSDirUtil.getDigitoolHome();
        return home;
    }

    public static synchronized String getDHome() {
        String home = FSDirUtil.getDigitoolHome();
        int jidx = home.indexOf(DIGITOOL_ANCHOR);
        if (jidx != -1) {
            String instId = home.substring(jidx + DIGITOOL_ANCHOR.length(), jidx + DIGITOOL_ANCHOR.length() + 1);
            String tempath = home.substring(0, jidx);
            home = tempath + LICENSE_ROOT_ALT + instId + SEPARATOR;
        }
        return home;
    }

    public static synchronized String getUHome() {
        String home = FSDirUtil.getDigitoolHome();
        int jidx = home.indexOf(DIGITOOL_ANCHOR);
        if (jidx != -1) {
            String instId = home.substring(jidx + DIGITOOL_ANCHOR.length(), jidx + DIGITOOL_ANCHOR.length() + 1);
            String tempath = home.substring(0, jidx);
            home = tempath + LICENSE_ROOT + instId + SEPARATOR;
        }
        return home;
    }

    public static synchronized String getProductDir() {
        String home = FSDirUtil.getDigitoolHome();
        int jidx = home.indexOf(DIGITOOL_ANCHOR);
        if (jidx != -1) {
            String instId = home.substring(jidx + DIGITOOL_ANCHOR.length(), jidx + DIGITOOL_ANCHOR.length() + 1);
            String tempath = home.substring(0, jidx);
            home = tempath + LICENSE_ROOT_ALT + instId + PRODUCT;
        }
        return home;
    }

    public static String getJhoveConfDir() {
        if (jhoveConfDir != null) {
            return jhoveConfDir;
        }
        jhoveConfDir = FSDirUtil.getSystemDir() + JHOVE_CONF_FILE;
        return jhoveConfDir;
    }

    public static String appendPath(String basePath, String appendPath) {
        if (basePath == null) {
            return basePath;
        }
        if (appendPath == null) {
            return basePath;
        }
        String localBasePath = basePath;
        if (!basePath.endsWith(File.separator)) {
            localBasePath = localBasePath + File.separator;
        }
        localBasePath = appendPath.startsWith(File.separator) ? localBasePath + appendPath.substring(1) : localBasePath + appendPath;
        return localBasePath;
    }

    public static String getCanonicalPath(String basePath) {
        if (basePath == null) {
            return basePath;
        }
        String localBasePath = basePath;
        File f = new File(basePath);
        try {
            localBasePath = f.getCanonicalPath();
            if (!localBasePath.endsWith(File.separator)) {
                localBasePath = localBasePath + File.separator;
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return localBasePath;
    }

    public static void createDirectory(String basePath) {
        File dirFile = new File(basePath);
        if (!dirFile.exists()) {
            dirFile.mkdir();
        }
    }
}

