/*
 * Decompiled with CFR 0.152.
 */
package com.exlibris.core.sdk.utils.metsHrefUtils;

import com.exlibris.core.infra.common.email.EncryptionUtil;
import com.exlibris.core.infra.common.exceptions.logging.ExLogger;
import com.exlibris.core.infra.common.util.IOUtil;
import com.exlibris.core.sdk.utils.FileUtil;
import com.exlibris.core.sdk.utils.metsHrefUtils.HrefUrlUtil;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.HttpURLConnection;
import java.net.URL;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Locale;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.lang.StringUtils;

public class HrefUrlHttpUtil
implements HrefUrlUtil {
    private String formattedPath;
    private String fileName = null;
    private long lastModified = 0L;
    private HttpURLConnection httpConnection;
    public static final String SEPARATOR = "/";
    private static final String CONTENT_DISPOSITION = "Content-Disposition";
    private static final String LAST_MODIFIED = "Last-Modified";
    private static final String LOCATION = "Location";
    private static final String FILENAME = "filename=";
    private static final ExLogger log = ExLogger.getExLogger(HrefUrlHttpUtil.class);

    public HrefUrlHttpUtil(String fileUrl) {
        this.formattedPath = fileUrl;
    }

    @Override
    public void init() throws Exception {
        this.httpConnection = (HttpURLConnection)new URL(this.formattedPath).openConnection();
        this.httpConnection.setInstanceFollowRedirects(false);
        this.httpConnection.connect();
        try {
            this.setLastModifiedFromHeader(this.formattedPath);
        }
        catch (Exception e) {
            log.error("Could not get date from header, file will get new modification date", new String[0]);
        }
    }

    @Override
    public long getFileSize() throws Exception {
        return this.httpConnection.getContentLengthLong();
    }

    @Override
    public InputStream getFileInputStream() throws Exception {
        InputStream is = null;
        if (this.httpConnection.getResponseCode() == 200) {
            is = this.httpConnection.getInputStream();
        }
        if (this.httpConnection.getResponseCode() == 301 || this.httpConnection.getResponseCode() == 302) {
            this.httpConnection = (HttpURLConnection)new URL(this.httpConnection.getHeaderField(LOCATION)).openConnection();
            this.httpConnection.setInstanceFollowRedirects(false);
            this.httpConnection.connect();
            is = this.httpConnection.getInputStream();
        }
        return is;
    }

    @Override
    public void closeFileConnection() throws Exception {
        this.httpConnection.disconnect();
    }

    @Override
    public String getFormattedFilePath() {
        return this.formattedPath;
    }

    @Override
    public String getFileName() throws IOException {
        if (StringUtils.isBlank((String)this.fileName)) {
            this.getFileNameFromURL(this.formattedPath);
            if (StringUtils.isBlank((String)this.fileName)) {
                log.warn((Object)"Could not retrieve file name from url or from header. generate random numeric filename.", new String[0]);
                this.fileName = FileUtil.fileNameNormalizer(EncryptionUtil.encryptAes(this.formattedPath, 10));
            }
        }
        this.fileName = this.fileName.replaceAll("\"", "");
        return this.fileName;
    }

    @Override
    public boolean supportsMove() {
        return false;
    }

    @Override
    public File getFile() {
        return null;
    }

    @Override
    public boolean isRelative() {
        return false;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.formattedPath == null ? 0 : this.formattedPath.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        HrefUrlHttpUtil other = (HrefUrlHttpUtil)obj;
        return !(this.formattedPath == null ? other.formattedPath != null : !this.formattedPath.equals(other.formattedPath));
    }

    public String toString() {
        return this.formattedPath;
    }

    @Override
    public String getRelativePath() throws IOException {
        return this.getFileName();
    }

    @Override
    public void copyTo(String destinationPath) throws Exception {
        InputStream is = this.getFileInputStream();
        FileOutputStream fos = new FileOutputStream(new File(destinationPath));
        try {
            log.info("Started downloading file from: " + this.formattedPath);
            IOUtil.copy(is, (OutputStream)fos);
            log.info("Finished downloading file from: " + this.formattedPath);
        }
        catch (Exception e) {
            log.error("Failed to copy file to the following location: " + destinationPath, e, new String[0]);
            throw e;
        }
        finally {
            is.close();
            fos.close();
            if (this.lastModified != 0L) {
                File destFile = new File(destinationPath);
                destFile.setLastModified(this.lastModified);
            }
        }
    }

    public void getFileNameFromURL(String url) throws IOException {
        HttpURLConnection con = (HttpURLConnection)new URL(url).openConnection();
        con.setInstanceFollowRedirects(false);
        con.connect();
        con.getInputStream();
        if (con.getResponseCode() == 200) {
            if (!this.getFileNameFromHeader(con) && StringUtils.isNotBlank((String)FilenameUtils.getExtension((String)url))) {
                this.fileName = FilenameUtils.getName((String)url);
            }
            con.disconnect();
            return;
        }
        if (con.getResponseCode() == 301 || con.getResponseCode() == 302) {
            if (this.getFileNameFromHeader(con)) {
                con.disconnect();
                return;
            }
            if (StringUtils.isNotBlank((String)FilenameUtils.getExtension((String)url))) {
                this.fileName = FilenameUtils.getName((String)url);
                con.disconnect();
                return;
            }
            String redirectUrl = con.getHeaderField(LOCATION);
            this.getFileNameFromURL(redirectUrl);
        }
        con.disconnect();
    }

    private boolean getFileNameFromHeader(HttpURLConnection con) {
        String disposition = con.getHeaderField(CONTENT_DISPOSITION);
        if (StringUtils.isNotBlank((String)disposition)) {
            if (disposition.contains("filename*=")) {
                this.fileName = disposition.substring(disposition.indexOf("filename*=") + 10, disposition.length()).trim().split(";")[0];
                if (StringUtils.isBlank((String)this.fileName)) {
                    return false;
                }
                this.fileName = this.fileName.split("''")[this.fileName.split("''").length - 1];
                return true;
            }
            this.fileName = disposition.substring(disposition.indexOf(FILENAME) + FILENAME.length(), disposition.length()).trim();
            return true;
        }
        return false;
    }

    private void setLastModifiedFromHeader(String url) throws Exception {
        if (this.httpConnection.getResponseCode() == 200) {
            this.setLastModified(this.httpConnection.getHeaderField(LAST_MODIFIED));
        }
        if (this.httpConnection.getResponseCode() == 301 || this.httpConnection.getResponseCode() == 302) {
            HttpURLConnection con = (HttpURLConnection)new URL(this.httpConnection.getHeaderField(LOCATION)).openConnection();
            con.setInstanceFollowRedirects(false);
            con.connect();
            con.getInputStream();
            if (con.getResponseCode() == 200) {
                this.setLastModified(con.getHeaderField(LAST_MODIFIED));
            }
            con.disconnect();
        }
    }

    private void setLastModified(String lastModifiedHeader) throws Exception {
        if (StringUtils.isNotBlank((String)lastModifiedHeader)) {
            SimpleDateFormat sdf = new SimpleDateFormat("EEE, dd MMM yyyy HH:mm:ss z", Locale.US);
            try {
                Date d = sdf.parse(lastModifiedHeader);
                this.lastModified = d.getTime();
            }
            catch (ParseException e) {
                throw new Exception("Could not parse date from header, header string:" + lastModifiedHeader, e);
            }
        }
    }

    @Override
    public String getFormattedAbsolutePath() throws IOException {
        String path = FileUtil.getPathFromUrl(this.formattedPath).replaceAll("[^a-zA-Z0-9\\.\\-\\\\////]", "_");
        path = path.contains(this.getFileName()) ? path : path.concat(File.separator + this.getFileName());
        return path;
    }
}

