/*
 * Decompiled with CFR 0.152.
 */
package com.exlibris.digitool.config;

import com.exlibris.core.infra.common.exceptions.logging.DescriptorConstants;
import com.exlibris.digitool.common.pi.PersitenceIdentityPublisher;
import com.exlibris.digitool.common.rule.xmlbeans.DeRuleDocument;
import com.exlibris.digitool.exceptions.DigitoolException;
import com.exlibrisgroup.xsd.digitool.publisher.Parameter;
import com.exlibrisgroup.xsd.digitool.publisher.Params;
import com.exlibrisgroup.xsd.digitool.publisher.ParamsGroup;
import com.exlibrisgroup.xsd.digitool.publisher.PiPublisher;
import com.exlibrisgroup.xsd.digitool.publisher.PiPublisherRuleDocument;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;

public class ConfigurationPublisherManager {
    public static final String SYSTEM_DEFAULT_PROFILE = "default";
    private static ConfigurationPublisherManager pic;
    private static final String PI_PUBLISHER_RULES_FILE = "pi_publisher_rules.xml";
    private static Map documentHash;
    private static Map rulesHash;
    private static Map publisherHash;
    private static Map publisherInstanceHash;
    private static Map paramsHash;
    private static Map paramsGroupHash;

    public static synchronized ConfigurationPublisherManager getInstance() {
        if (pic == null) {
            pic = new ConfigurationPublisherManager();
        }
        return pic;
    }

    public static void reset() {
        pic = null;
    }

    private void loadDocument(String adminUnit, PiPublisherRuleDocument document) {
        if (document == null) {
            return;
        }
        documentHash.put(adminUnit, document);
        this.setRulesForAdminUnit(adminUnit, document);
        this.setPublisherMapForAdminUnit(adminUnit, document);
        this.setParametersForAdminUnit(adminUnit, document);
        this.setGroupHashForAdminUnit(adminUnit, document);
    }

    private void setRulesForAdminUnit(String adminUnit, PiPublisherRuleDocument document) {
        if (document.getPiPublisherRule() != null) {
            HashMap<String, DeRuleDocument.DeRule> rulesMap = new HashMap<String, DeRuleDocument.DeRule>();
            DeRuleDocument.DeRule[] deRules = document.getPiPublisherRule().getDeRuleArray();
            for (int i = 0; i < deRules.length; ++i) {
                DeRuleDocument.DeRule rule = deRules[i];
                rulesMap.put(rule.getName(), rule);
            }
            rulesHash.put(adminUnit, rulesMap);
        }
    }

    private void setPublisherMapForAdminUnit(String adminUnit, PiPublisherRuleDocument document) {
        if (document.getPiPublisherRule() != null) {
            HashMap<String, PiPublisher> publisherMap = new HashMap<String, PiPublisher>();
            PiPublisher[] publishers = document.getPiPublisherRule().getPiPublisherArray();
            PiPublisher publisher = null;
            for (int i = 0; i < publishers.length; ++i) {
                publisher = publishers[i];
                publisherMap.put(publisher.getName(), publisher);
            }
            publisherHash.put(adminUnit, publisherMap);
        }
    }

    public PersitenceIdentityPublisher getPIPublisher(PiPublisher publisherXML) throws DigitoolException {
        String publisherClass = publisherXML.getPiPublisherClass();
        PersitenceIdentityPublisher publisher = null;
        try {
            publisher = (PersitenceIdentityPublisher)Class.forName(publisherClass).newInstance();
        }
        catch (ClassCastException e) {
            throw new DigitoolException(DescriptorConstants.GN_ExceptionWithMsg, "Error while trying to create PersitenceIdentityPublisher - " + publisherClass + " is not of type PersitenceIdentityPublisher");
        }
        catch (IllegalAccessException e) {
            throw new DigitoolException(DescriptorConstants.GN_ExceptionWithMsg, "Error while trying to create PersitenceIdentityPublisher - " + publisherClass);
        }
        catch (InstantiationException e) {
            throw new DigitoolException(DescriptorConstants.GN_ExceptionWithMsg, "Error while trying to create PersitenceIdentityPublisher - " + publisherClass + " is abstract or interface");
        }
        catch (ClassNotFoundException e) {
            throw new DigitoolException(DescriptorConstants.GN_ExceptionWithMsg, "Error while trying to create PersitenceIdentityPublisher - " + publisherClass + " not found");
        }
        if (publisherXML.getParams() != null) {
            Properties params = new Properties();
            Parameter[] parameterArray = publisherXML.getParams().getParameterArray();
            for (int i = 0; i < parameterArray.length; ++i) {
                Parameter parameter = parameterArray[i];
                params.setProperty(parameter.getName(), parameter.getValue());
            }
        }
        return publisher;
    }

    private Params setParametersForAdminUnit(String adminUnit, PiPublisherRuleDocument document) {
        Params params = document.getPiPublisherRule().getParams();
        Properties currParams = new Properties();
        if (params != null && params.getParameterArray() != null) {
            Parameter[] confiParams = params.getParameterArray();
            for (int i = 0; i < confiParams.length; ++i) {
                Parameter parameter = confiParams[i];
                currParams.setProperty(parameter.getName(), parameter.getValue());
            }
        }
        paramsHash.put(adminUnit, currParams);
        return params;
    }

    private void setGroupHashForAdminUnit(String adminUnit, PiPublisherRuleDocument document) {
        HashMap<String, Properties> currParamsGroupHash = new HashMap<String, Properties>();
        Params params = document.getPiPublisherRule().getParams();
        if (params != null && params.getParamsGroupArray() != null) {
            ParamsGroup[] paramsGroup = params.getParamsGroupArray();
            for (int j = 0; j < paramsGroup.length; ++j) {
                Properties currParams = new Properties();
                ParamsGroup group = paramsGroup[j];
                String groupName = group.getName();
                Parameter[] confiParams = group.getParameterArray();
                for (int i = 0; i < confiParams.length; ++i) {
                    Parameter parameter = confiParams[i];
                    currParams.setProperty(parameter.getName(), parameter.getValue());
                }
                currParamsGroupHash.put(groupName, currParams);
            }
        }
        paramsGroupHash.put(adminUnit, currParamsGroupHash);
    }

    public PiPublisher getPiPublisher(String adminUnit, String publisherName) {
        PiPublisher publisher = null;
        Map adminPublishersMap = (Map)publisherHash.get(adminUnit);
        if (adminPublishersMap == null) {
            adminPublishersMap = (Map)publisherHash.get(SYSTEM_DEFAULT_PROFILE);
        }
        if (adminPublishersMap != null) {
            publisher = (PiPublisher)adminPublishersMap.get(publisherName);
        }
        return publisher;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public PersitenceIdentityPublisher getPiPublisherInstance(String adminUnit, String publisherName) {
        PersitenceIdentityPublisher publisher = null;
        HashMap<String, PersitenceIdentityPublisher> adminPublishersMap = (HashMap<String, PersitenceIdentityPublisher>)publisherInstanceHash.get(adminUnit);
        if (adminPublishersMap == null) {
            adminPublishersMap = (Map)publisherInstanceHash.get(SYSTEM_DEFAULT_PROFILE);
        }
        if (adminPublishersMap != null) {
            publisher = (PersitenceIdentityPublisher)adminPublishersMap.get(publisherName);
        }
        if (publisher == null) {
            PiPublisher publisherXml = this.getPiPublisher(adminUnit, publisherName);
            try {
                Class<PersitenceIdentityPublisher> clazz = PersitenceIdentityPublisher.class;
                synchronized (PersitenceIdentityPublisher.class) {
                    publisher = this.getPIPublisher(publisherXml);
                    if (adminPublishersMap == null) {
                        adminPublishersMap = new HashMap<String, PersitenceIdentityPublisher>();
                        publisherInstanceHash.put(adminUnit, adminPublishersMap);
                    }
                    adminPublishersMap.put(publisherName, publisher);
                    // ** MonitorExit[var6_6] (shouldn't be in output)
                }
            }
            catch (DigitoolException e) {
                e.printStackTrace();
            }
        }
        {
            return publisher;
        }
    }

    public DeRuleDocument.DeRule getDeRule(String adminUnit, String ruleName) {
        DeRuleDocument.DeRule deRule = null;
        Map adminDeRuleMap = (Map)rulesHash.get(adminUnit);
        if (adminDeRuleMap == null) {
            adminDeRuleMap = (Map)rulesHash.get(SYSTEM_DEFAULT_PROFILE);
        }
        if (adminDeRuleMap != null) {
            deRule = (DeRuleDocument.DeRule)adminDeRuleMap.get(ruleName);
        }
        return deRule;
    }

    public PiPublisher[] getPiPublishers(String adminUnit) {
        PiPublisher[] publishers = null;
        PiPublisherRuleDocument document = this.getPiPublishersRuleDocument(adminUnit);
        if (document != null && document.getPiPublisherRule() != null) {
            publishers = document.getPiPublisherRule().getPiPublisherArray();
        }
        return publishers;
    }

    public DeRuleDocument.DeRule[] getDeRules(String adminUnit) {
        DeRuleDocument.DeRule[] profd = null;
        PiPublisherRuleDocument document = this.getPiPublishersRuleDocument(adminUnit);
        if (document != null && document.getPiPublisherRule() != null) {
            profd = document.getPiPublisherRule().getDeRuleArray();
        }
        return profd;
    }

    public PiPublisherRuleDocument getPiPublishersRuleDocument(String adminUnit) {
        PiPublisherRuleDocument document = (PiPublisherRuleDocument)documentHash.get(adminUnit);
        if (document == null) {
            document = (PiPublisherRuleDocument)documentHash.get(SYSTEM_DEFAULT_PROFILE);
        }
        return document;
    }

    public String getConfigurationProperty(String adminUnit, String key) {
        Properties config = (Properties)paramsHash.get(adminUnit);
        if (config == null) {
            config = (Properties)paramsHash.get(SYSTEM_DEFAULT_PROFILE);
        }
        if (config != null) {
            return config.getProperty(key);
        }
        return null;
    }

    public Properties getConfigurationPropertiesGroup(String adminUnit, String groupName) {
        Map groupsMap = (Map)paramsGroupHash.get(adminUnit);
        if (groupsMap == null) {
            groupsMap = (Map)paramsGroupHash.get(SYSTEM_DEFAULT_PROFILE);
        }
        if (groupsMap != null) {
            return (Properties)groupsMap.get(groupName);
        }
        return null;
    }

    static {
        documentHash = new HashMap();
        rulesHash = new HashMap();
        publisherHash = new HashMap();
        publisherInstanceHash = new HashMap();
        paramsHash = new HashMap();
        paramsGroupHash = new HashMap();
    }
}

