/*
 * Decompiled with CFR 0.152.
 */
package com.exlibris.dps.sdk.test;

import com.exlibris.digitool.deposit.service.xmlbeans.DepositActivityStatus;
import com.exlibris.dps.sdk.deposit.DepositWebServices;
import com.exlibris.dps.sdk.factory.DepositWSFactory;
import com.exlibris.dps.sdk.pds.PdsClient;

public class DepositActivityWSTest {
    static final String WSDL_URL = "/dpsws/deposit/DepositWebServices?wsdl";
    static final String PDS = "/pds";
    static final Long numberOfRecords = 8L;
    static final String producerIdStr = "10000";
    static final String producerAgentIdStr = "10000";
    static final String fromDate = "24/05/2010";
    static final String toDate = "20/06/2010";

    public static void main(String[] args) {
        String pdsHandle = null;
        String wb_url = null;
        String pds_url = null;
        String userName = "admin1";
        String password = "a12345678A";
        String institution = "INS00";
        if (args != null) {
            wb_url = args[0] + WSDL_URL;
            pds_url = args[1] + PDS;
        }
        try {
            PdsClient pds = PdsClient.getInstance();
            pds.init(pds_url, false);
            pdsHandle = pds.login(institution, userName, password);
        }
        catch (Exception pds) {
            // empty catch block
        }
        DepositWebServices services = DepositWSFactory.create(wb_url);
        System.out.println("**** start testing 1 - get example by submit date status INPROCESS ****:\n");
        System.out.println(services.getDepositActivityBySubmitDate(pdsHandle, DepositActivityStatus.INPROCESS.toString(), "10000", "10000", fromDate, toDate, "1", "5"));
        System.out.println("**** end testing 1 - get example by submit date status INPROCESS ****:\n");
        System.out.println("**** start testing 2 - get example by update date status INPROCESS ****:\n");
        System.out.println(services.getDepositActivityByUpdateDate(pdsHandle, DepositActivityStatus.INPROCESS.toString(), "10000", "10000", fromDate, toDate, "11", "20"));
        System.out.println("**** end testing 2 - get example by update date status INPROCESS ****:\n");
        System.out.println("**** start testing 3 - get example by submit date status INPROCESS (empty list high records)****:\n");
        System.out.println(services.getDepositActivityBySubmitDate(pdsHandle, DepositActivityStatus.INPROCESS.toString(), "10000", "10000", fromDate, toDate, "200", "250"));
        System.out.println("**** end testing 3 - get example by submit date status INPROCESS  (empty list)****:\n");
        System.out.println("**** start testing 4 - get example by submit date status INPROCESS (non existing producer)****:\n");
        System.out.println(services.getDepositActivityBySubmitDate(pdsHandle, DepositActivityStatus.INPROCESS.toString(), "1000010000", "10000", fromDate, toDate, "200", "250"));
        System.out.println("**** end testing 4 - get example by submit date status INPROCESS  (empty list)****:\n");
        System.out.println("**** start testing 5 - get error example by submit date status INPROCESS ****:\n");
        System.out.println("ERROR - converting to Long:\n" + services.getDepositActivityByUpdateDate(pdsHandle, DepositActivityStatus.INPROCESS.toString(), "error producer id", null, fromDate, toDate, "1", "20"));
        System.out.println("**** end testing 5 - get error example by submit date status INPROCESS ****:\n");
    }
}

