/*
 * Decompiled with CFR 0.152.
 */
package com.exlibris.dps.utils;

import com.exlibris.core.infra.common.enums.FileDeliveryRule;
import com.exlibris.core.infra.common.enums.IeDeliveryRule;
import com.exlibris.core.infra.common.exceptions.logging.ExLogger;
import com.exlibris.core.infra.common.rules.operators.Operator;
import com.exlibris.core.infra.common.shared.dataObjects.KeyValuePair;
import com.exlibris.core.infra.model.codetables.HMappingTables;
import com.exlibris.core.infra.svc.api.CodeTablesManager;
import com.exlibris.core.infra.svc.api.locator.ServiceLocator;
import com.exlibris.core.infra.svc.api.services.CacheServices;
import com.exlibris.core.sdk.consts.Enum;
import com.exlibris.digitool.common.dnx.DnxDocument;
import com.exlibris.digitool.common.dnx.DnxSection;
import com.exlibris.digitool.repository.ifc.DeliveryManager;
import com.exlibris.digitool.repository.ifc.MetadataService;
import com.exlibris.digitool.repository.ifc.RepositoryServices;
import com.exlibris.dps.sdk.delivery.AccessRightsCheckResult;
import com.exlibris.dps.sdk.delivery.DeliveryData;
import com.exlibris.dps.sdk.deposit.IEParser;
import com.exlibris.dps.sdk.deposit.IEParserFactory;
import com.exlibris.repository.persistence.delivery.DelRuleOutputParam;
import com.exlibris.repository.persistence.delivery.DeliveryRule;
import com.exlibris.repository.persistence.delivery.RepresentationProfile;
import com.exlibris.repository.persistence.delivery.RuleInputParam;
import com.exlibris.repository.persistence.digitalentity.MetadataWithPID;
import gov.loc.mets.MetsType;
import gov.loc.mets.StructMapType;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.json.JSONException;

public class DeliveryRulesManager {
    private static DeliveryRulesManager drm = null;
    private static Map<Integer, Operator> operatorMap = null;
    private static Set<String> ieDeliveryRuleValues = null;
    private static Set<String> fileDeliveryRuleValues = null;
    private RepositoryServices repository = null;
    private static final ExLogger logger = ExLogger.getExLogger(DeliveryRulesManager.class);

    public static DeliveryRulesManager getInstance() throws Exception {
        if (drm == null) {
            drm = new DeliveryRulesManager();
        }
        return drm;
    }

    private DeliveryRulesManager() {
    }

    public DelRuleOutputParam getDefaultIERule() throws Exception {
        List<DeliveryRule> rules = this.getDeliveryRules();
        for (DeliveryRule rule : rules) {
            if (!rule.getRuleEntityType().equals((Object)DeliveryRule.RuleEntityType.INTELLECTUAL_ENTITY) || rule.getRuleOrder() != 0) continue;
            for (DelRuleOutputParam delRuleOutputParam : rule.getDelRuleOutputParam()) {
                if (delRuleOutputParam.getRuleParamOrder() != 0) continue;
                return delRuleOutputParam;
            }
        }
        return null;
    }

    public DelRuleOutputParam getMatchingRule(Map<String, String> paramsMap, Map<String, Map<String, String>> representationProfilesParams) throws Exception {
        List<DeliveryRule> rules = this.getDeliveryRules();
        Iterator<DeliveryRule> iter = rules.iterator();
        DeliveryRule defaultRule = null;
        DeliveryRule.RuleEntityType ruleEntityType = DeliveryRule.RuleEntityType.valueOf(paramsMap.get("RuleEntityType"));
        this.initDeliveryRuleEnumValuesSet();
        List<DelRuleOutputParam> delRuleOutputParams = null;
        while (iter.hasNext()) {
            DeliveryRule dvr = iter.next();
            if (!dvr.getRuleEntityType().equals((Object)ruleEntityType)) continue;
            if (dvr.getRuleOrder() == 0) {
                defaultRule = dvr;
                continue;
            }
            if (!this.isRuleMatched(dvr, paramsMap)) continue;
            delRuleOutputParams = dvr.getDelRuleOutputParam();
            break;
        }
        if (delRuleOutputParams == null) {
            delRuleOutputParams = defaultRule.getDelRuleOutputParam();
        }
        Collections.sort(delRuleOutputParams, new DelRuleOutputParam().new DelRuleOutputParam.OrderComparator());
        switch (ruleEntityType) {
            case INTELLECTUAL_ENTITY: {
                DelRuleOutputParam defaultDelRuleOutputParam = null;
                for (int i = 0; i < delRuleOutputParams.size(); ++i) {
                    DelRuleOutputParam cur = delRuleOutputParams.get(i);
                    if (cur.getRuleParamOrder() == 0) {
                        defaultDelRuleOutputParam = cur;
                        continue;
                    }
                    Collection<Map<String, String>> representationProfilesParamsList = representationProfilesParams.values();
                    for (Map<String, String> curParamsMap : representationProfilesParamsList) {
                        if (!this.isProfileMatched(cur.getRepresentationProfile(), curParamsMap)) continue;
                        return cur;
                    }
                }
                return defaultDelRuleOutputParam;
            }
            case FILE: {
                return delRuleOutputParams.get(0);
            }
        }
        return null;
    }

    public List<DeliveryRule> getDeliveryRules() throws Exception {
        List<DeliveryRule> rules = new ArrayList<DeliveryRule>();
        DeliveryManager deliveryManager = null;
        int callTriesNum = 10;
        while (callTriesNum > 0) {
            try {
                rules = (List)CacheServices.getInstance().getCacheValue("DELIVERY_RULE", "1");
                if (rules == null || rules.size() == 0) {
                    throw new Exception();
                }
                return rules;
            }
            catch (Exception e) {
                if (deliveryManager == null) {
                    deliveryManager = (DeliveryManager)ServiceLocator.getInstance().lookUp(DeliveryManager.class);
                }
                deliveryManager.loadRules(true);
                Thread.sleep(1000L);
                if (--callTriesNum != 0) continue;
                logger.error("Error loading Delivery Rules", e, new String[0]);
                throw e;
            }
        }
        return rules;
    }

    private void initOperatorsMap() throws Exception {
        operatorMap = new HashMap<Integer, Operator>();
        CodeTablesManager codeTableManager = (CodeTablesManager)ServiceLocator.getInstance().lookUp(CodeTablesManager.class);
        List<HMappingTables> mappingTables = codeTableManager.findMappingTableByName("Operator", "CRS00");
        for (HMappingTables mappingTable : mappingTables) {
            int key = Integer.parseInt(mappingTable.getTargetCode());
            Operator value = (Operator)Class.forName(mappingTable.getSourceCode3()).newInstance();
            operatorMap.put(key, value);
        }
    }

    private void initDeliveryRuleEnumValuesSet() {
        if (ieDeliveryRuleValues == null) {
            ieDeliveryRuleValues = new HashSet<String>();
        }
        for (IeDeliveryRule ieDeliveryRule : IeDeliveryRule.values()) {
            ieDeliveryRuleValues.add(ieDeliveryRule.name());
        }
        if (fileDeliveryRuleValues == null) {
            fileDeliveryRuleValues = new HashSet<String>();
        }
        for (Enum enum_ : FileDeliveryRule.values()) {
            fileDeliveryRuleValues.add(enum_.name());
        }
    }

    private Operator getOperator(Integer operatorId) {
        if (operatorMap == null || !operatorMap.containsKey(operatorId)) {
            try {
                this.initOperatorsMap();
            }
            catch (Exception e) {
                logger.error("Failed to parse Operator mapping table", e, new String[0]);
            }
        }
        if (operatorMap.containsKey(operatorId)) {
            return operatorMap.get(operatorId);
        }
        throw new RuntimeException("Operator " + operatorId + " not defined");
    }

    private boolean isRuleMatched(DeliveryRule rule, Map<String, String> paramsMap) {
        DeliveryRule.RuleEntityType ruleEntityType = DeliveryRule.RuleEntityType.valueOf(paramsMap.get("RuleEntityType"));
        Operator oper = null;
        block4: for (String key : paramsMap.keySet()) {
            switch (ruleEntityType) {
                case INTELLECTUAL_ENTITY: {
                    if (!ieDeliveryRuleValues.contains(key)) continue block4;
                    oper = this.getOperator(IeDeliveryRule.valueOf(key).getOperator());
                    break;
                }
                case FILE: {
                    if (!fileDeliveryRuleValues.contains(key)) continue block4;
                    oper = this.getOperator(FileDeliveryRule.valueOf(key).getOperator());
                }
            }
            for (int i = 0; i < rule.getRuleInputParam().size(); ++i) {
                RuleInputParam cur = rule.getRuleInputParam().get(i);
                if (!key.equals(cur.getKey())) continue;
                Operator operator = oper = cur.getOperator() != null ? this.getOperator(cur.getOperator()) : oper;
                if ("*".equals(cur.getValue()) || paramsMap.get(key) == null && (cur.getValue() == null || cur.getValue().contains("null")) || oper.check(paramsMap.get(key), cur.getValue()).booleanValue()) continue;
                return false;
            }
        }
        return true;
    }

    public boolean isProfileMatched(RepresentationProfile profile, Map<String, String> paramsMap) {
        if (paramsMap.get(com.exlibris.core.infra.common.enums.RepresentationProfile.LIFE_CYCLE.name()).equals((Object)Enum.LifeCycle.PENDING) && !Boolean.valueOf(paramsMap.get("is_staff")).booleanValue()) {
            return false;
        }
        for (String key : paramsMap.keySet()) {
            Operator oper = this.getOperator(com.exlibris.core.infra.common.enums.RepresentationProfile.valueOf(key).getOperator());
            for (int i = 0; i < profile.getRuleInputParam().size(); ++i) {
                RuleInputParam cur = profile.getRuleInputParam().get(i);
                if (!key.equals(cur.getKey())) continue;
                Operator operator = oper = cur.getOperator() != null ? this.getOperator(cur.getOperator()) : oper;
                if (paramsMap.get(key) == null && (cur.getValue() == null || cur.getValue().contains("null")) || oper.check(paramsMap.get(key), cur.getValue()).booleanValue()) continue;
                return false;
            }
        }
        return true;
    }

    public Map<String, String> prepareData(IEParser parser, Map<String, String> paramMap, DnxDocument reqDnx) throws Exception {
        switch (DeliveryRule.RuleEntityType.valueOf(paramMap.get("RuleEntityType"))) {
            case INTELLECTUAL_ENTITY: {
                IeDeliveryRule[] ieKeys;
                for (IeDeliveryRule param : ieKeys = IeDeliveryRule.values()) {
                    if (param.getDnxSection() == null || param.getDnxSectionKey() == null) continue;
                    paramMap.put(param.name(), this.getDnxValue(parser.getIeDnx(), param.getDnxSection(), param.getDnxSectionKey()));
                }
                break;
            }
            case FILE: {
                FileDeliveryRule[] fileKeys;
                for (FileDeliveryRule param : fileKeys = FileDeliveryRule.values()) {
                    if (param.getDnxSection() == null || param.getDnxSectionKey() == null) continue;
                    paramMap.put(param.name(), this.getDnxValue(reqDnx, param.getDnxSection(), param.getDnxSectionKey()));
                }
                break;
            }
        }
        return paramMap;
    }

    public Map<String, Map<String, String>> prepareRepData(IEParser parser, HashMap<String, Enum.LifeCycle> RepLifeCycleList, boolean isStaff) throws Exception {
        MetsType.FileSec.FileGrp[] reps;
        HashMap<String, Map<String, String>> repParamMapList = new HashMap<String, Map<String, String>>();
        for (MetsType.FileSec.FileGrp rep : reps = parser.getFileGrpArray()) {
            repParamMapList.put(rep.getID(), this.prepareRepData(parser.getFileGrpDnx(rep.getID()), RepLifeCycleList.get(rep.getID()), isStaff));
        }
        return repParamMapList;
    }

    public Map<String, String> prepareRepData(DnxDocument repDnx, Enum.LifeCycle repLifeCycle, boolean isStaff) throws Exception {
        com.exlibris.core.infra.common.enums.RepresentationProfile[] repKeys = com.exlibris.core.infra.common.enums.RepresentationProfile.values();
        HashMap<String, String> repParamMap = new HashMap<String, String>();
        for (com.exlibris.core.infra.common.enums.RepresentationProfile param : repKeys) {
            repParamMap.put(param.name(), this.getDnxValue(repDnx, param.getDnxSection(), param.getDnxSectionKey()));
        }
        repParamMap.put(com.exlibris.core.infra.common.enums.RepresentationProfile.LIFE_CYCLE.name(), repLifeCycle.name());
        repParamMap.put(com.exlibris.core.infra.common.enums.RepresentationProfile.IS_STAFF.name(), String.valueOf(isStaff));
        return repParamMap;
    }

    public IEParser filterParser(DeliveryData data, RepresentationProfile representationProfile, Map<String, Map<String, String>> repData, Map ARparams) throws Exception {
        IEParser parser = IEParserFactory.parse(data.getIeXml());
        Set<String> repPids = repData.keySet();
        ArrayList<KeyValuePair> repPidsList = new ArrayList<KeyValuePair>();
        for (String repId : repPids) {
            if (!this.isProfileMatched(representationProfile, repData.get(repId))) {
                parser.removeFileGrp(repId);
                continue;
            }
            KeyValuePair<String, Map<String, String>> keyValuePair = new KeyValuePair<String, Map<String, String>>(repId, repData.get(repId));
            repPidsList.add(keyValuePair);
        }
        Collections.sort(repPidsList, new RepresentationProfileComparator(representationProfile));
        if (representationProfile.isSingleRepresentation()) {
            KeyValuePair repToShow = (KeyValuePair)repPidsList.get(0);
            for (int i = 1; i < repPidsList.size(); ++i) {
                parser.removeFileGrp((String)((KeyValuePair)repPidsList.get(i)).getKey());
            }
            repPidsList.clear();
            repPidsList.add(repToShow);
        }
        this.filterFilesWithRestrictedAR(parser, ARparams, data, false, representationProfile.isHideFiles());
        ArrayList smSortedList = new ArrayList();
        for (KeyValuePair keyValuePair : repPidsList) {
            StructMapType[] smArray = parser.getStructMapsByFileGrpId((String)keyValuePair.getKey());
            ArrayList smPhysicalList = new ArrayList();
            for (StructMapType sm : smArray) {
                if (sm.getTYPE().toLowerCase().equals("logical")) {
                    smSortedList.add(new KeyValuePair(keyValuePair.getKey(), sm.newCursor().xmlText()));
                    continue;
                }
                smPhysicalList.add(new KeyValuePair(keyValuePair.getKey(), sm.newCursor().xmlText()));
            }
            smSortedList.addAll(smPhysicalList);
            parser.removeFGStructMaps((String)keyValuePair.getKey());
        }
        for (KeyValuePair keyValuePair : smSortedList) {
            parser.setStructMap(parser.getFileGrp((String)keyValuePair.getKey()), (String)keyValuePair.getValue());
        }
        return parser;
    }

    public void filterFilesWithRestrictedAR(IEParser parser, Map ARparams, DeliveryData data, boolean removeFilesMd, boolean isHideSM) throws JSONException, Exception {
        MetsType.FileSec.FileGrp[] fileGrpArray;
        StructMapType[] smArry = parser.getStructMapArray();
        ArrayList<String> authFilePidList = new ArrayList<String>();
        ArrayList<String> restrictedFilePidList = new ArrayList<String>();
        HashMap<String, AccessRightsCheckResult> mid2Results = new HashMap<String, AccessRightsCheckResult>();
        HashMap<String, AccessRightsCheckResult> pid2result = new HashMap<String, AccessRightsCheckResult>();
        boolean hasFilesWithAR = false;
        for (int i = 0; i < smArry.length; ++i) {
            ArrayList<String> filePidList = parser.getFilesArray(smArry[i]);
            authFilePidList.addAll(filePidList);
            ArrayList<String> restrictedFiles = new ArrayList<String>();
            String ip = ARparams.get("ip") == null ? null : ARparams.get("ip").toString();
            String dvs = ARparams.get("dvs") == null ? null : ARparams.get("dvs").toString();
            String token = ARparams.get("token") == null ? null : ARparams.get("token").toString();
            MetadataService metadataService = (MetadataService)ServiceLocator.getInstance().lookUp(MetadataService.class);
            List<MetadataWithPID> arList = metadataService.getARByPidsOneFlush(filePidList);
            if (!arList.isEmpty()) {
                hasFilesWithAR = true;
            }
            for (MetadataWithPID fileAr : arList) {
                AccessRightsCheckResult accessRightsCheckResult;
                String mid = fileAr.getMetadata().getMid();
                String filePid = fileAr.getPid();
                if (mid2Results.get(mid) != null) {
                    if (((AccessRightsCheckResult)mid2Results.get(mid)).isDateCompare()) {
                        accessRightsCheckResult = this.getRepositoryServices().runAccessRightsCheckForFiles(filePid, ip, token, dvs, false);
                        if (accessRightsCheckResult.isAuthorized()) continue;
                        restrictedFiles.add(filePid);
                        pid2result.put(filePid, accessRightsCheckResult);
                        authFilePidList.remove(filePid);
                        continue;
                    }
                    if (((AccessRightsCheckResult)mid2Results.get(mid)).isAuthorized()) continue;
                    restrictedFiles.add(filePid);
                    pid2result.put(filePid, (AccessRightsCheckResult)mid2Results.get(mid));
                    authFilePidList.remove(filePid);
                    continue;
                }
                accessRightsCheckResult = this.getRepositoryServices().runAccessRightsCheckForFiles(filePid, ip, token, dvs, false);
                mid2Results.put(mid, accessRightsCheckResult);
                if (accessRightsCheckResult.isAuthorized()) continue;
                restrictedFiles.add(filePid);
                pid2result.put(filePid, accessRightsCheckResult);
                authFilePidList.remove(filePid);
            }
            if (restrictedFiles.size() == filePidList.size() && isHideSM) {
                parser.removeStructMap(smArry[i].getID());
            } else if (isHideSM) {
                smArry[i].setDiv(parser.removeFilesFromSM(smArry[i].getDiv(), restrictedFiles));
            }
            restrictedFilePidList.addAll(restrictedFiles);
        }
        for (MetsType.FileSec.FileGrp fileGrp : fileGrpArray = parser.getFileGrpArray()) {
            StructMapType[] smArray = parser.getStructMapsByFileGrpId(fileGrp.getID());
            if (smArray != null && smArray.length == 0) {
                parser.removeFileGrp(fileGrp.getID());
                continue;
            }
            if (!removeFilesMd || smArray.length <= 0) continue;
            parser.removeFilesFromFG(fileGrp.getID(), restrictedFilePidList);
        }
        data.setPid2result(pid2result);
        data.setFilePids(authFilePidList);
        data.setHasFilesWithAR(hasFilesWithAR);
    }

    private String getDnxValue(DnxDocument dnx, String section, String sectionKey) {
        DnxSection dnxSec = dnx.getSectionById(section);
        if (dnxSec != null) {
            return dnxSec.getSectionKeyValue(sectionKey);
        }
        return null;
    }

    public DelRuleOutputParam getManifestRule() {
        DelRuleOutputParam iiifRule = new DelRuleOutputParam();
        iiifRule.setViewerId(20L);
        iiifRule.setRepresentationProfileId(11L);
        iiifRule.setRuleParamOrder(1);
        iiifRule.setToolbar(true);
        iiifRule.setEmbedded(false);
        iiifRule.setViewer(this.getDeliveryManager().getViewer(20L));
        iiifRule.setRepresentationProfile(this.getDeliveryManager().getRepresentationProfileById(11L));
        return iiifRule;
    }

    private DeliveryManager getDeliveryManager() {
        DeliveryManager deliveryManager = (DeliveryManager)ServiceLocator.getInstance().lookUp(DeliveryManager.class);
        return deliveryManager;
    }

    private RepositoryServices getRepositoryServices() {
        if (this.repository == null) {
            this.repository = (RepositoryServices)ServiceLocator.getInstance().lookUp(RepositoryServices.class);
        }
        return this.repository;
    }

    class RepresentationProfileComparator
    implements Comparator {
        Map<String, List<String>> inputParamOrder = new HashMap<String, List<String>>();
        List<String> keyList = Arrays.asList(com.exlibris.core.infra.common.enums.RepresentationProfile.PRESERVATION_TYPE.name(), com.exlibris.core.infra.common.enums.RepresentationProfile.REPRESENTATION_CODE.name(), com.exlibris.core.infra.common.enums.RepresentationProfile.REPRESENTATION_ENTITY_TYPE.name());

        public RepresentationProfileComparator(RepresentationProfile representationProfile) {
            for (String key : this.keyList) {
                for (int i = 0; i < representationProfile.getRuleInputParam().size(); ++i) {
                    RuleInputParam cur = representationProfile.getRuleInputParam().get(i);
                    if (!key.equals(cur.getKey()) || cur.getValue() == null || cur.getOperator() == null || cur.getOperator() == 18) continue;
                    List<String> orderList = Arrays.asList(cur.getValue().split("[,;]"));
                    this.inputParamOrder.put(key, orderList);
                }
            }
        }

        public int compare(Object profile1, Object profile2) {
            for (String key : this.keyList) {
                int value2;
                List<String> orderList = this.inputParamOrder.get(key);
                if (orderList == null || orderList.size() <= 0) continue;
                int value1 = orderList.indexOf(((Map)((KeyValuePair)profile1).getValue()).get(key));
                if (value1 > (value2 = orderList.indexOf(((Map)((KeyValuePair)profile2).getValue()).get(key)))) {
                    return 1;
                }
                if (value1 >= value2) continue;
                return -1;
            }
            String pid1 = (String)((KeyValuePair)profile1).getKey();
            String pid2 = (String)((KeyValuePair)profile2).getKey();
            return pid2.compareTo(pid1);
        }
    }
}

