/*
 * Decompiled with CFR 0.152.
 */
package com.exlibris.repository.persistence.digitalentity;

import com.exlibris.core.infra.model.annotation.Searchable;
import com.exlibris.core.infra.svc.api.entityLock.DpsLockable;
import com.exlibris.core.sdk.config.CoreConfigurationManager;
import com.exlibris.digitool.repository.api.xmlbeans.Md;
import com.exlibris.digitool.repository.conf.xmlbeans.Metadata;
import com.exlibris.repository.persistence.HOwneredEntity;
import java.io.UnsupportedEncodingException;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.Lob;
import javax.persistence.NamedNativeQueries;
import javax.persistence.NamedNativeQuery;
import javax.persistence.NamedQueries;
import javax.persistence.NamedQuery;
import javax.persistence.Table;
import javax.persistence.Transient;
import javax.persistence.UniqueConstraint;
import org.hibernate.annotations.Index;

@Entity
@Table(name="HDeMetadata", uniqueConstraints={@UniqueConstraint(columnNames={"external_system", "external_system_id"})})
@NamedQueries(value={@NamedQuery(name="findByPidAndMdId", query="select metadata from HDeMetadata as metadata, HDeControl as control, HDePidMid as pidmid where control.pid=pidmid.pid and pidmid.mid=metadata.mid and metadata.mdId = :mdId and control.pid = :pid"), @NamedQuery(name="GET_SHARED_METADATA_QUERY", query="from HDeMetadata where mdId in (11, 51, 72)"), @NamedQuery(name="SET_INDEX_XML", query="update HDeMetadata as metadata set indexXml = :indexXml where id = :id"), @NamedQuery(name="SET_VALUE_QUERY", query="update HDeMetadata as metadata set value = :value, modificationDate = :modificationDate where mid = :mid"), @NamedQuery(name="SET_VALUE_QUERY_WITH_MODIFIER", query="update HDeMetadata as metadata set value = :value, modificationDate = :modificationDate, modifiedBy = :modifiedBy where mid = :mid")})
@NamedNativeQueries(value={@NamedNativeQuery(name="seachMetadataByMdid", query="SELECT /*+ index(metadata HDEMETADATA_MDID) */ metadata.* FROM HDeMetadata metadata WHERE metadata.mdId = :mdId ORDER BY UPPER(metadata.description)", resultClass=HDeMetadata.class)})
public class HDeMetadata
extends HOwneredEntity
implements DpsLockable {
    public static final String SET_INDEX_XML_QUERY = "SET_INDEX_XML";
    public static final String SET_VALUE_QUERY = "SET_VALUE_QUERY";
    public static final String SET_VALUE_QUERY_WITH_MODIFIER = "SET_VALUE_QUERY_WITH_MODIFIER";
    public static final String GET_SHARED_METADATA_QUERY = "GET_SHARED_METADATA_QUERY";
    private static final long serialVersionUID = 1L;
    public static final String SEARCH_METADATA_BY_MDID = "seachMetadataByMdid";
    public static final String FIND_BY_PID_AND_MDID = "findByPidAndMdId";
    private static final int DESCRIPTION_MAX_LENGTH = 255;
    private String mid;
    private String description = "undefined";
    private int mdId;
    private String mdType;
    private String value;
    private String indexXml;
    private boolean isShared;
    private String externalSystem;
    private String externalSystemId;
    private int status = 0;

    public HDeMetadata() {
    }

    public HDeMetadata(HDeMetadata copy) {
        this();
        this.setMid(copy.getMid());
        this.setIsShared(copy.getIsShared());
        this.setMdId(copy.getMdId());
        this.setValue(copy.getValue());
        this.setDescription(copy.getDescription());
        this.setOwner(copy.getOwner());
        this.setCreator(copy.getCreator());
        this.setCreateDate(copy.getCreateDate());
        this.setStatus(copy.getStatus());
    }

    @Transient
    public boolean getIsShared() {
        return this.isShared;
    }

    public void setIsShared(boolean isShared) {
        this.isShared = isShared;
    }

    @Column
    @Searchable
    @Index(name="HDEMETADATA_MDID")
    public int getMdId() {
        return this.mdId;
    }

    public void setMdId(int mdId) {
        this.mdId = mdId;
    }

    @Transient
    public String getMdType() {
        return this.mdType;
    }

    public void setMdType(String mdType) {
        this.mdType = mdType;
    }

    @Column(name="status", columnDefinition="NUMBER DEFAULT 0")
    @Searchable
    public int getStatus() {
        return this.status;
    }

    public void setStatus(int status) {
        this.status = status;
    }

    @Lob
    @Column
    @Searchable
    public String getValue() {
        return this.value;
    }

    public void setValue(String value) {
        this.value = value;
    }

    public void setMd(String md) {
        this.setValue(md);
    }

    @Column(name="mid", nullable=false, unique=true)
    @Searchable
    public String getMid() {
        return this.mid;
    }

    public void setMid(String mid) {
        this.mid = mid;
    }

    @Column(length=255)
    @Searchable
    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        if (description != null) {
            try {
                int bLength = description.getBytes("UTF-8").length;
                while (description.length() > 0 && bLength > 255) {
                    float ratio = (float)bLength / (float)description.length();
                    int numCharsToCut = (int)Math.ceil((float)(bLength - 255) / ratio);
                    description = description.substring(0, description.length() - numCharsToCut);
                    bLength = description.getBytes("UTF-8").length;
                }
            }
            catch (UnsupportedEncodingException e) {
                System.out.println("UnsupportedEncodingException occurred in md.setDescription(): desc=" + description);
            }
        }
        this.description = description;
    }

    @Column(name="external_system", nullable=true)
    @Searchable
    public String getExternalSystem() {
        return this.externalSystem;
    }

    public void setExternalSystem(String externalSystem) {
        this.externalSystem = externalSystem;
    }

    @Column(name="external_system_id", nullable=true)
    @Searchable
    @Index(name="HDEMETADATA_ESI")
    public String getExternalSystemId() {
        return this.externalSystemId;
    }

    public void setExternalSystemId(String externalSystemId) {
        this.externalSystemId = externalSystemId;
    }

    @Column(name="index_xml")
    @Lob
    public String getIndexXml() {
        return this.indexXml;
    }

    public void setIndexXml(String indexXml) {
        this.indexXml = indexXml;
    }

    public void export(Md md) throws Exception {
        try {
            md.setValue(this.getValue());
        }
        catch (Exception e) {
            throw new RuntimeException("Error retriving metadata, Exception: " + e.getMessage() + " cause: " + e.getCause());
        }
        md.setMid(this.getMid());
        md.setDescription(this.getDescription());
        Metadata conf_md = CoreConfigurationManager.getInstance().getMetadataById(this.getMdId());
        md.setName(conf_md.getName());
        md.setType(conf_md.getType());
        md.setShared(this.isShared);
    }

    @Override
    @Transient
    public String getLockId() {
        return this.getId() + "";
    }

    @Override
    @Transient
    public String getLockType() {
        return "HDeMetadata";
    }

    public String toString() {
        return "HDeMetadata [mid=" + this.mid + ", mdId=" + this.mdId + ", owner=" + this.getOwner() + ", description=" + this.description + "]";
    }

    @Override
    public int hashCode() {
        int prime = 31;
        int result = super.hashCode();
        result = 31 * result + (this.mid == null ? 0 : this.mid.hashCode());
        result = 31 * result + (this.description == null ? 0 : this.description.hashCode());
        result = 31 * result + this.mdId;
        result = 31 * result + (this.value == null ? 0 : this.value.hashCode());
        result = 31 * result + (this.indexXml == null ? 0 : this.indexXml.hashCode());
        result = 31 * result + (this.isShared ? 1 : 0);
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!super.equals(obj)) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        HDeMetadata other = (HDeMetadata)obj;
        if (this.mid == null ? other.mid != null : !this.mid.equals(other.mid)) {
            return false;
        }
        if (this.description == null ? other.description != null : !this.description.equals(other.description)) {
            return false;
        }
        if (this.mdId != other.mdId) {
            return false;
        }
        if (this.value == null ? other.value != null : !this.value.equals(other.value)) {
            return false;
        }
        if (this.indexXml == null ? other.indexXml != null : !this.indexXml.equals(other.indexXml)) {
            return false;
        }
        return this.isShared == other.isShared;
    }
}

