/*
 * Decompiled with CFR 0.152.
 */
package com.exlibris.repository.persistence.rip;

import com.exlibris.core.infra.model.DividedDate;
import com.exlibris.core.infra.model.annotation.Searchable;
import java.io.Serializable;
import java.util.Calendar;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.EnumType;
import javax.persistence.Enumerated;
import javax.persistence.Id;
import javax.persistence.Lob;
import javax.persistence.NamedQueries;
import javax.persistence.NamedQuery;
import javax.persistence.Transient;
import org.hibernate.annotations.Index;

@Entity
@NamedQueries(value={@NamedQuery(name="findRipByStage", query="select rip from HrRipRegistry rip where rip.stage = :stage"), @NamedQuery(name="findRipByTypeAndTypeId", query="select rip from HrRipRegistry rip where rip.type = :type and rip.typeId = :typeId"), @NamedQuery(name="cleanFinishedRips", query="delete from HrRipRegistry rip where rip.lifeCycle = 'FINISHED' and rip.submitDate < to_date(:date,'DD-MON-YY')"), @NamedQuery(name="findMeditorRipByTypeId", query="select rip from HrRipRegistry rip where rip.type in('MEDITOR','PERM_VS')and rip.typeId = :typeId")})
public class HrRipRegistry
implements Serializable,
Comparable<HrRipRegistry> {
    private static final long serialVersionUID = -2741738692171078510L;
    private Long ripId;
    private Long jbpmProcessId;
    private Long processId;
    private LifeCycle lifeCycle;
    private String stage;
    private String handlingAgent;
    private String owner;
    private RipType type;
    private String typeId;
    private String importFolder;
    private Long validationId;
    private Long enrichmentId;
    private Calendar submitDate;
    private DividedDate submitDateDummy;
    private String creator;
    private String indexXml;
    private String repPid;

    public HrRipRegistry() {
        this.setSubmitDate(this.submitDate);
    }

    @Id
    @Searchable
    public Long getRipId() {
        return this.ripId;
    }

    public void setRipId(Long ripId) {
        this.ripId = ripId;
    }

    @Column
    @Index(name="RIP_REGISTRY_JBPM_PROCESS_ID")
    @Searchable
    public Long getJbpmProcessId() {
        return this.jbpmProcessId;
    }

    public void setJbpmProcessId(Long jbpmProcessId) {
        this.jbpmProcessId = jbpmProcessId;
    }

    @Column
    @Searchable
    public Long getProcessId() {
        if (this.processId == null) {
            return this.jbpmProcessId;
        }
        return this.processId;
    }

    public void setProcessId(Long processId) {
        this.processId = processId;
    }

    @Column
    @Enumerated(value=EnumType.STRING)
    @Searchable
    public LifeCycle getLifeCycle() {
        return this.lifeCycle;
    }

    public void setLifeCycle(LifeCycle lifeCycle) {
        this.lifeCycle = lifeCycle;
    }

    @Column
    @Searchable
    public String getStage() {
        return this.stage;
    }

    public void setStage(String stage) {
        this.stage = stage;
    }

    @Column
    @Searchable
    public String getHandlingAgent() {
        return this.handlingAgent;
    }

    public void setHandlingAgent(String handlingAgent) {
        this.handlingAgent = handlingAgent;
    }

    @Column
    public String getOwner() {
        return this.owner;
    }

    public void setOwner(String owner) {
        this.owner = owner;
    }

    @Column
    @Enumerated(value=EnumType.STRING)
    @Searchable
    @Index(name="RIP_REGISTRY_TYPE")
    public RipType getType() {
        return this.type;
    }

    public void setType(RipType type) {
        this.type = type;
    }

    @Transient
    public String getRipType() {
        return this.type.toString();
    }

    public void setRipType(String ripType) {
        this.type = RipType.valueOf(ripType);
    }

    @Column
    public String getTypeId() {
        return this.typeId;
    }

    public void setTypeId(String typeId) {
        this.typeId = typeId;
    }

    @Column
    public Long getValidationId() {
        return this.validationId;
    }

    public void setValidationId(Long validationId) {
        this.validationId = validationId;
    }

    @Column
    public Long getEnrichmentId() {
        return this.enrichmentId;
    }

    public void setEnrichmentId(Long enrichmentId) {
        this.enrichmentId = enrichmentId;
    }

    @Column
    public String getImportFolder() {
        return this.importFolder;
    }

    public void setImportFolder(String importFolder) {
        this.importFolder = importFolder;
    }

    @Column
    public Calendar getSubmitDate() {
        if (this.submitDate.getTimeInMillis() == 0L) {
            return null;
        }
        return this.submitDate;
    }

    public void setSubmitDate(Calendar submitDate) {
        this.submitDate = submitDate;
        this.submitDateDummy = new DividedDate(this.submitDate);
        this.submitDate = this.submitDateDummy.getCalendar();
    }

    @Transient
    public DividedDate getSubmitDateDummy() {
        return this.submitDateDummy;
    }

    public void setSubmitDateDummy(DividedDate submitDateDummy) {
        this.submitDateDummy = submitDateDummy;
    }

    @Column
    public String getCreator() {
        return this.creator;
    }

    public void setCreator(String creator) {
        this.creator = creator;
    }

    public String getRepPid() {
        return this.repPid;
    }

    public void setRepPid(String repPid) {
        this.repPid = repPid;
    }

    @Column(name="index_xml")
    @Lob
    public String getIndexXml() {
        return this.indexXml;
    }

    public void setIndexXml(String indexXml) {
        this.indexXml = indexXml;
    }

    @Override
    public int compareTo(HrRipRegistry o) {
        return this.ripId.compareTo(o.ripId);
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.ripId == null ? 0 : this.ripId.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        HrRipRegistry other = (HrRipRegistry)obj;
        return !(this.ripId == null ? other.ripId != null : !this.ripId.equals(other.ripId));
    }

    public static enum LifeCycle {
        WAITING,
        IN_RIP_PROCESSING,
        FINISHED;

    }

    public static enum RipType {
        MEDITOR,
        API,
        PRESERVATION_TEST,
        PRESERVATION_ACTION,
        PERM_VS,
        API_LOCK;

    }
}

