/*
 * Decompiled with CFR 0.152.
 */
package ch.docuteam.packer.gui.launcher;

import ch.docuteam.darc.sa.SubmissionAgreement;
import ch.docuteam.packer.gui.PackerConstants;
import ch.docuteam.packer.gui.launcher.LauncherView;
import ch.docuteam.tools.gui.GUIUtil;
import ch.docuteam.tools.gui.GridBagPanel;
import ch.docuteam.tools.translations.I18N;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.io.File;
import java.nio.file.Path;
import javax.swing.AbstractAction;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JTextField;
import javax.swing.KeyStroke;
import javax.swing.border.Border;
import javax.swing.border.EmptyBorder;
import javax.swing.filechooser.FileFilter;

public class CreateNewSIPFromCSVDialog
extends JDialog {
    private static final long serialVersionUID = 1L;
    private final LauncherView launcherView;
    protected JButton selectSourceFileButton;
    protected JTextField sourceFileTextField;
    protected JButton selectDestinationZIPOrFolderButton;
    protected JButton selectDestinationIsWorkspaceButton;
    protected JTextField destinationFolderTextField;
    protected JTextField destinationNameTextField;
    protected JCheckBox beZIPCheckBox;
    protected JComboBox saComboBox;
    protected JLabel messageLabel;
    protected JButton goButton;
    protected boolean goButtonWasClicked = false;

    protected CreateNewSIPFromCSVDialog(LauncherView owner) {
        super(owner, I18N.translate((String)"TitleCreateNewSIPFromCSV"), true);
        this.launcherView = owner;
        this.setIconImage(PackerConstants.getImage("DocuteamPacker.png"));
        this.setDefaultCloseOperation(2);
        this.getRootPane().registerKeyboardAction(new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                CreateNewSIPFromCSVDialog.this.close();
            }
        }, KeyStroke.getKeyStroke(27, 0), 2);
        this.selectSourceFileButton = new JButton(PackerConstants.getImageIcon("OpenFolder.png"));
        this.selectSourceFileButton.setName("SIP_SELECT_SOURCE_FILE_OR_FOLDER_BUTTON");
        this.selectSourceFileButton.setToolTipText(I18N.translate((String)"ToolTipSelectSourceFile"));
        this.selectSourceFileButton.addActionListener(e -> this.selectSourceFolderButtonClicked());
        this.sourceFileTextField = new JTextField(new File(this.launcherView.getDataDirectory()).getAbsolutePath());
        this.sourceFileTextField.setToolTipText(I18N.translate((String)"ToolTipSourceFile"));
        this.sourceFileTextField.addActionListener(e -> this.sourceFileTextFieldChanged());
        this.sourceFileTextField.addFocusListener(new FocusAdapter(){

            @Override
            public void focusLost(FocusEvent e) {
                CreateNewSIPFromCSVDialog.this.sourceFileTextFieldChanged();
            }
        });
        this.selectDestinationZIPOrFolderButton = new JButton(PackerConstants.getImageIcon("OpenFolder.png"));
        this.selectDestinationZIPOrFolderButton.setToolTipText(I18N.translate((String)"ToolTipSelectDestinationFolder"));
        this.selectDestinationZIPOrFolderButton.addActionListener(e -> this.selectDestinationFolderButtonClicked());
        this.selectDestinationIsWorkspaceButton = new JButton(PackerConstants.getImageIcon("Workspace.png"));
        this.selectDestinationIsWorkspaceButton.setName("SIP_SELECT_DESTINATION_IS_WORKSPACE_BUTTON");
        this.selectDestinationIsWorkspaceButton.setToolTipText(I18N.translate((String)"ToolTipSelectDestinationIsWorkspaceFolder"));
        this.selectDestinationIsWorkspaceButton.addActionListener(e -> this.selectDestinationIsWorkspaceButtonClicked());
        this.destinationFolderTextField = new JTextField(new File(this.launcherView.getLastUsedOpenOrSaveDirectory()).getAbsolutePath());
        this.destinationFolderTextField.setToolTipText(I18N.translate((String)"ToolTipDestinationFolder"));
        this.destinationFolderTextField.addFocusListener(new FocusAdapter(){

            @Override
            public void focusLost(FocusEvent e) {
                CreateNewSIPFromCSVDialog.this.destinationFolderTextField.setText(CreateNewSIPFromCSVDialog.this.destinationFolderTextField.getText().trim());
            }
        });
        this.destinationNameTextField = new JTextField(new File(this.launcherView.getDataDirectory()).getName());
        this.destinationNameTextField.setName("SIP_DESTINATION_NAME_TEXT_FIELD");
        this.destinationNameTextField.setToolTipText(I18N.translate((String)"ToolTipDestinationName"));
        this.destinationNameTextField.addFocusListener(new FocusAdapter(){

            @Override
            public void focusLost(FocusEvent e) {
                CreateNewSIPFromCSVDialog.this.destinationNameTextField.setText(CreateNewSIPFromCSVDialog.this.destinationNameTextField.getText().trim());
            }
        });
        this.beZIPCheckBox = new JCheckBox("ZIP", this.launcherView.isNewSIPZippedByDefault());
        this.beZIPCheckBox.setToolTipText(I18N.translate((String)"ToolTipBeZIP"));
        this.saComboBox = new JComboBox<Object>(SubmissionAgreement.getAllFinalOverviews().toArray());
        this.saComboBox.setToolTipText(I18N.translate((String)"ToolTipSelectSA"));
        this.messageLabel = new JLabel();
        this.goButton = new JButton(PackerConstants.getImageIcon("Save.png"));
        this.goButton.setToolTipText(I18N.translate((String)"ToolTipCreateNew"));
        this.goButton.addActionListener(e -> this.goButtonClicked());
        GridBagPanel gridBag = new GridBagPanel((Border)new EmptyBorder(10, 10, 10, 10), new Insets(0, 5, 0, 0));
        gridBag.add((Component)new JLabel(I18N.translate((String)"LabelNewSIPSourceFile")), 1, 1, 13);
        gridBag.add((Component)this.selectSourceFileButton, 1, 3);
        gridBag.add((Component)this.sourceFileTextField, 1, 1, 4, 6, 17, 2, 1.0, 0.0);
        gridBag.add((Component)new JLabel(" "), 2, 2);
        gridBag.add((Component)new JLabel(I18N.translate((String)"LabelNewSIPDestination")), 3, 1, 13);
        gridBag.add((Component)this.selectDestinationIsWorkspaceButton, 3, 2);
        gridBag.add((Component)this.selectDestinationZIPOrFolderButton, 3, 3);
        gridBag.add((Component)this.destinationFolderTextField, 3, 4, 17, 2, 2.0, 0.0);
        gridBag.add((Component)this.destinationNameTextField, 3, 5, 17, 2, 1.0, 0.0);
        gridBag.add((Component)this.beZIPCheckBox, 3, 6);
        gridBag.add((Component)new JLabel(I18N.translate((String)"LabelNewSIPSA")), 4, 1, 13);
        gridBag.add((Component)this.saComboBox, 4, 4, 4, 6, 17, 2, 1.0, 0.0);
        gridBag.add((Component)this.messageLabel, 6, 6, 0, 5, 13, 2, 1.0, 0.0);
        gridBag.add((Component)this.goButton, 6, 6, 13);
        this.add((Component)gridBag);
        this.setPreferredSize(new Dimension(800, 190));
        this.pack();
        this.setLocationRelativeTo(owner);
        this.setVisible(true);
    }

    protected void selectSourceFolderButtonClicked() {
        JFileChooser fileChooser = new JFileChooser(this.sourceFileTextField.getText());
        fileChooser.setName("SIP_SELECT_SOURCE_FOLDER_FILE_CHOOSER");
        fileChooser.setFileSelectionMode(0);
        fileChooser.setFileFilter(new FileFilter(){

            @Override
            public boolean accept(File file) {
                return file.getName().toLowerCase().endsWith(".csv");
            }

            @Override
            public String getDescription() {
                return "CSV files";
            }
        });
        fileChooser.setDialogTitle(I18N.translate((String)"TitleSelectSourceFile"));
        fileChooser.setMultiSelectionEnabled(false);
        int result = fileChooser.showOpenDialog(this);
        if (result == 1) {
            return;
        }
        this.sourceFileTextField.setText(fileChooser.getSelectedFile().getPath());
        this.sourceFileTextFieldChanged();
    }

    protected void sourceFileTextFieldChanged() {
        String sourceFileText = this.sourceFileTextField.getText().trim();
        this.sourceFileTextField.setText(sourceFileText);
        String sourceFileName = new File(sourceFileText).getName();
        this.destinationNameTextField.setText(sourceFileName.substring(0, sourceFileName.lastIndexOf(46)));
    }

    protected void selectDestinationFolderButtonClicked() {
        JFileChooser fileChooser = new JFileChooser(this.destinationFolderTextField.getText());
        fileChooser.setFileSelectionMode(1);
        fileChooser.setDialogTitle(I18N.translate((String)"TitleSelectDestinationFolder"));
        fileChooser.setMultiSelectionEnabled(false);
        int result = fileChooser.showSaveDialog(this);
        if (result == 1) {
            return;
        }
        this.destinationFolderTextField.setText(fileChooser.getSelectedFile().getPath());
    }

    protected void selectDestinationIsWorkspaceButtonClicked() {
        this.destinationFolderTextField.setText(this.launcherView.getSipDirectory());
    }

    protected void goButtonClicked() {
        File destinationFile;
        String sourceFileOrFolder = this.sourceFileTextField.getText();
        String destinationFolder = this.destinationFolderTextField.getText();
        Object destinationName = this.destinationNameTextField.getText();
        if (((String)destinationName).isEmpty()) {
            GUIUtil.shake((Window)this);
            this.messageLabel.setText(I18N.translate((String)"MessageDestinationNameIsEmpty"));
            return;
        }
        if (sourceFileOrFolder.isEmpty()) {
            GUIUtil.shake((Window)this);
            this.messageLabel.setText(I18N.translate((String)"MessageSourceFileOrFolderIsEmpty"));
            return;
        }
        if (!new File(this.sourceFileTextField.getText()).isFile()) {
            this.messageLabel.setText(I18N.translate((String)"MessageSourceFileDoesNotExist"));
            return;
        }
        if (this.beZIPCheckBox.isSelected()) {
            if (!((String)destinationName).toLowerCase().endsWith(".zip")) {
                destinationName = (String)destinationName + ".zip";
            }
        } else if (((String)destinationName).toLowerCase().endsWith(".zip")) {
            destinationName = ((String)destinationName).substring(0, ((String)destinationName).length() - ".zip".length());
        }
        if ((destinationFile = Path.of(destinationFolder, new String[]{destinationName}).toFile()).exists()) {
            GUIUtil.shake((Window)this);
            this.messageLabel.setText(I18N.translate((String)"MessageSIPExistsAlready"));
            return;
        }
        this.launcherView.setDataDirectory(sourceFileOrFolder);
        this.launcherView.setLastUsedOpenOrSaveDirectory(destinationFolder);
        this.goButtonWasClicked = true;
        this.close();
    }

    protected void close() {
        this.setVisible(false);
        this.dispose();
    }
}

