/*
 * Decompiled with CFR 0.152.
 */
package org.icepdf.core.pobjects.acroform;

import java.util.HashMap;
import org.icepdf.core.pobjects.acroform.VariableTextFieldDictionary;
import org.icepdf.core.util.Library;

public class ButtonFieldDictionary
extends VariableTextFieldDictionary {
    public static final int NO_TOGGLE_TO_OFF_BIT_FLAG = 16384;
    public static final int RADIO_BIT_FLAG = 32768;
    public static final int PUSH_BUTTON_BIT_FLAG = 65536;
    public static final int RADIO_IN_UNISON_BIT_FLAG = 0x1000000;
    protected ButtonFieldType buttonFieldType;

    public ButtonFieldDictionary(Library library, HashMap entries) {
        super(library, entries);
    }

    public boolean isNoToggleToOff() {
        return (this.getFlags() & 0x4000) == 16384;
    }

    public boolean isRadioButton() {
        return (this.getFlags() & 0x8000) == 32768;
    }

    public boolean isPushButton() {
        return (this.getFlags() & 0x10000) == 65536;
    }

    public boolean isRadioInUnison() {
        return (this.getFlags() & 0x1000000) == 0x1000000;
    }

    public ButtonFieldType getButtonFieldType() {
        this.buttonFieldType = (this.getFlags() & 0x10000) == 65536 ? ButtonFieldType.PUSH_BUTTON : (this.isRadioButton() ? ButtonFieldType.RADIO_BUTTON : ButtonFieldType.CHECK_BUTTON);
        return this.buttonFieldType;
    }

    public void setButtonFieldType(ButtonFieldType buttonFieldType) {
        this.buttonFieldType = buttonFieldType;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum ButtonFieldType {
        PUSH_BUTTON,
        RADIO_BUTTON,
        CHECK_BUTTON;

    }
}

