/*
 * Decompiled with CFR 0.152.
 */
package com.twelvemonkeys.contrib.exif;

import com.twelvemonkeys.contrib.exif.Orientation;
import com.twelvemonkeys.contrib.tiff.TIFFUtilities;
import com.twelvemonkeys.image.ImageUtil;
import com.twelvemonkeys.imageio.ImageReaderBase;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.Iterator;
import javax.imageio.IIOImage;
import javax.imageio.ImageIO;
import javax.imageio.ImageReader;
import javax.imageio.metadata.IIOMetadata;
import javax.imageio.metadata.IIOMetadataNode;
import javax.imageio.stream.ImageInputStream;
import org.w3c.dom.NodeList;

public class EXIFUtilities {
    public static IIOImage readWithOrientation(URL uRL) throws IOException {
        try (ImageInputStream imageInputStream = ImageIO.createImageInputStream(uRL);){
            IIOImage iIOImage = EXIFUtilities.readWithOrientation(imageInputStream);
            return iIOImage;
        }
    }

    public static IIOImage readWithOrientation(InputStream inputStream) throws IOException {
        try (ImageInputStream imageInputStream = ImageIO.createImageInputStream(inputStream);){
            IIOImage iIOImage = EXIFUtilities.readWithOrientation(imageInputStream);
            return iIOImage;
        }
    }

    public static IIOImage readWithOrientation(File file) throws IOException {
        try (ImageInputStream imageInputStream = ImageIO.createImageInputStream(file);){
            IIOImage iIOImage = EXIFUtilities.readWithOrientation(imageInputStream);
            return iIOImage;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static IIOImage readWithOrientation(ImageInputStream imageInputStream) throws IOException {
        Iterator<ImageReader> iterator = ImageIO.getImageReaders(imageInputStream);
        if (!iterator.hasNext()) {
            return null;
        }
        ImageReader imageReader = iterator.next();
        try {
            imageReader.setInput(imageInputStream, true, false);
            IIOMetadata iIOMetadata = imageReader.getImageMetadata(0);
            BufferedImage bufferedImage = TIFFUtilities.applyOrientation(imageReader.read(0), EXIFUtilities.findImageOrientation(iIOMetadata).value());
            IIOImage iIOImage = new IIOImage(bufferedImage, null, iIOMetadata);
            return iIOImage;
        }
        finally {
            imageReader.dispose();
        }
    }

    public static Orientation findImageOrientation(IIOMetadata iIOMetadata) {
        IIOMetadataNode iIOMetadataNode;
        NodeList nodeList;
        if (iIOMetadata != null && (nodeList = (iIOMetadataNode = (IIOMetadataNode)iIOMetadata.getAsTree("javax_imageio_1.0")).getElementsByTagName("ImageOrientation")) != null && nodeList.getLength() > 0) {
            IIOMetadataNode iIOMetadataNode2 = (IIOMetadataNode)nodeList.item(0);
            return Orientation.fromMetadataOrientation(iIOMetadataNode2.getAttribute("value"));
        }
        return Orientation.Normal;
    }

    public static void main(String[] stringArray) throws IOException {
        for (String string : stringArray) {
            File file = new File(string);
            IIOImage iIOImage = EXIFUtilities.readWithOrientation(file);
            if (iIOImage == null) {
                System.err.printf("No reader for %s%n", file);
                continue;
            }
            Orientation orientation = EXIFUtilities.findImageOrientation(iIOImage.getMetadata());
            BufferedImage bufferedImage = ImageUtil.toBuffered((RenderedImage)iIOImage.getRenderedImage());
            DisplayHelper.showIt(bufferedImage, file.getName() + ": " + orientation.name() + "/" + orientation.value());
        }
    }

    static abstract class DisplayHelper
    extends ImageReaderBase {
        private DisplayHelper() {
            super(null);
        }

        protected static void showIt(BufferedImage bufferedImage, String string) {
            ImageReaderBase.showIt((BufferedImage)bufferedImage, (String)string);
        }
    }
}

