/*
 * Decompiled with CFR 0.152.
 */
package ch.docuteam.darc.common;

import ch.docuteam.darc.common.DocumentAbstract;
import ch.docuteam.darc.util.XMLUtil;
import ch.docuteam.tools.exception.Exception;
import java.util.ArrayList;
import java.util.List;
import org.dom4j.Element;
import org.dom4j.Node;
import org.dom4j.tree.DefaultElement;

public abstract class NodeAbstract {
    protected DocumentAbstract document;
    protected NodeAbstract parent;
    protected Element element;
    protected String id;

    public DocumentAbstract getDocument() {
        return this.document;
    }

    public NodeAbstract getParent() {
        return this.parent;
    }

    public Element getElement() {
        return this.element;
    }

    public String getId() {
        return this.id;
    }

    public String getElementText(String xPath, Boolean isMandatory) {
        Node subNode = this.element.selectSingleNode(xPath);
        if (isMandatory.booleanValue() && subNode == null) {
            Exception.remember((String)("Mandatory element missing in File: '" + this.document.getName() + "':\n\t'" + xPath + "'\nin location: '" + this.element.getPath() + "'\nID: " + this.id));
        }
        return subNode == null ? "" : subNode.getText();
    }

    protected void setId(String id) {
        this.id = id;
        this.element.addAttribute("ID", this.id);
    }

    protected List<String> getDynamicElementTexts(String xPath) {
        List nodes = this.element.selectNodes(xPath);
        if (nodes.isEmpty()) {
            return null;
        }
        ArrayList<String> results = new ArrayList<String>(nodes.size());
        for (Node node : nodes) {
            if (node.selectNodes("EAD:lb").size() > 0) {
                List children = node.selectNodes("node()");
                StringBuilder builder = new StringBuilder();
                for (int i = 0; i < children.size(); ++i) {
                    Node child = (Node)children.get(i);
                    builder = child instanceof DefaultElement && ((DefaultElement)child).getQualifiedName().equals("EAD:lb") ? builder.append("\n") : builder.append(child.getText().trim());
                }
                results.add(builder.toString());
                continue;
            }
            results.add(node.getText().trim());
        }
        return results;
    }

    protected void setDynamicElementTexts(List<String> values, String xPath) {
        XMLUtil.set(this.element, xPath, values);
    }
}

