/*
 * Decompiled with CFR 0.152.
 */
package edu.harvard.hul.ois.jhove.module.tiff;

import edu.harvard.hul.ois.jhove.ByteArrayXMPSource;
import edu.harvard.hul.ois.jhove.InfoMessage;
import edu.harvard.hul.ois.jhove.Message;
import edu.harvard.hul.ois.jhove.NisoImageMetadata;
import edu.harvard.hul.ois.jhove.Property;
import edu.harvard.hul.ois.jhove.PropertyArity;
import edu.harvard.hul.ois.jhove.PropertyType;
import edu.harvard.hul.ois.jhove.Rational;
import edu.harvard.hul.ois.jhove.RepInfo;
import edu.harvard.hul.ois.jhove.XMPHandler;
import edu.harvard.hul.ois.jhove.module.tiff.ExifIFD;
import edu.harvard.hul.ois.jhove.module.tiff.GPSInfoIFD;
import edu.harvard.hul.ois.jhove.module.tiff.GeoTiffStrings;
import edu.harvard.hul.ois.jhove.module.tiff.GlobalParametersIFD;
import edu.harvard.hul.ois.jhove.module.tiff.IFD;
import edu.harvard.hul.ois.jhove.module.tiff.InteroperabilityIFD;
import edu.harvard.hul.ois.jhove.module.tiff.TiffException;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.io.UnsupportedEncodingException;
import java.util.LinkedList;
import java.util.List;
import javax.xml.parsers.SAXParserFactory;
import org.xml.sax.ContentHandler;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.XMLReader;

public class TiffIFD
extends IFD {
    public static final int NEWSUBFILETYPE = 254;
    public static final int SUBFILETYPE = 255;
    public static final int IMAGEWIDTH = 256;
    public static final int IMAGELENGTH = 257;
    public static final int BITSPERSAMPLE = 258;
    public static final int COMPRESSION = 259;
    public static final int PHOTOMETRICINTERPRETATION = 262;
    public static final int THRESHHOLDING = 263;
    public static final int CELLWIDTH = 264;
    public static final int CELLLENGTH = 265;
    public static final int FILLORDER = 266;
    public static final int DOCUMENTNAME = 269;
    public static final int IMAGEDESCRIPTION = 270;
    public static final int MAKE = 271;
    public static final int MODEL = 272;
    public static final int STRIPOFFSETS = 273;
    public static final int ORIENTATION = 274;
    public static final int SAMPLESPERPIXEL = 277;
    public static final int ROWSPERSTRIP = 278;
    public static final int STRIPBYTECOUNTS = 279;
    public static final int MINSAMPLEVALUE = 280;
    public static final int MAXSAMPLEVALUE = 281;
    public static final int XRESOLUTION = 282;
    public static final int YRESOLUTION = 283;
    public static final int PLANARCONFIGURATION = 284;
    public static final int PAGENAME = 285;
    public static final int XPOSITION = 286;
    public static final int YPOSITION = 287;
    public static final int FREEOFFSETS = 288;
    public static final int FREEBYTECOUNTS = 289;
    public static final int GRAYRESPONSEUNIT = 290;
    public static final int GRAYRESPONSECURVE = 291;
    public static final int T4OPTIONS = 292;
    public static final int T6OPTIONS = 293;
    public static final int RESOLUTIONUNIT = 296;
    public static final int PAGENUMBER = 297;
    public static final int TRANSFERFUNCTION = 301;
    public static final int SOFTWARE = 305;
    public static final int DATETIME = 306;
    public static final int ARTIST = 315;
    public static final int HOSTCOMPUTER = 316;
    public static final int PREDICTOR = 317;
    public static final int WHITEPOINT = 318;
    public static final int PRIMARYCHROMATICITIES = 319;
    public static final int COLORMAP = 320;
    public static final int HALFTONEHINTS = 321;
    public static final int TILEWIDTH = 322;
    public static final int TILELENGTH = 323;
    public static final int TILEOFFSETS = 324;
    public static final int TILEBYTECOUNTS = 325;
    public static final int INKSET = 332;
    public static final int INKNAMES = 333;
    public static final int NUMBEROFINKS = 334;
    public static final int DOTRANGE = 336;
    public static final int TARGETPRINTER = 337;
    public static final int EXTRASAMPLES = 338;
    public static final int SAMPLEFORMAT = 339;
    public static final int SMINSAMPLEVALUE = 340;
    public static final int SMAXSAMPLEVALUE = 341;
    public static final int TRANSFERRANGE = 342;
    public static final int JPEGPROC = 512;
    public static final int JPEGINTERCHANGEFORMAT = 513;
    public static final int JPEGINTERCHANGEFORMATLENGTH = 514;
    public static final int JPEGRESTARTINTERVAL = 515;
    public static final int JPEGLOSSLESSPREDICTORS = 517;
    public static final int JPEGPOINTTRANSFORMS = 518;
    public static final int JPEGQTABLES = 519;
    public static final int JPEGDCTABLES = 520;
    public static final int JPEGACTABLES = 521;
    public static final int YCBCRCOEFFICIENTS = 529;
    public static final int YCBCRSUBSAMPLING = 530;
    public static final int YCBCRPOSITIONING = 531;
    public static final int REFERENCEBLACKWHITE = 532;
    public static final int COPYRIGHT = 33432;
    private static final String[] FILLORDER_L = new String[]{"", "high-order", "low-order"};
    private static final String[] INDEXED_L = new String[]{"not indexed", "indexed"};
    private static final String[] INKSET_L = new String[]{"", "CMYK", "not CMYK"};
    private static final String[] JPEGLOSSLESSPREDICTORS_L = new String[]{"", "A", "B", "C", "A+B+C", "A+((B-C)/2)", "B+((A-C)/2)", "(A+B)/2"};
    private static final String[] JPEGPROC_L = new String[]{"baseline sequential process", "lossless process with Huffman coding"};
    private static final int[] JPEGPROC_INDEX = new int[]{1, 14};
    private static final String[] NEWSUBFILETYPE_L = new String[]{"reduced-resolution image of another image in this file", "single page of multi-page image", "transparency mask for another image in this file"};
    private static final String[] OPIPROXY_L = new String[]{"no higher-resolution version exists", "higher-resolution version exists"};
    private static final String[] PREDICTOR_L = new String[]{"", "no prediction scheme", "horizontal differencing"};
    private static final String[] SAMPLEFORMAT_L = new String[]{"", "unsigned integer", "signed integer", "IEEE floating point", "undefined"};
    private static final String[] SUBFILETYPE_L = new String[]{"", "full-resolution image", "reduced-resolution image", "single page of multi-page image"};
    private static final String[] THRESHHOLDING_L = new String[]{"", "no dithering or halftoning", "ordered dithering or halftoning", "randomized process"};
    private static final String[] YCBCRPOSITIONING_L = new String[]{"", "centered", "cosited"};
    private static final String[] YCBCRSUBSAMPLING_HORZ = new String[]{"", "width of chroma image is equal to width of associated luma image", "width of chroma image is 1/2 the width of associated luma image", "", "width of chroma image is 1/4 the width of associated luma image"};
    private static final String[] YCBCRSUBSAMPLING_VERT = new String[]{"", "length of chroma image is equal to length of associated luma image", "length of chroma image is 1/2 the length of associated luma image", "", "length of chroma image is 1/4 the length of associated luma image"};
    private static final int SITE = 34016;
    private static final int COLORSEQUENCE = 34017;
    private static final int IT8HEADER = 34018;
    private static final int RASTERPADDING = 34019;
    private static final int BITSPERRUNLENGTH = 34020;
    private static final int BITSPEREXTENDEDRUNLENGTH = 34021;
    private static final int COLORTABLE = 34022;
    private static final int IMAGECOLORINDICATOR = 34023;
    private static final int BACKGROUNDCOLORINDICATOR = 34024;
    private static final int IMAGECOLORVALUE = 34025;
    private static final int BACKGROUNDCOLORVALUE = 34026;
    private static final int PIXELINTENSITYRANGE = 34027;
    private static final int TRANSPARENCYINDICATOR = 34028;
    private static final int COLORCHARACTERIZATION = 34029;
    private static final int HCUSAGE = 34030;
    public static final String[] BACKGROUNDCOLORINDICATOR_L = new String[]{"background not defined", "Background color defined", "full transparency, background color not defined"};
    public static final String[] HCUSAGE_L = new String[]{"high resolution CT contone information", "line art (line work) information", "trapping information"};
    public static final String[] IMAGECOLORINDICATOR_L = new String[]{"image not defined", "image color defined", "full transparency, image color not defined"};
    private static final String[] RASTERPADDING_L = new String[]{"1 byte", "2 bytes", "4 bytes", "512 bytes", "1024 bytes"};
    private static final int[] RASTERPADDING_INDEX = new int[]{0, 1, 2, 9, 10};
    public static final String[] TRANSPARENCYINDICATOR_L = new String[]{"no transparency", "transparency used"};
    private static final int CFAREPEATPATTERNDIM = 33421;
    private static final int CFAPATTERN = 33422;
    private static final int BATTERYLEVEL = 33423;
    private static final int EXPOSURETIME = 33434;
    private static final int FNUMBER = 33437;
    private static final int IPTCNAA = 33723;
    private static final int ICC_PROFILE = 34675;
    private static final int EXPOSUREPROGRAM = 34850;
    private static final int SPECTRALSENSITIVITY = 34852;
    private static final int ISOSPEEDRATINGS = 34855;
    private static final int OECF = 34856;
    private static final int INTERLACE = 34857;
    private static final int TIMEZONEOFFSET = 34858;
    private static final int SELFTIMERMODE = 34859;
    private static final int DATETIMEORIGINAL = 36867;
    private static final int COMPRESSEDBITSPERPIXEL = 37122;
    private static final int SHUTTERSPEEDVALUE = 37377;
    private static final int APERTUREVALUE = 37378;
    private static final int BRIGHTNESSVALUE = 37379;
    private static final int EXPOSUREBIASVALUE = 37380;
    private static final int MAXAPERTUREVALUE = 37381;
    private static final int SUBJECTDISTANCE = 37382;
    private static final int METERINGMODE = 37383;
    private static final int LIGHTSOURCE = 37384;
    private static final int FLASH = 37385;
    private static final int FOCALLENGTH = 37386;
    private static final int FLASHENERGY = 37387;
    private static final int SPATIALFREQUENCYRESPONSE = 37388;
    private static final int NOISE = 37389;
    private static final int FOCALPLANEXRESOLUTION = 37390;
    private static final int FOCALPLANEYRESOLUTION = 37391;
    private static final int FOCALPLANERESOLUTIONUNIT = 37392;
    private static final int IMAGENUMBER = 37393;
    private static final int SECURITYCLASSIFICATION = 37394;
    private static final int IMAGEHISTORY = 37395;
    private static final int SUBJECTLOCATION = 37396;
    private static final int EXPOSUREINDEX = 37397;
    private static final int TIFFEPSTANDARDID = 37398;
    private static final int SENSINGMETHOD = 37399;
    private static final String[] EXPOSUREPROGRAM_L = new String[]{"unidentified", "manual", "program normal", "aperature priority", "shutter priority", "program creative", "program action", "portrait mode", "landscape mode"};
    private static final String[] FLASH_L = new String[]{"did not fire", "fired", "fired, return not sensed", "fired, return sensed", "fired, fill flash mode, camera has no flash return sensing capability", "fired, fill flash mode, return not sensed", "fired, fill flash mode, return sensed", "did not fire, flash 'off' mode", "did not fire, 'auto' mode", "fired, 'auto' mode, camera has no flash return sensing capability", "fired, 'auto' mode, return not sensed", "fired, 'auto' mode, return sensed", "camera does not have a flash unit"};
    private static final int[] FLASH_INDEX = new int[]{0, 1, 5, 7, 9, 13, 15, 16, 24, 25, 29, 31, 32};
    private static final String[] FOCALPLANERESOLUTIONUNIT_L = new String[]{"", "inch", "metre", "centimetre", "millimetre", "micrometre"};
    private static final int EXIFIFD = 34665;
    private static final int GPSINFOIFD = 34853;
    private static final int INTEROPERABILITYIFD = 40965;
    private static final int GEOKEYDIRECTORYTAG = 34735;
    private static final int GEODOUBLEPARAMSTAG = 34736;
    private static final int GEOASCIIPARAMSTAG = 34737;
    private static final int MODELTIEPOINTTAG = 33922;
    private static final int MODELPIXELSCALETAG = 33550;
    private static final int MODELTRANSFORMATIONTAG = 34264;
    public static final int GTMODELTYPEGEOKEY = 1024;
    public static final int GTRASTERTYPEGEOKEY = 1025;
    public static final int GTCITATIONGEOKEY = 1026;
    public static final int GEOGRAPHICTYPEGEOKEY = 2048;
    public static final int GEOGCITATIONGEOKEY = 2049;
    public static final int GEOGGEODETICDATUMGEOKEY = 2050;
    public static final int GEOGPRIMEMERIDIANGEOKEY = 2051;
    public static final int GEOGLINEARUNITSGEOKEY = 2052;
    public static final int GEOGLINEARUNITSIZEGEOKEY = 2053;
    public static final int GEOGANGULARUNITSGEOKEY = 2054;
    public static final int GEOGANGULARUNITSIZEGEOKEY = 2055;
    public static final int GEOGELLIPSOIDGEOKEY = 2056;
    public static final int GEOGSEMIMAJORAXISGEOKEY = 2057;
    public static final int GEOGSEMIMINORAXISGEOKEY = 2058;
    public static final int GEOGINVFLATTENINGGEOKEY = 2059;
    public static final int GEOGAZIMUTHUNITSGEOKEY = 2060;
    public static final int GEOGPRIMEMERIDIANLONGGEOKEY = 2061;
    public static final int PROJECTEDCSTYPEGEOKEY = 3072;
    public static final int PCSCITATIONGEOKEY = 3073;
    public static final int PROJECTIONGEOKEY = 3074;
    public static final int PROJCOORDTRANSGEOKEY = 3075;
    public static final int PROJLINEARUNITSGEOKEY = 3076;
    public static final int PROJLINEARUNITSIZEGEOKEY = 3077;
    public static final int PROJSTDPARALLEL1GEOKEY = 3078;
    public static final int PROJSTDPARALLEL2GEOKEY = 3079;
    public static final int PROJNATORIGINLONGGEOKEY = 3080;
    public static final int PROJNATORIGINLATGEOKEY = 3081;
    public static final int PROJFALSEEASTINGGEOKEY = 3082;
    public static final int PROJFALSENORTHINGGEOKEY = 3083;
    public static final int PROJFALSEORIGINLONGGEOKEY = 3084;
    public static final int PROJFALSEORIGINLATGEOKEY = 3085;
    public static final int PROJFALSEORIGINEASTINGGEOKEY = 3086;
    public static final int PROJFALSEORIGINNORTHINGGEOKEY = 3087;
    public static final int PROJCENTERLONGGEOKEY = 3088;
    public static final int PROJCENTERLATGEOKEY = 3089;
    public static final int PROJCENTEREASTINGGEOKEY = 3090;
    public static final int PROJFALSEORIGINNORTHINGGEOKEY_2 = 3091;
    public static final int PROJSCALEATNATORIGINGEOKEY = 3092;
    public static final int PROJSCALEATCENTERGEOKEY = 3093;
    public static final int PROJAZIMUTHANGLEGEOKEY = 3094;
    public static final int PROJSTRAIGHTVERTPOLELONGEOKEY = 3095;
    public static final int VERTICALCSTYPEGEOKEY = 4096;
    public static final int VERTICALCITATIONGEOKEY = 4097;
    public static final int VERTICALDATUMGEOKEY = 4098;
    public static final int VERTICALUNITSGEOKEY = 4099;
    private static final int SUBIFDS = 330;
    private static final int CLIPPATH = 343;
    private static final int XCLIPPATHUNITS = 344;
    private static final int YCLIPPATHUNITS = 345;
    private static final int INDEXED = 346;
    private static final int OPIPROXY = 351;
    private static final int IMAGEID = 32781;
    private static final int JPEGTABLES = 347;
    private static final int IMAGESOURCEDATA = 37724;
    private static final int PHOTOSHOPPROPS = 34377;
    private static final int ANNOTATIONS = 50255;
    private static final int BADFAXLINES = 326;
    private static final int CLEANFAXDATA = 327;
    private static final int CONSECUTIVEBADFAXLINES = 328;
    private static final int XMP = 700;
    private static final int GLOBALPARAMETERSIFD = 400;
    private static final int STRIPROWCOUNTS = 559;
    private static final int IMAGELAYER = 34732;
    public static final String[] IMAGELAYER_L = new String[]{"", "Background", "Mask", "Foreground"};
    private static final int DNGVERSION = 50706;
    private static final int DNGBACKWARDVERSION = 50707;
    private static final int UNIQUECAMERAMODEL = 50708;
    private static final int LOCALIZEDCAMERAMODEL = 50709;
    private static final int CFAPLANECOLOR = 50710;
    private static final int CFALAYOUT = 50711;
    private static final int LINEARIZATIONTABLE = 50712;
    private static final int BLACKLEVELREPEATDIM = 50713;
    private static final int BLACKLEVEL = 50714;
    private static final int BLACKLEVELDELTAH = 50715;
    private static final int BLACKLEVELDELTAV = 50716;
    private static final int WHITELEVEL = 50717;
    private static final int DEFAULTSCALE = 50718;
    private static final int DEFAULTCROPORIGIN = 50719;
    private static final int DEFAULTCROPSIZE = 50720;
    private static final int COLORMATRIX1 = 50721;
    private static final int COLORMATRIX2 = 50722;
    private static final int CAMERACALIBRATION1 = 50723;
    private static final int CAMERACALIBRATION2 = 50724;
    private static final int REDUCTIONMATRIX1 = 50725;
    private static final int REDUCTIONMATRIX2 = 50726;
    private static final int ANALOGBALANCE = 50727;
    private static final int ASSHOTNEUTRAL = 50728;
    private static final int ASSHOTWHITEXY = 50729;
    private static final int BASELINEEXPOSURE = 50730;
    private static final int BASELINENOISE = 50731;
    private static final int BASELINESHARPNESS = 50732;
    private static final int BAYERGREENSPLIT = 50733;
    private static final int LINEARRESPONSELIMIT = 50734;
    private static final int CAMERASERIALNUMBER = 50735;
    private static final int LENSINFO = 50736;
    private static final int CHROMABLURRADIUS = 50737;
    private static final int ANTIALIASSTRENGTH = 50738;
    private static final int SHADOWSCALE = 50739;
    private static final int DNGPRIVATEDATA = 50740;
    private static final int MAKERNOTESAFETY = 50741;
    private static final int CALIBRATIONILLUMINANT1 = 50778;
    private static final int CALIBRATIONILLUMINANT2 = 50779;
    private static final int BESTQUALITYSCALE = 50780;
    public static final String[] CFALAYOUT_L = new String[]{"", "Rectangular", "Staggered Layout A", "Staggered Layout B", "Staggered Layout C", "Staggered Layout D"};
    public static final String[] MAKERNOTESAFETY_L = new String[]{"Unsafe", "Safe"};
    private NisoImageMetadata _niso = new NisoImageMetadata();
    private long _newSubfileType;
    private int _subfileType;
    private int _photometricInterpretation;
    private int _threshholding;
    private int _cellWidth;
    private int _cellLength;
    private int _fillOrder;
    private String _documentName;
    private String _imageDescription;
    private int[] _minSampleValue;
    private int[] _maxSampleValue;
    private String _pageName;
    private Rational _xPosition;
    private Rational _yPosition;
    private long[] _freeOffsets;
    private long[] _freeByteCounts;
    private long _t4Options;
    private long _t6Options;
    private int[] _pageNumber;
    private boolean _transferFunction;
    private String _dateTime;
    private int _predictor;
    private int[] _halftoneHints;
    private long _badFaxLines;
    private short _cleanFaxData;
    private long _consecutiveBadFaxLines;
    private int _inkSet;
    private String[] _inkNames;
    private long[] _subIFDs;
    private int _numberOfInks;
    private int[] _dotRange;
    private String _targetPrinter;
    private int[] _sampleFormat;
    private int[] _transferRange;
    private int[] _clipPath;
    private long _xClipPathUnits;
    private long _yClipPathUnits;
    private int _indexed;
    private int[] _jpegTables;
    private int _opiProxy;
    private int _jpegProc;
    private long _jpegInterchangeFormat;
    private long _jpegInterchangeFormatLength;
    private int _jpegRestartInterval;
    private int[] _jpegLosslessPredictors;
    private int[] _jpegPointTransforms;
    private long[] _jpegQTables;
    private long[] _jpegDCTables;
    private long[] _jpegACTables;
    private String _copyright;
    private long _exifIFD;
    private long _gpsInfoIFD;
    private long _globalParametersIFD;
    private int[] _photoshopProperties;
    private int[] _imageSourceData;
    private long _interoperabilityIFD;
    private int[] _annotations;
    private int _backgroundColorIndicator;
    private int _backgroundColorValue;
    private int _bitsPerExtendedRunLength;
    private int _bitsPerRunLength;
    private String _colorCharacterization;
    private String _colorSequence;
    private int[] _colorTable;
    private long _hcUsage;
    private int _imageColorIndicator;
    private int _imageColorValue;
    private String _it8Header;
    private int[] _pixelIntensityRange;
    private int _rasterPadding;
    private String _site;
    private int _transparencyIndicator;
    private Rational _aperatureValue;
    private String _batteryLevel;
    private int[] _cfaRepeatPatternDim;
    private int[] _cfaPattern;
    private Rational _compressedBitsPerPixel;
    private int _exposureProgram;
    private int _flash;
    private int _focalPlaneResolutionUnit;
    private Rational _focalPlaneXResolution;
    private Rational _focalPlaneYResolution;
    private byte[] _iccProfile;
    private String _imageHistory;
    private long _imageNumber;
    private int _interlace;
    private long[] _iptc;
    private int[] _isoSpeedRatings;
    private Rational _maxAperatureValue;
    private int[] _noise;
    private int[] _oecf;
    private String _securityClassification;
    private int _selfTimerMode;
    private Rational _shutterSpeedValue;
    private int[] _spatialFrequencyResponse;
    private String _spectralSensitivity;
    private int[] _subjectLocation;
    private String _tiffEPStandardID;
    private int[] _timeZoneOffset;
    private String _geoAsciiParamsTag;
    private double[] _geoDoubleParamsTag;
    private int[] _geoKeyDirectoryTag;
    private double[] _modelPixelScaleTag;
    private double[] _modelTiepointTag;
    private double[] _modelTransformationTag;
    private Property _xmpProp;
    private long[] _stripRowCounts;
    private int[] _imageLayer;
    private ExifIFD _theExifIFD;
    private GPSInfoIFD _theGPSInfoIFD;
    private InteroperabilityIFD _theInteroperabilityIFD;
    private GlobalParametersIFD _theGlobalParametersIFD;
    private int[] _dngVersion;
    private int[] _dngBackwardVersion;
    private String _uniqueCameraModel;
    private String _localizedCameraModel;
    private int[] _cfaPlaneColor;
    private int _cfaLayout;
    private int[] _linearizationTable;
    private int[] _blackLevelRepeatDim;
    private Rational[] _blackLevel;
    private Rational[] _blackLevelDeltaH;
    private Rational[] _blackLevelDeltaV;
    private long[] _whiteLevel;
    private Rational[] _defaultScale;
    private Rational _bestQualityScale;
    private Rational[] _defaultCropOrigin;
    private Rational[] _defaultCropSize;
    private int _calibrationIlluminant1;
    private int _calibrationIlluminant2;
    private Rational[] _colorMatrix1;
    private Rational[] _colorMatrix2;
    private Rational[] _cameraCalibration1;
    private Rational[] _cameraCalibration2;
    private Rational[] _reductionMatrix1;
    private Rational[] _reductionMatrix2;
    private Rational[] _analogBalance;
    private Rational[] _asShotNeutral;
    private Rational[] _asShotWhiteXY;
    private Rational _baselineExposure;
    private Rational _baselineNoise;
    private Rational _baselineSharpness;
    private int _bayerGreenSplit;
    private Rational _linearResponseLimit;
    private String _cameraSerialNumber;
    private Rational[] _lensInfo;
    private Rational _chromaBlurRadius;
    private Rational _antiAliasStrength;
    private int[] _dngPrivateData;
    private int _makerNoteSafety;

    public TiffIFD(long offset, RepInfo info, RandomAccessFile raf, boolean bigEndian) {
        super(offset, info, raf, bigEndian);
        this._niso.setMimeType("image/tiff");
        this._niso.setCompressionScheme(1);
        this._niso.setOrientation(1);
        this._niso.setPlanarConfiguration(1);
        this._niso.setRowsPerStrip(0xFFFFFFFFL);
        this._niso.setSamplesPerPixel(1);
        this._niso.setByteOrder(bigEndian ? "big-endian" : "little-endian");
        this._photometricInterpretation = -1;
        this._cellLength = -1;
        this._cellWidth = -1;
        this._fillOrder = -1;
        this._indexed = 0;
        this._inkSet = -1;
        this._jpegInterchangeFormat = -1L;
        this._jpegInterchangeFormatLength = -1L;
        this._jpegProc = -1;
        this._jpegRestartInterval = -1;
        this._newSubfileType = 0L;
        this._numberOfInks = -1;
        this._opiProxy = -1;
        this._predictor = -1;
        this._subfileType = -1;
        this._t4Options = -1L;
        this._t6Options = -1L;
        this._threshholding = 1;
        this._xClipPathUnits = -1L;
        this._yClipPathUnits = -1L;
        this._backgroundColorIndicator = 0;
        this._backgroundColorValue = -1;
        this._bitsPerExtendedRunLength = 16;
        this._bitsPerRunLength = 8;
        this._hcUsage = -1L;
        this._imageColorIndicator = 0;
        this._imageColorValue = -1;
        this._rasterPadding = 0;
        this._transparencyIndicator = 0;
        this._exposureProgram = -1;
        this._flash = -1;
        this._focalPlaneResolutionUnit = -1;
        this._gpsInfoIFD = -1L;
        this._imageNumber = -1L;
        this._selfTimerMode = -1;
        this._exifIFD = -1L;
        this._focalPlaneResolutionUnit = -1;
        this._imageNumber = -1L;
        this._interlace = -1;
        this._interoperabilityIFD = -1L;
        this._globalParametersIFD = -1L;
        this._badFaxLines = -1L;
        this._cleanFaxData = (short)-1;
        this._consecutiveBadFaxLines = -1L;
        this._xmpProp = null;
        this._stripRowCounts = null;
        this._imageLayer = null;
        this._dngVersion = null;
        this._dngBackwardVersion = null;
        this._uniqueCameraModel = null;
        this._localizedCameraModel = null;
        this._cfaPlaneColor = null;
        this._cfaLayout = -1;
        this._linearizationTable = null;
        this._blackLevelRepeatDim = null;
        this._blackLevel = null;
        this._blackLevelDeltaH = null;
        this._blackLevelDeltaV = null;
        this._whiteLevel = null;
        this._defaultScale = null;
        this._bestQualityScale = null;
        this._defaultCropOrigin = null;
        this._defaultCropSize = null;
        this._calibrationIlluminant1 = -1;
        this._calibrationIlluminant2 = -1;
        this._colorMatrix1 = null;
        this._colorMatrix2 = null;
        this._cameraCalibration1 = null;
        this._cameraCalibration2 = null;
        this._reductionMatrix1 = null;
        this._reductionMatrix2 = null;
        this._analogBalance = null;
        this._asShotNeutral = null;
        this._asShotWhiteXY = null;
        this._baselineExposure = null;
        this._baselineNoise = null;
        this._baselineSharpness = null;
        this._bayerGreenSplit = -1;
        this._linearResponseLimit = null;
        this._cameraSerialNumber = null;
        this._lensInfo = null;
        this._chromaBlurRadius = null;
        this._antiAliasStrength = null;
        this._dngPrivateData = null;
        this._makerNoteSafety = -1;
    }

    public Rational getAperatureValue() {
        return this._aperatureValue;
    }

    public int getBackgroundColorIndicator() {
        return this._backgroundColorIndicator;
    }

    public int getBackgroundColorValue() {
        return this._backgroundColorValue;
    }

    public String getBatteryLevel() {
        return this._batteryLevel;
    }

    public int getBitsPerExtendedRunLength() {
        return this._bitsPerExtendedRunLength;
    }

    public int getBitsPerRunLength() {
        return this._bitsPerRunLength;
    }

    public int getCellLength() {
        return this._cellLength;
    }

    public int getCellWidth() {
        return this._cellWidth;
    }

    public int[] getCFAPattern() {
        return this._cfaPattern;
    }

    public int[] getCFARepeatPatternDim() {
        return this._cfaRepeatPatternDim;
    }

    public int[] getClipPath() {
        return this._clipPath;
    }

    public String getColorSequence() {
        return this._colorSequence;
    }

    public int[] getColorTable() {
        return this._colorTable;
    }

    public Rational getCompressedBitsPerPixel() {
        return this._compressedBitsPerPixel;
    }

    public String getCopyright() {
        return this._copyright;
    }

    public String getDateTime() {
        return this._dateTime;
    }

    public String getDocumentName() {
        return this._documentName;
    }

    public int[] getDotRange() {
        return this._dotRange;
    }

    public long getExifIFD() {
        return this._exifIFD;
    }

    public long getGlobalParametersIFD() {
        return this._globalParametersIFD;
    }

    public int getExposureProgram() {
        return this._exposureProgram;
    }

    public int getFillOrder() {
        return this._fillOrder;
    }

    public int getFocalPlaneResolutionUnit() {
        return this._focalPlaneResolutionUnit;
    }

    public Rational getFocalPlaneXResolution() {
        return this._focalPlaneXResolution;
    }

    public Rational getFocalPlaneYResolution() {
        return this._focalPlaneYResolution;
    }

    public int[] getGeoKeyDirectoryTag() {
        return this._geoKeyDirectoryTag;
    }

    public long getGPSInfoIFD() {
        return this._gpsInfoIFD;
    }

    public int getImageColorIndicator() {
        return this._imageColorIndicator;
    }

    public int getImageColorValue() {
        return this._imageColorValue;
    }

    public String getImageDescription() {
        return this._imageDescription;
    }

    public String getImageHistory() {
        return this._imageHistory;
    }

    public int[] getImageLayer() {
        return this._imageLayer;
    }

    public long getImageNumber() {
        return this._imageNumber;
    }

    public int[] getImageSourceData() {
        return this._imageSourceData;
    }

    public int[] getPhotoshopProperties() {
        return this._photoshopProperties;
    }

    public int[] getAnnotations() {
        return this._annotations;
    }

    public String[] getInkNames() {
        return this._inkNames;
    }

    public int getInkSet() {
        return this._inkSet;
    }

    public int getInterlace() {
        return this._interlace;
    }

    public long getInteroperabilityIFD() {
        return this._interoperabilityIFD;
    }

    public byte[] getICCProfile() {
        return this._iccProfile;
    }

    public int getIndexed() {
        return this._indexed;
    }

    public long getJpegInterchangeFormat() {
        return this._jpegInterchangeFormat;
    }

    public long[] getIPTCNAA() {
        return this._iptc;
    }

    public int[] getISOSpeedRatings() {
        return this._isoSpeedRatings;
    }

    public String getIT8Header() {
        return this._it8Header;
    }

    public int getJPEGProc() {
        return this._jpegProc;
    }

    public Rational getMaxAperatureValue() {
        return this._maxAperatureValue;
    }

    public double[] getModelTiepointTag() {
        return this._modelTiepointTag;
    }

    public double[] getModelTransformationTag() {
        return this._modelTransformationTag;
    }

    public long getNewSubfileType() {
        return this._newSubfileType;
    }

    public NisoImageMetadata getNisoImageMetadata() {
        return this._niso;
    }

    public int[] getNoise() {
        return this._noise;
    }

    public int getNumberOfInks() {
        return this._numberOfInks;
    }

    public int[] getOECF() {
        return this._oecf;
    }

    public String getPageName() {
        return this._pageName;
    }

    public int[] getPageNumber() {
        return this._pageNumber;
    }

    public int[] getPixelIntensityRange() {
        return this._pixelIntensityRange;
    }

    public int getRasterPadding() {
        return this._rasterPadding;
    }

    public String getSecurityClasssification() {
        return this._securityClassification;
    }

    public int getSelfTimerMode() {
        return this._selfTimerMode;
    }

    public Rational getShutterSpeedValue() {
        return this._shutterSpeedValue;
    }

    public String getSite() {
        return this._site;
    }

    public int[] getSpatialFrequencyResponse() {
        return this._spatialFrequencyResponse;
    }

    public String getSpectralSensitivity() {
        return this._spectralSensitivity;
    }

    public long[] getStripRowCounts() {
        return this._stripRowCounts;
    }

    public long[] getSubIFDs() {
        return this._subIFDs;
    }

    public int[] getSubjectLocation() {
        return this._subjectLocation;
    }

    public long getT4Options() {
        return this._t4Options;
    }

    public long getT6Options() {
        return this._t6Options;
    }

    public ExifIFD getTheExifIFD() {
        return this._theExifIFD;
    }

    public GPSInfoIFD getTheGPSInfoIFD() {
        return this._theGPSInfoIFD;
    }

    public InteroperabilityIFD getTheInteroperabilityIFD() {
        return this._theInteroperabilityIFD;
    }

    public GlobalParametersIFD getTheGlobalParametersIFD() {
        return this._theGlobalParametersIFD;
    }

    public int getThreshholding() {
        return this._threshholding;
    }

    public String getTIFFEPStandardID() {
        return this._tiffEPStandardID;
    }

    public int[] getTimeZoneOffset() {
        return this._timeZoneOffset;
    }

    public int getTransparencyIndicator() {
        return this._transparencyIndicator;
    }

    public long getXClipPathUnits() {
        return this._xClipPathUnits;
    }

    public Rational getXPosition() {
        return this._xPosition;
    }

    public Rational getYPosition() {
        return this._yPosition;
    }

    public int[] getDNGVersion() {
        return this._dngVersion;
    }

    public String getUniqueCameraModel() {
        return this._uniqueCameraModel;
    }

    public int[] getCFAPlaneColor() {
        return this._cfaPlaneColor;
    }

    public Rational[] getAsShotNeutral() {
        return this._asShotNeutral;
    }

    public Rational[] getAsShotWhiteXY() {
        return this._asShotWhiteXY;
    }

    @Override
    public Property getProperty(boolean rawOutput) throws TiffException {
        LinkedList<Property> entries = new LinkedList<Property>();
        this.addNisoProperties(entries, rawOutput);
        this.addMiscProperties(entries, rawOutput);
        this.addTiffITProperties(entries, rawOutput);
        this.addTiffEPProperties(entries, rawOutput);
        this.addGeoTiffProperties(entries, rawOutput);
        this.addTiffFXProperties(entries, rawOutput);
        this.addDNGProperties(entries, rawOutput);
        return this.propertyHeader("TIFF", entries);
    }

    private void addNisoProperties(List<Property> entries, boolean rawOutput) {
        entries.add(new Property("NisoImageMetadata", PropertyType.NISOIMAGEMETADATA, (Object)this._niso));
    }

    private void addMiscProperties(List<Property> entries, boolean rawOutput) {
        if (this._imageDescription != null) {
            entries.add(new Property("ImageDescription", PropertyType.STRING, (Object)this._imageDescription));
        }
        if (this._dateTime != null) {
            entries.add(new Property("DateTime", PropertyType.STRING, (Object)this._dateTime));
        }
        if (this._newSubfileType != 0L || rawOutput) {
            entries.add(this.addBitmaskProperty("NewSubfileType", this._newSubfileType, NEWSUBFILETYPE_L, rawOutput));
        } else {
            entries.add(new Property("NewSubfileType", PropertyType.LONG, (Object)new Long(this._newSubfileType)));
        }
        if (this._subfileType != -1 && (this._subfileType != 0 || rawOutput)) {
            entries.add(this.addIntegerProperty("SubfileType", this._subfileType - 1, SUBFILETYPE_L, rawOutput));
        } else if (this._subfileType != -1) {
            entries.add(new Property("SubfileType", PropertyType.LONG, (Object)new Long(this._subfileType)));
        }
        if (this._documentName != null) {
            entries.add(new Property("DocmentName", PropertyType.STRING, (Object)this._documentName));
        }
        if (this._pageName != null) {
            entries.add(new Property("PageName", PropertyType.STRING, (Object)this._pageName));
        }
        if (this._pageNumber != null) {
            entries.add(new Property("PageNumber", PropertyType.INTEGER, PropertyArity.ARRAY, (Object)this._pageNumber));
        }
        if (this._xPosition != null) {
            entries.add(this.addRationalProperty("XPosition", this._xPosition, rawOutput));
        }
        if (this._yPosition != null) {
            entries.add(this.addRationalProperty("YPosition", this._yPosition, rawOutput));
        }
        if (this._copyright != null) {
            entries.add(new Property("Copyright", PropertyType.STRING, (Object)this._copyright));
        }
        if (this._fillOrder != -1) {
            entries.add(this.addIntegerProperty("FillOrder", this._fillOrder, FILLORDER_L, rawOutput));
        }
        entries.add(new Property("SampleFormat", PropertyType.INTEGER, PropertyArity.ARRAY, (Object)this._sampleFormat));
        if (this._minSampleValue != null) {
            entries.add(new Property("MinSampleValue", PropertyType.INTEGER, PropertyArity.ARRAY, (Object)this._minSampleValue));
        }
        if (this._maxSampleValue != null) {
            entries.add(new Property("MaxSampleValue", PropertyType.INTEGER, PropertyArity.ARRAY, (Object)this._maxSampleValue));
        }
        if (this._inkSet != -1) {
            entries.add(this.addIntegerProperty("InkSet", this._inkSet, INKSET_L, rawOutput));
        }
        if (this._numberOfInks != -1) {
            entries.add(new Property("NumberOfInks", PropertyType.INTEGER, (Object)new Integer(this._numberOfInks)));
        }
        if (this._inkNames != null) {
            entries.add(new Property("InkNames", PropertyType.STRING, PropertyArity.ARRAY, (Object)this._inkNames));
        }
        if (this._dotRange != null) {
            entries.add(new Property("DotRange", PropertyType.INTEGER, PropertyArity.ARRAY, (Object)this._dotRange));
        }
        if (this._targetPrinter != null) {
            entries.add(new Property("TargetPrinter", PropertyType.STRING, (Object)this._targetPrinter));
        }
        if (this._halftoneHints != null) {
            entries.add(new Property("HalftoneHints", PropertyType.INTEGER, PropertyArity.ARRAY, (Object)this._halftoneHints));
        }
        if (this._cellLength != -1) {
            entries.add(new Property("CellLength", PropertyType.INTEGER, (Object)new Integer(this._cellLength)));
        }
        if (this._cellWidth != -1) {
            entries.add(new Property("CellWidth", PropertyType.INTEGER, (Object)new Integer(this._cellWidth)));
        }
        if (this._transferFunction) {
            entries.add(new Property("TransferFunction", PropertyType.BOOLEAN, (Object)new Boolean(true)));
        }
        if (this._transferRange != null) {
            entries.add(new Property("TransferRange", PropertyType.INTEGER, PropertyArity.ARRAY, (Object)this._transferRange));
        }
        entries.add(new Property("Threshholding", PropertyType.INTEGER, (Object)new Integer(this._threshholding)));
        if (this._predictor != -1) {
            entries.add(this.addIntegerProperty("Predictor", this._predictor, PREDICTOR_L, rawOutput));
        }
        if (this._t4Options != -1L) {
            entries.add(new Property("T4Options", PropertyType.LONG, (Object)new Long(this._t4Options)));
        }
        if (this._t6Options != -1L) {
            entries.add(new Property("T6Options", PropertyType.LONG, (Object)new Long(this._t6Options)));
        }
        if (this._jpegProc != -1) {
            entries.add(this.addIntegerProperty("JPEGProc", this._jpegProc, JPEGPROC_L, JPEGPROC_INDEX, rawOutput));
        }
        if (this._jpegInterchangeFormat != -1L) {
            entries.add(new Property("JPEGInterchangeFormat", PropertyType.LONG, (Object)new Long(this._jpegInterchangeFormat)));
        }
        if (this._jpegInterchangeFormatLength != -1L) {
            entries.add(new Property("JPEGInterchangeFormatLength", PropertyType.LONG, (Object)new Long(this._jpegInterchangeFormatLength)));
        }
        if (this._jpegRestartInterval != -1) {
            entries.add(new Property("JPEGRestartInterval", PropertyType.INTEGER, (Object)new Integer(this._jpegRestartInterval)));
        }
        if (this._jpegLosslessPredictors != null) {
            entries.add(this.addIntegerArrayProperty("JPEGLosslessPredictors", this._jpegLosslessPredictors, JPEGLOSSLESSPREDICTORS_L, rawOutput));
        }
        if (this._jpegPointTransforms != null) {
            entries.add(new Property("JPEGPointTransforms", PropertyType.INTEGER, PropertyArity.ARRAY, (Object)this._jpegPointTransforms));
        }
        if (this._jpegQTables != null) {
            entries.add(new Property("JPEGQTables", PropertyType.LONG, PropertyArity.ARRAY, (Object)this._jpegQTables));
        }
        if (this._jpegDCTables != null) {
            entries.add(new Property("JPEGDCTables", PropertyType.LONG, PropertyArity.ARRAY, (Object)this._jpegDCTables));
        }
        if (this._jpegACTables != null) {
            entries.add(new Property("JPEGACTables", PropertyType.LONG, PropertyArity.ARRAY, (Object)this._jpegACTables));
        }
        if (this._jpegTables != null) {
            entries.add(new Property("JPEGTables", PropertyType.INTEGER, PropertyArity.ARRAY, (Object)this._jpegTables));
        }
        if (this._imageSourceData != null) {
            entries.add(new Property("ImageSourceData", PropertyType.INTEGER, PropertyArity.ARRAY, (Object)this._imageSourceData));
        }
        if (this._photoshopProperties != null) {
            entries.add(new Property("PhotoshopProperties", PropertyType.INTEGER, PropertyArity.ARRAY, (Object)this._photoshopProperties));
        }
        if (this._annotations != null) {
            entries.add(new Property("Annotations", PropertyType.INTEGER, PropertyArity.ARRAY, (Object)this._annotations));
        }
        if (this._clipPath != null) {
            entries.add(new Property("ClipPath", PropertyType.INTEGER, PropertyArity.ARRAY, (Object)this._clipPath));
        }
        if (this._xClipPathUnits != -1L) {
            entries.add(new Property("XClipPathUnits", PropertyType.LONG, (Object)new Long(this._xClipPathUnits)));
        }
        if (this._yClipPathUnits != -1L) {
            entries.add(new Property("YClipPathUnits", PropertyType.LONG, (Object)new Long(this._yClipPathUnits)));
        }
        if (this._cleanFaxData != -1) {
            entries.add(new Property("CleanFaxData", PropertyType.LONG, (Object)new Long(this._cleanFaxData)));
        }
        if (this._badFaxLines != -1L) {
            entries.add(new Property("BadFaxLines", PropertyType.LONG, (Object)new Long(this._badFaxLines)));
        }
        if (this._consecutiveBadFaxLines != -1L) {
            entries.add(new Property("ConsecutiveBadFaxLines", PropertyType.LONG, (Object)new Long(this._consecutiveBadFaxLines)));
        }
        if (this._freeByteCounts != null) {
            entries.add(new Property("FreeByteCounts", PropertyType.LONG, PropertyArity.ARRAY, (Object)this._freeByteCounts));
        }
        if (this._freeOffsets != null) {
            entries.add(new Property("FreeOffsets", PropertyType.LONG, PropertyArity.ARRAY, (Object)this._freeOffsets));
        }
    }

    private void addTiffITProperties(List<Property> entries, boolean rawOutput) {
        LinkedList<Property> itList = new LinkedList<Property>();
        if (this._site != null) {
            itList.add(new Property("Site", PropertyType.STRING, (Object)this._site));
        }
        if (this._colorTable != null) {
            itList.add(new Property("ColorTable", PropertyType.INTEGER, PropertyArity.ARRAY, (Object)this._colorTable));
        }
        itList.add(this.addIntegerProperty("BackgroundColorIndicator", this._backgroundColorIndicator, BACKGROUNDCOLORINDICATOR_L, rawOutput));
        if (this._backgroundColorValue != -1) {
            itList.add(new Property("BackgroundColorValue", PropertyType.INTEGER, (Object)new Integer(this._backgroundColorValue)));
        }
        itList.add(this.addIntegerProperty("ImageColorIndicator", this._imageColorIndicator, IMAGECOLORINDICATOR_L, rawOutput));
        itList.add(this.addIntegerProperty("TransparencyIndicator", this._transparencyIndicator, TRANSPARENCYINDICATOR_L, rawOutput));
        if (this._imageColorValue != -1) {
            itList.add(new Property("ImageColorValue", PropertyType.INTEGER, (Object)new Integer(this._imageColorValue)));
        }
        if (this._colorCharacterization != null) {
            itList.add(new Property("ColorCharacterization", PropertyType.STRING, (Object)this._colorCharacterization));
        }
        if (this._colorSequence != null) {
            itList.add(new Property("ColorSequence", PropertyType.STRING, (Object)this._colorSequence));
        }
        if (this._hcUsage != -1L) {
            itList.add(this.addBitmaskProperty("HCUsage", this._hcUsage, HCUSAGE_L, rawOutput));
        }
        if (this._it8Header != null) {
            itList.add(new Property("IT8Header", PropertyType.STRING, (Object)this._it8Header));
        }
        if (this._pixelIntensityRange != null) {
            itList.add(new Property("PixelIntensityRange", PropertyType.INTEGER, PropertyArity.ARRAY, (Object)this._pixelIntensityRange));
        }
        itList.add(this.addIntegerProperty("RasterPadding", this._rasterPadding, RASTERPADDING_L, rawOutput));
        itList.add(new Property("BitsPerRunLength", PropertyType.INTEGER, (Object)new Integer(this._bitsPerRunLength)));
        itList.add(new Property("BitsPerExtendedRunLength", PropertyType.INTEGER, (Object)new Integer(this._bitsPerExtendedRunLength)));
        entries.add(new Property("TIFFITProperties", PropertyType.PROPERTY, PropertyArity.LIST, itList));
    }

    private void addTiffEPProperties(List<Property> entries, boolean rawOutput) {
        LinkedList<Property> epList = new LinkedList<Property>();
        if (this._cfaRepeatPatternDim != null) {
            epList.add(new Property("CFARepeatPatternDim", PropertyType.INTEGER, PropertyArity.ARRAY, (Object)this._cfaRepeatPatternDim));
        }
        if (this._cfaPattern != null) {
            epList.add(new Property("CFAPattern", PropertyType.INTEGER, PropertyArity.ARRAY, (Object)this._cfaPattern));
        }
        if (this._batteryLevel != null) {
            epList.add(new Property("BatteryLevel", PropertyType.STRING, (Object)this._batteryLevel));
        }
        if (this._iptc != null) {
            epList.add(new Property("IPTCNAA", PropertyType.LONG, PropertyArity.ARRAY, (Object)this._iptc));
        }
        if (this._iccProfile != null) {
            epList.add(new Property("ICCProfile", PropertyType.BOOLEAN, (Object)Boolean.TRUE));
        }
        if (this._exposureProgram != -1) {
            epList.add(this.addIntegerProperty("ExposureProgram", this._exposureProgram, EXPOSUREPROGRAM_L, rawOutput));
        }
        if (this._spectralSensitivity != null) {
            epList.add(new Property("SpectralSensitivity", PropertyType.STRING, (Object)this._spectralSensitivity));
        }
        if (this._isoSpeedRatings != null) {
            epList.add(new Property("ISOSpeedRatings", PropertyType.INTEGER, PropertyArity.ARRAY, (Object)this._isoSpeedRatings));
        }
        if (this._oecf != null) {
            epList.add(new Property("OECF", PropertyType.INTEGER, PropertyArity.ARRAY, (Object)this._oecf));
        }
        if (this._interlace != -1) {
            epList.add(new Property("Interlace", PropertyType.INTEGER, (Object)new Integer(this._interlace)));
        }
        if (this._timeZoneOffset != null) {
            epList.add(new Property("TimeZoneOffset", PropertyType.INTEGER, PropertyArity.ARRAY, (Object)this._timeZoneOffset));
        }
        if (this._selfTimerMode != -1) {
            epList.add(new Property("SelfTimerMode", PropertyType.INTEGER, (Object)new Integer(this._selfTimerMode)));
        }
        if (this._compressedBitsPerPixel != null) {
            epList.add(this.addRationalProperty("CompressedBitsPerPixel", this._compressedBitsPerPixel, rawOutput));
        }
        if (this._shutterSpeedValue != null) {
            epList.add(this.addRationalProperty("ShutterSpeedValue", this._shutterSpeedValue, rawOutput));
        }
        if (this._aperatureValue != null) {
            epList.add(this.addRationalProperty("AperatureValue", this._aperatureValue, rawOutput));
        }
        if (this._maxAperatureValue != null) {
            epList.add(this.addRationalProperty("MaxAperatureValue", this._maxAperatureValue, rawOutput));
        }
        if (this._flash != -1) {
            epList.add(this.addIntegerProperty("FLASH", this._flash, FLASH_L, FLASH_INDEX, rawOutput));
        }
        if (this._spatialFrequencyResponse != null) {
            epList.add(new Property("SpatialFrequencyResponse", PropertyType.INTEGER, PropertyArity.ARRAY, (Object)this._spatialFrequencyResponse));
        }
        if (this._noise != null) {
            epList.add(new Property("Noise", PropertyType.INTEGER, PropertyArity.ARRAY, (Object)this._noise));
        }
        if (this._focalPlaneXResolution != null) {
            epList.add(this.addRationalProperty("FocalPlaneXResolution", this._focalPlaneXResolution, rawOutput));
        }
        if (this._focalPlaneYResolution != null) {
            epList.add(this.addRationalProperty("FocalPlaneYResolution", this._focalPlaneYResolution, rawOutput));
        }
        if (this._focalPlaneResolutionUnit != -1) {
            epList.add(this.addIntegerProperty("FocalPlaneResolutionUnit", this._focalPlaneResolutionUnit, FOCALPLANERESOLUTIONUNIT_L, rawOutput));
        }
        if (this._imageNumber != -1L) {
            epList.add(new Property("ImageNumber", PropertyType.LONG, (Object)new Long(this._imageNumber)));
        }
        if (this._securityClassification != null) {
            epList.add(new Property("SecurityClassification", PropertyType.STRING, (Object)this._securityClassification));
        }
        if (this._imageHistory != null) {
            epList.add(new Property("ImageHistory", PropertyType.STRING, (Object)this._imageHistory));
        }
        if (this._subjectLocation != null) {
            epList.add(new Property("SubjectLocation", PropertyType.INTEGER, PropertyArity.ARRAY, (Object)this._subjectLocation));
        }
        if (this._tiffEPStandardID != null) {
            epList.add(new Property("TIFFEPSStandardID", PropertyType.STRING, (Object)this._tiffEPStandardID));
        }
        if (epList.size() > 0) {
            entries.add(new Property("TIFFEPProperties", PropertyType.PROPERTY, PropertyArity.LIST, epList));
        }
        if (this._xmpProp != null) {
            entries.add(this._xmpProp);
        }
    }

    private void addGeoTiffProperties(List<Property> entries, boolean rawOutput) throws TiffException {
        LinkedList<Property> dirList = new LinkedList<Property>();
        if (this._geoKeyDirectoryTag != null) {
            dirList.add(new Property("Version", PropertyType.INTEGER, (Object)new Integer(this._geoKeyDirectoryTag[0])));
            dirList.add(new Property("Revision", PropertyType.STRING, (Object)(Integer.toString(this._geoKeyDirectoryTag[1]) + "." + Integer.toString(this._geoKeyDirectoryTag[2]))));
            dirList.add(new Property("NumberOfKeys", PropertyType.INTEGER, (Object)new Integer(this._geoKeyDirectoryTag[3])));
            for (int i = 0; i < this._geoKeyDirectoryTag[3]; ++i) {
                int j = i * 4 + 4;
                int key = this._geoKeyDirectoryTag[j];
                int location = this._geoKeyDirectoryTag[j + 1];
                int count = this._geoKeyDirectoryTag[j + 2];
                int offset = this._geoKeyDirectoryTag[j + 3];
                int ival = 0;
                double dval = 0.0;
                String sval = "NULL";
                if (location == 0) {
                    ival = offset;
                } else if (location == 34736) {
                    dval = this._geoDoubleParamsTag[offset];
                } else if (location == 34737) {
                    try {
                        sval = this._geoAsciiParamsTag.substring(offset, offset + count - 1);
                    }
                    catch (Exception e) {
                        throw new TiffException("Invalid GeoKeyDirectory tag");
                    }
                }
                if (key == 1024) {
                    dirList.add(this.addIntegerProperty("GTModelType", ival, GeoTiffStrings.MODELTYPE, GeoTiffStrings.MODELTYPE_INDEX, rawOutput));
                    continue;
                }
                if (key == 1025) {
                    dirList.add(this.addIntegerProperty("GTRasterType", ival, GeoTiffStrings.RASTERTYPE, GeoTiffStrings.RASTERTYPE_INDEX, rawOutput));
                    continue;
                }
                if (key == 1026) {
                    dirList.add(new Property("GTCitation", PropertyType.STRING, (Object)sval));
                    continue;
                }
                if (key == 2048) {
                    dirList.add(this.addIntegerProperty("GeographicType", ival, GeoTiffStrings.GEOGRAPHICS, GeoTiffStrings.GEOGRAPHICS_INDEX, rawOutput));
                    continue;
                }
                if (key == 2049) {
                    dirList.add(new Property("GeogCitation", PropertyType.STRING, (Object)sval));
                    continue;
                }
                if (key == 2050) {
                    dirList.add(this.addIntegerProperty("GeogGeodeticDatum", ival, GeoTiffStrings.GEODETICDATUM, GeoTiffStrings.GEODETICDATUM_INDEX, rawOutput));
                    continue;
                }
                if (key == 2051) {
                    dirList.add(this.addIntegerProperty("GeogPrimeMeridian", ival, GeoTiffStrings.PRIMEMERIDIAN, GeoTiffStrings.PRIMEMERIDIAN_INDEX, rawOutput));
                    continue;
                }
                if (key == 2061) {
                    dirList.add(new Property("GeogPrimeMeridianLong", PropertyType.DOUBLE, (Object)new Double(dval)));
                    continue;
                }
                if (key == 2052) {
                    dirList.add(this.addIntegerProperty("GeogLinearUnits", ival, GeoTiffStrings.LINEARUNITS, GeoTiffStrings.LINEARUNITS_INDEX, rawOutput));
                    continue;
                }
                if (key == 2053) {
                    dirList.add(new Property("GeogLinearUnitSize", PropertyType.DOUBLE, (Object)new Double(dval)));
                    continue;
                }
                if (key == 2054) {
                    dirList.add(this.addIntegerProperty("GeogAngularUnits", ival, GeoTiffStrings.ANGULARUNITS, GeoTiffStrings.ANGULARUNITS_INDEX, rawOutput));
                    continue;
                }
                if (key == 2055) {
                    dirList.add(new Property("GeogAngularUnitSize", PropertyType.DOUBLE, (Object)new Double(dval)));
                    continue;
                }
                if (key == 2056) {
                    dirList.add(this.addIntegerProperty("GeogEllipsoid", ival, GeoTiffStrings.ELLIPSOID, GeoTiffStrings.ELLIPSOID_INDEX, rawOutput));
                    continue;
                }
                if (key == 2057) {
                    dirList.add(new Property("GeogSemiMajorAxis", PropertyType.DOUBLE, (Object)new Double(dval)));
                    continue;
                }
                if (key == 2058) {
                    dirList.add(new Property("GeogSemiMinorAxis", PropertyType.DOUBLE, (Object)new Double(dval)));
                    continue;
                }
                if (key == 2059) {
                    dirList.add(new Property("GeogInvFlattening", PropertyType.DOUBLE, (Object)new Double(dval)));
                    continue;
                }
                if (key == 2060) {
                    dirList.add(this.addIntegerProperty("GeogAzimuthUnits", ival, GeoTiffStrings.ANGULARUNITS, GeoTiffStrings.ANGULARUNITS_INDEX, rawOutput));
                    continue;
                }
                if (key == 3072) {
                    dirList.add(this.addIntegerProperty("ProjectedCSType", ival, GeoTiffStrings.PROJECTEDCSTYPE, GeoTiffStrings.PROJECTEDCSTYPE_INDEX, rawOutput));
                    continue;
                }
                if (key == 3073) {
                    dirList.add(new Property("PCSCitation", PropertyType.STRING, (Object)sval));
                    continue;
                }
                if (key == 3074) {
                    dirList.add(this.addIntegerProperty("Projection", ival, GeoTiffStrings.PROJECTION, GeoTiffStrings.PROJECTION_INDEX, rawOutput));
                    continue;
                }
                if (key == 3075) {
                    dirList.add(this.addIntegerProperty("ProjCoordTrans", ival, GeoTiffStrings.COORDINATETRANSFORMATION, GeoTiffStrings.COORDINATETRANSFORMATION_INDEX, rawOutput));
                    continue;
                }
                if (key == 3076) {
                    dirList.add(this.addIntegerProperty("ProjLinearUnits", ival, GeoTiffStrings.LINEARUNITS, GeoTiffStrings.LINEARUNITS_INDEX, rawOutput));
                    continue;
                }
                if (key == 3077) {
                    dirList.add(new Property("ProjLinearUnitSize", PropertyType.DOUBLE, (Object)new Double(dval)));
                    continue;
                }
                if (key == 3078) {
                    dirList.add(new Property("ProjStdParallel1", PropertyType.DOUBLE, (Object)new Double(dval)));
                    continue;
                }
                if (key == 3079) {
                    dirList.add(new Property("ProjStdParallel2", PropertyType.DOUBLE, (Object)new Double(dval)));
                    continue;
                }
                if (key == 3080) {
                    dirList.add(new Property("ProjNatOriginLong", PropertyType.DOUBLE, (Object)new Double(dval)));
                    continue;
                }
                if (key == 3081) {
                    dirList.add(new Property("ProjNatOriginLat", PropertyType.DOUBLE, (Object)new Double(dval)));
                    continue;
                }
                if (key == 3082) {
                    dirList.add(new Property("ProjFalseEasting", PropertyType.DOUBLE, (Object)new Double(dval)));
                    continue;
                }
                if (key == 3083) {
                    dirList.add(new Property("ProjFalseNorthing", PropertyType.DOUBLE, (Object)new Double(dval)));
                    continue;
                }
                if (key == 3084) {
                    dirList.add(new Property("ProjFalseOriginLong", PropertyType.DOUBLE, (Object)new Double(dval)));
                    continue;
                }
                if (key == 3085) {
                    dirList.add(new Property("ProjFalseOriginLat", PropertyType.DOUBLE, (Object)new Double(dval)));
                    continue;
                }
                if (key == 3086) {
                    dirList.add(new Property("ProjFalseOriginEasting", PropertyType.DOUBLE, (Object)new Double(dval)));
                    continue;
                }
                if (key == 3087 || key == 3091) {
                    dirList.add(new Property("ProjFalseOriginNorthing", PropertyType.DOUBLE, (Object)new Double(dval)));
                    continue;
                }
                if (key == 3088) {
                    dirList.add(new Property("ProjCenterLong", PropertyType.DOUBLE, (Object)new Double(dval)));
                    continue;
                }
                if (key == 3089) {
                    dirList.add(new Property("ProjCenterLat", PropertyType.DOUBLE, (Object)new Double(dval)));
                    continue;
                }
                if (key == 3090) {
                    dirList.add(new Property("ProjCenterEasting", PropertyType.DOUBLE, (Object)new Double(dval)));
                    continue;
                }
                if (key == 3092) {
                    dirList.add(new Property("ProjScaleAtNatOrigin", PropertyType.DOUBLE, (Object)new Double(dval)));
                    continue;
                }
                if (key == 3093) {
                    dirList.add(new Property("ProjScaleAtCenter", PropertyType.DOUBLE, (Object)new Double(dval)));
                    continue;
                }
                if (key == 3094) {
                    dirList.add(new Property("ProjAzimuthAngle", PropertyType.DOUBLE, (Object)new Double(dval)));
                    continue;
                }
                if (key == 3095) {
                    dirList.add(new Property("ProjStraightVertPoleLong", PropertyType.DOUBLE, (Object)new Double(dval)));
                    continue;
                }
                if (key == 4096) {
                    dirList.add(this.addIntegerProperty("VerticalCSType", ival, GeoTiffStrings.VERTICALCSTYPE, GeoTiffStrings.VERTICALCSTYPE_INDEX, rawOutput));
                    continue;
                }
                if (key == 4097) {
                    dirList.add(new Property("VerticalCitation", PropertyType.STRING, (Object)sval));
                    continue;
                }
                if (key == 4098) {
                    dirList.add(this.addIntegerProperty("VerticalDatum", ival, GeoTiffStrings.VERTICALCSDATUM, GeoTiffStrings.VERTICALCSDATUM_INDEX, rawOutput));
                    continue;
                }
                if (key != 4099) continue;
                dirList.add(this.addIntegerProperty("VerticalUnits", ival, GeoTiffStrings.LINEARUNITS, GeoTiffStrings.LINEARUNITS_INDEX, rawOutput));
            }
        }
        LinkedList<Property> geoList = new LinkedList<Property>();
        if (dirList.size() > 0) {
            geoList.add(new Property("GeoKeyDirectory", PropertyType.PROPERTY, PropertyArity.LIST, dirList));
        }
        if (this._modelTiepointTag != null) {
            geoList.add(new Property("ModelTiepointTag", PropertyType.DOUBLE, PropertyArity.ARRAY, (Object)this._modelTiepointTag));
        }
        if (this._modelPixelScaleTag != null) {
            geoList.add(new Property("ModelPixelScaleTag", PropertyType.DOUBLE, PropertyArity.ARRAY, (Object)this._modelPixelScaleTag));
        }
        if (this._modelTransformationTag != null) {
            geoList.add(new Property("ModelTransformationTag", PropertyType.DOUBLE, PropertyArity.ARRAY, (Object)this._modelTransformationTag));
        }
        if (geoList.size() > 0) {
            entries.add(new Property("GeoTIFFProperties", PropertyType.PROPERTY, PropertyArity.LIST, geoList));
        }
    }

    private void addTiffFXProperties(List<Property> entries, boolean rawOutput) {
        if (this._stripRowCounts != null) {
            entries.add(new Property("StripRowCounts", PropertyType.LONG, PropertyArity.ARRAY, (Object)this._stripRowCounts));
        }
        if (this._imageLayer != null) {
            Property[] layerProps = new Property[2];
            try {
                layerProps[0] = this.addIntegerProperty("LayerType", this._imageLayer[0], IMAGELAYER_L, rawOutput);
                layerProps[1] = new Property("OrdinalNumber", PropertyType.INTEGER, (Object)new Integer(this._imageLayer[1]));
                entries.add(new Property("ImageLayer", PropertyType.PROPERTY, PropertyArity.ARRAY, (Object)layerProps));
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    private void addDNGProperties(List<Property> entries, boolean rawOutput) {
        this.setDNGDefaults();
        LinkedList<Property> dngList = new LinkedList<Property>();
        if (this._dngVersion != null) {
            dngList.add(new Property("DNGVersion", PropertyType.INTEGER, PropertyArity.ARRAY, (Object)this._dngVersion));
        }
        if (this._dngBackwardVersion != null) {
            dngList.add(new Property("DNGBackwardVersion", PropertyType.INTEGER, PropertyArity.ARRAY, (Object)this._dngBackwardVersion));
        }
        if (this._uniqueCameraModel != null) {
            dngList.add(new Property("UniqueCameraModel", PropertyType.STRING, (Object)this._uniqueCameraModel));
        }
        if (this._localizedCameraModel != null) {
            dngList.add(new Property("LocalizedCameraModel", PropertyType.STRING, (Object)this._localizedCameraModel));
        }
        if (this._cfaPlaneColor != null) {
            dngList.add(new Property("CFAPlaneColor", PropertyType.INTEGER, PropertyArity.ARRAY, (Object)this._cfaPlaneColor));
        }
        if (this._cfaLayout != -1) {
            dngList.add(this.addIntegerProperty("CFALayout", this._cfaLayout, CFALAYOUT_L, rawOutput));
        }
        if (this._linearizationTable != null) {
            dngList.add(new Property("LinearizationTable", PropertyType.INTEGER, PropertyArity.ARRAY, (Object)this._linearizationTable));
        }
        if (this._blackLevelRepeatDim != null) {
            dngList.add(new Property("BlackLevelRepeatDim", PropertyType.INTEGER, PropertyArity.ARRAY, (Object)this._blackLevelRepeatDim));
        }
        if (this._blackLevel != null) {
            dngList.add(new Property("BlackLevel", PropertyType.RATIONAL, PropertyArity.ARRAY, (Object)this._blackLevel));
        }
        if (this._blackLevelDeltaH != null) {
            dngList.add(new Property("BlackLevelDeltaH", PropertyType.RATIONAL, PropertyArity.ARRAY, (Object)this._blackLevelDeltaH));
        }
        if (this._blackLevelDeltaV != null) {
            dngList.add(new Property("BlackLevelDeltaV", PropertyType.RATIONAL, PropertyArity.ARRAY, (Object)this._blackLevelDeltaV));
        }
        if (this._whiteLevel != null) {
            dngList.add(new Property("WhiteLevel", PropertyType.LONG, PropertyArity.ARRAY, (Object)this._whiteLevel));
        }
        if (this._defaultScale != null) {
            dngList.add(new Property("DefaultScale", PropertyType.RATIONAL, PropertyArity.ARRAY, (Object)this._defaultScale));
        }
        if (this._bestQualityScale != null) {
            dngList.add(new Property("BestQualityScale", PropertyType.RATIONAL, (Object)this._bestQualityScale));
        }
        if (this._defaultCropOrigin != null) {
            dngList.add(new Property("DefaultCropOrigin", PropertyType.RATIONAL, PropertyArity.ARRAY, (Object)this._defaultCropOrigin));
        }
        if (this._defaultCropSize != null) {
            dngList.add(new Property("DefaultCropSize", PropertyType.RATIONAL, PropertyArity.ARRAY, (Object)this._defaultCropSize));
        }
        if (this._calibrationIlluminant1 != -1) {
            dngList.add(new Property("CalibrationIlluminant1", PropertyType.INTEGER, (Object)new Integer(this._calibrationIlluminant1)));
        }
        if (this._calibrationIlluminant2 != -1) {
            dngList.add(new Property("CalibrationIlluminant2", PropertyType.INTEGER, (Object)new Integer(this._calibrationIlluminant2)));
        }
        if (this._colorMatrix1 != null) {
            dngList.add(new Property("ColorMatrix1", PropertyType.RATIONAL, PropertyArity.ARRAY, (Object)this._colorMatrix1));
        }
        if (this._colorMatrix2 != null) {
            dngList.add(new Property("ColorMatrix2", PropertyType.RATIONAL, PropertyArity.ARRAY, (Object)this._colorMatrix2));
        }
        if (this._cameraCalibration1 != null) {
            dngList.add(new Property("CameraCalibration1", PropertyType.RATIONAL, PropertyArity.ARRAY, (Object)this._cameraCalibration1));
        }
        if (this._cameraCalibration2 != null) {
            dngList.add(new Property("CameraCalibration2", PropertyType.RATIONAL, PropertyArity.ARRAY, (Object)this._cameraCalibration2));
        }
        if (this._reductionMatrix1 != null) {
            dngList.add(new Property("ReductionMatrix1", PropertyType.RATIONAL, PropertyArity.ARRAY, (Object)this._reductionMatrix1));
        }
        if (this._reductionMatrix2 != null) {
            dngList.add(new Property("ReductionMatrix2", PropertyType.RATIONAL, PropertyArity.ARRAY, (Object)this._reductionMatrix2));
        }
        if (this._analogBalance != null) {
            dngList.add(new Property("AnalogBalance", PropertyType.RATIONAL, PropertyArity.ARRAY, (Object)this._analogBalance));
        }
        if (this._asShotNeutral != null) {
            dngList.add(new Property("AsShotNeutral", PropertyType.RATIONAL, PropertyArity.ARRAY, (Object)this._asShotNeutral));
        }
        if (this._asShotWhiteXY != null) {
            dngList.add(new Property("AsShotWhiteXY", PropertyType.RATIONAL, PropertyArity.ARRAY, (Object)this._asShotWhiteXY));
        }
        if (this._baselineExposure != null) {
            dngList.add(new Property("BaselineExposure", PropertyType.RATIONAL, (Object)this._baselineExposure));
        }
        if (this._baselineNoise != null) {
            dngList.add(new Property("BaselineNoise", PropertyType.RATIONAL, (Object)this._baselineNoise));
        }
        if (this._baselineNoise != null) {
            dngList.add(new Property("BaselineSharpness", PropertyType.RATIONAL, (Object)this._baselineSharpness));
        }
        if (this._bayerGreenSplit != -1) {
            dngList.add(new Property("BayerGreenSplit", PropertyType.INTEGER, (Object)new Integer(this._bayerGreenSplit)));
        }
        if (this._linearResponseLimit != null) {
            dngList.add(new Property("LinearResponseLimit", PropertyType.RATIONAL, (Object)this._linearResponseLimit));
        }
        if (this._cameraSerialNumber != null) {
            dngList.add(new Property("CameraSerialNumber", PropertyType.STRING, (Object)this._cameraSerialNumber));
        }
        if (this._lensInfo != null) {
            dngList.add(new Property("LensInfo", PropertyType.RATIONAL, PropertyArity.ARRAY, (Object)this._lensInfo));
        }
        if (this._chromaBlurRadius != null) {
            dngList.add(new Property("ChromaBlurRadius", PropertyType.RATIONAL, (Object)this._chromaBlurRadius));
        }
        if (this._antiAliasStrength != null) {
            dngList.add(new Property("AntiAliasStrength", PropertyType.RATIONAL, (Object)this._antiAliasStrength));
        }
        if (this._dngPrivateData != null) {
            dngList.add(new Property("DNGPrivateData", PropertyType.INTEGER, (Object)this._dngPrivateData));
        }
        if (this._makerNoteSafety != -1) {
            dngList.add(this.addIntegerProperty("MakerNoteSafety", this._makerNoteSafety, MAKERNOTESAFETY_L, rawOutput));
        }
        if (dngList.size() > 0) {
            entries.add(new Property("DNGProperties", PropertyType.PROPERTY, PropertyArity.LIST, dngList));
        }
    }

    private int calcColorPlanes() {
        if (this._photometricInterpretation == 32803) {
            int nUnique = 0;
            if (this._cfaPattern == null) {
                return 1;
            }
            int[] uniqueColors = new int[this._cfaPattern.length];
            for (int i = 0; i < this._cfaPattern.length; ++i) {
                boolean unique = true;
                int color = this._cfaPattern[i];
                for (int j = 0; j < nUnique; ++j) {
                    if (color != uniqueColors[j]) continue;
                    unique = false;
                    break;
                }
                if (!unique) continue;
                uniqueColors[nUnique++] = color;
            }
            return nUnique;
        }
        return this._niso.getSamplesPerPixel();
    }

    private void setDNGDefaults() {
        if (this._dngVersion != null) {
            if (this._dngBackwardVersion == null) {
                this._dngBackwardVersion = new int[4];
                this._dngBackwardVersion[0] = this._dngVersion[0];
                this._dngBackwardVersion[1] = this._dngVersion[1];
                this._dngBackwardVersion[2] = 0;
                this._dngBackwardVersion[3] = 0;
            }
            if (this._uniqueCameraModel != null && this._localizedCameraModel == null) {
                this._localizedCameraModel = this._uniqueCameraModel;
            }
            if (this._calibrationIlluminant1 == -1) {
                this._calibrationIlluminant1 = 0;
            }
            if (this._baselineExposure == null) {
                this._baselineExposure = new Rational(0, 1);
            }
            if (this._baselineNoise == null) {
                this._baselineNoise = new Rational(1, 1);
            }
            if (this._baselineSharpness == null) {
                this._baselineSharpness = new Rational(1, 1);
            }
            if (this._linearResponseLimit == null) {
                this._linearResponseLimit = new Rational(1, 1);
            }
            if (this._makerNoteSafety == -1) {
                this._makerNoteSafety = 0;
            }
        }
        if (this._photometricInterpretation == 32803 || this._photometricInterpretation == 34892) {
            int i;
            if (this._cfaPlaneColor == null) {
                this._cfaPlaneColor = new int[]{0, 1, 2};
            }
            if (this._cfaLayout == -1) {
                this._cfaLayout = 1;
            }
            if (this._blackLevelRepeatDim == null) {
                this._blackLevelRepeatDim = new int[]{1, 1};
            }
            Rational zero = new Rational(0, 1);
            if (this._blackLevel == null) {
                this._blackLevel = new Rational[this._blackLevelRepeatDim[0] * this._blackLevelRepeatDim[1] * this._niso.getSamplesPerPixel()];
                for (i = 0; i < this._blackLevel.length; ++i) {
                    this._blackLevel[i] = zero;
                }
            }
            if (this._blackLevelDeltaH == null) {
                this._blackLevelDeltaH = new Rational[(int)this._niso.getImageWidth()];
                for (i = 0; i < this._blackLevelDeltaH.length; ++i) {
                    this._blackLevelDeltaH[i] = zero;
                }
            }
            if (this._blackLevelDeltaV == null) {
                this._blackLevelDeltaV = new Rational[(int)this._niso.getImageLength()];
                for (i = 0; i < this._blackLevelDeltaV.length; ++i) {
                    this._blackLevelDeltaV[i] = zero;
                }
            }
            if (this._whiteLevel == null) {
                this._whiteLevel = new long[this._niso.getSamplesPerPixel()];
                long defWhite = 1L << this._niso.getBitsPerSample()[0] - 1;
                for (int i2 = 0; i2 < this._whiteLevel.length; ++i2) {
                    this._whiteLevel[i2] = defWhite;
                }
            }
            Rational one = new Rational(1, 1);
            if (this._defaultScale == null) {
                this._defaultScale = new Rational[]{one, one};
            }
            if (this._bestQualityScale == null) {
                this._bestQualityScale = one;
            }
            if (this._defaultCropOrigin == null) {
                this._defaultCropOrigin = new Rational[]{zero, zero};
            }
            if (this._defaultCropSize == null) {
                this._defaultCropSize = new Rational[2];
                this._defaultCropSize[0] = new Rational(this._niso.getImageWidth(), 1L);
                this._defaultCropSize[1] = new Rational(this._niso.getImageLength(), 1L);
            }
            int colorPlanes = this.calcColorPlanes();
            if (this._cameraCalibration1 == null) {
                this._cameraCalibration1 = this.identityMatrix(colorPlanes);
            }
            if (this._cameraCalibration2 == null) {
                this._cameraCalibration2 = this.identityMatrix(colorPlanes);
            }
            if (this._bayerGreenSplit == -1 && this._photometricInterpretation == 32803) {
                this._bayerGreenSplit = 0;
            }
            if (this._antiAliasStrength == null) {
                this._antiAliasStrength = new Rational(1, 1);
            }
        }
    }

    private Rational[] identityMatrix(int dim) {
        int i;
        Rational[] val = new Rational[dim * dim];
        for (i = 0; i < dim * dim; ++i) {
            val[i] = new Rational(0, 1);
        }
        for (i = 0; i < dim; ++i) {
            val[dim * i + i] = new Rational(1, 1);
        }
        return val;
    }

    @Override
    public void lookupTag(int tag, int type, long count, long value) throws TiffException {
        block410: {
            try {
                if (tag == 37378) {
                    TiffIFD.checkType(tag, type, 5);
                    TiffIFD.checkCount(tag, count, 1);
                    this._aperatureValue = this.readRational(count, value);
                    break block410;
                }
                if (tag == 315) {
                    TiffIFD.checkType(tag, type, 2);
                    this._niso.setImageProducer(this.readASCII(count, value));
                    if (this._version < 5) {
                        this._version = 5;
                    }
                    break block410;
                }
                if (tag == 34024) {
                    TiffIFD.checkType(tag, type, 1);
                    TiffIFD.checkCount(tag, count, 1);
                    this._backgroundColorIndicator = this.readByte(type, count, value);
                    break block410;
                }
                if (tag == 34026) {
                    TiffIFD.checkType(tag, type, 1);
                    TiffIFD.checkCount(tag, count, 1);
                    this._backgroundColorValue = this.readByte(type, count, value);
                    break block410;
                }
                if (tag == 326) {
                    TiffIFD.checkType(tag, type, 3, 4);
                    TiffIFD.checkCount(tag, count, 1);
                    this._badFaxLines = this.readLong(type, count, value);
                    break block410;
                }
                if (tag == 33423) {
                    TiffIFD.checkType(tag, type, 5, 2);
                    if (type == 5) {
                        Rational r = this.readRational(count, value);
                        this._batteryLevel = Double.toString(r.toDouble());
                    } else {
                        this._batteryLevel = this.readASCII(count, value);
                    }
                    break block410;
                }
                if (tag == 34021) {
                    TiffIFD.checkType(tag, type, 3);
                    TiffIFD.checkCount(tag, count, 1);
                    this._bitsPerExtendedRunLength = this.readShort(type, count, value);
                    break block410;
                }
                if (tag == 34020) {
                    TiffIFD.checkType(tag, type, 3);
                    TiffIFD.checkCount(tag, count, 1);
                    this._bitsPerRunLength = this.readShort(type, count, value);
                    break block410;
                }
                if (tag == 258) {
                    TiffIFD.checkType(tag, type, 3);
                    this._niso.setBitsPerSample(this.readShortArray(type, count, value));
                    break block410;
                }
                if (tag == 37379) {
                    TiffIFD.checkType(tag, type, 10);
                    if (count == 1L) {
                        this._niso.setBrightness(this.readSignedRational(count, value).toDouble());
                    } else {
                        Rational[] r = this.readSignedRationalArray(count, value);
                        this._niso.setBrightness(TiffIFD.average(r[0], r[1]).toDouble());
                    }
                    break block410;
                }
                if (tag == 265) {
                    TiffIFD.checkType(tag, type, 3);
                    this._cellLength = this.readShort(type, count, value);
                    break block410;
                }
                if (tag == 264) {
                    TiffIFD.checkType(tag, type, 3);
                    this._cellWidth = this.readShort(type, count, value);
                    break block410;
                }
                if (tag == 33422) {
                    TiffIFD.checkType(tag, type, 1);
                    this._cfaPattern = this.readByteArray(type, count, value);
                    break block410;
                }
                if (tag == 33421) {
                    TiffIFD.checkType(tag, type, 3);
                    TiffIFD.checkCount(tag, count, 2);
                    this._cfaRepeatPatternDim = this.readShortArray(type, count, value);
                    break block410;
                }
                if (tag == 327) {
                    TiffIFD.checkType(tag, type, 3);
                    TiffIFD.checkCount(tag, count, 1);
                    this._badFaxLines = this.readShort(type, count, value);
                    break block410;
                }
                if (tag == 343) {
                    TiffIFD.checkType(tag, type, 1);
                    this._clipPath = this.readByteArray(type, count, value);
                    break block410;
                }
                if (tag == 34029) {
                    TiffIFD.checkType(tag, type, 2);
                    this._colorCharacterization = this.readASCII(count, value);
                    break block410;
                }
                if (tag == 34017) {
                    TiffIFD.checkType(tag, type, 2);
                    this._colorSequence = this.readASCII(count, value);
                    break block410;
                }
                if (tag == 320) {
                    TiffIFD.checkType(tag, type, 3);
                    int[] colorMap = this.readShortArray(type, count, value);
                    int[] bitCode = new int[colorMap.length];
                    int[] red = new int[colorMap.length];
                    int[] green = new int[colorMap.length];
                    int[] blue = new int[colorMap.length];
                    int len = colorMap.length / 3;
                    int len2 = 2 * len;
                    for (int i = 0; i < len; ++i) {
                        bitCode[i] = i;
                        red[i] = colorMap[i];
                        green[i] = colorMap[i + len];
                        blue[i] = colorMap[i + len2];
                    }
                    this._niso.setColormapBitCodeValue(bitCode);
                    this._niso.setColormapRedValue(red);
                    this._niso.setColormapGreenValue(green);
                    this._niso.setColormapBlueValue(blue);
                    if (this._version < 5) {
                        this._version = 5;
                    }
                    break block410;
                }
                if (tag == 34022) {
                    TiffIFD.checkType(tag, type, 1);
                    this._colorTable = this.readByteArray(type, count, value);
                    break block410;
                }
                if (tag == 37122) {
                    TiffIFD.checkType(tag, type, 5);
                    TiffIFD.checkCount(tag, count, 1);
                    this._compressedBitsPerPixel = this.readRational(count, value);
                    break block410;
                }
                if (tag == 259) {
                    TiffIFD.checkType(tag, type, 3);
                    TiffIFD.checkCount(tag, count, 1);
                    int scheme = this.readShort(type, count, value);
                    this._niso.setCompressionScheme(scheme);
                    if (scheme == 5) {
                        if (this._predictor == -1) {
                            this._predictor = 1;
                        }
                        if (this._version < 5) {
                            this._version = 5;
                        }
                    }
                    if (scheme == 6 && this._version < 6) {
                        this._version = 6;
                    }
                    if (scheme == 3 && this._t4Options == -1L) {
                        this._t4Options = 0L;
                    }
                    if (scheme == 4 && this._t6Options == -1L) {
                        this._t6Options = 0L;
                    }
                    if (scheme == 6) {
                        this._info.setMessage((Message)new InfoMessage("TIFF compression scheme 6 is deprecated"));
                    }
                    break block410;
                }
                if (tag == 328) {
                    TiffIFD.checkType(tag, type, 3, 4);
                    TiffIFD.checkCount(tag, count, 1);
                    this._consecutiveBadFaxLines = this.readLong(type, count, value);
                    break block410;
                }
                if (tag == 33432) {
                    TiffIFD.checkType(tag, type, 2);
                    this._copyright = this.readASCII(count, value);
                    if (this._version < 6) {
                        this._version = 6;
                    }
                    break block410;
                }
                if (tag == 306) {
                    TiffIFD.checkType(tag, type, 2);
                    TiffIFD.checkCount(tag, count, 20);
                    this._dateTime = this.readASCII(count, value);
                    this._niso.setDateTimeCreated(this._dateTime);
                    if (this._version < 5) {
                        this._version = 5;
                    }
                    break block410;
                }
                if (tag == 36867) {
                    TiffIFD.checkType(tag, type, 2);
                    TiffIFD.checkCount(tag, count, 20);
                    this._niso.setDateTimeCreated(this.readASCII(count, value));
                    break block410;
                }
                if (tag == 269) {
                    TiffIFD.checkType(tag, type, 2);
                    this._documentName = this.readASCII(count, value);
                    break block410;
                }
                if (tag == 336) {
                    TiffIFD.checkType(tag, type, 1, 3);
                    TiffIFD.checkCount(tag, count, 2);
                    this._dotRange = this.readShortArray(type, count, value);
                    if (this._version < 6) {
                        this._version = 6;
                    }
                    break block410;
                }
                if (tag == 34665) {
                    TiffIFD.checkType(tag, type, 4);
                    TiffIFD.checkCount(tag, count, 1);
                    this._exifIFD = this.readLong(type, count, value);
                    break block410;
                }
                if (tag == 37380) {
                    TiffIFD.checkType(tag, type, 10);
                    if (count == 1L) {
                        this._niso.setExposureBias(this.readSignedRational(count, value).toDouble());
                    } else {
                        Rational[] r = this.readSignedRationalArray(count, value);
                        this._niso.setExposureBias(TiffIFD.average(r[0], r[1]).toDouble());
                    }
                    break block410;
                }
                if (tag == 34850) {
                    TiffIFD.checkType(tag, type, 3);
                    TiffIFD.checkCount(tag, count, 1);
                    this._exposureProgram = this.readShort(type, count, value);
                    break block410;
                }
                if (tag == 33434) {
                    TiffIFD.checkType(tag, type, 5);
                    if (count == 1L) {
                        this._niso.setExposureTime(this.readRational(count, value).toDouble());
                    } else {
                        Rational[] r = this.readRationalArray(count, value);
                        this._niso.setExposureTime(TiffIFD.average(r[0], r[1]).toDouble());
                    }
                    break block410;
                }
                if (tag == 338) {
                    TiffIFD.checkType(tag, type, 3);
                    this._niso.setExtraSamples(this.readShortArray(type, count, value));
                    if (this._version < 6) {
                        this._version = 6;
                    }
                    break block410;
                }
                if (tag == 266) {
                    TiffIFD.checkType(tag, type, 3);
                    TiffIFD.checkCount(tag, count, 1);
                    this._fillOrder = this.readShort(type, count, value);
                    break block410;
                }
                if (tag == 37385) {
                    TiffIFD.checkType(tag, type, 3);
                    TiffIFD.checkCount(tag, count, 1);
                    this._flash = this.readShort(type, count, value);
                    this._niso.setFlash(this._flash);
                    this._niso.setFlashReturn((this._flash & 6) != 0 ? 1 : 0);
                    break block410;
                }
                if (tag == 37387) {
                    TiffIFD.checkType(tag, type, 5);
                    if (count == 1L) {
                        this._niso.setFlashEnergy(this.readRational(count, value).toDouble());
                    } else {
                        Rational[] r = this.readRationalArray(count, value);
                        this._niso.setFlashEnergy(TiffIFD.average(r[0], r[1]).toDouble());
                    }
                    break block410;
                }
                if (tag == 33437) {
                    TiffIFD.checkType(tag, type, 5);
                    if (count == 1L) {
                        this._niso.setFNumber(this.readRational(count, value).toDouble());
                    } else {
                        Rational[] r = this.readRationalArray(count, value);
                        this._niso.setFNumber(TiffIFD.average(r[0], r[1]).toDouble());
                    }
                    break block410;
                }
                if (tag == 37386) {
                    TiffIFD.checkType(tag, type, 5);
                    if (count == 1L) {
                        this._niso.setFocalLength(this.readRational(count, value).toDouble());
                    } else {
                        Rational[] r = this.readRationalArray(count, value);
                        this._niso.setFocalLength(TiffIFD.average(r[0], r[1]).toDouble());
                    }
                    break block410;
                }
                if (tag == 37392) {
                    TiffIFD.checkType(tag, type, 3);
                    TiffIFD.checkCount(tag, count, 1);
                    this._focalPlaneResolutionUnit = this.readShort(type, count, value);
                    if (this._niso.getSamplingFrequencyUnit() != -1) {
                        this._niso.setSamplingFrequencyUnit(this._focalPlaneResolutionUnit);
                    }
                    break block410;
                }
                if (tag == 37390) {
                    TiffIFD.checkType(tag, type, 5);
                    TiffIFD.checkCount(tag, count, 1);
                    this._focalPlaneXResolution = this.readRational(count, value);
                    break block410;
                }
                if (tag == 37391) {
                    TiffIFD.checkType(tag, type, 5);
                    TiffIFD.checkCount(tag, count, 1);
                    this._focalPlaneYResolution = this.readRational(count, value);
                    break block410;
                }
                if (tag == 289) {
                    TiffIFD.checkType(tag, type, 4);
                    this._freeByteCounts = this.readLongArray(type, count, value);
                    break block410;
                }
                if (tag == 288) {
                    TiffIFD.checkType(tag, type, 4);
                    this._freeOffsets = this.readLongArray(type, count, value);
                    break block410;
                }
                if (tag == 34737) {
                    TiffIFD.checkType(tag, type, 2);
                    this._geoAsciiParamsTag = this.readASCII(count, value);
                    break block410;
                }
                if (tag == 34736) {
                    TiffIFD.checkType(tag, type, 12);
                    this._geoDoubleParamsTag = this.readDoubleArray(count, value);
                    break block410;
                }
                if (tag == 34735) {
                    TiffIFD.checkType(tag, type, 3);
                    this._geoKeyDirectoryTag = this.readShortArray(type, count, value);
                    int num = this._geoKeyDirectoryTag[3];
                    int prevKey = -1;
                    for (int i = 0; i < num; ++i) {
                        int j = i * 4 + 4;
                        int key = this._geoKeyDirectoryTag[j];
                        if (prevKey > key) {
                            throw new TiffException("GeoKey " + key + " out of sequence");
                        }
                        prevKey = key;
                    }
                    break block410;
                }
                if (tag == 400) {
                    TiffIFD.checkType(tag, type, 4, 13);
                    TiffIFD.checkCount(tag, count, 1);
                    this._globalParametersIFD = this.readLong(type, count, value);
                    break block410;
                }
                if (tag == 34853) {
                    TiffIFD.checkType(tag, type, 4);
                    TiffIFD.checkCount(tag, count, 1);
                    this._gpsInfoIFD = this.readLong(type, count, value);
                    break block410;
                }
                if (tag == 291) {
                    TiffIFD.checkType(tag, type, 3);
                    this._niso.setGrayResponseCurve(this.readShortArray(type, count, value));
                    break block410;
                }
                if (tag == 290) {
                    TiffIFD.checkType(tag, type, 3);
                    TiffIFD.checkCount(tag, count, 1);
                    this._niso.setGrayResponseUnit(this.readShort(type, count, value));
                    break block410;
                }
                if (tag == 321) {
                    TiffIFD.checkType(tag, type, 3);
                    TiffIFD.checkCount(tag, count, 2);
                    this._halftoneHints = this.readShortArray(type, count, value);
                    if (this._version < 6) {
                        this._version = 6;
                    }
                    break block410;
                }
                if (tag == 34030) {
                    TiffIFD.checkType(tag, type, 4);
                    TiffIFD.checkCount(tag, count, 1);
                    this._hcUsage = this.readLong(type, count, value);
                    break block410;
                }
                if (tag == 316) {
                    TiffIFD.checkType(tag, type, 2);
                    this._niso.setHostComputer(this.readASCII(count, value));
                    if (this._version < 5) {
                        this._version = 5;
                    }
                    break block410;
                }
                if (tag == 270) {
                    TiffIFD.checkType(tag, type, 2);
                    this._imageDescription = this.readASCII(count, value);
                    break block410;
                }
                if (tag == 32781) {
                    TiffIFD.checkType(tag, type, 2);
                    this._niso.setImageIdentifier(this.readASCII(count, value));
                    break block410;
                }
                if (tag == 34023) {
                    TiffIFD.checkType(tag, type, 1);
                    TiffIFD.checkCount(tag, count, 1);
                    this._imageColorIndicator = this.readByte(type, count, value);
                    break block410;
                }
                if (tag == 34025) {
                    TiffIFD.checkType(tag, type, 1);
                    TiffIFD.checkCount(tag, count, 1);
                    this._imageColorValue = this.readByte(type, count, value);
                    break block410;
                }
                if (tag == 37395) {
                    TiffIFD.checkType(tag, type, 2);
                    this._imageHistory = this.readASCII(count, value);
                    break block410;
                }
                if (tag == 34732) {
                    TiffIFD.checkType(tag, type, 3, 4);
                    TiffIFD.checkCount(tag, count, 2);
                    this._imageLayer = this.readShortArray(type, count, value);
                    break block410;
                }
                if (tag == 257) {
                    TiffIFD.checkType(tag, type, 3, 4);
                    TiffIFD.checkCount(tag, count, 1);
                    this._niso.setImageLength(this.readLong(type, count, value));
                    break block410;
                }
                if (tag == 37393) {
                    TiffIFD.checkType(tag, type, 4);
                    TiffIFD.checkCount(tag, count, 1);
                    this._imageNumber = this.readLong(type, count, value);
                    break block410;
                }
                if (tag == 37724) {
                    TiffIFD.checkType(tag, type, 7);
                    this._imageSourceData = new int[]{1};
                    break block410;
                }
                if (tag == 34377) {
                    this._photoshopProperties = this.readByteArray(type, count, value);
                    break block410;
                }
                if (tag == 50255) {
                    this._annotations = this.readByteArray(type, count, value);
                    break block410;
                }
                if (tag == 256) {
                    TiffIFD.checkType(tag, type, 3, 4);
                    TiffIFD.checkCount(tag, count, 1);
                    this._niso.setImageWidth(this.readLong(type, count, value));
                    break block410;
                }
                if (tag == 346) {
                    TiffIFD.checkType(tag, type, 3);
                    TiffIFD.checkCount(tag, count, 1);
                    this._indexed = this.readShort(type, count, value);
                    break block410;
                }
                if (tag == 333) {
                    TiffIFD.checkType(tag, type, 2);
                    this._inkNames = this.readASCIIArray(count, value);
                    if (this._version < 6) {
                        this._version = 6;
                    }
                    break block410;
                }
                if (tag == 332) {
                    TiffIFD.checkType(tag, type, 3);
                    TiffIFD.checkCount(tag, count, 1);
                    this._inkSet = this.readShort(type, count, value);
                    if (this._version < 6) {
                        this._version = 6;
                    }
                    break block410;
                }
                if (tag == 34675) {
                    TiffIFD.checkType(tag, type, 7);
                    this._iccProfile = this.readTrueByteArray(type, count, value);
                    try {
                        String desc = NisoImageMetadata.extractIccProfileDescription((byte[])this._iccProfile);
                        if (desc != null) {
                            this._niso.setProfileName(desc);
                        }
                        break block410;
                    }
                    catch (IllegalArgumentException ie) {
                        throw new TiffException("Bad ICCProfile in tag " + tag + "; message " + ie.getMessage());
                    }
                }
                if (tag == 34857) {
                    TiffIFD.checkType(tag, type, 3);
                    TiffIFD.checkCount(tag, count, 1);
                    this._interlace = this.readShort(type, count, value);
                } else if (tag == 40965) {
                    TiffIFD.checkType(tag, type, 4);
                    TiffIFD.checkCount(tag, count, 1);
                    this._interoperabilityIFD = this.readLong(type, count, value);
                } else if (tag == 33723) {
                    if (type == 2) {
                        String s = this.readASCII(count, value);
                        long[] larray = new long[s.length()];
                        for (int i = 0; i < s.length(); ++i) {
                            larray[i] = s.charAt(i);
                        }
                        this._iptc = larray;
                    } else if (type == 4) {
                        this._iptc = this.readLongArray(type, count, value);
                    } else {
                        TiffIFD.checkType(tag, type, 1, 7);
                        int[] b = this.readByteArray(type, count, value);
                        long[] larray = new long[b.length];
                        for (int i = 0; i < b.length; ++i) {
                            larray[i] = b[i];
                            this._iptc = larray;
                        }
                    }
                } else if (tag == 34855) {
                    TiffIFD.checkType(tag, type, 3);
                    TiffIFD.checkCount(tag, count, 1);
                    this._isoSpeedRatings = this.readShortArray(tag, count, value);
                } else if (tag == 34018) {
                    TiffIFD.checkType(tag, type, 2);
                    this._it8Header = this.readASCII(count, value);
                } else if (tag == 521) {
                    TiffIFD.checkType(tag, type, 4);
                    this._jpegACTables = this.readLongArray(type, count, value);
                    if (this._version < 6) {
                        this._version = 6;
                    }
                } else if (tag == 520) {
                    TiffIFD.checkType(tag, type, 4);
                    this._jpegDCTables = this.readLongArray(type, count, value);
                    if (this._version < 6) {
                        this._version = 6;
                    }
                } else if (tag == 513) {
                    TiffIFD.checkType(tag, type, 4);
                    TiffIFD.checkCount(tag, count, 1);
                    this._jpegInterchangeFormat = this.readLong(type, count, value);
                    if (this._version < 6) {
                        this._version = 6;
                    }
                } else if (tag == 514) {
                    TiffIFD.checkType(tag, type, 4);
                    TiffIFD.checkCount(tag, count, 1);
                    this._jpegInterchangeFormatLength = this.readLong(type, count, value);
                    if (this._version < 6) {
                        this._version = 6;
                    }
                } else if (tag == 517) {
                    TiffIFD.checkType(tag, type, 3);
                    this._jpegLosslessPredictors = this.readShortArray(type, count, value);
                    if (this._version < 6) {
                        this._version = 6;
                    }
                } else if (tag == 518) {
                    TiffIFD.checkType(tag, type, 3);
                    this._jpegPointTransforms = this.readShortArray(type, count, value);
                    if (this._version < 6) {
                        this._version = 6;
                    }
                } else if (tag == 512) {
                    TiffIFD.checkType(tag, type, 3);
                    TiffIFD.checkCount(tag, count, 1);
                    this._jpegProc = this.readShort(type, count, value);
                    if (this._version < 6) {
                        this._version = 6;
                    }
                } else if (tag == 519) {
                    TiffIFD.checkType(tag, type, 4);
                    this._jpegQTables = this.readLongArray(type, count, value);
                    if (this._version < 6) {
                        this._version = 6;
                    }
                } else if (tag == 515) {
                    TiffIFD.checkType(tag, type, 3);
                    TiffIFD.checkCount(tag, count, 1);
                    this._jpegRestartInterval = this.readShort(type, count, value);
                    if (this._version < 6) {
                        this._version = 6;
                    }
                } else if (tag == 347) {
                    TiffIFD.checkType(tag, type, 7);
                    this._jpegTables = this.readByteArray(type, count, value);
                } else if (tag == 37384) {
                    TiffIFD.checkType(tag, type, 3);
                    TiffIFD.checkCount(tag, count, 1);
                    this._niso.setSceneIlluminant(this.readShort(type, count, value));
                } else if (tag == 271) {
                    TiffIFD.checkType(tag, type, 2);
                    this._niso.setScannerManufacturer(this.readASCII(count, value));
                } else if (tag == 37381) {
                    TiffIFD.checkType(tag, type, 5);
                    TiffIFD.checkCount(tag, count, 1);
                    this._maxAperatureValue = this.readRational(count, value);
                } else if (tag == 281) {
                    TiffIFD.checkType(tag, type, 3);
                    this._maxSampleValue = this.readShortArray(type, count, value);
                } else if (tag == 37383) {
                    TiffIFD.checkType(tag, type, 3);
                    TiffIFD.checkCount(tag, count, 1);
                    this._niso.setMeteringMode(this.readShort(type, count, value));
                } else if (tag == 280) {
                    TiffIFD.checkType(tag, type, 3);
                    this._minSampleValue = this.readShortArray(type, count, value);
                } else if (tag == 272) {
                    TiffIFD.checkType(tag, type, 2);
                    this._niso.setScannerModelName(this.readASCII(count, value));
                } else if (tag == 33550) {
                    TiffIFD.checkType(tag, type, 12);
                    TiffIFD.checkCount(tag, count, 3);
                    this._modelPixelScaleTag = this.readDoubleArray(count, value);
                } else if (tag == 33922) {
                    TiffIFD.checkType(tag, type, 12);
                    this._modelTiepointTag = this.readDoubleArray(count, value);
                } else if (tag == 34264) {
                    TiffIFD.checkType(tag, type, 12);
                    TiffIFD.checkCount(tag, count, 16);
                    this._modelTransformationTag = this.readDoubleArray(count, value);
                } else if (tag == 254) {
                    TiffIFD.checkType(tag, type, 4);
                    TiffIFD.checkCount(tag, count, 1);
                    this._newSubfileType = this.readLong(type, count, value);
                    if (this._version < 5) {
                        this._version = 5;
                    }
                } else if (tag == 37389) {
                    TiffIFD.checkType(tag, type, 7);
                    this._noise = this.readByteArray(type, count, value);
                } else if (tag == 334) {
                    TiffIFD.checkType(tag, type, 3);
                    TiffIFD.checkCount(tag, count, 1);
                    this._numberOfInks = this.readShort(type, count, value);
                    if (this._version < 6) {
                        this._version = 6;
                    }
                } else if (tag == 34856) {
                    TiffIFD.checkType(tag, type, 7);
                    this._oecf = this.readByteArray(tag, count, value);
                } else if (tag == 351) {
                    TiffIFD.checkType(tag, type, 3);
                    TiffIFD.checkCount(tag, count, 1);
                    this._opiProxy = this.readShort(type, count, value);
                } else if (tag == 274) {
                    TiffIFD.checkType(tag, type, 3);
                    TiffIFD.checkCount(tag, count, 1);
                    this._niso.setOrientation(this.readShort(type, count, value));
                } else if (tag == 285) {
                    TiffIFD.checkType(tag, type, 2);
                    this._pageName = this.readASCII(count, value);
                } else if (tag == 297) {
                    TiffIFD.checkType(tag, type, 3);
                    TiffIFD.checkCount(tag, count, 2);
                    this._pageNumber = this.readShortArray(type, count, value);
                } else if (tag == 262) {
                    int colorSpace;
                    TiffIFD.checkType(tag, type, 3);
                    TiffIFD.checkCount(tag, count, 1);
                    this._photometricInterpretation = this.readShort(type, count, value);
                    this._niso.setColorSpace(this._photometricInterpretation);
                    if (this._photometricInterpretation == 5) {
                        if (this._inkSet == -1) {
                            this._inkSet = 1;
                        }
                        if (this._numberOfInks == -1) {
                            this._numberOfInks = 4;
                        }
                    } else if (this._photometricInterpretation == 6) {
                        if (this._niso.getYCbCrCoefficients() == null) {
                            this._niso.setYCbCrCoefficients(new Rational[]{new Rational(299, 1000), new Rational(587, 1000), new Rational(114, 1000)});
                        }
                        if (this._niso.getYCbCrPositioning() == -1) {
                            this._niso.setYCbCrPositioning(1);
                        }
                        if (this._niso.getYCbCrSubSampling() == null) {
                            this._niso.setYCbCrSubSampling(new int[]{2, 2});
                        }
                    }
                    if ((colorSpace = this._niso.getColorSpace()) == 3 || colorSpace == 4) {
                        if (this._version < 5) {
                            this._version = 5;
                        }
                    } else if ((colorSpace == 5 || colorSpace == 6 || colorSpace == 8) && this._version < 6) {
                        this._version = 6;
                    }
                } else if (tag == 34027) {
                    TiffIFD.checkType(tag, type, 1);
                    this._pixelIntensityRange = this.readShortArray(type, count, value);
                } else if (tag == 284) {
                    TiffIFD.checkType(tag, type, 3);
                    TiffIFD.checkCount(tag, count, 1);
                    this._niso.setPlanarConfiguration(this.readShort(type, count, value));
                } else if (tag == 317) {
                    TiffIFD.checkType(tag, type, 3);
                    TiffIFD.checkCount(tag, count, 1);
                    this._predictor = this.readShort(type, count, value);
                    if (this._version < 5) {
                        this._version = 5;
                    }
                } else if (tag == 319) {
                    TiffIFD.checkType(tag, type, 5);
                    TiffIFD.checkCount(tag, count, 6);
                    Rational[] rarray = this.readRationalArray(count, value);
                    this._niso.setPrimaryChromaticitiesRedX(rarray[0]);
                    this._niso.setPrimaryChromaticitiesRedY(rarray[1]);
                    this._niso.setPrimaryChromaticitiesGreenX(rarray[2]);
                    this._niso.setPrimaryChromaticitiesGreenY(rarray[3]);
                    this._niso.setPrimaryChromaticitiesBlueX(rarray[4]);
                    this._niso.setPrimaryChromaticitiesBlueY(rarray[5]);
                    if (this._version < 5) {
                        this._version = 5;
                    }
                } else if (tag == 34019) {
                    TiffIFD.checkType(tag, type, 3);
                    TiffIFD.checkCount(tag, count, 1);
                    this._rasterPadding = this.readShort(type, count, value);
                } else if (tag == 532) {
                    TiffIFD.checkType(tag, type, 5);
                    TiffIFD.checkCount(tag, count, 6);
                    this._niso.setReferenceBlackWhite(this.readRationalArray(count, value));
                    if (this._version < 6) {
                        this._version = 6;
                    }
                } else if (tag == 296) {
                    TiffIFD.checkType(tag, type, 3);
                    TiffIFD.checkCount(tag, count, 1);
                    this._niso.setSamplingFrequencyUnit(this.readShort(type, count, value));
                } else if (tag == 278) {
                    TiffIFD.checkType(tag, type, 3, 4);
                    TiffIFD.checkCount(tag, count, 1);
                    this._niso.setRowsPerStrip(this.readLong(type, count, value));
                } else if (tag == 339) {
                    TiffIFD.checkType(tag, type, 3);
                    this._sampleFormat = this.readShortArray(type, count, value);
                    if (this._version < 6) {
                        this._version = 6;
                    }
                } else if (tag == 277) {
                    TiffIFD.checkType(tag, type, 3);
                    TiffIFD.checkCount(tag, count, 1);
                    this._niso.setSamplesPerPixel(this.readShort(type, count, value));
                } else if (tag == 37394) {
                    TiffIFD.checkType(tag, type, 2);
                    this._securityClassification = this.readASCII(count, value);
                } else if (tag == 34859) {
                    TiffIFD.checkType(tag, type, 3);
                    TiffIFD.checkCount(tag, count, 1);
                    this._selfTimerMode = this.readShort(type, count, value);
                } else if (tag == 37399) {
                    TiffIFD.checkType(tag, type, 3);
                    TiffIFD.checkCount(tag, count, 1);
                    this._niso.setSensor(this.readShort(type, count, value));
                } else if (tag == 34016) {
                    TiffIFD.checkType(tag, type, 2);
                    this._site = this.readASCII(count, value);
                } else if (tag == 559) {
                    TiffIFD.checkType(tag, type, 4);
                    this._stripRowCounts = this.readLongArray(type, count, value);
                } else if (tag == 37382) {
                    TiffIFD.checkType(tag, type, 5, 10);
                    double[] darray = new double[2];
                    if (count == 1L) {
                        darray[0] = this.readRational(count, value).toDouble();
                        darray[1] = darray[0];
                    } else {
                        Rational[] r = type == 5 ? this.readRationalArray(count, value) : this.readSignedRationalArray(count, value);
                        darray[0] = r[0].toDouble();
                        darray[1] = r.length > 1 ? r[1].toDouble() : darray[0];
                    }
                    this._niso.setSubjectDistance(darray);
                } else if (tag == 305) {
                    TiffIFD.checkType(tag, type, 2);
                    this._niso.setScanningSoftware(this.readASCII(count, value));
                    if (this._version < 5) {
                        this._version = 5;
                    }
                } else if (tag == 37388) {
                    TiffIFD.checkType(tag, type, 7);
                    this._spatialFrequencyResponse = this.readByteArray(type, count, value);
                } else if (tag == 34852) {
                    TiffIFD.checkType(tag, type, 2);
                    this._spectralSensitivity = this.readASCII(count, value);
                } else if (tag == 279) {
                    TiffIFD.checkType(tag, type, 3, 4);
                    this._niso.setStripByteCounts(this.readLongArray(type, count, value));
                } else if (tag == 273) {
                    TiffIFD.checkType(tag, type, 3, 4);
                    this._niso.setStripOffsets(this.readLongArray(type, count, value));
                } else if (tag == 255) {
                    TiffIFD.checkType(tag, type, 4);
                    TiffIFD.checkCount(tag, count, 1);
                    this._subfileType = this.readShort(type, count, value);
                } else if (tag == 330) {
                    TiffIFD.checkType(tag, type, 4, 13);
                    this._subIFDs = this.readLongArray(type, count, value);
                } else if (tag == 37396) {
                    TiffIFD.checkType(tag, type, 3);
                    this._subjectLocation = this.readShortArray(type, count, value);
                } else if (tag == 292) {
                    TiffIFD.checkType(tag, type, 4);
                    this._t4Options = this.readShort(type, count, value);
                } else if (tag == 293) {
                    TiffIFD.checkType(tag, type, 4);
                    this._t6Options = this.readShort(type, count, value);
                } else if (tag == 337) {
                    TiffIFD.checkType(tag, type, 2);
                    this._targetPrinter = this.readASCII(count, value);
                    if (this._version < 6) {
                        this._version = 6;
                    }
                } else if (tag == 263) {
                    TiffIFD.checkType(tag, type, 3);
                    TiffIFD.checkCount(tag, count, 1);
                    this._threshholding = this.readShort(type, count, value);
                } else if (tag == 37398) {
                    TiffIFD.checkType(tag, type, 3);
                    TiffIFD.checkCount(tag, count, 4);
                    int[] iarray = this.readShortArray(type, count, value);
                    this._tiffEPStandardID = Integer.toString(iarray[0]) + "." + Integer.toString(iarray[1]) + "." + Integer.toString(iarray[2]) + "." + Integer.toString(iarray[3]);
                } else if (tag == 325) {
                    TiffIFD.checkType(tag, type, 3, 4);
                    this._niso.setTileByteCounts(this.readLongArray(type, count, value));
                    if (this._version < 6) {
                        this._version = 6;
                    }
                } else if (tag == 323) {
                    TiffIFD.checkType(tag, type, 3, 4);
                    TiffIFD.checkCount(tag, count, 1);
                    this._niso.setTileLength(this.readLong(type, count, value));
                    if (this._version < 6) {
                        this._version = 6;
                    }
                } else if (tag == 324) {
                    TiffIFD.checkType(tag, type, 3, 4);
                    this._niso.setTileOffsets(this.readLongArray(type, count, value));
                    if (this._version < 6) {
                        this._version = 6;
                    }
                } else if (tag == 322) {
                    TiffIFD.checkType(tag, type, 3, 4);
                    TiffIFD.checkCount(tag, count, 1);
                    this._niso.setTileWidth(this.readLong(type, count, value));
                    if (this._version < 6) {
                        this._version = 6;
                    }
                } else if (tag == 34858) {
                    TiffIFD.checkType(tag, type, 8);
                    this._timeZoneOffset = this.readSShortArray(type, count, value);
                } else if (tag == 301) {
                    TiffIFD.checkType(tag, type, 3);
                    this._transferFunction = true;
                } else if (tag == 342) {
                    TiffIFD.checkType(tag, type, 3);
                    TiffIFD.checkCount(tag, count, 6);
                    this._transferRange = this.readShortArray(type, count, value);
                    if (this._version < 6) {
                        this._version = 6;
                    }
                } else if (tag == 34028) {
                    TiffIFD.checkType(tag, type, 1);
                    TiffIFD.checkCount(tag, count, 1);
                    this._transparencyIndicator = this.readByte(type, count, value);
                } else if (tag == 318) {
                    TiffIFD.checkType(tag, type, 5);
                    TiffIFD.checkCount(tag, count, 2);
                    Rational[] rarray = this.readRationalArray(count, value);
                    this._niso.setWhitePointXValue(rarray[0]);
                    this._niso.setWhitePointYValue(rarray[0]);
                    if (this._version < 5) {
                        this._version = 5;
                    }
                } else if (tag == 344) {
                    TiffIFD.checkType(tag, type, 4);
                    TiffIFD.checkCount(tag, count, 1);
                    this._xClipPathUnits = this.readLong(type, count, value);
                } else if (tag == 286) {
                    TiffIFD.checkType(tag, type, 5);
                    TiffIFD.checkCount(tag, count, 1);
                    this._xPosition = this.readRational(count, value);
                } else if (tag == 282) {
                    TiffIFD.checkType(tag, type, 5);
                    TiffIFD.checkCount(tag, count, 1);
                    this._niso.setXSamplingFrequency(this.readRational(count, value));
                } else if (tag == 529) {
                    TiffIFD.checkType(tag, type, 5);
                    TiffIFD.checkCount(tag, count, 3);
                    this._niso.setYCbCrCoefficients(this.readRationalArray(count, value));
                    if (this._version < 6) {
                        this._version = 6;
                    }
                } else if (tag == 531) {
                    TiffIFD.checkType(tag, type, 3);
                    TiffIFD.checkCount(tag, count, 1);
                    this._niso.setYCbCrPositioning(this.readShort(type, count, value));
                    if (this._version < 6) {
                        this._version = 6;
                    }
                } else if (tag == 530) {
                    TiffIFD.checkType(tag, type, 3);
                    TiffIFD.checkCount(tag, count, 2);
                    this._niso.setYCbCrSubSampling(this.readShortArray(type, count, value));
                    if (this._version < 6) {
                        this._version = 6;
                    }
                } else if (tag == 345) {
                    TiffIFD.checkType(tag, type, 4);
                    TiffIFD.checkCount(tag, count, 1);
                    this._yClipPathUnits = this.readLong(type, count, value);
                } else if (tag == 287) {
                    TiffIFD.checkType(tag, type, 5);
                    TiffIFD.checkCount(tag, count, 1);
                    this._yPosition = this.readRational(count, value);
                } else if (tag == 283) {
                    TiffIFD.checkType(tag, type, 5);
                    TiffIFD.checkCount(tag, count, 1);
                    this._niso.setYSamplingFrequency(this.readRational(count, value));
                } else if (tag == 700) {
                    TiffIFD.checkType(tag, type, 7, 1);
                    this._xmpProp = this.readXMP(count, value);
                } else if (tag == 50706) {
                    TiffIFD.checkType(tag, type, 1);
                    TiffIFD.checkCount(tag, count, 4);
                    this._dngVersion = this.readByteArray(type, count, value);
                } else if (tag == 50707) {
                    TiffIFD.checkType(tag, type, 1);
                    TiffIFD.checkCount(tag, count, 4);
                    this._dngBackwardVersion = this.readByteArray(type, count, value);
                } else if (tag == 50708) {
                    TiffIFD.checkType(tag, type, 2);
                    this._uniqueCameraModel = this.readASCII(count, value);
                } else if (tag == 50709) {
                    int len;
                    TiffIFD.checkType(tag, type, 2, 1);
                    byte[] lcm = this.readTrueByteArray(type, count, value);
                    for (len = lcm.length; len > 0 && lcm[len - 1] == 0; --len) {
                    }
                    this._localizedCameraModel = new String(lcm, 0, len);
                } else if (tag == 50710) {
                    TiffIFD.checkType(tag, type, 1);
                    this._cfaPlaneColor = this.readByteArray(type, count, value);
                } else if (tag == 50711) {
                    TiffIFD.checkType(tag, type, 3);
                    this._cfaLayout = this.readShort(type, count, value);
                } else if (tag == 50712) {
                    TiffIFD.checkType(tag, type, 3);
                    this._linearizationTable = this.readShortArray(type, count, value);
                } else if (tag == 50713) {
                    TiffIFD.checkType(tag, type, 3);
                    this._blackLevelRepeatDim = this.readShortArray(type, count, value);
                } else if (tag == 50714) {
                    if (type == 5) {
                        this._blackLevel = this.readRationalArray(count, value);
                    } else {
                        TiffIFD.checkType(tag, type, 3, 4);
                        long[] ibl = this.readLongArray(type, count, value);
                        this._blackLevel = new Rational[(int)count];
                        int i = 0;
                        while ((long)i < count) {
                            this._blackLevel[i] = new Rational(ibl[i], 1L);
                            ++i;
                        }
                    }
                } else if (tag == 50715) {
                    TiffIFD.checkType(tag, type, 10);
                    this._blackLevelDeltaH = this.readSignedRationalArray(count, value);
                } else if (tag == 50716) {
                    TiffIFD.checkType(tag, type, 10);
                    this._blackLevelDeltaV = this.readSignedRationalArray(count, value);
                } else if (tag == 50717) {
                    TiffIFD.checkType(tag, type, 3, 4);
                    this._whiteLevel = this.readLongArray(type, count, value);
                } else if (tag == 50718) {
                    TiffIFD.checkType(tag, type, 5);
                    TiffIFD.checkCount(tag, count, 2);
                    this._defaultScale = this.readRationalArray(count, value);
                } else if (tag == 50780) {
                    TiffIFD.checkType(tag, type, 5);
                    TiffIFD.checkCount(tag, count, 1);
                    this._bestQualityScale = this.readRational(count, value);
                } else if (tag == 50719) {
                    TiffIFD.checkCount(tag, count, 2);
                    if (type == 5) {
                        this._defaultCropOrigin = this.readRationalArray(count, value);
                    } else {
                        TiffIFD.checkType(tag, type, 3, 4);
                        long[] lco = this.readLongArray(type, count, value);
                        this._defaultCropOrigin = new Rational[(int)count];
                        int i = 0;
                        while ((long)i < count) {
                            this._defaultCropOrigin[i] = new Rational(lco[i], 1L);
                            ++i;
                        }
                    }
                } else if (tag == 50720) {
                    TiffIFD.checkCount(tag, count, 2);
                    if (type == 5) {
                        this._defaultCropSize = this.readRationalArray(count, value);
                    } else {
                        TiffIFD.checkType(tag, type, 3, 4);
                        long[] lcs = this.readLongArray(type, count, value);
                        this._defaultCropSize = new Rational[(int)count];
                        int i = 0;
                        while ((long)i < count) {
                            this._defaultCropSize[i] = new Rational(lcs[i], 1L);
                            ++i;
                        }
                    }
                } else if (tag == 50778) {
                    TiffIFD.checkCount(tag, count, 1);
                    TiffIFD.checkType(tag, type, 3);
                    this._calibrationIlluminant1 = this.readShort(type, count, value);
                } else if (tag == 50779) {
                    TiffIFD.checkCount(tag, count, 1);
                    TiffIFD.checkType(tag, type, 3);
                    this._calibrationIlluminant2 = this.readShort(type, count, value);
                } else if (tag == 50721) {
                    TiffIFD.checkType(tag, type, 10);
                    this._colorMatrix1 = this.readSignedRationalArray(count, value);
                } else if (tag == 50722) {
                    TiffIFD.checkType(tag, type, 10);
                    this._colorMatrix2 = this.readSignedRationalArray(count, value);
                } else if (tag == 50723) {
                    TiffIFD.checkType(tag, type, 10);
                    this._colorMatrix1 = this.readSignedRationalArray(count, value);
                } else if (tag == 50724) {
                    TiffIFD.checkType(tag, type, 10);
                    this._colorMatrix2 = this.readSignedRationalArray(count, value);
                } else if (tag == 50725) {
                    TiffIFD.checkType(tag, type, 10);
                    this._reductionMatrix1 = this.readSignedRationalArray(count, value);
                } else if (tag == 50726) {
                    TiffIFD.checkType(tag, type, 10);
                    this._reductionMatrix2 = this.readSignedRationalArray(count, value);
                } else if (tag == 50727) {
                    TiffIFD.checkType(tag, type, 5);
                    this._analogBalance = this.readRationalArray(count, value);
                } else if (tag == 50728) {
                    TiffIFD.checkType(tag, type, 3, 5);
                    if (type == 3) {
                        int[] asn = this.readShortArray(type, count, value);
                        this._asShotNeutral = new Rational[(int)count];
                        int i = 0;
                        while ((long)i < count) {
                            this._asShotNeutral[i] = new Rational(asn[i], 1);
                            ++i;
                        }
                    } else {
                        this._asShotNeutral = this.readRationalArray(count, value);
                    }
                } else if (tag == 50729) {
                    TiffIFD.checkType(tag, type, 5);
                    TiffIFD.checkCount(tag, count, 2);
                    this._asShotWhiteXY = this.readRationalArray(count, value);
                } else if (tag == 50730) {
                    TiffIFD.checkType(tag, type, 10);
                    this._baselineExposure = this.readSignedRational(count, value);
                } else if (tag == 50731) {
                    TiffIFD.checkType(tag, type, 5);
                    this._baselineNoise = this.readRational(count, value);
                } else if (tag == 50732) {
                    TiffIFD.checkType(tag, type, 5);
                    this._baselineSharpness = this.readRational(count, value);
                } else if (tag == 50733) {
                    TiffIFD.checkType(tag, type, 4);
                    this._bayerGreenSplit = (int)this.readLong(type, count, value);
                } else if (tag == 50734) {
                    TiffIFD.checkType(tag, type, 5);
                    this._linearResponseLimit = this.readRational(count, value);
                } else if (tag == 50735) {
                    TiffIFD.checkType(tag, type, 2);
                    this._cameraSerialNumber = this.readASCII(count, value);
                } else if (tag == 50736) {
                    TiffIFD.checkType(tag, type, 5);
                    TiffIFD.checkCount(tag, count, 4);
                    this._lensInfo = this.readRationalArray(count, value);
                } else if (tag == 50737) {
                    TiffIFD.checkType(tag, type, 5);
                    this._chromaBlurRadius = this.readRational(count, value);
                } else if (tag == 50738) {
                    TiffIFD.checkType(tag, type, 5);
                    this._antiAliasStrength = this.readRational(count, value);
                } else if (tag == 50739) {
                    this._info.setMessage((Message)new InfoMessage("Undocumented TIFF tag", "ShadowScale (50739)"));
                } else if (tag == 50740) {
                    TiffIFD.checkType(tag, type, 1);
                    this._dngPrivateData = this.readByteArray(type, count, value);
                } else if (tag == 50741) {
                    TiffIFD.checkType(tag, type, 3);
                    this._makerNoteSafety = this.readShort(type, count, value);
                } else {
                    this._info.setMessage((Message)new InfoMessage("Unknown TIFF IFD tag: " + tag, value));
                }
            }
            catch (IOException e) {
                throw new TiffException("Read error for tag " + tag, value);
            }
        }
    }

    @Override
    protected void postParseInitialization() {
        int i;
        int samplesPerPixel = this._niso.getSamplesPerPixel();
        int[] bitsPerSample = this._niso.getBitsPerSample();
        if (bitsPerSample == null) {
            bitsPerSample = new int[samplesPerPixel];
            for (int i2 = 0; i2 < samplesPerPixel; ++i2) {
                bitsPerSample[i2] = 1;
            }
            this._niso.setBitsPerSample(bitsPerSample);
        }
        int bps1 = (1 << bitsPerSample[0]) - 1;
        if (this._maxSampleValue == null) {
            this._maxSampleValue = new int[samplesPerPixel];
            for (i = 0; i < samplesPerPixel; ++i) {
                this._maxSampleValue[i] = bps1;
            }
        }
        if (this._minSampleValue == null) {
            this._minSampleValue = new int[samplesPerPixel];
            for (i = 0; i < samplesPerPixel; ++i) {
                this._minSampleValue[i] = 0;
            }
        }
        if (this._sampleFormat == null) {
            this._sampleFormat = new int[samplesPerPixel];
            for (i = 0; i < samplesPerPixel; ++i) {
                this._sampleFormat[i] = 1;
            }
        }
        if (this._photometricInterpretation == 5 && this._dotRange == null) {
            this._dotRange = new int[2];
            this._dotRange[0] = 0;
            this._dotRange[1] = bps1;
        }
        if (this._photometricInterpretation == 2 || this._photometricInterpretation == 6) {
            if (this._transferRange == null) {
                this._transferRange = new int[6];
                this._transferRange[4] = 0;
                this._transferRange[2] = 0;
                this._transferRange[0] = 0;
                this._transferRange[3] = this._transferRange[5] = bps1;
                this._transferRange[1] = this._transferRange[5];
            }
            if (this._niso.getReferenceBlackWhite() == null) {
                Rational[] reference = new Rational[6];
                reference[2] = reference[4] = new Rational(0, 1);
                reference[0] = reference[4];
                reference[3] = reference[5] = new Rational(bps1, 1);
                reference[1] = reference[5];
                this._niso.setReferenceBlackWhite(reference);
            }
        }
        if (this._pixelIntensityRange == null) {
            this._pixelIntensityRange = new int[2];
            this._pixelIntensityRange[0] = 0;
            this._pixelIntensityRange[1] = bps1;
        }
    }

    public void setTheExifIFD(ExifIFD exif) {
        this._theExifIFD = exif;
    }

    public void setTheGPSInfoIFD(GPSInfoIFD gpsInfo) {
        this._theGPSInfoIFD = gpsInfo;
    }

    public void setTheInteroperabilityIFD(InteroperabilityIFD interOp) {
        this._theInteroperabilityIFD = interOp;
    }

    public void setTheGlobalParametersIFD(GlobalParametersIFD gp) {
        this._theGlobalParametersIFD = gp;
    }

    private Property readXMP(long count, long value) throws TiffException {
        Property xmpProp = null;
        try {
            byte[] buf = this.readTrueByteArray(1, count, value);
            ByteArrayInputStream strm = new ByteArrayInputStream(buf);
            ByteArrayXMPSource src = new ByteArrayXMPSource(strm);
            SAXParserFactory factory = SAXParserFactory.newInstance();
            factory.setNamespaceAware(true);
            XMLReader parser = factory.newSAXParser().getXMLReader();
            XMPHandler handler = new XMPHandler();
            parser.setContentHandler((ContentHandler)handler);
            try {
                parser.parse((InputSource)src);
                xmpProp = src.makeProperty();
                return xmpProp;
            }
            catch (SAXException se) {
                String msg = se.getMessage();
                if (msg != null && msg.startsWith("ENC=")) {
                    String encoding = msg.substring(5);
                    try {
                        src = new ByteArrayXMPSource(strm, encoding);
                        parser.parse((InputSource)src);
                    }
                    catch (UnsupportedEncodingException uee) {
                        throw new TiffException("Invalid or ill-formed XMP metadata");
                    }
                }
                xmpProp = src.makeProperty();
                return xmpProp;
            }
        }
        catch (TiffException e) {
            throw e;
        }
        catch (Exception f) {
            return null;
        }
    }
}

