/*
 * Decompiled with CFR 0.152.
 */
package ch.docuteam.mapping.csv;

public enum CsvImportError {
    NONE("", "ImportCsvErrorMsgNone"),
    GENERIC("Error while importing CSV file!", "ImportCsvErrorMsgGeneric"),
    PARSER_ERROR("Could not parse CSV file: %s", "ImportCsvErrorMsgParser"),
    NOT_A_CHARACTER("%s needs to be a single character", "ImportCsvErrorMsgNotACharacter"),
    REFERENCE_COLUMN_MISSING("No reference column set in config!", "ImportCsvErrorMsgMissingRefCol"),
    REFERENCE_COLUMN_NOT_IN_CSV("Reference column '%s' not found in CSV!", "ImportCsvErrorMsgRefColNotInCsv"),
    MISSING_IN_METS("Not all lines from the CSV file are present in METS%nMissing in METS:%n%s", "ImportCsvErrorMsgMissingInMets"),
    MISSING_IN_CSV("Not all nodes from METS are present in the CSV file%nMissing in CSV:%n%s", "ImportCsvErrorMsgMissingInCsv"),
    VALUE_COULD_NOT_BE_SET("Import could not set value %s to %s", "ImportCsvErrorMsgValueCannotBeSet"),
    ACCESS_ERROR("Error while accessing the METS file", "ImportCsvErrorMsgAccess"),
    REVERT_ERROR("Error while reverting failed CSV import!", "ImportCsvErrorMsgRevert"),
    UNSAVED_CHANGES_IMPORT_ABORT("Import was aborted because changes were not saved before!", "ImportCsvUnsavedChangesAbort"),
    FILE_DOES_NOT_EXIST("File %s does not exist (CSV line %d)", "ImportCsvErrorMsgFileDoesNotExist"),
    LEVEL_NOT_ALLOWED("Level of Description '%s' does not exist in provided levels.xml (CSV line %d)", "ImportCsvErrorMsgLevelNotAllowed");

    private final String message;
    private final String messageKey;

    private CsvImportError(String message, String messageKey) {
        this.message = message;
        this.messageKey = messageKey;
    }

    public String getFormattedMessage(Object ... additionalObjects) {
        return String.format(this.message, additionalObjects);
    }

    public String getMessageKey() {
        return this.messageKey;
    }
}

