/*
 * Decompiled with CFR 0.152.
 */
package ch.docuteam.mapping.csv;

import ch.docuteam.mapping.csv.CsvFormat;
import ch.docuteam.mapping.csv.CsvImportError;
import ch.docuteam.mapping.csv.CsvImportException;
import java.io.IOException;
import java.nio.charset.Charset;
import java.nio.file.Path;
import java.util.List;
import org.apache.commons.csv.CSVFormat;
import org.apache.commons.csv.CSVParser;
import org.apache.commons.csv.CSVRecord;

public class CsvReader {
    private CsvReader() {
    }

    public static List<CSVRecord> readCsv(Path pathToCsv, CsvFormat csvFormat) {
        try {
            return CSVParser.parse((Path)pathToCsv, (Charset)Charset.forName(csvFormat.getCharset()), (CSVFormat)CSVFormat.newFormat((char)CsvReader.getSingleCharFromString(csvFormat.getDelimiter(), "delimiter")).builder().setEscape(CsvReader.getSingleNullableCharacterFormString(csvFormat.getEscapeCharacter(), "escapeCharacter")).setQuote(CsvReader.getSingleNullableCharacterFormString(csvFormat.getQuoteCharacter(), "quoteCharacter")).setHeader(new String[0]).setSkipHeaderRecord(true).setAllowMissingColumnNames(true).setIgnoreEmptyLines(true).build()).getRecords();
        }
        catch (IOException e) {
            throw new CsvImportException(CsvImportError.PARSER_ERROR, (Throwable)e, pathToCsv);
        }
    }

    private static char getSingleCharFromString(String string, String propName) {
        if (string == null || string.length() != 1) {
            throw new CsvImportException(CsvImportError.NOT_A_CHARACTER, propName);
        }
        return string.charAt(0);
    }

    private static Character getSingleNullableCharacterFormString(String string, String propName) {
        if (string != null && string.length() > 1) {
            throw new CsvImportException(CsvImportError.NOT_A_CHARACTER, propName);
        }
        return string == null || string.isEmpty() ? null : Character.valueOf(string.charAt(0));
    }
}

