/*
 * Decompiled with CFR 0.152.
 */
package ch.docuteam.mapping.csv;

import bsh.EvalError;
import ch.docuteam.darc.exceptions.DocumentIsReadOnlyException;
import ch.docuteam.darc.exceptions.FileOrFolderIsInUseException;
import ch.docuteam.darc.exceptions.LevelMetadataElementIsReadOnly;
import ch.docuteam.darc.exceptions.MetadataElementAllowedValuesException;
import ch.docuteam.darc.exceptions.MetadataElementCantAddException;
import ch.docuteam.darc.exceptions.MetadataElementIsNotAllowedException;
import ch.docuteam.darc.exceptions.MetadataElementIsNotDefinedException;
import ch.docuteam.darc.exceptions.MetadataElementSetterPostActionException;
import ch.docuteam.darc.exceptions.MetadataElementValidatorException;
import ch.docuteam.darc.exceptions.OriginalSIPIsMissingException;
import ch.docuteam.darc.mets.Document;
import ch.docuteam.darc.mets.structmap.NodeAbstract;
import ch.docuteam.mapping.csv.Column;
import ch.docuteam.mapping.csv.CsvImportError;
import ch.docuteam.mapping.csv.CsvImportException;
import ch.docuteam.mapping.csv.CsvImportWarning;
import ch.docuteam.mapping.csv.CsvReader;
import ch.docuteam.mapping.csv.ExistingValueType;
import ch.docuteam.mapping.csv.ImportResult;
import ch.docuteam.mapping.csv.ImportTableConfig;
import ch.docuteam.mapping.csv.MatterhornFieldType;
import ch.docuteam.mapping.csv.MetsPropertyState;
import ch.docuteam.mapping.util.XmlUtil;
import ch.docuteam.tools.file.exception.FileUtilExceptionListException;
import ch.docuteam.tools.out.Logger;
import com.google.common.collect.Sets;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonSyntaxException;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.Spliterators;
import java.util.function.BooleanSupplier;
import java.util.stream.Collectors;
import java.util.stream.StreamSupport;
import org.apache.commons.csv.CSVRecord;

public class CsvToMetsImporter {
    private final List<CsvImportWarning> warningList = new ArrayList<CsvImportWarning>();
    private final Gson gson = new GsonBuilder().create();

    private CsvToMetsImporter() {
    }

    public static ImportResult importCsv(Document metsDocument, Path pathToCsv, Path pathToConfig) {
        return CsvToMetsImporter.importCsv(metsDocument, pathToCsv, pathToConfig, () -> true);
    }

    public static ImportResult importCsv(Document metsDocument, Path pathToCsv, Path pathToConfig, BooleanSupplier saveHandler) {
        return new CsvToMetsImporter().importCsvInternal(metsDocument, pathToCsv, pathToConfig, saveHandler);
    }

    public ImportResult importCsvInternal(Document metsDocument, Path pathToCsv, Path pathToConfig, BooleanSupplier saveHandler) {
        Logger.info((Object)String.format("Importing '%s' using '%s'", pathToCsv, pathToConfig));
        boolean hasBackup = false;
        try {
            ImportTableConfig importConfig = XmlUtil.unmarshalXml(pathToConfig, ImportTableConfig.class);
            List<CSVRecord> csvRecords = CsvReader.readCsv(pathToCsv, importConfig.getCsvFormat());
            this.checkConstraints(metsDocument, csvRecords, importConfig);
            if (!metsDocument.isModified() || saveHandler.getAsBoolean()) {
                metsDocument.saveWithBackup();
                hasBackup = true;
                this.mapToMets(metsDocument, csvRecords, importConfig);
                return new ImportResult(true, this.warningList, CsvImportError.NONE, new Object[0]);
            }
            return new ImportResult(false, this.warningList, CsvImportError.UNSAVED_CHANGES_IMPORT_ABORT, new Object[0]);
        }
        catch (DocumentIsReadOnlyException | FileOrFolderIsInUseException | OriginalSIPIsMissingException | FileUtilExceptionListException | IOException e) {
            throw new CsvImportException(CsvImportError.GENERIC, e, new Object[0]);
        }
        catch (CsvImportException e) {
            if (hasBackup) {
                this.revertChanges(metsDocument);
            }
            return ImportResult.fromCSVImportException(e);
        }
    }

    private void checkConstraints(Document metsDocument, List<CSVRecord> csvRecords, ImportTableConfig importConfig) {
        if (importConfig.getReferenceColumnNumber() == null && importConfig.getReferenceColumnLabel() == null) {
            throw new CsvImportException(CsvImportError.REFERENCE_COLUMN_MISSING, new Object[0]);
        }
        if (importConfig.isCheckAllLines().booleanValue() || importConfig.isCheckAllNodes().booleanValue()) {
            Sets.SetView inMetsButNotInCsv;
            Sets.SetView inCsvButNotInMets;
            Set<String> pathStringsFromMets = this.getPathStrings(metsDocument.getStructureMap().getRoot());
            Set<String> pathStringsFromCsv = this.getPathStringsFromCsv(csvRecords, importConfig);
            if (importConfig.isCheckAllLines().booleanValue() && !(inCsvButNotInMets = Sets.difference(pathStringsFromCsv, pathStringsFromMets)).isEmpty()) {
                throw new CsvImportException(CsvImportError.MISSING_IN_METS, String.join((CharSequence)System.lineSeparator(), (Iterable<? extends CharSequence>)inCsvButNotInMets));
            }
            if (importConfig.isCheckAllNodes().booleanValue() && !(inMetsButNotInCsv = Sets.difference(pathStringsFromMets, pathStringsFromCsv)).isEmpty()) {
                throw new CsvImportException(CsvImportError.MISSING_IN_CSV, String.join((CharSequence)System.lineSeparator(), (Iterable<? extends CharSequence>)inMetsButNotInCsv));
            }
        }
    }

    private Set<String> getPathStrings(NodeAbstract node) {
        return node.getWithDescendants().stream().map(NodeAbstract::getPathString).collect(Collectors.toUnmodifiableSet());
    }

    private Set<String> getPathStringsFromCsv(List<CSVRecord> csv, ImportTableConfig importConfig) {
        return csv.stream().map(record -> this.getMetsPath((CSVRecord)record, importConfig)).collect(Collectors.toUnmodifiableSet());
    }

    private String getMetsPath(CSVRecord record, ImportTableConfig importConfig) {
        if (importConfig.getReferenceColumnLabel() != null) {
            if (!record.isMapped(importConfig.getReferenceColumnLabel())) {
                throw new CsvImportException(CsvImportError.REFERENCE_COLUMN_NOT_IN_CSV, importConfig.getReferenceColumnLabel());
            }
            return this.toMetsPath(record.get(importConfig.getReferenceColumnLabel()));
        }
        if (!record.isSet(importConfig.getReferenceColumnNumber().intValue())) {
            throw new CsvImportException(CsvImportError.REFERENCE_COLUMN_NOT_IN_CSV, importConfig.getReferenceColumnNumber().toString());
        }
        return this.toMetsPath(record.get(importConfig.getReferenceColumnNumber().intValue()));
    }

    private String toMetsPath(String pathString) {
        return pathString.replace('\\', '/').replaceFirst("^/", "");
    }

    private void mapToMets(Document metsDocument, List<CSVRecord> csvRecords, ImportTableConfig importConfig) {
        csvRecords.forEach(record -> this.mapRecordToMets(metsDocument, (CSVRecord)record, importConfig));
    }

    private void mapRecordToMets(Document metsDocument, CSVRecord record, ImportTableConfig importConfig) {
        this.getMetsNode(metsDocument.getStructureMap().getRoot(), this.getMetsPath(record, importConfig)).ifPresent(node -> importConfig.getColumnMapping().getColumn().forEach(columnMapping -> this.mapToMetsNode((NodeAbstract)node, record, (Column)columnMapping, importConfig.getExistingValues())));
    }

    private Optional<NodeAbstract> getMetsNode(NodeAbstract root, String metsPath) {
        Optional<Object> node = Optional.ofNullable(root);
        String[] pathFragments = metsPath.split("/");
        for (String path : Arrays.copyOfRange(pathFragments, 1, pathFragments.length)) {
            node = node.flatMap(nodeToMap -> StreamSupport.stream(Spliterators.spliteratorUnknownSize(nodeToMap.children().asIterator(), 0), false).map(foundNode -> (NodeAbstract)foundNode).filter(foundNode -> foundNode.getLabel().equals(path)).findFirst());
        }
        return node;
    }

    private void mapToMetsNode(NodeAbstract metsNode, CSVRecord record, Column columnMapping, ExistingValueType existingValues) {
        if (record.isMapped(columnMapping.getTableHeaderLabel())) {
            String recordValue = record.get(columnMapping.getTableHeaderLabel());
            if (recordValue == null || recordValue.isBlank()) {
                return;
            }
            MatterhornFieldType metsAccessor = columnMapping.getMatterhornMetsAccessorID();
            if (this.handleUnitTitle(metsNode, existingValues, recordValue, metsAccessor)) {
                return;
            }
            if (this.handleLevelOfDescription(metsNode, existingValues, recordValue, metsAccessor)) {
                return;
            }
            MetsPropertyState propertyState = this.checkState(metsNode, metsAccessor, recordValue);
            if (ExistingValueType.SKIP.equals((Object)existingValues) && MetsPropertyState.DEFINED.equals((Object)propertyState) || MetsPropertyState.NOT_ALLOWED.equals((Object)propertyState)) {
                return;
            }
            try {
                int propertyIndex;
                if (MetsPropertyState.DEFINED.equals((Object)propertyState) && ExistingValueType.ADD.equals((Object)existingValues)) {
                    metsNode.addDynamicMetadataElementInstanceWithName(metsAccessor.value());
                }
                int n = propertyIndex = ExistingValueType.OVERWRITE.equals((Object)existingValues) ? 0 : metsNode.getAllDynamicMetadataValuesForName(metsAccessor.value()).size() - 1;
                if (recordValue.matches("^\\[.+\\]$")) {
                    List recordValues = (List)this.gson.fromJson(recordValue, List.class);
                    boolean first = true;
                    for (String recordValueItem : recordValues) {
                        if (!first) {
                            metsNode.addDynamicMetadataElementInstanceWithName(metsAccessor.value());
                        }
                        metsNode.setDynamicMetadataValueForName(metsAccessor.value(), propertyIndex, recordValueItem);
                        ++propertyIndex;
                    }
                } else {
                    metsNode.setDynamicMetadataValueForName(metsAccessor.value(), propertyIndex, recordValue);
                }
            }
            catch (EvalError | LevelMetadataElementIsReadOnly | MetadataElementAllowedValuesException | MetadataElementCantAddException | MetadataElementIsNotAllowedException | MetadataElementIsNotDefinedException | MetadataElementSetterPostActionException | MetadataElementValidatorException | JsonSyntaxException | IllegalAccessException | InvocationTargetException e) {
                throw new CsvImportException(CsvImportError.VALUE_COULD_NOT_BE_SET, e, recordValue, metsAccessor.value());
            }
        }
    }

    private boolean handleUnitTitle(NodeAbstract metsNode, ExistingValueType existingValues, String recordValue, MatterhornFieldType metsAccessor) {
        if (MatterhornFieldType.UNIT_TITLE.equals((Object)metsAccessor)) {
            if (metsNode.getUnitTitle() == null || ExistingValueType.OVERWRITE.equals((Object)existingValues)) {
                metsNode.setUnitTitle(recordValue);
            }
            return true;
        }
        return false;
    }

    private boolean handleLevelOfDescription(NodeAbstract metsNode, ExistingValueType existingValues, String recordValue, MatterhornFieldType metsAccessor) {
        if (MatterhornFieldType.LEVEL_OF_DESCRIPTION.equals((Object)metsAccessor)) {
            if (ExistingValueType.OVERWRITE.equals((Object)existingValues)) {
                try {
                    metsNode.setLevel(metsNode.getDocument().getLevels().get(recordValue));
                }
                catch (IllegalAccessException | InvocationTargetException e) {
                    this.warningList.add(new CsvImportWarning(metsNode.getAbsolutePathString(), metsAccessor.value(), recordValue, CsvImportWarning.WarningType.PROPERTY_NOT_ALLOWED));
                }
            }
            return true;
        }
        return false;
    }

    private MetsPropertyState checkState(NodeAbstract metsNode, MatterhornFieldType metsAccessor, String recordValue) {
        try {
            if (metsNode.getLevel().getDynamicMetadataElement(metsAccessor.value()).isReadOnly()) {
                return MetsPropertyState.NOT_ALLOWED;
            }
            return metsNode.getDynamicMetadataValueForName(metsAccessor.value()) != null ? MetsPropertyState.DEFINED : MetsPropertyState.UNDEFINED;
        }
        catch (IllegalAccessException | InvocationTargetException e) {
            throw new CsvImportException(CsvImportError.ACCESS_ERROR, (Throwable)e, new Object[0]);
        }
        catch (MetadataElementIsNotAllowedException e) {
            this.warningList.add(new CsvImportWarning(metsNode.getAbsolutePathString(), metsAccessor.value(), recordValue, CsvImportWarning.WarningType.PROPERTY_NOT_ALLOWED));
            return MetsPropertyState.NOT_ALLOWED;
        }
        catch (MetadataElementIsNotDefinedException e) {
            return MetsPropertyState.UNDEFINED;
        }
    }

    private void revertChanges(Document metsDocument) {
        try {
            metsDocument.revertToLastBackup();
        }
        catch (Exception ex) {
            throw new CsvImportException(CsvImportError.REVERT_ERROR, (Throwable)ex, new Object[0]);
        }
    }
}

