/*
 * Decompiled with CFR 0.152.
 */
package edu.harvard.hul.ois.jhove;

import edu.harvard.hul.ois.jhove.Agent;
import edu.harvard.hul.ois.jhove.App;
import edu.harvard.hul.ois.jhove.Checksum;
import edu.harvard.hul.ois.jhove.ChecksumType;
import edu.harvard.hul.ois.jhove.Checksummer;
import edu.harvard.hul.ois.jhove.Document;
import edu.harvard.hul.ois.jhove.InternalSignature;
import edu.harvard.hul.ois.jhove.JhoveBase;
import edu.harvard.hul.ois.jhove.Module;
import edu.harvard.hul.ois.jhove.OutputHandler;
import edu.harvard.hul.ois.jhove.Property;
import edu.harvard.hul.ois.jhove.PropertyType;
import edu.harvard.hul.ois.jhove.Rational;
import edu.harvard.hul.ois.jhove.RepInfo;
import edu.harvard.hul.ois.jhove.Signature;
import edu.harvard.hul.ois.jhove.SignatureUseType;
import java.io.BufferedInputStream;
import java.io.DataInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.RandomAccessFile;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.ArrayList;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.List;
import java.util.ListIterator;
import java.util.Vector;
import java.util.logging.Logger;
import java.util.zip.CRC32;

public abstract class ModuleBase
implements Module {
    protected App _app;
    protected String _coverage;
    protected Date _date;
    protected String[] _format;
    protected String _init;
    protected List<String> _defaultParams;
    protected JhoveBase _je;
    protected String[] _mimeType;
    protected String _name;
    protected String _note;
    protected String _param;
    protected String _release;
    protected String _repInfoNote;
    protected String _rights;
    protected List<Signature> _signature;
    protected List<Document> _specification;
    protected Agent _vendor;
    protected String _wellFormedNote;
    protected String _validityNote;
    protected boolean _isRandomAccess;
    protected long _nByte;
    protected CRC32 _crc32;
    protected MessageDigest _md5;
    protected MessageDigest _sha1;
    protected boolean _checksumFinished;
    protected int _verbosity;
    protected boolean _countStream;
    protected boolean _bigEndian;
    protected List<String> _features;
    protected Logger _logger = Logger.getLogger("edu.harvard.hul.ois.jhove.module");

    protected ModuleBase(String name, String release, int[] date, String[] format, String coverage, String[] mimeType, String wellFormedNote, String validityNote, String repInfoNote, String note, String rights, boolean isRandomAccess) {
        this._logger.info("Initializing " + name);
        this._name = name;
        this._release = release;
        GregorianCalendar calendar = new GregorianCalendar();
        calendar.set(date[0], date[1] - 1, date[2]);
        this._date = calendar.getTime();
        this._format = format;
        this._coverage = coverage;
        this._mimeType = mimeType;
        this._signature = new ArrayList<Signature>();
        this._specification = new ArrayList<Document>();
        this._wellFormedNote = wellFormedNote;
        this._repInfoNote = repInfoNote;
        this._validityNote = validityNote;
        this._note = note;
        this._rights = rights;
        this._isRandomAccess = isRandomAccess;
        this._verbosity = 2;
        this.initFeatures();
    }

    public void initFeatures() {
        this._features = new ArrayList<String>(2);
        this._features.add("edu.harvard.hul.ois.jhove.canValidate");
        this._features.add("edu.harvard.hul.ois.jhove.canCharacterize");
    }

    @Override
    public void init(String init) throws Exception {
        this._init = init;
    }

    @Override
    public void setDefaultParams(List<String> params) {
        this._defaultParams = params;
    }

    @Override
    public void applyDefaultParams() throws Exception {
        this.resetParams();
        for (String parm : this._defaultParams) {
            this.param(parm);
        }
    }

    @Override
    public void resetParams() throws Exception {
        this._param = null;
    }

    @Override
    public void param(String param) throws Exception {
        this._param = param;
    }

    public App getApp() {
        return this._app;
    }

    public JhoveBase getBase() {
        return this._je;
    }

    public long getNByte() {
        return this._nByte;
    }

    public boolean isBigEndian() {
        return this._bigEndian;
    }

    @Override
    public final String getCoverage() {
        return this._coverage;
    }

    @Override
    public final Date getDate() {
        return this._date;
    }

    @Override
    public final String[] getFormat() {
        return this._format;
    }

    @Override
    public final String[] getMimeType() {
        return this._mimeType;
    }

    @Override
    public final String getName() {
        return this._name;
    }

    @Override
    public final String getNote() {
        return this._note;
    }

    @Override
    public final String getRelease() {
        return this._release;
    }

    @Override
    public final String getRepInfoNote() {
        return this._repInfoNote;
    }

    @Override
    public final String getRights() {
        return this._rights;
    }

    @Override
    public final List<Signature> getSignature() {
        return this._signature;
    }

    @Override
    public final List<Document> getSpecification() {
        return this._specification;
    }

    @Override
    public final Agent getVendor() {
        return this._vendor;
    }

    @Override
    public final String getWellFormedNote() {
        return this._wellFormedNote;
    }

    @Override
    public final String getValidityNote() {
        return this._validityNote;
    }

    @Override
    public final boolean isRandomAccess() {
        return this._isRandomAccess;
    }

    @Override
    public boolean hasFeature(String feature) {
        if (this._features == null) {
            return false;
        }
        for (String f : this._features) {
            if (!f.equals(feature)) continue;
            return true;
        }
        return false;
    }

    @Override
    public List<String> getFeatures() {
        return this._features;
    }

    @Override
    public List<String> getDefaultParams() {
        return this._defaultParams;
    }

    @Override
    public final void setApp(App app) {
        this._app = app;
    }

    @Override
    public final void setBase(JhoveBase je) {
        this._je = je;
    }

    public final void setValidityNote(String validityNote) {
        this._validityNote = validityNote;
    }

    public final void setCRC32(CRC32 crc32) {
        this._crc32 = crc32;
        this._checksumFinished = true;
    }

    @Override
    public void setVerbosity(int verbosity) {
        this._verbosity = verbosity;
    }

    public final void setNByte(long nByte) {
        this._nByte = nByte;
        this._checksumFinished = true;
    }

    public final void setMD5(MessageDigest md5) {
        this._md5 = md5;
        this._checksumFinished = true;
    }

    public final void setSHA1(MessageDigest sha1) {
        this._sha1 = sha1;
        this._checksumFinished = true;
    }

    @Override
    public int parse(InputStream stream, RepInfo info, int parseIndex) throws IOException {
        return 0;
    }

    @Override
    public void parse(RandomAccessFile file, RepInfo info) throws IOException {
    }

    @Override
    public void checkSignatures(File file, InputStream stream, RepInfo info) throws IOException {
        info.setFormat(this._format[0]);
        info.setMimeType(this._mimeType[0]);
        info.setModule(this);
        int sigsChecked = 0;
        if (this._signature.size() > 0) {
            byte[] sigBuf = new byte[1024];
            stream.read(sigBuf);
            stream.close();
            ListIterator<Signature> iter = this._signature.listIterator();
            while (iter.hasNext()) {
                Signature sig = iter.next();
                if (!(sig instanceof InternalSignature)) continue;
                InternalSignature isig = (InternalSignature)sig;
                int[] sigValue = isig.getValue();
                int offset = isig.getOffset();
                boolean match = true;
                for (int i = 0; i < sigValue.length; ++i) {
                    if (sigBuf[offset + i] == sigValue[i]) continue;
                    match = false;
                    break;
                }
                if (!match && isig.getUse().equals(SignatureUseType.MANDATORY)) {
                    info.setWellFormed(false);
                    return;
                }
                if (!match) continue;
                ++sigsChecked;
            }
        }
        if (sigsChecked == 0) {
            int parseIndex = this.parse(stream, info, 0);
            while (parseIndex != 0) {
                stream.close();
                if (file != null) {
                    stream = new FileInputStream(file);
                    parseIndex = this.parse(stream, info, parseIndex);
                    continue;
                }
                parseIndex = 0;
            }
        } else if (info.getWellFormed() == 1) {
            info.setSigMatch(this._name);
        }
    }

    @Override
    public void checkSignatures(File file, RandomAccessFile raf, RepInfo info) throws IOException {
        info.setFormat(this._format[0]);
        info.setMimeType(this._mimeType[0]);
        info.setModule(this);
        int sigsChecked = 0;
        ListIterator<Signature> iter = this._signature.listIterator();
        try {
            while (iter.hasNext()) {
                Signature sig = iter.next();
                if (!(sig instanceof InternalSignature)) continue;
                InternalSignature isig = (InternalSignature)sig;
                raf.seek(isig.getOffset());
                int[] sigValue = isig.getValue();
                boolean match = true;
                for (int i = 0; i < sigValue.length; ++i) {
                    if (ModuleBase.readUnsignedByte(raf) == sigValue[i]) continue;
                    match = false;
                    break;
                }
                if (!match && isig.getUse().equals(SignatureUseType.MANDATORY)) {
                    info.setWellFormed(false);
                    break;
                }
                if (!match) continue;
                ++sigsChecked;
            }
        }
        catch (Exception e) {
            info.setWellFormed(false);
            return;
        }
        if (sigsChecked == 0) {
            info.setWellFormed(false);
        } else if (info.getWellFormed() == 1) {
            info.setSigMatch(this._name);
        }
    }

    protected void initParse() {
        this._logger.info(this._name + " called initParse");
        this._checksumFinished = false;
        this._nByte = 0L;
        this._crc32 = new CRC32();
        try {
            this._md5 = MessageDigest.getInstance("MD5");
            this._sha1 = MessageDigest.getInstance("SHA-1");
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            // empty catch block
        }
    }

    protected void calcRAChecksum(Checksummer ckSummer, RandomAccessFile raf) throws IOException {
        if (ckSummer == null) {
            return;
        }
        raf.seek(0L);
        byte[] buffer = new byte[this._je.getBufferSize()];
        int n = -1;
        try {
            while ((n = raf.read(buffer)) != -1) {
                if (n <= 0) continue;
                ckSummer.update(buffer, 0, n);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    protected void setChecksums(Checksummer ckSummer, RepInfo info) {
        if (ckSummer != null) {
            info.setChecksum(new Checksum(ckSummer.getCRC32(), ChecksumType.CRC32));
            String value = ckSummer.getMD5();
            if (value != null) {
                info.setChecksum(new Checksum(value, ChecksumType.MD5));
            }
            if ((value = ckSummer.getSHA1()) != null) {
                info.setChecksum(new Checksum(value, ChecksumType.SHA1));
            }
        }
    }

    @Override
    public void show(OutputHandler handler) {
        handler.show(this);
    }

    protected String getCRC32() {
        return Long.toHexString(this._crc32.getValue());
    }

    public Property addIntegerProperty(String name, int value, String[] labels, int[] index) {
        boolean rawOutput = this._je.getShowRawFlag();
        Property prop = null;
        if (!rawOutput) {
            int n = -1;
            for (int i = 0; i < index.length; ++i) {
                if (value != index[i]) continue;
                n = i;
                break;
            }
            if (n > -1) {
                prop = new Property(name, PropertyType.STRING, labels[n]);
            }
        }
        if (prop == null) {
            prop = new Property(name, PropertyType.INTEGER, new Integer(value));
        }
        return prop;
    }

    public Property addIntegerProperty(String name, int value, String[] labels) {
        if (!this._je.getShowRawFlag()) {
            try {
                return new Property(name, PropertyType.STRING, labels[value]);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return new Property(name, PropertyType.INTEGER, new Integer(value));
    }

    public static int readUnsignedByte(DataInputStream stream) throws IOException {
        return ModuleBase.readUnsignedByte(stream, null);
    }

    public static int readUnsignedByte(DataInputStream stream, ModuleBase counted) throws IOException {
        int val = stream.readUnsignedByte();
        if (counted != null) {
            ++counted._nByte;
        }
        return val;
    }

    public static int readUnsignedByte(RandomAccessFile file) throws IOException {
        return file.readUnsignedByte();
    }

    public static int readByteBuf(DataInputStream stream, byte[] buf, ModuleBase counted) throws IOException {
        int bytesRead = stream.read(buf);
        if (counted != null && bytesRead > 0) {
            counted._nByte += (long)bytesRead;
        }
        return bytesRead;
    }

    public static int readUnsignedShort(DataInputStream stream, boolean bigEndian) throws IOException {
        return ModuleBase.readUnsignedShort(stream, bigEndian, null);
    }

    public static int readUnsignedShort(DataInputStream stream, boolean bigEndian, ModuleBase counted) throws IOException {
        int n = 0;
        if (bigEndian) {
            n = stream.readUnsignedShort();
        } else {
            int b1 = stream.readUnsignedByte();
            int b0 = stream.readUnsignedByte();
            n = b0 << 8 | b1;
        }
        if (counted != null) {
            counted._nByte += 2L;
        }
        return n;
    }

    public static int readUnsignedShort(RandomAccessFile file, boolean bigEndian) throws IOException {
        int n = 0;
        if (bigEndian) {
            n = file.readUnsignedShort();
        } else {
            int b1 = file.readUnsignedByte();
            int b0 = file.readUnsignedByte();
            n = b0 << 8 | b1;
        }
        return n;
    }

    public static long readUnsignedInt(DataInputStream stream, boolean bigEndian) throws IOException {
        return ModuleBase.readUnsignedInt(stream, bigEndian, null);
    }

    public static long readUnsignedInt(DataInputStream stream, boolean bigEndian, ModuleBase counted) throws IOException {
        long n = 0L;
        if (bigEndian) {
            n = stream.readInt();
            if (n < 0L) {
                n &= 0xFFFFFFFFL;
            }
        } else {
            long b3 = stream.readUnsignedByte();
            long b2 = stream.readUnsignedByte();
            long b1 = stream.readUnsignedByte();
            long b0 = stream.readUnsignedByte();
            n = b0 << 24 | b1 << 16 | b2 << 8 | b3;
        }
        if (counted != null) {
            counted._nByte += 4L;
        }
        return n;
    }

    public static long readUnsignedInt(RandomAccessFile file, boolean bigEndian) throws IOException {
        long n = 0L;
        if (bigEndian) {
            n = file.readInt();
            if (n < 0L) {
                n &= 0xFFFFFFFFL;
            }
        } else {
            byte[] buf = new byte[4];
            file.read(buf);
            long b3 = (long)buf[0] & 0xFFL;
            long b2 = (long)buf[1] & 0xFFL;
            long b1 = (long)buf[2] & 0xFFL;
            long b0 = (long)buf[3] & 0xFFL;
            n = b0 << 24 | b1 << 16 | b2 << 8 | b3;
        }
        return n;
    }

    public static long readSignedLong(DataInputStream stream, boolean bigEndian, ModuleBase counted) throws IOException {
        long n = 0L;
        if (bigEndian) {
            n = stream.readLong();
        } else {
            long b7 = stream.readUnsignedByte();
            long b6 = stream.readUnsignedByte();
            long b5 = stream.readUnsignedByte();
            long b4 = stream.readUnsignedByte();
            long b3 = stream.readUnsignedByte();
            long b2 = stream.readUnsignedByte();
            long b1 = stream.readUnsignedByte();
            long b0 = stream.readUnsignedByte();
            n = b0 << 56 | b1 << 48 | b2 << 40 | b3 << 32 | b4 << 24 | b5 << 16 | b6 << 8 | b7;
        }
        if (counted != null) {
            counted._nByte += 8L;
        }
        return n;
    }

    public static Rational readUnsignedRational(DataInputStream stream, boolean endian) throws IOException {
        return ModuleBase.readUnsignedRational(stream, endian, null);
    }

    public static Rational readUnsignedRational(DataInputStream stream, boolean endian, ModuleBase counted) throws IOException {
        long n = ModuleBase.readUnsignedInt(stream, endian, counted);
        long d = ModuleBase.readUnsignedInt(stream, endian, counted);
        return new Rational(n, d);
    }

    public static Rational readUnsignedRational(RandomAccessFile file, boolean endian) throws IOException {
        long n = ModuleBase.readUnsignedInt(file, endian);
        long d = ModuleBase.readUnsignedInt(file, endian);
        return new Rational(n, d);
    }

    public static Rational readSignedRational(DataInputStream stream, boolean endian, ModuleBase counted) throws IOException {
        long n = ModuleBase.readSignedInt(stream, endian, counted);
        long d = ModuleBase.readSignedInt(stream, endian, counted);
        return new Rational(n, d);
    }

    public static Rational readSignedRational(RandomAccessFile file, boolean endian) throws IOException {
        long n = ModuleBase.readSignedInt(file, endian);
        long d = ModuleBase.readSignedInt(file, endian);
        return new Rational(n, d);
    }

    public static int readSignedByte(RandomAccessFile file) throws IOException {
        return file.readByte();
    }

    public static int readSignedShort(RandomAccessFile file, boolean endian) throws IOException {
        int b = ModuleBase.readUnsignedShort(file, endian);
        if ((b & 0x8000) != 0) {
            b |= 0xFFFF0000;
        }
        return b;
    }

    public static int readSignedInt(RandomAccessFile file, boolean endian) throws IOException {
        long b = ModuleBase.readUnsignedInt(file, endian);
        if ((b & 0x80000000L) != 0L) {
            b |= 0xFFFFFFFF00000000L;
        }
        return (int)b;
    }

    public static int readSignedByte(DataInputStream stream) throws IOException {
        return ModuleBase.readSignedByte(stream, null);
    }

    public static int readSignedByte(DataInputStream stream, ModuleBase counted) throws IOException {
        byte val = stream.readByte();
        if (counted != null) {
            ++counted._nByte;
        }
        return val;
    }

    public static int readSignedShort(DataInputStream stream, boolean endian) throws IOException {
        return ModuleBase.readSignedShort(stream, endian, null);
    }

    public static int readSignedShort(DataInputStream stream, boolean endian, ModuleBase counted) throws IOException {
        int b = ModuleBase.readUnsignedShort(stream, endian, counted);
        if ((b & 0x8000) != 0) {
            b |= 0xFFFF0000;
        }
        return b;
    }

    public static int readSignedInt(DataInputStream stream, boolean endian) throws IOException {
        return ModuleBase.readSignedInt(stream, endian, null);
    }

    public static int readSignedInt(DataInputStream stream, boolean endian, ModuleBase counted) throws IOException {
        long b = ModuleBase.readUnsignedInt(stream, endian, counted);
        if ((b & 0x80000000L) != 0L) {
            b |= 0xFFFFFFFF00000000L;
        }
        return (int)b;
    }

    public static float readFloat(RandomAccessFile file, boolean endian) throws IOException {
        float f = 0.0f;
        if (endian) {
            f = file.readFloat();
        } else {
            byte[] buf = new byte[4];
            file.read(buf);
            int b3 = buf[0] & 0xFF;
            int b2 = buf[1] & 0xFF;
            int b1 = buf[2] & 0xFF;
            int b0 = buf[3] & 0xFF;
            f = Float.intBitsToFloat(b0 << 24 | b1 << 16 | b2 << 8 | b3);
        }
        return f;
    }

    public static float readFloat(DataInputStream stream, boolean endian, ModuleBase counted) throws IOException {
        float f = 0.0f;
        if (endian) {
            f = stream.readFloat();
        } else {
            int b3 = stream.readUnsignedByte();
            int b2 = stream.readUnsignedByte();
            int b1 = stream.readUnsignedByte();
            int b0 = stream.readUnsignedByte();
            f = Float.intBitsToFloat(b0 << 24 | b1 << 16 | b2 << 8 | b3);
        }
        if (counted != null) {
            counted._nByte += 4L;
        }
        return f;
    }

    public static double readDouble(RandomAccessFile file, boolean endian) throws IOException {
        double f = 0.0;
        if (endian) {
            f = file.readDouble();
        } else {
            byte[] buf = new byte[8];
            file.read(buf);
            long b7 = (long)buf[0] & 0xFFL;
            long b6 = (long)buf[1] & 0xFFL;
            long b5 = (long)buf[2] & 0xFFL;
            long b4 = (long)buf[3] & 0xFFL;
            long b3 = (long)buf[4] & 0xFFL;
            long b2 = (long)buf[5] & 0xFFL;
            long b1 = (long)buf[6] & 0xFFL;
            long b0 = (long)buf[7] & 0xFFL;
            f = Double.longBitsToDouble(b0 << 56 | b1 << 48 | b2 << 40 | b3 << 32 | b4 << 24 | b5 << 16 | b6 << 8 | b7);
        }
        return f;
    }

    public static double readDouble(DataInputStream stream, boolean endian) throws IOException {
        return ModuleBase.readDouble(stream, endian, null);
    }

    public static double readDouble(DataInputStream stream, boolean endian, ModuleBase counted) throws IOException {
        double f = 0.0;
        if (endian) {
            f = stream.readDouble();
        } else {
            long b7 = stream.readUnsignedByte();
            long b6 = stream.readUnsignedByte();
            long b5 = stream.readUnsignedByte();
            long b4 = stream.readUnsignedByte();
            long b3 = stream.readUnsignedByte();
            long b2 = stream.readUnsignedByte();
            long b1 = stream.readUnsignedByte();
            long b0 = stream.readUnsignedByte();
            f = Double.longBitsToDouble(b0 << 56 | b1 << 48 | b2 << 40 | b3 << 32 | b4 << 24 | b5 << 16 | b6 << 8 | b7);
        }
        if (counted != null) {
            counted._nByte += 8L;
        }
        return f;
    }

    public long skipBytes(DataInputStream stream, long bytesToSkip) throws IOException {
        return this.skipBytes(stream, bytesToSkip, null);
    }

    public long skipBytes(DataInputStream stream, long bytesToSkip, ModuleBase counted) throws IOException {
        long availableBytes;
        long totalBytesSkipped = 0L;
        while (bytesToSkip > 0L && (availableBytes = (long)stream.available()) != 0L) {
            long bytesSkipped = bytesToSkip > availableBytes ? stream.skip(availableBytes) : stream.skip(bytesToSkip);
            if (bytesSkipped > availableBytes) {
                bytesSkipped = availableBytes;
            }
            totalBytesSkipped += bytesSkipped;
            bytesToSkip -= bytesSkipped;
        }
        if (counted != null) {
            counted._nByte += totalBytesSkipped;
        }
        return totalBytesSkipped;
    }

    public static DataInputStream getBufferedDataStream(InputStream stream, int size) {
        BufferedInputStream bis = size <= 0 ? new BufferedInputStream(stream) : new BufferedInputStream(stream, size);
        return new DataInputStream(bis);
    }

    protected Property[] vectorToPropArray(Vector vec) {
        Property[] prop = new Property[vec.size()];
        for (int i = 0; i < vec.size(); ++i) {
            prop[i] = (Property)vec.elementAt(i);
        }
        return prop;
    }
}

