/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.xml.xpath2.processor.internal.function;

import java.nio.ByteBuffer;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import org.eclipse.wst.xml.xpath2.processor.DynamicError;
import org.eclipse.wst.xml.xpath2.processor.ResultSequence;
import org.eclipse.wst.xml.xpath2.processor.ResultSequenceFactory;
import org.eclipse.wst.xml.xpath2.processor.internal.SeqType;
import org.eclipse.wst.xml.xpath2.processor.internal.function.Function;
import org.eclipse.wst.xml.xpath2.processor.internal.types.AnyType;
import org.eclipse.wst.xml.xpath2.processor.internal.types.QName;
import org.eclipse.wst.xml.xpath2.processor.internal.types.XSString;

public abstract class AbstractURIFunction
extends Function {
    private static final Charset UTF_8 = Charset.forName("UTF-8");
    static Collection _expected_args = null;

    protected static boolean needs_escape(byte x, boolean escape_delimiters, boolean escape_space) {
        if (65 <= x && x <= 90) {
            return false;
        }
        if (97 <= x && x <= 122) {
            return false;
        }
        if (48 <= x && x <= 57) {
            return false;
        }
        switch (x) {
            case 45: 
            case 46: 
            case 95: 
            case 126: {
                return false;
            }
            case 33: 
            case 35: 
            case 36: 
            case 37: 
            case 38: 
            case 39: 
            case 40: 
            case 41: 
            case 42: 
            case 43: 
            case 44: 
            case 47: 
            case 58: 
            case 59: 
            case 61: 
            case 63: 
            case 64: 
            case 91: 
            case 93: {
                return escape_delimiters;
            }
            case 32: {
                return escape_space;
            }
        }
        return true;
    }

    public static ResultSequence escape_uri(Collection args, boolean escape) throws DynamicError {
        return AbstractURIFunction.escape_uri(args, escape, true);
    }

    public static ResultSequence escape_uri(Collection args, boolean escape_delimiters, boolean escape_space) throws DynamicError {
        Collection cargs = Function.convert_arguments(args, AbstractURIFunction.expected_args());
        Iterator argi = cargs.iterator();
        ResultSequence arg1 = (ResultSequence)argi.next();
        ResultSequence rs = ResultSequenceFactory.create_new();
        if (arg1.empty()) {
            rs.add(new XSString(""));
            return rs;
        }
        AnyType aat = arg1.first();
        String str = aat.string_value();
        ByteBuffer buffer = UTF_8.encode(str);
        StringBuffer sb = new StringBuffer();
        int i = 0;
        while (i < buffer.limit()) {
            byte x = buffer.get(i);
            if (AbstractURIFunction.needs_escape(x, escape_delimiters, escape_space)) {
                sb.append("%");
                sb.append(Integer.toHexString(x & 0xFF).toUpperCase());
            } else {
                sb.append((char)x);
            }
            ++i;
        }
        rs.add(new XSString(sb.toString()));
        return rs;
    }

    public static synchronized Collection expected_args() {
        if (_expected_args == null) {
            _expected_args = new ArrayList();
            _expected_args.add(new SeqType(new XSString(), 3));
        }
        return _expected_args;
    }

    public AbstractURIFunction(QName name, int arity) {
        super(name, arity);
    }

    public AbstractURIFunction(QName name, int min_arity, int max_arity) {
        super(name, min_arity, max_arity);
    }

    public ResultSequence evaluate(Collection args) throws DynamicError {
        return null;
    }
}

