/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.xml.xpath2.processor.internal.types;

import org.eclipse.wst.xml.xpath2.processor.DynamicContext;
import org.eclipse.wst.xml.xpath2.processor.DynamicError;
import org.eclipse.wst.xml.xpath2.processor.ResultSequence;
import org.eclipse.wst.xml.xpath2.processor.ResultSequenceFactory;
import org.eclipse.wst.xml.xpath2.processor.internal.function.CmpEq;
import org.eclipse.wst.xml.xpath2.processor.internal.function.CmpGt;
import org.eclipse.wst.xml.xpath2.processor.internal.function.CmpLt;
import org.eclipse.wst.xml.xpath2.processor.internal.types.AnyType;
import org.eclipse.wst.xml.xpath2.processor.internal.types.CtrType;
import org.eclipse.wst.xml.xpath2.processor.internal.types.XSString;

public class XSAnyURI
extends CtrType
implements CmpEq,
CmpGt,
CmpLt {
    private static final String XS_ANY_URI = "xs:anyURI";
    private String _value;

    public XSAnyURI(String x) {
        this._value = x;
    }

    public XSAnyURI() {
        this(null);
    }

    public String string_type() {
        return XS_ANY_URI;
    }

    public String type_name() {
        return "anyURI";
    }

    public String string_value() {
        return this._value;
    }

    public ResultSequence constructor(ResultSequence arg) throws DynamicError {
        ResultSequence rs = ResultSequenceFactory.create_new();
        if (arg.empty()) {
            return rs;
        }
        AnyType aat = arg.first();
        if (!(aat.string_type().equals("xs:string") || aat.string_type().equals(XS_ANY_URI) || aat.string_type().equals("xs:untypedAtomic"))) {
            throw DynamicError.invalidType();
        }
        rs.add(new XSAnyURI(aat.string_value()));
        return rs;
    }

    public boolean eq(AnyType arg, DynamicContext context) throws DynamicError {
        if (arg instanceof XSAnyURI || arg instanceof XSString) {
            return this.string_value().equals(arg.string_value());
        }
        throw DynamicError.throw_type_error();
    }

    public boolean gt(AnyType arg, DynamicContext context) throws DynamicError {
        String compareToURI;
        if (!(arg instanceof XSAnyURI) && !(arg instanceof XSString)) {
            throw DynamicError.throw_type_error();
        }
        String anyURI = this.string_value();
        return anyURI.compareTo(compareToURI = arg.string_value()) > 0;
    }

    public boolean lt(AnyType arg, DynamicContext context) throws DynamicError {
        String compareToURI;
        if (!(arg instanceof XSAnyURI) && !(arg instanceof XSString)) {
            throw DynamicError.throw_type_error();
        }
        String anyURI = this.string_value();
        return anyURI.compareTo(compareToURI = arg.string_value()) < 0;
    }
}

