/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rdf4j.http.client;

import java.io.IOException;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicLong;
import org.apache.http.HttpConnection;
import org.apache.http.HttpResponse;
import org.apache.http.client.HttpClient;
import org.apache.http.client.HttpRequestRetryHandler;
import org.apache.http.client.ServiceUnavailableRetryStrategy;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.client.protocol.HttpClientContext;
import org.apache.http.client.utils.HttpClientUtils;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClientBuilder;
import org.apache.http.protocol.HttpContext;
import org.eclipse.rdf4j.http.client.HttpClientDependent;
import org.eclipse.rdf4j.http.client.HttpClientSessionManager;
import org.eclipse.rdf4j.http.client.RDF4JProtocolSession;
import org.eclipse.rdf4j.http.client.SPARQLProtocolSession;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SharedHttpClientSessionManager
implements HttpClientSessionManager,
HttpClientDependent {
    public static final String CORE_POOL_SIZE_PROPERTY = "org.eclipse.rdf4j.client.executors.corePoolSize";
    private static final AtomicLong threadCount = new AtomicLong();
    private final Logger logger = LoggerFactory.getLogger(SharedHttpClientSessionManager.class);
    private volatile HttpClient httpClient;
    private volatile CloseableHttpClient dependentClient;
    private final ExecutorService executor;
    private volatile HttpClientBuilder httpClientBuilder;
    private final Map<SPARQLProtocolSession, Boolean> openSessions = new ConcurrentHashMap<SPARQLProtocolSession, Boolean>();
    private static final HttpRequestRetryHandler retryHandlerStale = new RetryHandlerStale();
    private static final ServiceUnavailableRetryStrategy serviceUnavailableRetryHandler = new ServiceUnavailableRetryHandler();

    public SharedHttpClientSessionManager() {
        ThreadFactory backingThreadFactory = Executors.defaultThreadFactory();
        ExecutorService threadPoolExecutor = Executors.newCachedThreadPool(runnable -> {
            Thread thread = backingThreadFactory.newThread(runnable);
            thread.setName(String.format("rdf4j-SharedHttpClientSessionManager-%d", threadCount.getAndIncrement()));
            thread.setDaemon(true);
            return thread;
        });
        Integer corePoolSize = Integer.getInteger(CORE_POOL_SIZE_PROPERTY, 1);
        ((ThreadPoolExecutor)threadPoolExecutor).setCorePoolSize(corePoolSize);
        this.executor = threadPoolExecutor;
    }

    public SharedHttpClientSessionManager(CloseableHttpClient dependentClient, ScheduledExecutorService dependentExecutorService) {
        this.dependentClient = Objects.requireNonNull(dependentClient, "HTTP client was null");
        this.httpClient = this.dependentClient;
        this.executor = Objects.requireNonNull(dependentExecutorService, "Executor service was null");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public HttpClient getHttpClient() {
        HttpClient result = this.httpClient;
        if (result == null) {
            SharedHttpClientSessionManager sharedHttpClientSessionManager = this;
            synchronized (sharedHttpClientSessionManager) {
                result = this.httpClient;
                if (result == null) {
                    this.dependentClient = this.createHttpClient();
                    this.httpClient = this.dependentClient;
                    result = this.dependentClient;
                }
            }
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setHttpClient(HttpClient httpClient) {
        SharedHttpClientSessionManager sharedHttpClientSessionManager = this;
        synchronized (sharedHttpClientSessionManager) {
            this.httpClient = Objects.requireNonNull(httpClient, "HTTP Client cannot be null");
            CloseableHttpClient toCloseDependentClient = this.dependentClient;
            this.dependentClient = null;
            if (toCloseDependentClient != null) {
                HttpClientUtils.closeQuietly((HttpClient)toCloseDependentClient);
            }
        }
    }

    public void setHttpClientBuilder(HttpClientBuilder httpClientBuilder) {
        this.httpClientBuilder = httpClientBuilder;
    }

    @Override
    public SPARQLProtocolSession createSPARQLProtocolSession(String queryEndpointUrl, String updateEndpointUrl) {
        SPARQLProtocolSession session = new SPARQLProtocolSession(this.getHttpClient(), this.executor){

            @Override
            public void close() {
                try {
                    super.close();
                }
                finally {
                    SharedHttpClientSessionManager.this.openSessions.remove(this);
                }
            }
        };
        session.setQueryURL(queryEndpointUrl);
        session.setUpdateURL(updateEndpointUrl);
        this.openSessions.put(session, true);
        return session;
    }

    @Override
    public RDF4JProtocolSession createRDF4JProtocolSession(String serverURL) {
        RDF4JProtocolSession session = new RDF4JProtocolSession(this.getHttpClient(), this.executor){

            @Override
            public void close() {
                try {
                    super.close();
                }
                finally {
                    SharedHttpClientSessionManager.this.openSessions.remove(this);
                }
            }
        };
        session.setServerURL(serverURL);
        this.openSessions.put(session, true);
        return session;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void shutDown() {
        try {
            this.openSessions.keySet().forEach(session -> {
                try {
                    session.close();
                }
                catch (Exception e) {
                    this.logger.error(e.toString(), (Throwable)e);
                }
            });
            CloseableHttpClient toCloseDependentClient = this.dependentClient;
            this.dependentClient = null;
            if (toCloseDependentClient != null) {
                HttpClientUtils.closeQuietly((HttpClient)toCloseDependentClient);
            }
        }
        finally {
            try {
                this.executor.shutdown();
                this.executor.awaitTermination(10L, TimeUnit.SECONDS);
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
            }
            finally {
                if (!this.executor.isTerminated()) {
                    this.executor.shutdownNow();
                }
            }
        }
    }

    @Deprecated
    public void initialize() {
    }

    protected final ExecutorService getExecutorService() {
        return this.executor;
    }

    private CloseableHttpClient createHttpClient() {
        HttpClientBuilder nextHttpClientBuilder = this.httpClientBuilder;
        if (nextHttpClientBuilder != null) {
            return nextHttpClientBuilder.build();
        }
        return HttpClientBuilder.create().evictExpiredConnections().setRetryHandler(retryHandlerStale).setServiceUnavailableRetryStrategy(serviceUnavailableRetryHandler).useSystemProperties().setDefaultRequestConfig(RequestConfig.custom().setCookieSpec("standard").build()).build();
    }

    private static class ServiceUnavailableRetryHandler
    implements ServiceUnavailableRetryStrategy {
        private final Logger logger = LoggerFactory.getLogger(ServiceUnavailableRetryHandler.class);

        private ServiceUnavailableRetryHandler() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public boolean retryRequest(HttpResponse response, int executionCount, HttpContext context) {
            if (response.getStatusLine().getStatusCode() != 408) {
                return false;
            }
            String keepAlive = System.getProperty("http.keepAlive", "true");
            if (!"true".equalsIgnoreCase(keepAlive)) {
                return false;
            }
            int pooledConnections = Integer.parseInt(System.getProperty("http.maxConnections", "5"));
            if (executionCount > pooledConnections + 1) {
                return false;
            }
            HttpClientContext clientContext = HttpClientContext.adapt((HttpContext)context);
            HttpConnection conn = clientContext.getConnection();
            ServiceUnavailableRetryHandler serviceUnavailableRetryHandler = this;
            synchronized (serviceUnavailableRetryHandler) {
                try {
                    this.logger.info("Cleaning up closed connection");
                    conn.close();
                    return true;
                }
                catch (IOException e) {
                    this.logger.error("Error cleaning up closed connection", (Throwable)e);
                }
            }
            return false;
        }

        public long getRetryInterval() {
            return 1000L;
        }
    }

    private static class RetryHandlerStale
    implements HttpRequestRetryHandler {
        private final Logger logger = LoggerFactory.getLogger(RetryHandlerStale.class);

        private RetryHandlerStale() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public boolean retryRequest(IOException ioe, int count, HttpContext context) {
            if (count > 1) {
                return false;
            }
            HttpClientContext clientContext = HttpClientContext.adapt((HttpContext)context);
            HttpConnection conn = clientContext.getConnection();
            RetryHandlerStale retryHandlerStale = this;
            synchronized (retryHandlerStale) {
                if (conn.isStale()) {
                    try {
                        this.logger.warn("Closing stale connection");
                        conn.close();
                        return true;
                    }
                    catch (IOException e) {
                        this.logger.error("Error closing stale connection", (Throwable)e);
                    }
                }
            }
            return false;
        }
    }
}

