/*
 * Decompiled with CFR 0.152.
 */
package com.exlibris.core.infra.common.startup;

import com.exlibris.core.infra.common.exceptions.logging.ExLogger;
import com.exlibris.core.infra.common.startup.ServerStartedStatus;

public abstract class TaskSchedulerInitializator
implements Runnable {
    private static ExLogger log = ExLogger.getExLogger(TaskSchedulerInitializator.class);
    public static final String SERVER_STARTUP_ERROR = "SERVER_STARTUP_ERROR";

    protected abstract void initializeTask() throws Exception;

    public TaskSchedulerInitializator() {
        new Thread(this).start();
    }

    @Override
    public void run() {
        while (!ServerStartedStatus.isStarted()) {
            ServerStartedStatus.waitStartup();
        }
        if (ServerStartedStatus.isStarted()) {
            try {
                this.initializeTask();
            }
            catch (Exception e) {
                log.error("Failed to initialize ", e, new String[0]);
            }
        }
    }
}

