/*
 * Decompiled with CFR 0.152.
 */
package com.exlibris.digitool.common.dnx;

import com.exlibris.core.infra.common.exceptions.logging.ExLogger;
import com.exlibris.digitool.common.dnx.JxlDnxProfileWorkBookStructure;
import com.exlibris.digitool.utils.JxlUtil;
import com.exlibris.digitool.utils.JxlWorkBookStructure;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import jxl.Cell;
import jxl.Sheet;
import jxl.Workbook;
import org.apache.commons.lang.StringUtils;

public class DNXProfile {
    private static ExLogger log = ExLogger.getExLogger(DNXProfile.class);
    private HashMap<String, HashMap<String, String>> sectionMap = new HashMap();
    private HashMap<String, List<String>> sectionKeys = new HashMap();
    private HashMap<String, HashMap<String, String>> sectionKeyMap = new HashMap();
    private HashMap<String, String> attributeKeys;
    private JxlWorkBookStructure workbookStructure;
    private HashMap<String, Integer> columnsOrder;
    private static final String DESCRIPTION = "description";
    private static final String RELEVANT_FOR_IE = "relevantForIE";
    private static final String RELEVANT_FOR_REP = "relevantForRep";
    private static final String RELEVANT_FOR_FILE = "relevantForFile";
    private static final String REPEATABLE = "repeating";
    private static final String MANDATORY_FOR_PERMANENT = "mandatoryForPermanent";
    private static final String MANDATORY_FOR_STAGING = "mandatoryForStaging";
    private static final String METS_MAPPING = "metsMapping";
    private static final String EDIT_PERMISSION = "editPermission";
    private static final String VALIDATION_ROUTINE = "validationRoutine";
    private static final String CORRECTION_ROUTINE = "correctionRoutine";
    private static final String DISPLAY_KEY = "displayKey";
    private static final String SECTION_KEY_TYPE = "type";
    private static final String SECTION_KEY_CODETABLENAME = "codeTablename";
    private static final String DNX_PROFILE_FILE_NAME = "dnx_profile.xls";

    public DNXProfile() throws Exception {
        this.initAttConsts();
        this.importData();
    }

    private void initAttConsts() {
        this.attributeKeys = new HashMap();
        this.attributeKeys.put("Description", DESCRIPTION);
        this.attributeKeys.put("IE", RELEVANT_FOR_IE);
        this.attributeKeys.put("REP", RELEVANT_FOR_REP);
        this.attributeKeys.put("FILE", RELEVANT_FOR_FILE);
        this.attributeKeys.put("Repeating", REPEATABLE);
        this.attributeKeys.put("Mandatory For Permanent", MANDATORY_FOR_PERMANENT);
        this.attributeKeys.put("Mandatory For Staging", MANDATORY_FOR_STAGING);
        this.attributeKeys.put("Mets Mapping", METS_MAPPING);
        this.attributeKeys.put("Edit Permission", EDIT_PERMISSION);
        this.attributeKeys.put("Validation Routine", VALIDATION_ROUTINE);
        this.attributeKeys.put("Correction Routine", CORRECTION_ROUTINE);
        this.attributeKeys.put("DisplayKey", DISPLAY_KEY);
        this.attributeKeys.put("Type", SECTION_KEY_TYPE);
        this.attributeKeys.put("CodeTableName", SECTION_KEY_CODETABLENAME);
    }

    public List<String> getSectionList() {
        ArrayList<String> list = new ArrayList<String>();
        for (String sectionId : this.sectionMap.keySet()) {
            list.add(sectionId);
        }
        return list;
    }

    public List<String> getSectionKeyList(String sectionId) {
        List<String> list = this.sectionKeys.get(sectionId);
        return list;
    }

    public String getDescription(String sectionId) {
        String value = this.getSectionAttribute(sectionId, DESCRIPTION);
        if (value == null) {
            return sectionId;
        }
        return value;
    }

    public String getDescription(String sectionId, String sectionKeyId) {
        String value = this.getSectionKeyAttribute(sectionId, sectionKeyId, DESCRIPTION);
        if (value == null) {
            return sectionKeyId;
        }
        return value;
    }

    public boolean isRelevantForIE(String sectionId) {
        if (!this.hasSection(sectionId)) {
            return false;
        }
        String value = this.getSectionAttribute(sectionId, RELEVANT_FOR_IE);
        if (value == null) {
            return true;
        }
        return "1".equals(value);
    }

    public boolean isRelevantForREP(String sectionId) {
        if (!this.hasSection(sectionId)) {
            return false;
        }
        String value = this.getSectionAttribute(sectionId, RELEVANT_FOR_REP);
        if (value == null) {
            return true;
        }
        return "1".equals(value);
    }

    public boolean isRelevantForFILE(String sectionId) {
        if (!this.hasSection(sectionId)) {
            return false;
        }
        String value = this.getSectionAttribute(sectionId, RELEVANT_FOR_FILE);
        if (value == null) {
            return true;
        }
        return "1".equals(value);
    }

    public boolean isRepeatable(String sectionId) {
        String value = this.getSectionAttribute(sectionId, REPEATABLE);
        return "1".equals(value);
    }

    public boolean isMandatoryForPermanent(String sectionId) {
        String value = this.getSectionAttribute(sectionId, MANDATORY_FOR_PERMANENT);
        return "1".equals(value);
    }

    public boolean isMandatoryForPermanent(String sectionId, String sectionKeyId) {
        String value = this.getSectionKeyAttribute(sectionId, sectionKeyId, MANDATORY_FOR_PERMANENT);
        return "1".equals(value);
    }

    public boolean isMandatoryForStaging(String sectionId) {
        String value = this.getSectionAttribute(sectionId, MANDATORY_FOR_STAGING);
        return "1".equals(value);
    }

    public boolean isMandatoryForStageing(String sectionId, String sectionKeyId) {
        String value = this.getSectionKeyAttribute(sectionId, sectionKeyId, MANDATORY_FOR_STAGING);
        return "1".equals(value);
    }

    public boolean isRelevantForTechMD(String sectionId) {
        String value = this.getSectionAttribute(sectionId, METS_MAPPING);
        try {
            return MetsMapping.valueOf(value.toUpperCase()).equals((Object)MetsMapping.TECHMD);
        }
        catch (Exception e) {
            return false;
        }
    }

    public boolean isRelevantForDigiprovMD(String sectionId) {
        String value = this.getSectionAttribute(sectionId, METS_MAPPING);
        try {
            return MetsMapping.valueOf(value.toUpperCase()).equals((Object)MetsMapping.DIGIPROVMD);
        }
        catch (Exception e) {
            return false;
        }
    }

    public boolean isRelevantForRightsMD(String sectionId) {
        String value = this.getSectionAttribute(sectionId, METS_MAPPING);
        try {
            return MetsMapping.valueOf(value.toUpperCase()).equals((Object)MetsMapping.RIGHTSMD);
        }
        catch (Exception e) {
            return false;
        }
    }

    public boolean isRelevantForSourceMD(String sectionId) {
        String value = this.getSectionAttribute(sectionId, METS_MAPPING);
        try {
            return MetsMapping.valueOf(value.toUpperCase()).equals((Object)MetsMapping.SOURCEMD);
        }
        catch (Exception e) {
            return false;
        }
    }

    public EditPermission getEditPermission(String sectionId, String sectionKeyId) {
        String sectionAttribute = this.getSectionAttribute(sectionId, EDIT_PERMISSION);
        EditPermission sectionEditPermission = EditPermission.READONLY;
        try {
            sectionEditPermission = EditPermission.valueOf(sectionAttribute.toUpperCase());
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (sectionEditPermission.equals((Object)EditPermission.READONLY) || EditPermission.HIDDEN.equals((Object)sectionEditPermission)) {
            return sectionEditPermission;
        }
        String sectionKeyAttribute = this.getSectionKeyAttribute(sectionId, sectionKeyId, EDIT_PERMISSION);
        EditPermission sectionKeyEditPermission = EditPermission.FULL;
        try {
            sectionKeyEditPermission = EditPermission.valueOf(sectionKeyAttribute.toUpperCase());
        }
        catch (Exception exception) {
            // empty catch block
        }
        return sectionKeyEditPermission;
    }

    public EditPermission getEditPermission(String sectionId) {
        String sectionAttribute = this.getSectionAttribute(sectionId, EDIT_PERMISSION);
        EditPermission sectionEditPermission = EditPermission.READONLY;
        try {
            sectionEditPermission = EditPermission.valueOf(sectionAttribute.toUpperCase());
        }
        catch (Exception exception) {
            // empty catch block
        }
        return sectionEditPermission;
    }

    public String getValidationRoutine(String sectionId, String sectionKeyId) {
        String value = this.getSectionKeyAttribute(sectionId, sectionKeyId, VALIDATION_ROUTINE);
        return value;
    }

    public String getCorrectionRoutine(String sectionId, String sectionKeyId) {
        String value = this.getSectionKeyAttribute(sectionId, sectionKeyId, CORRECTION_ROUTINE);
        return value;
    }

    public String getDisplayKey(String sectionId) {
        String value = this.getSectionAttribute(sectionId, DISPLAY_KEY);
        return value;
    }

    public String getSectionKeyControlListName(String sectionId, String sectionKeyId) {
        String value = this.getSectionKeyAttribute(sectionId, sectionKeyId, SECTION_KEY_CODETABLENAME);
        return value;
    }

    public SectionKeyType getSectionKeyType(String sectionId, String sectionKeyId) {
        String value = this.getSectionKeyAttribute(sectionId, sectionKeyId, SECTION_KEY_TYPE);
        if (StringUtils.isEmpty((String)value)) {
            return SectionKeyType.STRING;
        }
        try {
            return SectionKeyType.valueOf(value.toUpperCase());
        }
        catch (Exception e) {
            log.error("Error in file dnx_profile.xls in section: '" + sectionId + "' for key: '" + sectionKeyId + "', Not a valid type: '" + value + "'", new String[0]);
            return SectionKeyType.STRING;
        }
    }

    private Exception parsingError(String msg) {
        return new Exception("DNXProfile parsing error - " + msg);
    }

    private String getSectionAttribute(String sectionId, String sectionKeyId) {
        HashMap<String, String> sectionAttrs = this.sectionMap.get(sectionId);
        if (sectionAttrs == null) {
            return null;
        }
        return sectionAttrs.get(sectionKeyId);
    }

    private String getSectionKeyAttribute(String sectionId, String sectionKeyName, String sectionKeyId) {
        String key = sectionId + "/" + sectionKeyName;
        HashMap<String, String> sectionKeyAttrs = this.sectionKeyMap.get(key);
        if (sectionKeyAttrs == null) {
            return null;
        }
        return sectionKeyAttrs.get(sectionKeyId);
    }

    public static void main(String[] args) throws Exception {
        DNXProfile profile = null;
        try {
            profile = new DNXProfile();
        }
        catch (Exception e) {
            System.out.println(e.getMessage());
        }
        List<String> sectionList = profile.getSectionList();
        for (String sectionId : sectionList) {
            DNXProfile.println("=====================");
            DNXProfile.println("sectionId = " + sectionId);
            List<String> keyList = profile.getSectionKeyList(sectionId);
            for (String sectionKeyId : keyList) {
                DNXProfile.println("    sectionKeyId = " + sectionKeyId);
                DNXProfile.println("        isMand = " + profile.isMandatoryForStageing(sectionId, sectionKeyId));
                DNXProfile.println("        type = " + (Object)((Object)profile.getSectionKeyType(sectionId, sectionKeyId)));
            }
        }
    }

    public static void println(String msg) {
        System.out.println(msg);
    }

    public List<String> getSectionListForIE() {
        ArrayList<String> list = new ArrayList<String>();
        for (String sectionId : this.sectionMap.keySet()) {
            if (!this.isRelevantForIE(sectionId)) continue;
            list.add(sectionId);
        }
        return list;
    }

    public List<String> getSectionListForFILE() {
        ArrayList<String> list = new ArrayList<String>();
        for (String sectionId : this.sectionMap.keySet()) {
            if (!this.isRelevantForFILE(sectionId)) continue;
            list.add(sectionId);
        }
        return list;
    }

    public List<String> getSectionListForREP() {
        ArrayList<String> list = new ArrayList<String>();
        for (String sectionId : this.sectionMap.keySet()) {
            if (!this.isRelevantForREP(sectionId)) continue;
            list.add(sectionId);
        }
        return list;
    }

    public boolean hasSection(String sectionid) {
        return this.sectionMap.containsKey(sectionid);
    }

    public boolean hasSectionKey(String sectionid, String keyid) {
        List<String> list = this.sectionKeys.get(sectionid);
        if (list != null) {
            for (int x = 0; x < list.size(); ++x) {
                if (!list.get(x).equals(keyid)) continue;
                return true;
            }
        }
        return false;
    }

    private List<String> importData() throws Exception {
        InputStream file = Thread.currentThread().getContextClassLoader().getResourceAsStream(DNX_PROFILE_FILE_NAME);
        Workbook workbook = null;
        List<String> importErrors = null;
        try {
            workbook = Workbook.getWorkbook((InputStream)file);
        }
        catch (Exception e) {
            throw new Exception("DNXProfile exception: " + e.getMessage());
        }
        try {
            importErrors = this.importData(workbook);
        }
        catch (Exception e) {
            workbook.close();
            file.close();
            throw e;
        }
        workbook.close();
        file.close();
        if (importErrors != null && importErrors.size() > 0) {
            throw new Exception("DNXProfile exception: failed validation of dnx profile excel.");
        }
        return importErrors;
    }

    private List<String> importData(Workbook workbook) throws Exception {
        this.workbookStructure = new JxlDnxProfileWorkBookStructure();
        List<String> importErrors = this.workbookStructure.validate(workbook, 20);
        if (importErrors != null && importErrors.size() != 0) {
            workbook.close();
            return importErrors;
        }
        try {
            this.importSheetData(workbook);
        }
        catch (Exception e) {
            workbook.close();
            e.printStackTrace();
            throw e;
        }
        return null;
    }

    private void importSheetData(Workbook workbook) throws Exception {
        Sheet sheet = workbook.getSheets()[0];
        this.columnsOrder = this.workbookStructure.determineColumnsOrder(sheet);
        String sectionId = null;
        for (int x = 1; x < sheet.getRows(); ++x) {
            Cell[] cells = sheet.getRow(x);
            if (JxlUtil.isEmptyRow(cells)) continue;
            String type = this.workbookStructure.getStringField(cells, this.columnsOrder, "Type");
            if (type.equals("Section")) {
                sectionId = this.parseSection(cells);
                continue;
            }
            this.parseSectionKey(sectionId, cells);
        }
    }

    private String parseSection(Cell[] cells) throws Exception {
        String keyValue = null;
        String sectionId = null;
        HashMap<String, String> sectionAttributes = new HashMap<String, String>();
        List<String> keyList = JxlDnxProfileWorkBookStructure.columns;
        for (String keyId : keyList) {
            keyValue = this.workbookStructure.getStringField(cells, this.columnsOrder, keyId);
            if (keyId == null) {
                throw this.parsingError("key is missing attr \"id\"");
            }
            if (sectionAttributes.containsKey(keyId)) {
                throw this.parsingError("section attr is duplicated - " + keyId);
            }
            String mappedKeyName = this.attributeKeys.get(keyId);
            if (mappedKeyName != null && mappedKeyName.equals(DISPLAY_KEY) && keyValue != null) {
                keyValue = keyValue.replaceAll(",", "@@");
            }
            sectionAttributes.put(mappedKeyName == null ? keyId : mappedKeyName, keyValue);
            if (!keyId.equals("Name")) continue;
            sectionId = keyValue;
        }
        if (sectionId == null) {
            throw this.parsingError("section is missing \"name\"");
        }
        if (this.sectionMap.containsKey(sectionId)) {
            throw this.parsingError("section is duplicated - " + sectionId);
        }
        this.sectionMap.put(sectionId, sectionAttributes);
        return sectionId;
    }

    private void parseSectionKey(String sectionId, Cell[] cells) throws Exception {
        String sectionKeyId = null;
        String keyValue = null;
        HashMap<String, String> sectionKeyAttributes = new HashMap<String, String>();
        for (String keyId : JxlDnxProfileWorkBookStructure.columns) {
            keyValue = this.workbookStructure.getStringField(cells, this.columnsOrder, keyId);
            if (keyId == null) {
                throw this.parsingError("key is missing attr \"id\"");
            }
            if (sectionKeyAttributes.containsKey(keyId)) {
                throw this.parsingError("section attr is duplicated - " + keyId);
            }
            String mappedKeyName = this.attributeKeys.get(keyId);
            if (mappedKeyName != null && mappedKeyName.equals(DISPLAY_KEY) && keyValue != null) {
                keyValue = keyValue.replaceAll(",", "@@");
            }
            sectionKeyAttributes.put(mappedKeyName == null ? keyId : mappedKeyName, keyValue);
            if (!keyId.equals("Name")) continue;
            sectionKeyId = keyValue;
        }
        if (sectionKeyId == null) {
            throw this.parsingError("section " + sectionId + " contains dnx_profile_section_key without attr \"name\"");
        }
        String mapKey = sectionId + "/" + sectionKeyId;
        if (this.sectionKeyMap.containsKey(mapKey)) {
            throw this.parsingError("section is duplicated - " + mapKey);
        }
        this.sectionKeyMap.put(mapKey, sectionKeyAttributes);
        if (!this.sectionKeys.containsKey(sectionId)) {
            this.sectionKeys.put(sectionId, new ArrayList());
        }
        this.sectionKeys.get(sectionId).add(sectionKeyId);
    }

    public static enum MetsMapping {
        TECHMD,
        DIGIPROVMD,
        RIGHTSMD,
        SOURCEMD;

    }

    public static enum SectionKeyType {
        STRING,
        INT,
        DATETIME,
        BOOLEAN,
        CONTROLLEDLIST,
        EXTENSION,
        POPULATOR,
        DOUBLE;

    }

    public static enum EditPermission {
        READONLY,
        FULL,
        HIDDEN;

    }
}

