/*
 * Decompiled with CFR 0.152.
 */
package uk.gov.nationalarchives.droid.core.interfaces.archive;

import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.net.URL;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.jwat.arc.ArcReader;
import org.jwat.arc.ArcReaderFactory;
import org.jwat.arc.ArcRecord;
import org.jwat.arc.ArcRecordBase;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import uk.gov.nationalarchives.droid.core.interfaces.IdentificationRequest;
import uk.gov.nationalarchives.droid.core.interfaces.RequestIdentifier;
import uk.gov.nationalarchives.droid.core.interfaces.ResourceId;
import uk.gov.nationalarchives.droid.core.interfaces.archive.ArchiveFileWalker;
import uk.gov.nationalarchives.droid.core.interfaces.archive.ArchiveHandler;
import uk.gov.nationalarchives.droid.core.interfaces.archive.ArchiveInputStreamIterator;
import uk.gov.nationalarchives.droid.core.interfaces.archive.WebArchiveHandler;
import uk.gov.nationalarchives.droid.core.interfaces.resource.RequestMetaData;

public class ArcArchiveHandler
extends WebArchiveHandler
implements ArchiveHandler {
    protected static final String WEB_ARCHIVE_TYPE = "arc";
    private final Logger log = LoggerFactory.getLogger(this.getClass());

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final void handle(IdentificationRequest request) throws IOException {
        try (final InputStream arcIn = request.getSourceInputStream();){
            Iterable<ArcRecordBase> iterable = new Iterable<ArcRecordBase>(){

                @Override
                public final Iterator<ArcRecordBase> iterator() {
                    return new ArcArchiveEntryIterator(arcIn);
                }
            };
            ArcArchiveWalker walker = new ArcArchiveWalker(request.getIdentifier(), arcIn);
            walker.walk(iterable);
        }
    }

    final void submit(ArcRecordBase entry, String entryName, URI parentName, InputStream in, ResourceId correlationId, long originatorNodeId) throws IOException {
        long size = entry.getArchiveLength();
        Date time = entry.getArchiveDate();
        RequestMetaData metaData = new RequestMetaData(size == -1L ? null : Long.valueOf(size), time == null ? null : Long.valueOf(time.getTime()), entryName);
        super.submit(WEB_ARCHIVE_TYPE, metaData, parentName, entry.getPayloadContent(), correlationId, originatorNodeId);
    }

    private final class ArcArchiveWalker
    extends ArchiveFileWalker<ArcRecordBase> {
        private final ResourceId parentId;
        private final long originatorNodeId;
        private final URI parentName;
        private final InputStream in;
        private final Map<String, ResourceId> directories = new HashMap<String, ResourceId>();

        ArcArchiveWalker(RequestIdentifier parent, InputStream in) {
            this.in = in;
            this.parentId = parent.getResourceId();
            this.parentName = parent.getUri();
            this.originatorNodeId = parent.getAncestorId();
        }

        @Override
        protected void handleEntry(ArcRecordBase entry) throws IOException {
            int maxLEN = 4095;
            String entryUri = entry.getUrlStr();
            String entryPath = new URL(entryUri).getFile();
            int queryPos = entryPath.indexOf(63);
            String querylessPath = queryPos > 0 ? entryPath.substring(0, queryPos) : entryPath;
            String entryName = entryPath.substring(querylessPath.lastIndexOf(47) + 1);
            String prefixPath = entryUri.substring(0, entryUri.length() - entryName.length());
            ResourceId correlationId = this.parentId;
            if (!prefixPath.isEmpty() && (correlationId = this.directories.get(prefixPath)) == null) {
                correlationId = ArcArchiveHandler.this.processAncestorFolders(ArcArchiveHandler.WEB_ARCHIVE_TYPE, prefixPath, entryUri, this.parentId, this.parentName, this.directories);
            }
            String truncatedName = entryName.length() < 4095 ? entryName : entryName.substring(0, 4095);
            ArcArchiveHandler.this.submit(entry, truncatedName, this.parentName, this.in, correlationId, this.originatorNodeId);
        }
    }

    private final class ArcArchiveEntryIterator
    extends ArchiveInputStreamIterator<ArcRecordBase, InputStream> {
        private Iterator<ArcRecordBase> iterator;

        ArcArchiveEntryIterator(InputStream in) {
            super(in);
            try {
                ArcReader arcReader = ArcReaderFactory.getReader((InputStream)in);
                this.iterator = arcReader.iterator();
            }
            catch (IOException e) {
                ArcArchiveHandler.this.log.error(e.getMessage(), (Throwable)e);
                System.err.println(e);
            }
        }

        @Override
        protected ArcRecordBase getNextEntry() throws IOException {
            ArcRecordBase base = null;
            if (this.iterator.hasNext()) {
                base = this.iterator.next();
                while (!(base instanceof ArcRecord) || "dns".equals(base.getScheme()) || base.getHttpHeader().statusCode != 200) {
                    if (this.iterator.hasNext()) {
                        base = this.iterator.next();
                        continue;
                    }
                    base = null;
                    break;
                }
            }
            return base;
        }
    }
}

